/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientstats;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class StreamEncoder {
    private final ByteBuffer payload;

    public StreamEncoder(String handshake_key, ByteBuffer message) {
        byte[] handshake = handshake_key.getBytes();
        this.payload = ByteBuffer.allocate(1 + handshake.length + 4 + message.limit());
        this.payload.put((byte)handshake_key.length());
        this.payload.put(handshake);
        this.payload.putInt(message.limit());
        this.payload.put(message);
        this.payload.flip();
    }

    public boolean encode(SocketChannel channel) throws IOException {
        channel.write(this.payload);
        return !this.payload.hasRemaining();
    }
}

