/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.system.handler;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;

/**
 * The ComponentHandler interface marks the ComponentHandler implementations.
 * The desire for a ComponentHandler is to manage the instances of a Component.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.4 $ $Date: 2002/01/30 15:44:06 $
 * @since 4.0
 */
public interface ComponentHandler
    extends Initializable, Disposable
{
    Class[] HANDLER_CONSTRUCTOR = new Class[] {
        Class.class,
        Configuration.class,
        ComponentManager.class,
        Context.class
    };

    /**
     * Sometimes Components call other components during their initialization
     * process.  This is a quick test that the ComponentManager will perform
     * before attempting to use the the ComponentHandler.
     */
    boolean isInitialized();

    /**
     * Gets the current reference to a Component according to the policy of the
     * implementation.
     */
    Component get() throws Exception;

    /**
     * Puts the reference back in the ComponentHandler according to the policy
     * of the implementation.
     */
    void put(Component component);
}
