#! /bin/sh
#
# atokx server start/stop script
#
# Written by Taku YASUI <tach@debian.or.jp>.

NAME=atokx2mngdaemon
DESC="ATOKX2 server"
DAEMON=/usr/sbin/${NAME}

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting ${DESC}: "
	start-stop-daemon --start --quiet --background --exec ${DAEMON} && \
	    touch /var/lock/subsys/atokx2 && \
	    echo "${NAME}."
	;;

  stop)
	echo -n "Stopping ${DESC}: "
	start-stop-daemon --stop --quiet --oknodo --name ${NAME} && \
	    rm -f /var/lock/subsys/atokx2 && \
	    echo "${NAME}."
	;;

  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	$0 stop
	sleep 1
	$0 start
	;;

  *)
	N=/etc/init.d/atokx2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
