/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceProxy;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public abstract class Resource
extends PlatformObject
implements IResource,
ICoreConstants,
Cloneable {
    IPath path;
    Workspace workspace;
    static /* synthetic */ Class class$0;

    protected Resource(IPath path, Workspace workspace) {
        this.path = path.removeTrailingSeparator();
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(final IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        final ResourceProxy proxy = new ResourceProxy();
        final boolean includePhantoms = (memberFlags & 1) != 0;
        final boolean includeTeamPrivate = (memberFlags & 2) != 0;
        IElementContentVisitor elementVisitor = new IElementContentVisitor(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object contents) {
                ResourceInfo info = (ResourceInfo)contents;
                if (!includePhantoms && info.isSet(8)) {
                    return false;
                }
                if (!includeTeamPrivate && info.isSet(32768)) {
                    return false;
                }
                proxy.requestor = requestor;
                proxy.info = info;
                try {
                    try {
                        boolean bl = visitor.visit(proxy);
                        Object var6_6 = null;
                        proxy.reset();
                        return bl;
                    }
                    catch (CoreException e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    proxy.reset();
                    throw throwable;
                }
            }
        };
        try {
            try {
                new ElementTreeIterator(this.workspace.getElementTree(), this.getFullPath()).iterate(elementVisitor);
            }
            catch (WrappedRuntimeException e) {
                throw (CoreException)e.getTargetException();
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                String msg = Policy.bind("resources.errorVisiting");
                ResourceStatus errorStatus = new ResourceStatus(566, this.getFullPath(), msg, e);
                ResourcesPlugin.getPlugin().getLog().log(errorStatus);
                throw new ResourceException(errorStatus);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            proxy.requestor = null;
            proxy.info = null;
            throw throwable;
        }
        {
            Object var10_14 = null;
            proxy.requestor = null;
            proxy.info = null;
            return;
        }
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, depth, includePhantoms ? 1 : 0);
    }

    public void accept(final IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        boolean includeTeamPrivateMembers;
        boolean includePhantoms = (memberFlags & 1) != 0;
        ResourceInfo info = this.getResourceInfo(includePhantoms, false);
        int flags = this.getFlags(info);
        this.checkExists(flags, true);
        if (depth == 2) {
            this.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    return visitor.visit(proxy.requestResource());
                }
            }, memberFlags);
            return;
        }
        boolean bl = includeTeamPrivateMembers = (memberFlags & 2) != 0;
        if (!includeTeamPrivateMembers && this.isTeamPrivateMember(flags)) {
            return;
        }
        if (!visitor.visit(this) || depth == 0) {
            return;
        }
        info = this.getResourceInfo(includePhantoms, false);
        if (info == null) {
            return;
        }
        int type = info.getType();
        if (type == 1) {
            return;
        }
        IContainer resource = this.getType() != type ? (IContainer)((Object)this.workspace.newResource(this.getFullPath(), type)) : (IContainer)((Object)this);
        IResource[] members = resource.members(memberFlags);
        int i = 0;
        while (i < members.length) {
            members[i].accept(visitor, 0, memberFlags);
            ++i;
        }
    }

    protected void assertCopyRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        IStatus status = this.checkCopyRequirements(destination, destinationType, updateFlags);
        if (!status.isOK()) {
            Assert.isTrue(false, status.getChildren()[0].getMessage());
        }
    }

    protected void assertLinkRequirements(IPath localLocation, int updateFlags) throws CoreException {
        this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), true);
        boolean allowMissingLocal = (updateFlags & 0x10) != 0;
        IStatus locationStatus = this.workspace.validateLinkLocation(this, localLocation);
        if (locationStatus.getSeverity() == 4 || locationStatus.getCode() == 333 && !allowMissingLocal) {
            throw new ResourceException(locationStatus);
        }
        Container parent = (Container)this.getParent();
        parent.checkAccessible(this.getFlags(parent.getResourceInfo(false, false)));
        File localFile = this.workspace.getPathVariableManager().resolvePath(localLocation).toFile();
        boolean localExists = localFile.exists();
        if (!allowMissingLocal && !localExists) {
            String msg = Policy.bind("links.localDoesNotExist", localFile.toString());
            throw new ResourceException(269, this.getFullPath(), msg, null);
        }
        if (localExists && this.getType() == 2 != localFile.isDirectory()) {
            String msg = Policy.bind("links.wrongLocalType", this.getFullPath().toString());
            throw new ResourceException(276, this.getFullPath(), msg, null);
        }
    }

    protected void assertMoveRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        IStatus status = this.checkMoveRequirements(destination, destinationType, updateFlags);
        if (!status.isOK()) {
            Assert.isTrue(false, status.getChildren()[0].getMessage());
        }
    }

    public void checkAccessible(int flags) throws CoreException {
        this.checkExists(flags, true);
    }

    public IStatus checkCopyRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        boolean isDeepCopy;
        String message = Policy.bind("resources.copyNotMet");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        if (destination == null) {
            message = Policy.bind("resources.destNotNull");
            return new ResourceStatus(77, this.getFullPath(), message);
        }
        destination = this.makePathAbsolute(destination);
        if (this.getFullPath().isPrefixOf(destination)) {
            message = Policy.bind("resources.copyDestNotSub", this.getFullPath().toString());
            status.add(new ResourceStatus(77, this.getFullPath(), message));
        }
        this.checkValidPath(destination, destinationType, false);
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 2);
        Resource dest = this.workspace.newResource(destination, destinationType);
        dest.checkDoesNotExist();
        if (this.getType() == 1 && destinationType == 4) {
            message = Policy.bind("resources.fileToProj");
            throw new ResourceException(77, this.getFullPath(), message, null);
        }
        Container parent = (Container)dest.getParent();
        boolean bl = isDeepCopy = (updateFlags & 0x20) == 0;
        if (this.isLinked() && !isDeepCopy && (parent == null || parent.getType() != 4)) {
            message = Policy.bind("links.copyNotProject", this.getFullPath().toString(), destination.toString());
            throw new ResourceException(77, this.getFullPath(), message, null);
        }
        if (destinationType != 4) {
            Project project = (Project)dest.getProject();
            info = project.getResourceInfo(false, false);
            project.checkAccessible(this.getFlags(info));
            if (!parent.equals(project)) {
                info = parent.getResourceInfo(false, false);
                parent.checkExists(this.getFlags(info), true);
            }
        }
        if (this.isUnderLink() || dest.isUnderLink()) {
            IPath sourceLocation = this.getLocation();
            if (sourceLocation == null) {
                message = Policy.bind("localstore.locationUndefined", this.getFullPath().toString());
                throw new ResourceException(271, this.getFullPath(), message, null);
            }
            IPath destLocation = dest.getLocation();
            if (destLocation == null) {
                message = Policy.bind("localstore.locationUndefined", dest.getFullPath().toString());
                throw new ResourceException(271, dest.getFullPath(), message, null);
            }
            if (sourceLocation.isPrefixOf(destLocation)) {
                message = Policy.bind("resources.copyDestNotSub", this.getFullPath().toString());
                throw new ResourceException(77, this.getFullPath(), message, null);
            }
        }
        return status.isOK() ? Status.OK_STATUS : status;
    }

    protected void checkDoesNotExist() throws CoreException {
        this.checkDoesNotExist(this.getFlags(this.getResourceInfo(false, false)), false);
        if (CoreFileSystemLibrary.isCaseSensitive()) {
            return;
        }
        IResource variant = this.findExistingResourceVariant(this.getFullPath());
        if (variant == null) {
            return;
        }
        String msg = Policy.bind("resources.existsDifferentCase", variant.getFullPath().toString());
        throw new ResourceException(275, variant.getFullPath(), msg, null);
    }

    public void checkDoesNotExist(int flags, boolean checkType) throws CoreException {
        if (!this.exists(flags, false)) {
            return;
        }
        if (checkType && !this.exists(flags, checkType)) {
            return;
        }
        String message = Policy.bind("resources.mustNotExist", this.getFullPath().toString());
        throw new ResourceException(checkType ? 367 : 374, this.getFullPath(), message, null);
    }

    public void checkExists(int flags, boolean checkType) throws CoreException {
        if (!this.exists(flags, checkType)) {
            String message = Policy.bind("resources.mustExist", this.getFullPath().toString());
            throw new ResourceException(368, this.getFullPath(), message, null);
        }
    }

    public void checkLocal(int flags, int depth) throws CoreException {
        if (!this.isLocal(flags, depth)) {
            String message = Policy.bind("resources.mustBeLocal", this.getFullPath().toString());
            throw new ResourceException(369, this.getFullPath(), message, null);
        }
    }

    protected IStatus checkMoveRequirements(IPath destination, int destinationType, int updateFlags) throws CoreException {
        boolean isDeepMove;
        IResource variant;
        String message = Policy.bind("resources.moveNotMet");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        if (destination == null) {
            message = Policy.bind("resources.destNotNull");
            return new ResourceStatus(77, this.getFullPath(), message);
        }
        destination = this.makePathAbsolute(destination);
        if (this.getFullPath().isPrefixOf(destination)) {
            message = Policy.bind("resources.moveDestNotSub", this.getFullPath().toString());
            status.add(new ResourceStatus(77, this.getFullPath(), message));
        }
        this.checkValidPath(destination, destinationType, false);
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 2);
        Resource dest = this.workspace.newResource(destination, destinationType);
        IResource iResource = variant = CoreFileSystemLibrary.isCaseSensitive() ? null : this.findExistingResourceVariant(destination);
        if (variant == null || !this.equals(variant)) {
            dest.checkDoesNotExist();
        }
        if (this.getType() == 1 && dest.getType() == 4) {
            message = Policy.bind("resources.fileToProj");
            throw new ResourceException(new ResourceStatus(77, this.getFullPath(), message));
        }
        Container parent = (Container)dest.getParent();
        boolean bl = isDeepMove = (updateFlags & 0x20) == 0;
        if (!isDeepMove && this.isLinked() && (parent == null || parent.getType() != 4)) {
            message = Policy.bind("links.moveNotProject", this.getFullPath().toString(), destination.toString());
            throw new ResourceException(new ResourceStatus(77, this.getFullPath(), message));
        }
        if (destinationType != 4) {
            Project project = (Project)dest.getProject();
            info = project.getResourceInfo(false, false);
            project.checkAccessible(this.getFlags(info));
            if (!parent.equals(project)) {
                info = parent.getResourceInfo(false, false);
                parent.checkExists(this.getFlags(info), true);
            }
        }
        if (this.isUnderLink() || dest.isUnderLink()) {
            IPath sourceLocation = this.getLocation();
            if (sourceLocation == null) {
                message = Policy.bind("localstore.locationUndefined", this.getFullPath().toString());
                throw new ResourceException(271, this.getFullPath(), message, null);
            }
            IPath destLocation = dest.getLocation();
            if (destLocation == null) {
                message = Policy.bind("localstore.locationUndefined", dest.getFullPath().toString());
                throw new ResourceException(271, dest.getFullPath(), message, null);
            }
            if (sourceLocation.isPrefixOf(destLocation)) {
                message = Policy.bind("resources.moveDestNotSub", this.getFullPath().toString());
                throw new ResourceException(77, this.getFullPath(), message, null);
            }
        }
        return status.isOK() ? Status.OK_STATUS : status;
    }

    public void checkValidPath(IPath toValidate, int type, boolean lastSegmentOnly) throws CoreException {
        IStatus result = this.workspace.validatePath(toValidate, type, lastSegmentOnly);
        if (!result.isOK()) {
            throw new ResourceException(result);
        }
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
        this.getLocalManager().getHistoryStore().remove(this.getFullPath(), monitor);
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        Class<?> clazz = rule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.WorkManager$NotifyRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof IResource)) {
            return false;
        }
        return this.path.isPrefixOf(((IResource)rule).getFullPath());
    }

    public void convertToPhantom() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, true);
        if (info == null || this.isPhantom(this.getFlags(info))) {
            return;
        }
        info.clearSessionProperties();
        info.set(8);
        this.getLocalManager().updateLocalSync(info, -1L);
        info.clearModificationStamp();
        info.setMarkers(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(IProjectDescription destDesc, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(destDesc);
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.copying", this.getFullPath().toString());
            monitor.beginTask(message, 100);
            try {
                try {
                    this.workspace.prepareOperation(this.workspace.getRoot(), monitor);
                    IPath destPath = new Path(destDesc.getName()).makeAbsolute();
                    this.assertCopyRequirements(destPath, this.getType(), updateFlags);
                    Project destProject = (Project)this.workspace.getRoot().getProject(destPath.lastSegment());
                    this.workspace.beginOperation(true);
                    destProject.create(destDesc, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    destProject.open(Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    IResource[] children = ((IContainer)((Object)this)).members(2);
                    int i = 0;
                    while (true) {
                        block9: {
                            if (i < children.length) break block9;
                            this.getPropertyManager().copy(this, destProject, 0);
                            monitor.worked(Policy.opWork * 15 / 100);
                            break;
                        }
                        Resource child = (Resource)children[i];
                        child.copy(destPath.append(child.getName()), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 60 / 100 / children.length));
                        ++i;
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.workspace.endOperation(this.workspace.getRoot(), true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var10_13 = null;
                this.workspace.endOperation(this.workspace.getRoot(), true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_16 = null;
            monitor.done();
            return;
        }
    }

    public void copy(IProjectDescription destDesc, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.copy(destDesc, updateFlags, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = Policy.monitorFor(monitor);
            String message = Policy.bind("resources.copying", this.getFullPath().toString());
            monitor.beginTask(message, 100);
            Policy.checkCanceled(monitor);
            destination = this.makePathAbsolute(destination);
            this.checkValidPath(destination, this.getType(), false);
            Resource destResource = this.workspace.newResource(destination, this.getType());
            ISchedulingRule rule = this.workspace.getRuleFactory().copyRule(this, destResource);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    this.assertCopyRequirements(destination, this.getType(), updateFlags);
                    this.workspace.beginOperation(true);
                    this.getLocalManager().copy(this, destResource, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var8_10 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
            monitor.done();
            return;
        }
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.copy(destination, updateFlags, monitor);
    }

    public int countResources(int depth, boolean phantom) {
        return this.workspace.countResources(this.path, depth, phantom);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.creatingLink", this.getFullPath().toString());
            monitor.beginTask(message, 100);
            Policy.checkCanceled(monitor);
            this.checkValidPath(this.path, 2, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    if (localLocation.isAbsolute() && localLocation.getDevice() == null) {
                        localLocation = new Path(localLocation.toFile().getAbsolutePath());
                    }
                    this.assertLinkRequirements(localLocation, updateFlags);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(512, this));
                    this.workspace.beginOperation(true);
                    IPath resolvedLocation = this.workspace.getPathVariableManager().resolvePath(localLocation);
                    ResourceInfo info = this.workspace.createResource(this, false);
                    info.set(65536);
                    this.getLocalManager().link(this, resolvedLocation);
                    monitor.worked(Policy.opWork * 5 / 100);
                    Project project = (Project)this.getProject();
                    project.internalGetDescription().setLinkLocation(this.getName(), new LinkDescription(this, localLocation));
                    project.writeDescription(0);
                    monitor.worked(Policy.opWork * 5 / 100);
                    if (this.getType() != 1) {
                        this.refreshLocal(2, Policy.subMonitorFor(monitor, Policy.opWork * 90 / 100));
                    } else {
                        monitor.worked(Policy.opWork * 90 / 100);
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_15 = null;
            monitor.done();
            return;
        }
    }

    public IMarker createMarker(String type) throws CoreException {
        Marker marker;
        Assert.isNotNull(type);
        ISchedulingRule rule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(rule, null);
            this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
            this.workspace.beginOperation(true);
            MarkerInfo info = new MarkerInfo();
            info.setType(type);
            info.setCreationTime(System.currentTimeMillis());
            this.workspace.getMarkerManager().add(this, info);
            marker = new Marker(this, info.getId());
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.workspace.endOperation(rule, false, null);
            throw throwable;
        }
        this.workspace.endOperation(rule, false, null);
        return marker;
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force ? 1 : 0, monitor);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            ISchedulingRule rule;
            block17: {
                ResourceTree tree;
                boolean wasLinked;
                IPath originalLocation;
                block16: {
                    String message;
                    block15: {
                        message = Policy.bind("resources.deleting", this.getFullPath().toString());
                        monitor.beginTask(message, 100000);
                        rule = this.workspace.getRuleFactory().deleteRule(this);
                        this.workspace.prepareOperation(rule, monitor);
                        if (this.exists()) break block15;
                        Object var13_5 = null;
                        this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork * 1000));
                        Object var15_8 = null;
                        monitor.done();
                        return;
                    }
                    this.workspace.beginOperation(true);
                    originalLocation = this.getLocation();
                    wasLinked = this.isLinked();
                    message = Policy.bind("resources.deleteProblem");
                    MultiStatus status = new MultiStatus("org.eclipse.core.resources", 4, message, null);
                    WorkManager workManager = this.workspace.getWorkManager();
                    tree = new ResourceTree(workManager.getLock(), status, updateFlags);
                    int depth = 0;
                    try {
                        depth = workManager.beginUnprotected();
                        this.unprotectedDelete(tree, updateFlags, monitor);
                        Object var11_20 = null;
                        workManager.endUnprotected(depth);
                        if (this.getType() != 8) break block16;
                        this.workspace.getMarkerManager().removeMarkers(this, 0);
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        workManager.endUnprotected(depth);
                        throw throwable;
                    }
                    this.getPropertyManager().deleteProperties(this, 0);
                    this.getResourceInfo(false, false).clearSessionProperties();
                }
                tree.makeInvalid();
                if (!tree.getStatus().isOK()) {
                    throw new ResourceException(tree.getStatus());
                }
                if (!wasLinked) {
                    this.workspace.getAliasManager().updateAliases(this, originalLocation, 2, monitor);
                }
                if (this.getType() != 4) break block17;
                ((Rules)this.workspace.getRuleFactory()).setRuleFactory((IProject)((Object)this), null);
            }
            Object var13_7 = null;
            this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork * 1000));
            {
                catch (Throwable throwable) {
                    Object var13_6 = null;
                    this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork * 1000));
                    throw throwable;
                }
            }
            Object var15_10 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var15_9 = null;
            monitor.done();
            throw throwable;
        }
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        ISchedulingRule rule = this.workspace.getRuleFactory().markerRule(this);
        try {
            this.workspace.prepareOperation(rule, null);
            ResourceInfo info = this.getResourceInfo(false, false);
            this.checkAccessible(this.getFlags(info));
            this.workspace.beginOperation(true);
            this.workspace.getMarkerManager().removeMarkers(this, type, includeSubtypes, depth);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.workspace.endOperation(rule, false, null);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.workspace.endOperation(rule, false, null);
    }

    public void deleteResource(boolean convertToPhantom, MultiStatus status) throws CoreException {
        CoreException err = null;
        try {
            this.getPropertyManager().deleteResource(this);
        }
        catch (CoreException e) {
            if (status != null) {
                status.add(e.getStatus());
            }
            err = e;
        }
        if (this.exists()) {
            this.getMarkerManager().removeMarkers(this, 2);
        }
        if (this.isLinked()) {
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(1024, this));
            Project project = (Project)this.getProject();
            ProjectDescription description = project.internalGetDescription();
            description.setLinkLocation(this.getName(), null);
            project.internalSetDescription(description, true);
            project.writeDescription(1);
        }
        ProjectPreferences.deleted(this);
        if (convertToPhantom && this.getType() != 4 && this.synchronizing(this.getResourceInfo(true, false))) {
            this.convertToPhantom();
        } else {
            this.workspace.deleteResource(this);
        }
        if (err != null) {
            throw err;
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)target;
        return this.getType() == resource.getType() && this.path.equals(resource.path) && this.workspace.equals(resource.workspace);
    }

    public boolean exists() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.exists(this.getFlags(info), true);
    }

    public boolean exists(int flags, boolean checkType) {
        return flags != -1 && (!checkType || ResourceInfo.getType(flags) == this.getType());
    }

    public IMarker findMarker(long id) throws CoreException {
        return this.workspace.getMarkerManager().findMarker(this, id);
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return this.workspace.getMarkerManager().findMarkers(this, type, includeSubtypes, depth);
    }

    protected void fixupAfterMoveSource() throws CoreException {
        ResourceInfo info = this.getResourceInfo(true, true);
        if (this.isLinked()) {
            Project project = (Project)this.getProject();
            project.internalGetDescription().setLinkLocation(this.getName(), null);
            project.writeDescription(0);
        }
        ProjectPreferences.deleted(this);
        if (!this.synchronizing(info)) {
            this.workspace.deleteResource(this);
            return;
        }
        info.clearSessionProperties();
        info.clear(2);
        info.setLocalSyncInfo(-1L);
        info.set(8);
        info.clearModificationStamp();
        info.setMarkers(null);
    }

    public String getFileExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public int getFlags(ResourceInfo info) {
        return info == null ? -1 : info.getFlags();
    }

    public IPath getFullPath() {
        return this.path;
    }

    public FileSystemResourceManager getLocalManager() {
        return this.workspace.getFileSystemManager();
    }

    public long getLocalTimeStamp() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return info == null ? -1L : info.getLocalSyncInfo();
    }

    public IPath getLocation() {
        IProject project = this.getProject();
        if (project != null && !project.exists()) {
            return null;
        }
        return this.getLocalManager().locationFor(this);
    }

    public URL getLocationURL() {
        IProject project = this.getProject();
        if (project != null && !project.exists()) {
            return null;
        }
        try {
            return new URL("platform:/resource" + this.getFullPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IMarker getMarker(long id) {
        return new Marker(this, id);
    }

    protected MarkerManager getMarkerManager() {
        return this.workspace.getMarkerManager();
    }

    public long getModificationStamp() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return info == null ? -1L : info.getModificationStamp();
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IContainer getParent() {
        int segments = this.path.segmentCount();
        Assert.isLegal(segments > 1, this.path.toString());
        if (segments == 2) {
            return this.workspace.getRoot().getProject(this.path.segment(0));
        }
        return (IFolder)((Object)this.workspace.newResource(this.path.removeLastSegments(1), 2));
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getPropertyManager().getProperty(this, key);
    }

    public IProject getProject() {
        return this.workspace.getRoot().getProject(this.path.segment(0));
    }

    public IPath getProjectRelativePath() {
        return this.getFullPath().removeFirstSegments(1);
    }

    public PropertyManager getPropertyManager() {
        return this.workspace.getPropertyManager();
    }

    public IPath getRawLocation() {
        if (this.isLinked()) {
            return ((Project)this.getProject()).internalGetDescription().getLinkLocation(this.getName());
        }
        return this.getLocation();
    }

    public ResourceAttributes getResourceAttributes() {
        IPath location = this.getLocation();
        if (location == null) {
            return null;
        }
        return CoreFileSystemLibrary.getResourceAttributes(location.toOSString());
    }

    public ResourceInfo getResourceInfo(boolean phantom, boolean mutable) {
        return this.workspace.getResourceInfo(this.getFullPath(), phantom, mutable);
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return info.getSessionProperty(key);
    }

    public abstract int getType();

    public String getTypeString() {
        switch (this.getType()) {
            case 1: {
                return "L";
            }
            case 2: {
                return "F";
            }
            case 4: {
                return "P";
            }
            case 8: {
                return "R";
            }
        }
        return "";
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    protected void internalSetLocal(boolean flag, int depth) throws CoreException {
        ResourceInfo info = this.getResourceInfo(true, true);
        if (info.isSet(2) != flag) {
            if (flag && !this.isPhantom(this.getFlags(info))) {
                info.set(2);
                this.workspace.updateModificationStamp(info);
            } else {
                info.clear(2);
                info.clearModificationStamp();
            }
        }
        if (this.getType() == 1 || depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = ((IContainer)((Object)this)).members();
        int i = 0;
        while (i < children.length) {
            ((Resource)children[i]).internalSetLocal(flag, depth);
            ++i;
        }
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isConflicting(ISchedulingRule rule) {
        Class<?> clazz = rule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.WorkManager$NotifyRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (!(rule instanceof IResource)) {
            return false;
        }
        IPath otherPath = ((IResource)rule).getFullPath();
        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
    }

    public boolean isLocal(int depth) {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isLocal(this.getFlags(info), depth);
    }

    public boolean isLocal(int flags, int depth) {
        if (this.getType() == 4) {
            return flags != -1;
        }
        return flags != -1 && ResourceInfo.isSet(flags, 2);
    }

    public boolean isPhantom() {
        ResourceInfo info = this.getResourceInfo(true, false);
        return this.isPhantom(this.getFlags(info));
    }

    public boolean isPhantom(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 8);
    }

    public boolean isReadOnly() {
        IPath location = this.getLocation();
        if (location == null) {
            return false;
        }
        return CoreFileSystemLibrary.isReadOnly(location.toOSString());
    }

    public boolean isSynchronized(int depth) {
        return this.getLocalManager().isSynchronized(this, depth);
    }

    protected IPath makePathAbsolute(IPath target) {
        if (target.isAbsolute()) {
            return target;
        }
        return this.getParent().getFullPath().append(target);
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.move(description, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(description);
        if (this.getType() != 4) {
            String message = Policy.bind("resources.moveNotProject", this.getFullPath().toString(), description.getName());
            throw new ResourceException(77, this.getFullPath(), message, null);
        }
        ((Project)this).move(description, updateFlags, monitor);
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.move(destination, force ? 1 : 0, monitor);
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.move(destination, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.moving", this.getFullPath().toString());
            monitor.beginTask(message, 100);
            Policy.checkCanceled(monitor);
            destination = this.makePathAbsolute(destination);
            this.checkValidPath(destination, this.getType(), false);
            Resource destResource = this.workspace.newResource(destination, this.getType());
            ISchedulingRule rule = this.workspace.getRuleFactory().moveRule(this, destResource);
            try {
                try {
                    ResourceTree tree;
                    block12: {
                        this.workspace.prepareOperation(rule, monitor);
                        this.assertMoveRequirements(destination, this.getType(), updateFlags);
                        this.workspace.beginOperation(true);
                        IPath originalLocation = this.getLocation();
                        message = Policy.bind("resources.moveProblem");
                        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 4, message, null);
                        WorkManager workManager = this.workspace.getWorkManager();
                        tree = new ResourceTree(workManager.getLock(), status, updateFlags);
                        boolean success = false;
                        int depth = 0;
                        try {
                            depth = workManager.beginUnprotected();
                            success = this.unprotectedMove(tree, destResource, updateFlags, monitor);
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            workManager.endUnprotected(depth);
                            throw throwable;
                        }
                        {
                            Object var13_16 = null;
                            workManager.endUnprotected(depth);
                            tree.makeInvalid();
                            if (!success) break block12;
                        }
                        this.workspace.getAliasManager().updateAliases(this, originalLocation, 2, monitor);
                        this.workspace.getAliasManager().updateAliases(destResource, destResource.getLocation(), 2, monitor);
                    }
                    if (!tree.getStatus().isOK()) {
                        throw new ResourceException(tree.getStatus());
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var15_19 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_22 = null;
            monitor.done();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            ISchedulingRule rule;
            boolean build;
            block10: {
                boolean isRoot = this.getType() == 8;
                String message = isRoot ? Policy.bind("resources.refreshingRoot") : Policy.bind("resources.refreshing", this.getFullPath().toString());
                monitor.beginTask(message, 100);
                build = false;
                rule = this.workspace.getRuleFactory().refreshRule(this);
                this.workspace.prepareOperation(rule, monitor);
                if (isRoot || this.getProject().isAccessible()) break block10;
                Object var8_7 = null;
                this.workspace.endOperation(rule, build, Policy.subMonitorFor(monitor, Policy.endOpWork));
                Object var10_10 = null;
                monitor.done();
                return;
            }
            this.workspace.beginOperation(true);
            build = this.getLocalManager().refresh(this, depth, true, Policy.subMonitorFor(monitor, Policy.opWork));
            Object var8_9 = null;
            this.workspace.endOperation(rule, build, Policy.subMonitorFor(monitor, Policy.endOpWork));
            {
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.workspace.endOperation(rule, build, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    throw throwable;
                }
            }
            Object var10_12 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.setLocal");
            monitor.beginTask(message, 100);
            try {
                this.workspace.prepareOperation(null, monitor);
                this.workspace.beginOperation(true);
                this.internalSetLocal(flag, depth);
                monitor.worked(Policy.opWork);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
            monitor.done();
            return;
        }
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        if (value < 0L) {
            throw new IllegalArgumentException("Illegal time stamp: " + value);
        }
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().setLocalTimeStamp(this, info, value);
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        this.getPropertyManager().setProperty(this, key, value);
    }

    public void setReadOnly(boolean readonly) {
        IPath location = this.getLocation();
        if (location != null) {
            CoreFileSystemLibrary.setReadOnly(location.toOSString(), readonly);
        }
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        IPath location = this.getLocation();
        if (location == null) {
            String message = Policy.bind("localstore.locationUndefined", this.getFullPath().toString());
            throw new ResourceException(272, this.getFullPath(), message, null);
        }
        CoreFileSystemLibrary.setResourceAttributes(location.toOSString(), attributes);
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        info.setSessionProperty(key, value);
    }

    public boolean synchronizing(ResourceInfo info) {
        return info != null && info.getSyncInfo(false) != null;
    }

    public String toString() {
        return String.valueOf(this.getTypeString()) + this.getFullPath().toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void touch(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.touch", this.getFullPath().toString());
            monitor.beginTask(message, 100);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    int flags = this.getFlags(info);
                    this.checkAccessible(flags);
                    this.checkLocal(flags, 0);
                    this.workspace.beginOperation(true);
                    info = this.getResourceInfo(false, true);
                    info.incrementContentId();
                    info.clear(393216);
                    this.workspace.updateModificationStamp(info);
                    monitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var6_9 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
            monitor.done();
            return;
        }
    }

    public IResource findExistingResourceVariant(IPath target) {
        if (!this.workspace.tree.includesIgnoreCase(target)) {
            return null;
        }
        IPath result = Path.ROOT;
        int segmentCount = target.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            String[] childNames = this.workspace.tree.getNamesOfChildren(result);
            String name = this.findVariant(target.segment(i), childNames);
            if (name == null) {
                return null;
            }
            result = result.append(name);
            ++i;
        }
        return this.workspace.getRoot().findMember(result);
    }

    private String findVariant(String target, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (target.equalsIgnoreCase(list[i])) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isDerived() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isDerived(this.getFlags(info));
    }

    public boolean isDerived(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 16384);
    }

    public boolean isLinked() {
        if (this.path.segmentCount() != 2) {
            return false;
        }
        ResourceInfo info = this.getResourceInfo(false, false);
        return info != null && info.isSet(65536);
    }

    public void setDerived(boolean isDerived) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        if (info.getType() == 1 || info.getType() == 2) {
            if (isDerived) {
                info.set(16384);
            } else {
                info.clear(16384);
            }
        }
    }

    public boolean isTeamPrivateMember() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isTeamPrivateMember(this.getFlags(info));
    }

    public boolean isTeamPrivateMember(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 32768);
    }

    public boolean isUnderLink() {
        int depth = this.path.segmentCount();
        if (depth < 2) {
            return false;
        }
        if (depth == 2) {
            return this.isLinked();
        }
        IPath linkParent = this.path.removeLastSegments(depth - 2);
        return this.workspace.getResourceInfo(linkParent, false, false).isSet(65536);
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        if (info.getType() == 1 || info.getType() == 2) {
            if (isTeamPrivate) {
                info.set(32768);
            } else {
                info.clear(32768);
            }
        }
    }

    private void unprotectedDelete(ResourceTree tree, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
        switch (this.getType()) {
            case 1: {
                if (hook.deleteFile(tree, (IFile)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2))) break;
                tree.standardDeleteFile((IFile)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2));
                break;
            }
            case 2: {
                if (hook.deleteFolder(tree, (IFolder)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2))) break;
                tree.standardDeleteFolder((IFolder)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2));
                break;
            }
            case 4: {
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, this));
                if (hook.deleteProject(tree, (IProject)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2))) break;
                tree.standardDeleteProject((IProject)((Object)this), updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / 2));
                break;
            }
            case 8: {
                IProject[] projects = ((IWorkspaceRoot)((Object)this)).getProjects();
                int i = 0;
                while (i < projects.length) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(16, projects[i]));
                    if (!hook.deleteProject(tree, projects[i], updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / projects.length / 2))) {
                        tree.standardDeleteProject(projects[i], updateFlags, Policy.subMonitorFor(monitor, Policy.opWork * 1000 / projects.length / 2));
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private boolean unprotectedMove(ResourceTree tree, IResource destination, int updateFlags, IProgressMonitor monitor) throws CoreException, ResourceException {
        IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
        switch (this.getType()) {
            case 1: {
                if (this.isLinked()) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2048, this, destination, updateFlags));
                }
                if (hook.moveFile(tree, (IFile)((Object)this), (IFile)destination, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) break;
                tree.standardMoveFile((IFile)((Object)this), (IFile)destination, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                break;
            }
            case 2: {
                if (this.isLinked()) {
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2048, this, destination, updateFlags));
                }
                if (hook.moveFolder(tree, (IFolder)((Object)this), (IFolder)destination, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) break;
                tree.standardMoveFolder((IFolder)((Object)this), (IFolder)destination, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                break;
            }
            case 4: {
                IProject project = (IProject)((Object)this);
                if (this.getName().equals(destination.getName())) {
                    return false;
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, destination, updateFlags));
                IProjectDescription description = project.getDescription();
                description.setName(destination.getName());
                if (hook.moveProject(tree, project, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) break;
                tree.standardMoveProject(project, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                break;
            }
            case 8: {
                String msg = Policy.bind("resources.moveRoot");
                throw new ResourceException(new ResourceStatus(77, this.getFullPath(), msg));
            }
        }
        return true;
    }
}

