/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.BindingPattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.TypePattern;

public class BindingTypePattern
extends ExactTypePattern
implements BindingPattern {
    private int formalIndex;

    public BindingTypePattern(TypeX type, int index, boolean isVarArgs) {
        super(type, false, isVarArgs);
        this.formalIndex = index;
    }

    public BindingTypePattern(FormalBinding binding, boolean isVarArgs) {
        this(binding.getType(), binding.getIndex(), isVarArgs);
    }

    public int getFormalIndex() {
        return this.formalIndex;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BindingTypePattern)) {
            return false;
        }
        BindingTypePattern o = (BindingTypePattern)other;
        if (this.includeSubtypes != o.includeSubtypes) {
            return false;
        }
        if (this.isVarArgs != o.isVarArgs) {
            return false;
        }
        return o.type.equals(this.type) && o.formalIndex == this.formalIndex;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.formalIndex;
        return result;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(3);
        this.type.write(out);
        out.writeShort((short)this.formalIndex);
        out.writeBoolean(this.isVarArgs);
        this.writeLocation(out);
    }

    public static TypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        BindingTypePattern ret = new BindingTypePattern(TypeX.read(s), s.readShort(), s.readBoolean());
        ret.readLocation(context, s);
        return ret;
    }

    public TypePattern remapAdviceFormals(IntMap bindings) {
        if (!bindings.hasKey(this.formalIndex)) {
            return new ExactTypePattern(this.type, false, this.isVarArgs);
        }
        int newFormalIndex = bindings.get(this.formalIndex);
        return new BindingTypePattern(this.type, newFormalIndex, this.isVarArgs);
    }

    public String toString() {
        return "BindingTypePattern(" + super.toString() + ", " + this.formalIndex + ")";
    }
}

