/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.ISourceReference;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.MoveElementsOperation;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(IJavaElement[] elements, IJavaElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    protected String getMainTaskName() {
        return Util.bind("operation.renameElementProgress");
    }

    protected boolean isRename() {
        return true;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList == null || this.renamingsList.length == 0) {
            return new JavaModelStatus(982);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        Member localContext;
        int elementType = element.getElementType();
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if (elementType < 7 || elementType == 10) {
            this.error(967, element);
        }
        if (element instanceof Member && (localContext = ((Member)element).getOuterMostLocalContext()) != null && localContext != element) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

