/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IDependent;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public abstract class ReferenceBinding
extends TypeBinding
implements IDependent {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        boolean ret = this.innerCanBeSeenBy(receiverType, invocationType);
        if (ret) {
            return true;
        }
        if (Scope.findPrivilegedHandler(invocationType) != null) {
            Scope.findPrivilegedHandler(invocationType).notePrivilegedTypeAccess(this, null);
            return true;
        }
        return false;
    }

    private final boolean innerCanBeSeenBy(ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        ReferenceBinding declaringClass;
        if (this.isPublic()) {
            return true;
        }
        if (invocationType == this && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this) {
                return true;
            }
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass2 = this.enclosingType();
            if (declaringClass2 == null) {
                return false;
            }
            do {
                if (declaringClass2 == invocationType) {
                    return true;
                }
                if (!declaringClass2.isSuperclassOf(currentType)) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            TypeVariableBinding typeVariable;
            if (!(receiverType == this || receiverType == this.enclosingType() || receiverType.isTypeVariable() && ((typeVariable = (TypeVariableBinding)receiverType).isErasureBoundTo(this.erasure()) || typeVariable.isErasureBoundTo(this.enclosingType().erasure())))) {
                return false;
            }
            if (invocationType != this) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding type = receiverType;
        ReferenceBinding referenceBinding = declaringClass = this.enclosingType() == null ? this : this.enclosingType();
        do {
            if (declaringClass == type) {
                return true;
            }
            if (this.fPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        boolean ret = this.innerCanBeSeenBy(scope);
        if (ret) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (Scope.findPrivilegedHandler(invocationType) != null) {
            Scope.findPrivilegedHandler(invocationType).notePrivilegedTypeAccess(this, null);
            return true;
        }
        return false;
    }

    private final boolean innerCanBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        if (scope.kind == 4) {
            return this.canBeSeenBy(((CompilationUnitScope)scope).fPackage);
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (invocationType == this) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass = this.enclosingType();
            if (declaringClass == null) {
                return false;
            }
            do {
                if (declaringClass == invocationType) {
                    return true;
                }
                if (!declaringClass.isSuperclassOf(currentType)) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.fPackage;
    }

    public void computeId() {
        switch (this.compoundName.length) {
            case 3: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    if (CharOperation.equals(TypeConstants.JAVA_IO_PRINTSTREAM, this.compoundName)) {
                        this.id = 24;
                    } else if (CharOperation.equals(TypeConstants.JAVA_UTIL_ITERATOR, this.compoundName)) {
                        this.id = 39;
                    } else if (CharOperation.equals(TypeConstants.JAVA_IO_SERIALIZABLE, this.compoundName)) {
                        this.id = 37;
                    }
                    return;
                }
                char[] typeName = this.compoundName[2];
                if (typeName.length == 0) {
                    return;
                }
                switch (typeName[0]) {
                    case 'A': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ASSERTIONERROR[2])) {
                            this.id = 35;
                        }
                        return;
                    }
                    case 'B': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_BOOLEAN[2])) {
                            this.id = 33;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_BYTE[2])) {
                            this.id = 26;
                        }
                        return;
                    }
                    case 'C': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CHARACTER[2])) {
                            this.id = 28;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLASS[2])) {
                            this.id = 16;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                            this.id = 23;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_CLONEABLE[2])) {
                            this.id = 36;
                        }
                        return;
                    }
                    case 'D': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_DOUBLE[2])) {
                            this.id = 32;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                            this.id = 44;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ERROR[2])) {
                            this.id = 19;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_EXCEPTION[2])) {
                            this.id = 25;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ENUM[2])) {
                            this.id = 41;
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        }
                        return;
                    }
                    case 'I': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_INTEGER[2])) {
                            this.id = 29;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ITERABLE[2])) {
                            this.id = 38;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                            this.id = 42;
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_NOCLASSDEFERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_OBJECT[2])) {
                            this.id = 1;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_OVERRIDE[2])) {
                            this.id = 47;
                        }
                        return;
                    }
                    case 'S': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRING[2])) {
                            this.id = 11;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRINGBUFFER[2])) {
                            this.id = 17;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_STRINGBUILDER[2])) {
                            this.id = 40;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SYSTEM[2])) {
                            this.id = 18;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SHORT[2])) {
                            this.id = 27;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_SUPPRESSWARNINGS[2])) {
                            this.id = 49;
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    return;
                }
                char[] packageName = this.compoundName[2];
                if (packageName.length == 0) {
                    return;
                }
                char[] typeName = this.compoundName[3];
                if (typeName.length == 0) {
                    return;
                }
                if (CharOperation.equals(packageName, TypeConstants.REFLECT)) {
                    if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[3])) {
                        this.id = 20;
                    }
                    return;
                }
                if (!CharOperation.equals(packageName, TypeConstants.ANNOTATION)) break;
                switch (typeName[0]) {
                    case 'A': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                            this.id = 43;
                        }
                        return;
                    }
                    case 'D': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                            this.id = 45;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                            this.id = 52;
                        }
                        return;
                    }
                    case 'I': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                            this.id = 46;
                        }
                        return;
                    }
                    case 'R': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                            this.id = 48;
                        } else if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                            this.id = 51;
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(typeName, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                            this.id = 50;
                        }
                        return;
                    }
                }
            }
        }
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int depth = 0;
        ReferenceBinding current = this;
        while ((current = current.enclosingType()) != null) {
            ++depth;
        }
        return depth;
    }

    public final ReferenceBinding enclosingTypeAt(int relativeDepth) {
        ReferenceBinding current = this;
        while (relativeDepth-- > 0 && current != null) {
            current = current.enclosingType();
        }
        return current;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return TypeConstants.NoFields;
    }

    public ReferenceBinding findSuperTypeErasingTo(int erasureId, boolean erasureIsClass) {
        if (this.id == erasureId || this.erasure().id == erasureId) {
            return this;
        }
        ReferenceBinding currentType = this;
        if (erasureIsClass) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType.id != erasureId && currentType.erasure().id != erasureId) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType.id == erasureId || currentType.erasure().id == erasureId) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ReferenceBinding findSuperTypeErasingTo(ReferenceBinding erasure) {
        if (this == erasure || this.erasure() == erasure) {
            return this;
        }
        ReferenceBinding currentType = this;
        if (erasure.isClass()) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType != erasure && currentType.erasure() != erasure) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType == erasure || currentType.erasure() == erasure) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes) {
        return this.getExactMethod(selector, argumentTypes, null);
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean resolve, InvocationSite site, Scope scope) {
        return this.getField(fieldName, resolve);
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding[] memberTypes = this.memberTypes();
        int i = memberTypes.length;
        while (--i >= 0) {
            if (!CharOperation.equals(memberTypes[i].sourceName, typeName)) continue;
            return memberTypes[i];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        return TypeConstants.NoMethods;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        TypeVariableBinding[] typeVariables = this.typeVariables();
        int i = typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(typeVariables[i].sourceName, variableName)) continue;
            return typeVariables[i];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean implementsInterface(ReferenceBinding anInterface, boolean searchHierarchy) {
        if (this == anInterface) {
            return true;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        ReferenceBinding currentType = this;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while (searchHierarchy && (currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType.isEquivalentTo(anInterface)) {
                    return true;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding method) {
        ReferenceBinding type = this;
        while (type != null) {
            MethodBinding[] methods = type.getMethods(method.selector);
            int i = methods.length;
            while (--i >= 0) {
                if (!methods[i].areParametersEqual(method)) continue;
                return true;
            }
            type = type.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isCompatibleWith(TypeBinding otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType.id == 1) {
            return true;
        }
        if (!(otherType instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding otherReferenceType = (ReferenceBinding)otherType;
        if (this.isEquivalentTo(otherReferenceType)) {
            return true;
        }
        if (otherReferenceType.isWildcard()) {
            return false;
        }
        if (otherReferenceType.isInterface()) {
            return this.implementsInterface(otherReferenceType, true);
        }
        if (this.isInterface()) {
            return false;
        }
        return otherReferenceType.isSuperclassOf(this);
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x2200) == 512;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPrivateUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        while ((otherType = otherType.superclass()) != null) {
            if (!otherType.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x100000) != 0 || (this.modifiers & 0x200000) != 0;
    }

    public ReferenceBinding[] memberTypes() {
        return TypeConstants.NoMemberTypes;
    }

    public boolean needsUncheckedConversion(TypeBinding targetType) {
        if (this == targetType) {
            return false;
        }
        if (!(targetType instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding compatible = this.findSuperTypeErasingTo((ReferenceBinding)targetType.erasure());
        if (compatible == null) {
            return false;
        }
        if (!compatible.isPartOfRawType()) {
            return false;
        }
        do {
            if (!compatible.isRawType() || !targetType.isBoundParameterizedType() && !targetType.isGenericType()) continue;
            return true;
        } while ((compatible = compatible.enclosingType()) != null && (targetType = targetType.enclosingType()) != null);
        return false;
    }

    public MethodBinding[] methods() {
        return TypeConstants.NoMethods;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        TypeVariableBinding[] typeVars = this.typeVariables();
        if (typeVars != TypeConstants.NoTypeVariables) {
            StringBuffer nameBuffer = new StringBuffer(10);
            nameBuffer.append(readableName).append('<');
            int i = 0;
            int length = typeVars.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i].readableName());
                ++i;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            readableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, readableName, 0);
        }
        return readableName;
    }

    public char[] shortReadableName() {
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        TypeVariableBinding[] typeVars = this.typeVariables();
        if (typeVars != TypeConstants.NoTypeVariables) {
            StringBuffer nameBuffer = new StringBuffer(10);
            nameBuffer.append(shortReadableName).append('<');
            int i = 0;
            int length = typeVars.length;
            while (i < length) {
                if (i > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i].shortReadableName());
                ++i;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            shortReadableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, shortReadableName, 0);
        }
        return shortReadableName;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return TypeConstants.NoSuperInterfaces;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType == null) {
            return null;
        }
        return new ReferenceBinding[]{enclosingType};
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }
}

