/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    public MethodBinding tiebreakMethod;

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, TypeBinding[] typeArguments, LookupEnvironment environment) {
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = originalMethod.declaringClass;
        this.typeVariables = TypeConstants.NoTypeVariables;
        this.typeArguments = typeArguments;
        this.isRaw = false;
        this.originalMethod = originalMethod;
        this.parameters = Scope.substitute((Substitution)this, originalMethod.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, originalMethod.thrownExceptions);
        this.returnType = this.substitute(originalMethod.returnType);
        this.wasInferred = true;
    }

    public ParameterizedGenericMethodBinding(MethodBinding originalMethod, RawTypeBinding rawType, LookupEnvironment environment) {
        TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        int length = originalVariables.length;
        TypeBinding[] rawArguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            rawArguments[i] = originalVariables[i].erasure();
            ++i;
        }
        this.isRaw = true;
        this.environment = environment;
        this.modifiers = originalMethod.modifiers;
        this.selector = originalMethod.selector;
        this.declaringClass = rawType == null ? originalMethod.declaringClass : rawType;
        this.typeVariables = TypeConstants.NoTypeVariables;
        this.typeArguments = rawArguments;
        this.originalMethod = originalMethod;
        boolean ignoreRawTypeSubstitution = rawType == null || originalMethod.isStatic();
        this.parameters = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.parameters : Scope.substitute((Substitution)rawType, originalMethod.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, ignoreRawTypeSubstitution ? originalMethod.thrownExceptions : Scope.substitute((Substitution)rawType, originalMethod.thrownExceptions));
        this.returnType = this.substitute(ignoreRawTypeSubstitution ? originalMethod.returnType : rawType.substitute(originalMethod.returnType));
        this.wasInferred = false;
    }

    public static MethodBinding computeCompatibleMethod(MethodBinding originalMethod, TypeBinding[] arguments, Scope scope, InvocationSite invocationSite) {
        ParameterizedGenericMethodBinding methodSubstitute;
        TypeVariableBinding[] typeVariables = originalMethod.typeVariables;
        TypeBinding[] substitutes = invocationSite.genericTypeArguments();
        if (substitutes != null) {
            if (substitutes.length != typeVariables.length) {
                return new ProblemMethodBinding(originalMethod, originalMethod.selector, substitutes, 11);
            }
            methodSubstitute = new ParameterizedGenericMethodBinding(originalMethod, substitutes, scope.environment());
        } else {
            int i;
            int paramLength;
            TypeBinding[] parameters = originalMethod.parameters;
            int varLength = typeVariables.length;
            HashMap<TypeVariableBinding, TypeBinding[]> collectedSubstitutes = new HashMap<TypeVariableBinding, TypeBinding[]>(varLength);
            int i2 = 0;
            while (i2 < varLength) {
                collectedSubstitutes.put(typeVariables[i2], new TypeBinding[1]);
                ++i2;
            }
            if (originalMethod.isVarargs()) {
                paramLength = parameters.length;
                int minArgLength = paramLength - 1;
                int argLength = arguments.length;
                int i3 = 0;
                while (i3 < minArgLength) {
                    parameters[i3].collectSubstitutes(arguments[i3], collectedSubstitutes);
                    ++i3;
                }
                if (minArgLength < argLength) {
                    TypeBinding varargType = parameters[minArgLength];
                    if (paramLength != argLength || arguments[minArgLength] != BaseTypes.NullBinding && arguments[minArgLength].dimensions() != varargType.dimensions()) {
                        varargType = ((ArrayBinding)varargType).elementsType();
                    }
                    int i4 = minArgLength;
                    while (i4 < argLength) {
                        varargType.collectSubstitutes(arguments[i4], collectedSubstitutes);
                        ++i4;
                    }
                }
            } else {
                paramLength = parameters.length;
                i = 0;
                while (i < paramLength) {
                    parameters[i].collectSubstitutes(arguments[i], collectedSubstitutes);
                    ++i;
                }
            }
            boolean needReturnTypeInference = false;
            if (collectedSubstitutes.isEmpty()) {
                methodSubstitute = new ParameterizedGenericMethodBinding(originalMethod, null, scope.environment());
            } else {
                substitutes = new TypeBinding[varLength];
                i = 0;
                while (i < varLength) {
                    TypeBinding[] variableSubstitutes = (TypeBinding[])collectedSubstitutes.get(typeVariables[i]);
                    TypeBinding mostSpecificSubstitute = scope.lowerUpperBound(variableSubstitutes);
                    if (mostSpecificSubstitute == null) {
                        return null;
                    }
                    if (mostSpecificSubstitute == BaseTypes.VoidBinding) {
                        needReturnTypeInference = true;
                        mostSpecificSubstitute = typeVariables[i];
                    }
                    substitutes[i] = mostSpecificSubstitute;
                    ++i;
                }
                methodSubstitute = new ParameterizedGenericMethodBinding(originalMethod, substitutes, scope.environment());
            }
            if (needReturnTypeInference && invocationSite instanceof MessageSend) {
                MessageSend message = (MessageSend)invocationSite;
                TypeBinding expectedType = message.expectedType;
                if (expectedType == null) {
                    expectedType = methodSubstitute.returnType.isTypeVariable() ? methodSubstitute.returnType.erasure() : scope.getJavaLangObject();
                }
                methodSubstitute.inferFromExpectedType(expectedType, scope);
            }
        }
        if (!methodSubstitute.isRaw) {
            int i = 0;
            int length = typeVariables.length;
            while (i < length) {
                TypeVariableBinding typeVariable = typeVariables[i];
                TypeBinding substitute = substitutes[i];
                if (!typeVariable.boundCheck(methodSubstitute, substitute)) {
                    return new ProblemMethodBinding(methodSubstitute, originalMethod.selector, new TypeBinding[]{substitutes[i], typeVariables[i]}, 10);
                }
                ++i;
            }
        }
        return methodSubstitute;
    }

    public char[] computeUniqueKey() {
        if (this.isRaw) {
            return super.computeUniqueKey();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.computeUniqueKey());
        buffer.append('%');
        buffer.append('<');
        int length = this.typeArguments.length;
        int i = 0;
        while (i < length) {
            TypeBinding typeArgument = this.typeArguments[i];
            buffer.append(typeArgument.computeUniqueKey());
            ++i;
        }
        buffer.append('>');
        int resultLength = buffer.length();
        char[] result = new char[resultLength];
        buffer.getChars(0, resultLength, result, 0);
        return result;
    }

    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    public boolean hasSubstitutedReturnType() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    public void inferFromExpectedType(TypeBinding expectedType, Scope scope) {
        if (this.returnType == expectedType) {
            return;
        }
        if ((this.returnType.tagBits & 0x20000000L) == 0L) {
            return;
        }
        HashMap<TypeVariableBinding, TypeBinding[]> substitutes = new HashMap<TypeVariableBinding, TypeBinding[]>(1);
        int length = this.typeArguments.length;
        TypeVariableBinding[] originalVariables = this.original().typeVariables;
        boolean hasUnboundParameters = false;
        int i = 0;
        while (i < length) {
            if (this.typeArguments[i] == originalVariables[i]) {
                hasUnboundParameters = true;
                substitutes.put(originalVariables[i], new TypeBinding[1]);
            } else {
                substitutes.put(originalVariables[i], new TypeBinding[]{this.typeArguments[i]});
            }
            ++i;
        }
        if (!hasUnboundParameters) {
            return;
        }
        this.returnType.collectSubstitutes(expectedType, substitutes);
        if (substitutes.isEmpty()) {
            this.isRaw = true;
            i = 0;
            while (i < length) {
                this.typeArguments[i] = originalVariables[i].erasure();
                ++i;
            }
        } else {
            i = 0;
            while (i < length) {
                TypeBinding[] variableSubstitutes = (TypeBinding[])substitutes.get(originalVariables[i]);
                TypeBinding mostSpecificSubstitute = scope.lowerUpperBound(variableSubstitutes);
                if (mostSpecificSubstitute == null) {
                    return;
                }
                if (mostSpecificSubstitute == BaseTypes.VoidBinding) {
                    mostSpecificSubstitute = originalVariables[i].erasure();
                }
                this.typeArguments[i] = mostSpecificSubstitute;
                ++i;
            }
        }
        TypeBinding oldReturnType = this.returnType;
        this.returnType = this.substitute(this.returnType);
        this.inferredReturnType = this.returnType != oldReturnType;
        this.parameters = Scope.substitute((Substitution)this, this.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeBinding substitute(TypeBinding originalType) {
        switch (originalType.kind()) {
            case 2052: {
                TypeVariableBinding originalVariable = (TypeVariableBinding)originalType;
                TypeVariableBinding[] variables = this.originalMethod.typeVariables;
                int length = variables.length;
                if (originalVariable.rank < length && variables[originalVariable.rank] == originalVariable) {
                    return this.typeArguments[originalVariable.rank];
                }
                if (!(this.declaringClass instanceof Substitution)) return originalType;
                return ((Substitution)((Object)this.declaringClass)).substitute(originalType);
            }
            case 132: {
                TypeBinding[] originalArguments;
                ReferenceBinding originalEnclosing;
                ParameterizedTypeBinding originalParameterizedType = (ParameterizedTypeBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)this.substitute(originalEnclosing);
                }
                if (this.isRaw) {
                    return this.environment.createRawType(originalParameterizedType.type, substitutedEnclosing);
                }
                TypeBinding[] substitutedArguments = originalArguments = originalParameterizedType.arguments;
                if (originalArguments != null) {
                    substitutedArguments = Scope.substitute((Substitution)this, originalArguments);
                }
                if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) return originalType;
                if (substitutedEnclosing != originalEnclosing) return this.environment.createParameterizedType(originalParameterizedType.type, substitutedArguments, substitutedEnclosing);
                TypeVariableBinding[] originalVariables = originalParameterizedType.type.typeVariables();
                int length = originalVariables.length;
                int i = 0;
                while (i < length) {
                    if (substitutedArguments[i] != originalVariables[i]) return this.environment.createParameterizedType(originalParameterizedType.type, substitutedArguments, substitutedEnclosing);
                    ++i;
                }
                return originalParameterizedType.type;
            }
            case 68: {
                TypeBinding originalLeafComponentType = originalType.leafComponentType();
                TypeBinding substitute = this.substitute(originalLeafComponentType);
                if (substitute == originalLeafComponentType) return originalType;
                return this.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalType.dimensions());
            }
            case 260: {
                TypeBinding originalBound;
                TypeBinding substitutedBound;
                WildcardBinding wildcard = (WildcardBinding)originalType;
                if (wildcard.kind == 0 || (substitutedBound = this.substitute(originalBound = wildcard.bound)) == originalBound) return originalType;
                return this.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, wildcard.kind);
            }
            case 1028: {
                ReferenceBinding originalEnclosing;
                ReferenceBinding originalGenericType = (ReferenceBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)this.substitute(originalEnclosing);
                }
                if (this.isRaw) {
                    return this.environment.createRawType(originalGenericType, substitutedEnclosing);
                }
                TypeVariableBinding[] originalVariables = originalGenericType.typeVariables();
                int length = originalVariables.length;
                TypeBinding[] originalArguments = new TypeBinding[length];
                System.arraycopy(originalVariables, 0, originalArguments, 0, length);
                TypeBinding[] substitutedArguments = Scope.substitute((Substitution)this, originalArguments);
                if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) return originalType;
                return this.environment.createParameterizedType(originalGenericType, substitutedArguments, substitutedEnclosing);
            }
        }
        return originalType;
    }

    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            this.tiebreakMethod = new ParameterizedGenericMethodBinding(this.originalMethod, null, this.environment);
        }
        return this.tiebreakMethod;
    }
}

