/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;

class BindingKeyScanner {
    static final int START = -1;
    static final int PACKAGE = 0;
    static final int TYPE = 1;
    static final int FIELD = 2;
    static final int METHOD = 3;
    static final int ARRAY = 4;
    static final int TYPE_PARAMETER = 5;
    static final int LOCAL_VAR = 6;
    static final int END = 7;
    int index = 0;
    int start;
    char[] source;
    int token = -1;

    BindingKeyScanner(char[] source) {
        this.source = source;
    }

    char[] getTokenSource() {
        int length = this.index - this.start;
        char[] result = new char[length];
        System.arraycopy(this.source, this.start, result, 0, length);
        return result;
    }

    boolean isAtFieldOrMethodStart() {
        return this.index + 1 < this.source.length && this.source[this.index + 1] == '.';
    }

    boolean isAtLocalVariableStart() {
        return this.index < this.source.length && this.source[this.index] == '#';
    }

    boolean isAtMemberTypeStart() {
        return this.index < this.source.length && (this.source[this.index] == '$' || this.source[this.index] == '.' && this.source[this.index - 1] == '>');
    }

    boolean isAtParametersStart() {
        char currentChar;
        return this.index > 0 && this.index < this.source.length && ((currentChar = this.source[this.index]) == '<' || currentChar == '%');
    }

    boolean isAtTypeParameterStart() {
        return this.index + 1 < this.source.length && this.source[this.index + 1] == 'T';
    }

    boolean isAtTypeStart() {
        return this.index + 1 < this.source.length && "LIZVCDBFJS[".indexOf(this.source[this.index + 1]) != -1;
    }

    boolean isAtWildCardStart() {
        return this.index + 1 < this.source.length && "*+-".indexOf(this.source[this.index + 1]) != -1;
    }

    int nextToken() {
        int previousTokenEnd = this.index;
        this.start = this.index;
        int length = this.source.length;
        while (this.index <= length) {
            int currentChar = this.index == length ? 0 : this.source[this.index];
            switch (currentChar) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 86: 
                case 90: {
                    if (this.index != previousTokenEnd) break;
                    ++this.index;
                    this.token = 1;
                    return this.token;
                }
                case 76: 
                case 84: {
                    if (this.index != previousTokenEnd) break;
                    this.start = this.index + 1;
                    break;
                }
                case 36: 
                case 59: {
                    if (this.index == previousTokenEnd) {
                        previousTokenEnd = this.start = this.index + 1;
                        break;
                    }
                    this.token = 1;
                    return this.token;
                }
                case 37: 
                case 46: {
                    previousTokenEnd = this.start = this.index + 1;
                    break;
                }
                case 91: {
                    while (this.index < length && this.source[this.index] == '[') {
                        ++this.index;
                    }
                    this.token = 4;
                    return this.token;
                }
                case 60: {
                    if (this.index == previousTokenEnd) {
                        previousTokenEnd = this.start = this.index + 1;
                        break;
                    }
                    if (this.start <= 0) break;
                    switch (this.source[this.start - 1]) {
                        case '.': {
                            this.token = this.source[this.start - 2] == '>' ? 1 : 3;
                            return this.token;
                        }
                    }
                    this.token = 1;
                    return this.token;
                }
                case 40: {
                    this.token = 3;
                    return this.token;
                }
                case 41: {
                    this.start = ++this.index;
                    this.token = 7;
                    return this.token;
                }
                case 58: {
                    this.token = 5;
                    return this.token;
                }
                case 35: {
                    if (this.index == previousTokenEnd) {
                        previousTokenEnd = this.start = this.index + 1;
                        break;
                    }
                    this.token = 6;
                    return this.token;
                }
                case 0: {
                    switch (this.token) {
                        case -1: {
                            this.token = 0;
                            break;
                        }
                        case 3: 
                        case 6: {
                            this.token = 6;
                            break;
                        }
                        case 1: {
                            if (this.index > this.start && this.source[this.start - 1] == '.') {
                                this.token = 2;
                                break;
                            }
                            this.token = 7;
                            break;
                        }
                        default: {
                            this.token = 7;
                        }
                    }
                    return this.token;
                }
                case 42: 
                case 43: 
                case 45: {
                    ++this.index;
                    this.token = 1;
                    return this.token;
                }
            }
            ++this.index;
        }
        this.token = 7;
        return this.token;
    }

    void skipMethodSignature() {
        char currentChar;
        while (this.index < this.source.length && (currentChar = this.source[this.index]) != '#' && currentChar != '%') {
            ++this.index;
        }
    }

    void skipParametersEnd() {
        while (this.index < this.source.length && this.source[this.index] != '>') {
            ++this.index;
        }
        ++this.index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.token) {
            case -1: {
                buffer.append("START: ");
                break;
            }
            case 0: {
                buffer.append("PACKAGE: ");
                break;
            }
            case 1: {
                buffer.append("TYPE: ");
                break;
            }
            case 2: {
                buffer.append("FIELD: ");
                break;
            }
            case 3: {
                buffer.append("METHOD: ");
                break;
            }
            case 4: {
                buffer.append("ARRAY: ");
                break;
            }
            case 5: {
                buffer.append("TYPE PARAMETER: ");
                break;
            }
            case 6: {
                buffer.append("LOCAL VAR: ");
                break;
            }
            case 7: {
                buffer.append("END: ");
            }
        }
        if (this.index < 0) {
            buffer.append("**");
            buffer.append(this.source);
        } else if (this.index <= this.source.length) {
            buffer.append(CharOperation.subarray(this.source, 0, this.start));
            buffer.append('*');
            if (this.start <= this.index) {
                buffer.append(CharOperation.subarray(this.source, this.start, this.index));
                buffer.append('*');
                buffer.append(CharOperation.subarray(this.source, this.index, this.source.length));
            } else {
                buffer.append('*');
                buffer.append(CharOperation.subarray(this.source, this.start, this.source.length));
            }
        } else {
            buffer.append(this.source);
            buffer.append("**");
        }
        return buffer.toString();
    }
}

