/***************************************************************************
                          agsharemanager.cpp  -  description
                             -------------------
    begin                : Fri Mar 30 2001
    copyright            : (C) 2001 by Joe Theriault
    email                : uallloveme@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <unistd.h>

#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextstream.h>

#include <kprocess.h>
#include <kstddirs.h>

//#include "agbrowser.h"
#include "agsharemanager.h"

AGShareManager::AGShareManager()
{
}

AGShareManager::~AGShareManager()
{
}


void AGShareManager::open(QString downloadDir, QStringList sharedDirs)
{
  // On some given day when I'm so inclined I may use KIO::Job to
  // accomplish this, but until then StatJob isn't documented well enough
  // for my patience and this shouldn't take so long that blocking operations
  // shouldn't harm the program much.

  QString sharesDir(locateLocal("appdata", "shares/"));

  QDir shares_dir(sharesDir);

  // Clearing the Directory
  QStringList  filesToRemove = shares_dir.entryList();
  for(int index = 0; index < filesToRemove.count(); index++)
    shares_dir.remove(filesToRemove[index]);

  // Populating it with links
  for(int index = 0; index < sharedDirs.count(); index++)
  {
    if(sharedDirs[index][sharedDirs[index].length() - 1] == '/')
      sharedDirs[index].truncate(sharedDirs[index].length() - 1);
    symlink(sharedDirs[index], sharesDir + rindex(sharedDirs[index], '/'));
  }

  // Creating custom Konqueror profile
  QFile konq_profile(locateLocal("data", "konqueror/profiles/mp3management"));
  konq_profile.open(IO_WriteOnly);
  QTextStream profile(&konq_profile);
  profile << "[Profile]" << "\n"
          << "Container0_Children=View1,View2" << "\n"
          << "Container0_Orientation=Horizontal" << "\n"
          << "Container0_SplitterSizes=100,100" << "\n"
          << "Name=Mp3 Management" << "\n"
          << "RootItem=Container0" << "\n"
          << "View1_LinkedView=false" << "\n"
          << "View1_LockedLocation=false" << "\n"
          << "View1_PassiveMode=false" << "\n"
          << "View1_ServiceName=konq_iconview" << "\n"
          << "View1_ServiceType=inode/directory" << "\n"
          << "View1_ToggleView=false" << "\n"
          << "View1_URL=file:" << downloadDir << "\n"
          << "View2_LinkedView=false" << "\n"
          << "View2_LockedLocation=false" << "\n"
          << "View2_PassiveMode=false" << "\n"
          << "Vew2_ServiceName=konq_iconview" << "\n"
          << "View2_ServiceType=inode/directory" << "\n"
          << "View2_ToggleView=false" << "\n"
          << "View2_URL=file:" << sharesDir << "\n";
  konq_profile.close();

  // Launching Konqueror with profile
  KProcess kfmclient;
  kfmclient << "kfmclient" << "openProfile" << "mp3management";
  kfmclient.start(KProcess::DontCare);
}
