// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef GROUP_H
#define GROUP_H

#include <qlistview.h>

class QDomElement;
class QTextStream;


class Group : public QCheckListItem
{
public:
    Group(const QString &);
    Group(Group *parent, const QString &);

    QString text(int) const;

    void setText(int, const QString &);
    void setOn(bool);
    void propogate(const QString &);
    void xmlDescription(QTextStream &) const;

    void paintCell(QPainter *, const QColorGroup &, int, int, int);

    static int RTTI;
    int rtti() const;

    static void create(Group *, const QDomElement &);


private:
    QString coltext;
    int totalSongs, enabledSongs;

    friend class Song;
    void addSong();
    void remSong();
    void enableSong(bool);
};

#endif // GROUP_H
