/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.1, (the "License"); you may not use this file except in
 * compliance with the License. You should have received a copy of the
 * Erlang Public License along with this software. If not, it can be
 * retrieved via the world wide web at http://www.erlang.org/.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Original Code is Ericsson Utvecklings AB.
 * Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
 * AB. All Rights Reserved.''
 * 
 *     $Id$
 */
#ifdef __WIN32__
#include <winsock2.h>
#include <windows.h>
#include <winbase.h>

#elif VXWORKS
#include <unistd.h>

#else /* unix */
#include <unistd.h>

#endif

#include <string.h>
#include <stdlib.h>
#include "ei.h"
#include "erl_connect.h"
#include "erl_format.h"
#include "erl_malloc.h"

erlang_pid *ei_whereis(int fd, const char *name)
{
  ETERM *reply;
  ETERM *n;
  static erlang_pid pid;
  
  n = erl_format("[~a]",name);
  reply = erl_rpc(fd,"erlang","whereis",n);
  erl_free_term(n);

  if (reply && (ERL_IS_PID(reply))) {
    char *node;
    node =  ERL_PID_NODE(reply);
    strcpy(pid.node,node);
    pid.num = ERL_PID_NUMBER(reply);
    pid.serial = ERL_PID_SERIAL(reply);
    pid.creation = ERL_PID_CREATION(reply);
    erl_free_term(reply);
    return &pid;
  }

  if (reply) erl_free_term(reply);
  return NULL;
}

