//
// C++ Implementation: AccessDialog
//
// Description:
//
//
// Author: Mike Gabriel <mike.gabriel@das-netzwerkteam.de>, (C) 2018
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "accessdialog.h"
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QLabel>
#include <QPixmap>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>

AccessWindow::AccessWindow(QString uname, QString hname, QWidget *parent)
        : QDialog (parent)
{
	setWindowTitle(QString("%1 (%2)").arg(uname).arg(hname));

	QVBoxLayout *hbox = new QVBoxLayout(this);

	/* question mark and text */
	QHBoxLayout *vtexticonbox = new QHBoxLayout();
	QLabel *icon = new QLabel();
	icon->setPixmap ( QPixmap (":icons/svg/dialog-question.svg") );
	vtexticonbox->addWidget(icon, 1, Qt::AlignLeft);
	QLabel *text = new QLabel();
	text->setText(QString(tr("Accept user \"%1\" from host [%2]?")).arg(uname).arg(hname));
	vtexticonbox->addWidget(text, 1, Qt::AlignLeft);
	hbox->addLayout(vtexticonbox);

	/* the check box (remember this setting for user X) */
	checkBox=new QCheckBox(QString(tr("Remember selection for user \"%1\".")).arg(uname),this);
	hbox->addWidget(checkBox, 1, Qt::AlignLeft);

	/* dialog buttons */
	QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
	buttonBox->button(QDialogButtonBox::Ok)->setText(tr("Grant access"));
#if QT_VERSION < 0x050000
	connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
#else
	connect(buttonBox, &QDialogButtonBox::accepted, this, &QDialog::accept);
#endif
	buttonBox->button(QDialogButtonBox::Cancel)->setText(tr("Deny access"));
	buttonBox->button(QDialogButtonBox::Cancel)->setDefault(true);
#if QT_VERSION < 0x050000
	connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
#else
	connect(buttonBox, &QDialogButtonBox::rejected, this, &QDialog::reject);
#endif
	hbox->addWidget(buttonBox, 1, Qt::AlignRight | Qt::AlignBottom);

	/* modality */
	setWindowModality(Qt::WindowModal);
}

AccessWindow::~AccessWindow()
{
}

bool AccessWindow::isChecked()
{
	return checkBox->isChecked();
}
