/* gtkdoccommentparser.c generated by valac, the Vala compiler
 * generated from gtkdoccommentparser.vala, do not modify */

/* gtkcommentparser.vala
 *
 * Copyright (C) 2011-2014  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

enum  {
	VALADOC_GTKDOC_PARSER_0_PROPERTY,
	VALADOC_GTKDOC_PARSER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_parser_properties[VALADOC_GTKDOC_PARSER_NUM_PROPERTIES];
#define _valadoc_gtkdoc_scanner_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_scanner_unref (var), NULL)))
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _valadoc_importer_internal_id_registrar_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_importer_internal_id_registrar_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocGtkdocParserPrivate {
	ValadocGtkdocScanner* scanner;
	ValadocGtkdocToken* current;
	ValaList* stack;
	ValaList* footnotes;
	ValadocContentContentFactory* factory;
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValadocApiTree* tree;
	ValadocApiNode* element;
	gboolean show_warnings;
	ValadocApiSourceComment* comment;
	const gchar* instance_param_name;
	gchar** comment_lines;
	gint comment_lines_length1;
	gint _comment_lines_size_;
	GRegex* is_numeric_regex;
	GRegex* normalize_regex;
	GRegex* regex_source_lang;
	ValadocImporterInternalIdRegistrar* id_registrar;
	ValadocGirMetaData* current_metadata;
};

static gint ValadocGtkdocParser_private_offset;
static gpointer valadoc_gtkdoc_parser_parent_class = NULL;
static ValadocResourceLocatorIface * valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = NULL;

static inline gchar* valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self,
                                                const gchar* path);
static void valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self,
                                  ValadocApiSourceComment* comment);
static gchar* valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self,
                                        const gchar* text);
static gboolean valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self,
                                           const gchar* str);
static void valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self,
                                                    ValadocGtkdocToken* got,
                                                    const gchar* expected);
static void valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self,
                                           ValadocGtkdocToken* got,
                                           const gchar* message);
static ValadocContentNote* _valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self,
                                                       ValadocApiSourceComment* comment);
static ValadocContentComment* valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self,
                                                                 ValadocApiSourceComment* gir_comment);
static void valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self,
                                     ValadocContentComment* * comment,
                                     ValadocContentNote* note);
static void valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self,
                                       ValadocContentComment* * comment,
                                       ValadocContentTaglet* taglet);
G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment,
                                                 ValadocContentContentFactory* factory);
static ValadocContentTaglet* valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self,
                                                                ValadocApiSourceComment* gir_comment,
                                                                const gchar* taglet_name);
G_GNUC_INTERNAL void valadoc_taglets_param_set_is_c_self_param (ValadocTagletsParam* self,
                                                gboolean value);
G_GNUC_INTERNAL void valadoc_taglets_param_set_parameter_name (ValadocTagletsParam* self,
                                               const gchar* value);
static ValadocGtkdocToken* valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self,
                                                 gboolean accept_paragraphs);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self);
static gboolean valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self,
                                                   const gchar* tagname);
static gboolean valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self,
                                                    const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self,
                                                                         const gchar* tagname,
                                                                         gboolean is_internal);
G_GNUC_INTERNAL void valadoc_content_link_set_id_registrar (ValadocContentLink* self,
                                            ValadocImporterInternalIdRegistrar* value);
static ValadocContentInlineTaglet* valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self,
                                                                     const gchar* tagname);
static ValadocContentInline* valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self,
                                                              const gchar* name,
                                                              gboolean c_accept_plural);
static void valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self);
static ValadocContentLink* valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self,
                                                                     const gchar* tag_name,
                                                                     ValadocContentRunStyle style);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self);
static ValadocContentBlockContent* valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self,
                                                                                          const gchar* tagname,
                                                                                          ValadocContentBlockContent* container);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self);
static ValadocContentNote* valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self);
static ValadocContentWarning* valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self,
                                                                  const gchar* tag_name,
                                                                  ValadocContentListBullet bullet_type);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self,
                                                          ValaCollection* run,
                                                          ValadocContentBlock* element);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self,
                                                          const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self);
static ValadocContentSourceCodeLanguage* _valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self);
G_GNUC_INTERNAL gboolean valadoc_highlighter_xml_scanner_is_xml (const gchar* source);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self);
static ValadocContentEmbedded* valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self,
                                                                           const gchar* tag_name);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self);
static inline ValaCollection* valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self,
                                                             const gchar* tag_name);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self,
                                                        gint nr);
static inline void valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self,
                                                              ValaCollection* run,
                                                              ValaCollection* elements);
static ValaList* valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self);
static ValadocContentTableRow* valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self,
                                                                 ValadocContentRunStyle default_style);
static ValadocContentTableCell* valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self,
                                                                    ValadocContentRunStyle default_style);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self);
static ValadocContentTable* valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self);
static ValadocContentList* valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self);
static ValadocContentParagraph* valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self);
static ValadocContentListItem* valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self);
static ValaCollection* valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self);
static ValadocContentRun* valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self);
static void valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self,
                                                         ValadocContentRun* run,
                                                         const gchar* current);
G_GNUC_INTERNAL void valadoc_taglets_link_set_c_accept_plural (ValadocTagletsLink* self,
                                               gboolean value);
G_GNUC_INTERNAL void valadoc_taglets_link_set_symbol_name (ValadocTagletsLink* self,
                                           const gchar* value);
static inline void valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self,
                                                           ValadocContentRun* run,
                                                           ValadocContentInline* element);
G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree,
                                                        ValadocApiNode* element,
                                                        const gchar* parameter_name,
                                                        gchar* * param_name,
                                                        gchar* * param_array_name,
                                                        gboolean* is_return_type_len);
static gchar* valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base,
                                           const gchar* path);
static void valadoc_gtkdoc_parser_finalize (GObject * obj);
static GType valadoc_gtkdoc_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
valadoc_gtkdoc_parser_get_instance_private (ValadocGtkdocParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocGtkdocParser_private_offset);
}

static inline gchar*
valadoc_gtkdoc_parser_fix_resource_path (ValadocGtkdocParser* self,
                                         const gchar* path)
{
	ValadocGirMetaData* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->current_metadata;
	_tmp1_ = valadoc_gir_meta_data_get_resource_path (_tmp0_, path);
	result = _tmp1_;
	return result;
}

static gpointer
_valadoc_api_source_comment_ref0 (gpointer self)
{
	return self ? valadoc_api_source_comment_ref (self) : NULL;
}

static void
valadoc_gtkdoc_parser_reset (ValadocGtkdocParser* self,
                             ValadocApiSourceComment* comment)
{
	ValadocGtkdocScanner* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiSourceFile* _tmp3_;
	ValadocApiSourceFile* _tmp4_;
	ValadocApiPackage* _tmp5_;
	ValadocApiPackage* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	ValaList* _tmp9_;
	ValadocApiSourceComment* _tmp10_;
	ValaList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = valadoc_api_source_comment_get_content (comment);
	_tmp2_ = _tmp1_;
	valadoc_gtkdoc_scanner_reset (_tmp0_, _tmp2_);
	_tmp3_ = valadoc_api_source_comment_get_file (comment);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_source_file_get_package (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_package_get_is_package (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->show_warnings = !_tmp8_;
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	self->priv->comment_lines = NULL;
	self->priv->comment_lines_length1 = 0;
	self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	_tmp9_ = self->priv->footnotes;
	vala_collection_clear ((ValaCollection*) _tmp9_);
	_tmp10_ = _valadoc_api_source_comment_ref0 (comment);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment = _tmp10_;
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp11_ = self->priv->stack;
	vala_collection_clear ((ValaCollection*) _tmp11_);
}

static gchar*
valadoc_gtkdoc_parser_normalize (ValadocGtkdocParser* self,
                                 const gchar* text)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->normalize_regex;
		_tmp2_ = g_regex_replace (_tmp1_, text, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
valadoc_gtkdoc_parser_is_numeric (ValadocGtkdocParser* self,
                                  const gchar* str)
{
	GRegex* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = self->priv->is_numeric_regex;
	result = g_regex_match (_tmp0_, str, 0, NULL);
	return result;
}

static void
valadoc_gtkdoc_parser_report_unexpected_token (ValadocGtkdocParser* self,
                                               ValadocGtkdocToken* got,
                                               const gchar* expected)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (expected != NULL);
	_tmp0_ = valadoc_gtkdoc_token_to_string (got);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("Unexpected Token: %s (Expected: %s)", _tmp1_, expected);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_parser_report_warning (self, got, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
valadoc_gtkdoc_parser_report_warning (ValadocGtkdocParser* self,
                                      ValadocGtkdocToken* got,
                                      const gchar* message)
{
	gint _tmp0_ = 0;
	gint startpos = 0;
	gint _tmp4_ = 0;
	gint endpos = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValadocErrorReporter* _tmp14_;
	ValadocApiSourceComment* _tmp15_;
	ValadocApiSourceFile* _tmp16_;
	ValadocApiSourceFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValadocApiSourceComment* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (got != NULL);
	g_return_if_fail (message != NULL);
	if (!self->priv->show_warnings) {
		return;
	}
	if (got->line == 0) {
		ValadocApiSourceComment* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->comment;
		_tmp2_ = valadoc_api_source_comment_get_first_column (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ + got->first_column;
	} else {
		_tmp0_ = got->first_column;
	}
	startpos = _tmp0_;
	if (got->line == 0) {
		ValadocApiSourceComment* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->comment;
		_tmp6_ = valadoc_api_source_comment_get_first_column (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp4_ = _tmp7_ + got->last_column;
	} else {
		_tmp4_ = got->last_column;
	}
	endpos = _tmp4_;
	_tmp8_ = self->priv->comment_lines;
	_tmp8__length1 = self->priv->comment_lines_length1;
	if (_tmp8_ == NULL) {
		ValadocApiSourceComment* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		_tmp9_ = self->priv->comment;
		_tmp10_ = valadoc_api_source_comment_get_content (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "\n", 0);
		self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
		self->priv->comment_lines = _tmp13_;
		self->priv->comment_lines_length1 = _vala_array_length (_tmp12_);
		self->priv->_comment_lines_size_ = self->priv->comment_lines_length1;
	}
	_tmp14_ = self->priv->reporter;
	_tmp15_ = self->priv->comment;
	_tmp16_ = valadoc_api_source_comment_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_api_source_file_get_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->comment;
	_tmp21_ = valadoc_api_source_comment_get_first_line (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->comment_lines;
	_tmp23__length1 = self->priv->comment_lines_length1;
	_tmp24_ = _tmp23_[got->line];
	valadoc_error_reporter_warning (_tmp14_, _tmp19_, (glong) (_tmp22_ + got->line), (glong) (startpos + 1), (glong) (endpos + 1), _tmp24_, "%s", message);
	_g_free0 (_tmp19_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

ValadocGtkdocParser*
valadoc_gtkdoc_parser_construct (GType object_type,
                                 ValadocSettings* settings,
                                 ValadocErrorReporter* reporter,
                                 ValadocApiTree* tree,
                                 ValadocModuleLoader* modules)
{
	ValadocGtkdocParser * self = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocSettings* _tmp2_;
	ValadocApiTree* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	self = (ValadocGtkdocParser*) g_object_new (object_type, NULL);
	_tmp0_ = valadoc_content_content_factory_new (settings, (ValadocResourceLocator*) self, modules);
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	_tmp2_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp3_;
	{
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_;
		GRegex* _tmp12_;
		_tmp5_ = g_regex_new ("^[+-]?([0-9]*\\.?[0-9]+|[0-9]+\\.?[0-9]*)([eE][+-]?[0-9]+)?$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (self->priv->is_numeric_regex);
		self->priv->is_numeric_regex = _tmp6_;
		_tmp8_ = g_regex_new ("( |\n|\t)+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp4_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_regex_unref0 (self->priv->normalize_regex);
		self->priv->normalize_regex = _tmp9_;
		_tmp11_ = g_regex_new ("^<!--[ \t]+language=\"([A-Za-z]*)\"[ \t]+-->", 0, 0, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (self->priv->regex_source_lang);
		self->priv->regex_source_lang = _tmp12_;
		_g_regex_unref0 (_tmp10_);
		_g_regex_unref0 (_tmp7_);
		_g_regex_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

ValadocGtkdocParser*
valadoc_gtkdoc_parser_new (ValadocSettings* settings,
                           ValadocErrorReporter* reporter,
                           ValadocApiTree* tree,
                           ValadocModuleLoader* modules)
{
	return valadoc_gtkdoc_parser_construct (VALADOC_GTKDOC_TYPE_PARSER, settings, reporter, tree, modules);
}

static ValadocContentNote*
_valadoc_gtkdoc_parser_parse_note (ValadocGtkdocParser* self,
                                   ValadocApiSourceComment* comment)
{
	ValadocContentComment* cmnt = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentNote* note = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentNote* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentComment* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (comment != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_root_content (self, comment);
	cmnt = _tmp0_;
	_tmp1_ = cmnt;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (cmnt);
		return result;
	}
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_note (_tmp2_);
	note = _tmp3_;
	_tmp4_ = note;
	_tmp5_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cmnt;
	_tmp8_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add_all ((ValaCollection*) _tmp6_, (ValaCollection*) _tmp9_);
	result = note;
	_g_object_unref0 (cmnt);
	return result;
}

static void
valadoc_gtkdoc_parser_add_note (ValadocGtkdocParser* self,
                                ValadocContentComment* * comment,
                                ValadocContentNote* note)
{
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValaList* _tmp11_;
	ValaList* _tmp12_;
	g_return_if_fail (self != NULL);
	if (note == NULL) {
		return;
	}
	if ((*comment) == NULL) {
		ValadocContentContentFactory* _tmp0_;
		ValadocContentComment* _tmp1_;
		_tmp0_ = self->priv->factory;
		_tmp1_ = valadoc_content_content_factory_create_comment (_tmp0_);
		_g_object_unref0 (*comment);
		*comment = _tmp1_;
	}
	_tmp2_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		ValadocContentParagraph* _tmp9_;
		ValadocContentParagraph* _tmp10_;
		_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->factory;
		_tmp9_ = valadoc_content_content_factory_create_paragraph (_tmp8_);
		_tmp10_ = _tmp9_;
		vala_collection_add ((ValaCollection*) _tmp7_, (ValadocContentBlock*) _tmp10_);
		_g_object_unref0 (_tmp10_);
	}
	_tmp11_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) (*comment));
	_tmp12_ = _tmp11_;
	vala_list_insert (_tmp12_, 1, (ValadocContentBlock*) note);
}

static void
valadoc_gtkdoc_parser_add_taglet (ValadocGtkdocParser* self,
                                  ValadocContentComment* * comment,
                                  ValadocContentTaglet* taglet)
{
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	if (taglet == NULL) {
		return;
	}
	if ((*comment) == NULL) {
		ValadocContentContentFactory* _tmp0_;
		ValadocContentComment* _tmp1_;
		_tmp0_ = self->priv->factory;
		_tmp1_ = valadoc_content_content_factory_create_comment (_tmp0_);
		_g_object_unref0 (*comment);
		*comment = _tmp1_;
	}
	_tmp2_ = valadoc_content_comment_get_taglets (*comment);
	_tmp3_ = _tmp2_;
	vala_collection_add ((ValaCollection*) _tmp3_, taglet);
}

static gpointer
_valadoc_importer_internal_id_registrar_ref0 (gpointer self)
{
	return self ? valadoc_importer_internal_id_registrar_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValadocContentComment*
valadoc_gtkdoc_parser_parse (ValadocGtkdocParser* self,
                             ValadocApiNode* element,
                             ValadocApiGirSourceComment* gir_comment,
                             ValadocGirMetaData* gir_metadata,
                             ValadocImporterInternalIdRegistrar* id_registrar)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValadocGirMetaData* _tmp2_;
	ValadocImporterInternalIdRegistrar* _tmp3_;
	ValadocApiNode* _tmp4_;
	ValadocContentComment* cmnt = NULL;
	ValadocContentComment* _tmp5_;
	ValadocContentComment* _tmp6_;
	ValadocApiSourceComment* _tmp9_;
	ValadocApiSourceComment* _tmp10_;
	ValadocApiSourceComment* _tmp15_;
	ValadocApiSourceComment* _tmp16_;
	ValadocApiSourceComment* _tmp21_;
	ValadocApiSourceComment* _tmp22_;
	ValadocApiSourceComment* _tmp27_;
	ValadocApiSourceComment* _tmp28_;
	ValaMapIterator* iter = NULL;
	ValaMapIterator* _tmp33_;
	gboolean first = FALSE;
	ValadocContentComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (gir_metadata != NULL, NULL);
	g_return_val_if_fail (id_registrar != NULL, NULL);
	_tmp0_ = valadoc_api_gir_source_comment_get_instance_param_name (gir_comment);
	_tmp1_ = _tmp0_;
	self->priv->instance_param_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (gir_metadata);
	_g_object_unref0 (self->priv->current_metadata);
	self->priv->current_metadata = _tmp2_;
	_tmp3_ = _valadoc_importer_internal_id_registrar_ref0 (id_registrar);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	self->priv->id_registrar = _tmp3_;
	_tmp4_ = _g_object_ref0 (element);
	_g_object_unref0 (self->priv->element);
	self->priv->element = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_root_content (self, (ValadocApiSourceComment*) gir_comment);
	cmnt = _tmp5_;
	_tmp6_ = cmnt;
	if (_tmp6_ != NULL) {
		ValadocContentComment* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		_tmp7_ = cmnt;
		_tmp8_ = self->priv->factory;
		valadoc_importer_helper_extract_short_desc (_tmp7_, _tmp8_);
	}
	_tmp9_ = valadoc_api_gir_source_comment_get_deprecated_comment (gir_comment);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp11_;
		ValadocApiSourceComment* _tmp12_;
		ValadocContentNote* _tmp13_;
		ValadocContentNote* _tmp14_;
		_tmp11_ = valadoc_api_gir_source_comment_get_deprecated_comment (gir_comment);
		_tmp12_ = _tmp11_;
		_tmp13_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp12_);
		note = _tmp13_;
		_tmp14_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp14_);
		_g_object_unref0 (note);
	}
	_tmp15_ = valadoc_api_gir_source_comment_get_version_comment (gir_comment);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp17_;
		ValadocApiSourceComment* _tmp18_;
		ValadocContentNote* _tmp19_;
		ValadocContentNote* _tmp20_;
		_tmp17_ = valadoc_api_gir_source_comment_get_version_comment (gir_comment);
		_tmp18_ = _tmp17_;
		_tmp19_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp18_);
		note = _tmp19_;
		_tmp20_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp20_);
		_g_object_unref0 (note);
	}
	_tmp21_ = valadoc_api_gir_source_comment_get_stability_comment (gir_comment);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValadocContentNote* note = NULL;
		ValadocApiSourceComment* _tmp23_;
		ValadocApiSourceComment* _tmp24_;
		ValadocContentNote* _tmp25_;
		ValadocContentNote* _tmp26_;
		_tmp23_ = valadoc_api_gir_source_comment_get_stability_comment (gir_comment);
		_tmp24_ = _tmp23_;
		_tmp25_ = _valadoc_gtkdoc_parser_parse_note (self, _tmp24_);
		note = _tmp25_;
		_tmp26_ = note;
		valadoc_gtkdoc_parser_add_note (self, &cmnt, _tmp26_);
		_g_object_unref0 (note);
	}
	_tmp27_ = valadoc_api_gir_source_comment_get_return_comment (gir_comment);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValadocContentTaglet* taglet = NULL;
		ValadocApiSourceComment* _tmp29_;
		ValadocApiSourceComment* _tmp30_;
		ValadocContentTaglet* _tmp31_;
		ValadocContentTaglet* _tmp32_;
		_tmp29_ = valadoc_api_gir_source_comment_get_return_comment (gir_comment);
		_tmp30_ = _tmp29_;
		_tmp31_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp30_, "return");
		taglet = _tmp31_;
		_tmp32_ = taglet;
		valadoc_gtkdoc_parser_add_taglet (self, &cmnt, _tmp32_);
		_g_object_unref0 (taglet);
	}
	_tmp33_ = valadoc_api_gir_source_comment_parameter_iterator (gir_comment);
	iter = _tmp33_;
	{
		gboolean has_next = FALSE;
		ValaMapIterator* _tmp34_;
		_tmp34_ = iter;
		has_next = vala_map_iterator_next (_tmp34_);
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				ValadocTagletsParam* taglet = NULL;
				ValaMapIterator* _tmp37_;
				gpointer _tmp38_;
				ValadocApiSourceComment* _tmp39_;
				ValadocContentTaglet* _tmp40_;
				ValadocTagletsParam* _tmp41_;
				ValadocTagletsParam* _tmp42_;
				gchar* param_name = NULL;
				ValaMapIterator* _tmp43_;
				gpointer _tmp44_;
				ValadocTagletsParam* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValadocTagletsParam* _tmp49_;
				const gchar* _tmp50_;
				ValadocTagletsParam* _tmp51_;
				if (!_tmp35_) {
					ValaMapIterator* _tmp36_;
					_tmp36_ = iter;
					has_next = vala_map_iterator_next (_tmp36_);
				}
				_tmp35_ = FALSE;
				if (!has_next) {
					break;
				}
				_tmp37_ = iter;
				_tmp38_ = vala_map_iterator_get_value (_tmp37_);
				_tmp39_ = (ValadocApiSourceComment*) _tmp38_;
				_tmp40_ = valadoc_gtkdoc_parser_parse_block_taglet (self, _tmp39_, "param");
				_tmp41_ = VALADOC_TAGLETS_IS_PARAM (_tmp40_) ? ((ValadocTagletsParam*) _tmp40_) : NULL;
				if (_tmp41_ == NULL) {
					_g_object_unref0 (_tmp40_);
				}
				_tmp42_ = _tmp41_;
				_valadoc_api_source_comment_unref0 (_tmp39_);
				taglet = _tmp42_;
				_tmp43_ = iter;
				_tmp44_ = vala_map_iterator_get_key (_tmp43_);
				param_name = (gchar*) _tmp44_;
				_tmp45_ = taglet;
				_tmp46_ = param_name;
				_tmp47_ = valadoc_api_gir_source_comment_get_instance_param_name (gir_comment);
				_tmp48_ = _tmp47_;
				valadoc_taglets_param_set_is_c_self_param (_tmp45_, g_strcmp0 (_tmp46_, _tmp48_) == 0);
				_tmp49_ = taglet;
				_tmp50_ = param_name;
				valadoc_taglets_param_set_parameter_name (_tmp49_, _tmp50_);
				_tmp51_ = taglet;
				valadoc_gtkdoc_parser_add_taglet (self, &cmnt, (ValadocContentTaglet*) _tmp51_);
				_g_free0 (param_name);
				_g_object_unref0 (taglet);
			}
		}
	}
	first = TRUE;
	{
		ValaList* _note_list = NULL;
		ValaList* _tmp52_;
		ValaList* _tmp53_;
		gint _note_size = 0;
		ValaList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _note_index = 0;
		_tmp52_ = self->priv->footnotes;
		_tmp53_ = _vala_iterable_ref0 (_tmp52_);
		_note_list = _tmp53_;
		_tmp54_ = _note_list;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_note_size = _tmp56_;
		_note_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			ValaList* note = NULL;
			ValaList* _tmp59_;
			gpointer _tmp60_;
			gboolean _tmp61_ = FALSE;
			ValadocContentComment* _tmp82_;
			ValaList* _tmp83_;
			ValaList* _tmp84_;
			ValaList* _tmp85_;
			_note_index = _note_index + 1;
			_tmp57_ = _note_index;
			_tmp58_ = _note_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _note_list;
			_tmp60_ = vala_list_get (_tmp59_, _note_index);
			note = (ValaList*) _tmp60_;
			if (first == TRUE) {
				ValaList* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				_tmp62_ = note;
				_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp61_ = _tmp64_ > 0;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValadocContentParagraph* p = NULL;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValadocContentBlock* _tmp67_;
				ValadocContentParagraph* _tmp68_;
				ValadocContentParagraph* _tmp69_;
				ValadocContentParagraph* _tmp76_;
				ValaList* _tmp77_;
				ValaList* _tmp78_;
				ValadocContentContentFactory* _tmp79_;
				ValadocContentText* _tmp80_;
				ValadocContentText* _tmp81_;
				_tmp65_ = note;
				_tmp66_ = vala_list_first (_tmp65_);
				_tmp67_ = (ValadocContentBlock*) _tmp66_;
				_tmp68_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp67_) ? ((ValadocContentParagraph*) _tmp67_) : NULL;
				if (_tmp68_ == NULL) {
					_g_object_unref0 (_tmp67_);
				}
				p = _tmp68_;
				_tmp69_ = p;
				if (_tmp69_ == NULL) {
					ValadocContentContentFactory* _tmp70_;
					ValadocContentParagraph* _tmp71_;
					ValadocContentComment* _tmp72_;
					ValaList* _tmp73_;
					ValaList* _tmp74_;
					ValadocContentParagraph* _tmp75_;
					_tmp70_ = self->priv->factory;
					_tmp71_ = valadoc_content_content_factory_create_paragraph (_tmp70_);
					_g_object_unref0 (p);
					p = _tmp71_;
					_tmp72_ = cmnt;
					_tmp73_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = p;
					vala_collection_add ((ValaCollection*) _tmp74_, (ValadocContentBlock*) _tmp75_);
				}
				_tmp76_ = p;
				_tmp77_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = self->priv->factory;
				_tmp80_ = valadoc_content_content_factory_create_text (_tmp79_, "\n");
				_tmp81_ = _tmp80_;
				vala_list_insert (_tmp78_, 0, (ValadocContentInline*) _tmp81_);
				_g_object_unref0 (_tmp81_);
				_g_object_unref0 (p);
			}
			_tmp82_ = cmnt;
			_tmp83_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = note;
			vala_collection_add_all ((ValaCollection*) _tmp84_, (ValaCollection*) _tmp85_);
			first = FALSE;
			_vala_iterable_unref0 (note);
		}
		_vala_iterable_unref0 (_note_list);
	}
	result = cmnt;
	_vala_map_iterator_unref0 (iter);
	return result;
}

static ValadocContentTaglet*
valadoc_gtkdoc_parser_parse_block_taglet (ValadocGtkdocParser* self,
                                          ValadocApiSourceComment* gir_comment,
                                          const gchar* taglet_name)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocContentRun* ic = NULL;
	ValadocContentRun* _tmp2_;
	ValadocContentBlockContent* taglet = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTaglet* _tmp4_;
	ValadocContentBlockContent* _tmp5_;
	ValadocContentBlockContent* _tmp6_;
	ValadocContentParagraph* paragraph = NULL;
	ValadocContentContentFactory* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocTokenType _tmp10_;
	ValadocContentBlockContent* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	ValadocContentParagraph* _tmp19_;
	ValadocContentBlockContent* _tmp20_;
	ValadocContentTaglet* _tmp21_;
	ValadocContentTaglet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	g_return_val_if_fail (taglet_name != NULL, NULL);
	valadoc_gtkdoc_parser_reset (self, gir_comment);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp0_ = valadoc_gtkdoc_parser_next (self);
	_tmp1_ = _tmp0_;
	_valadoc_gtkdoc_token_unref0 (_tmp1_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp2_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	ic = _tmp2_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_taglet (_tmp3_, taglet_name);
	_tmp5_ = VALADOC_CONTENT_IS_BLOCK_CONTENT (_tmp4_) ? ((ValadocContentBlockContent*) _tmp4_) : NULL;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (_tmp4_);
	}
	taglet = _tmp5_;
	_tmp6_ = taglet;
	_vala_assert (_tmp6_ != NULL, "taglet != null");
	_tmp7_ = self->priv->factory;
	_tmp8_ = valadoc_content_content_factory_create_paragraph (_tmp7_);
	paragraph = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->type;
	if (_tmp10_ == VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocContentParagraph* _tmp11_;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		ValadocContentRun* _tmp14_;
		_tmp11_ = paragraph;
		_tmp12_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = ic;
		vala_collection_add ((ValaCollection*) _tmp13_, (ValadocContentInline*) _tmp14_);
	} else {
		ValadocGtkdocToken* _tmp15_;
		_tmp15_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp15_, "<EOF>");
	}
	_tmp16_ = taglet;
	_tmp17_ = valadoc_content_block_content_get_content (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = paragraph;
	vala_collection_add ((ValaCollection*) _tmp18_, (ValadocContentBlock*) _tmp19_);
	_tmp20_ = taglet;
	_tmp21_ = _g_object_ref0 (VALADOC_CONTENT_IS_TAGLET (_tmp20_) ? ((ValadocContentTaglet*) _tmp20_) : NULL);
	result = _tmp21_;
	_g_object_unref0 (paragraph);
	_g_object_unref0 (taglet);
	_g_object_unref0 (ic);
	return result;
}

static gpointer
_valadoc_gtkdoc_token_ref0 (gpointer self)
{
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}

static ValadocContentComment*
valadoc_gtkdoc_parser_parse_root_content (ValadocGtkdocParser* self,
                                          ValadocApiSourceComment* gir_comment)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* tmp = NULL;
	ValadocContentComment* comment = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentComment* _tmp3_;
	ValadocGtkdocToken* _tmp39_;
	ValadocGtkdocTokenType _tmp40_;
	ValadocContentComment* _tmp42_;
	ValadocContentContentFactory* _tmp43_;
	ValadocContentComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	valadoc_gtkdoc_parser_reset (self, gir_comment);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = NULL;
	_tmp0_ = valadoc_gtkdoc_parser_next (self);
	_tmp1_ = _tmp0_;
	_valadoc_gtkdoc_token_unref0 (_tmp1_);
	tmp = NULL;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_comment (_tmp2_);
	comment = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocTokenType _tmp6_;
		ValadocGtkdocToken* _tmp9_;
		ValadocGtkdocToken* _tmp10_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp11_;
		gboolean _tmp12_ = FALSE;
		ValadocContentRun* _tmp13_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp29_;
		gboolean _tmp30_ = FALSE;
		ValaCollection* _tmp31_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
			ValadocGtkdocToken* _tmp7_;
			ValadocGtkdocToken* _tmp8_;
			_tmp7_ = tmp;
			_tmp8_ = self->priv->current;
			_tmp4_ = _tmp7_ != _tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_tmp9_ = self->priv->current;
		_tmp10_ = _valadoc_gtkdoc_token_ref0 (_tmp9_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp10_;
		_tmp11_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp11_;
		_tmp13_ = ic;
		if (_tmp13_ != NULL) {
			ValadocContentRun* _tmp14_;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp14_ = ic;
			_tmp15_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = _tmp18_ > 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp19_;
			ValadocContentParagraph* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			ValadocContentRun* _tmp24_;
			ValadocContentComment* _tmp25_;
			ValaList* _tmp26_;
			ValaList* _tmp27_;
			ValadocContentParagraph* _tmp28_;
			_tmp19_ = self->priv->factory;
			_tmp20_ = valadoc_content_content_factory_create_paragraph (_tmp19_);
			p = _tmp20_;
			_tmp21_ = p;
			_tmp22_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = ic;
			vala_collection_add ((ValaCollection*) _tmp23_, (ValadocContentInline*) _tmp24_);
			_tmp25_ = comment;
			_tmp26_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = p;
			vala_collection_add ((ValaCollection*) _tmp27_, (ValadocContentBlock*) _tmp28_);
			_g_object_unref0 (p);
		}
		_tmp29_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp29_;
		_tmp31_ = bc;
		if (_tmp31_ != NULL) {
			ValaCollection* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			_tmp32_ = bc;
			_tmp33_ = vala_collection_get_size (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp30_ = _tmp34_ > 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValadocContentComment* _tmp35_;
			ValaList* _tmp36_;
			ValaList* _tmp37_;
			ValaCollection* _tmp38_;
			_tmp35_ = comment;
			_tmp36_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp37_, _tmp38_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	_tmp39_ = self->priv->current;
	_tmp40_ = _tmp39_->type;
	if (_tmp40_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
		ValadocGtkdocToken* _tmp41_;
		_tmp41_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp41_, "<INLINE|BLOCK>");
		result = NULL;
		_g_object_unref0 (comment);
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp42_ = comment;
	_tmp43_ = self->priv->factory;
	valadoc_importer_helper_extract_short_desc (_tmp42_, _tmp43_);
	result = comment;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static ValadocGtkdocToken*
valadoc_gtkdoc_parser_next (ValadocGtkdocParser* self)
{
	ValadocGtkdocScanner* _tmp0_;
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = valadoc_gtkdoc_scanner_next (_tmp0_);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	self->priv->current = _tmp1_;
	_tmp2_ = self->priv->current;
	_tmp3_ = _valadoc_gtkdoc_token_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
valadoc_gtkdoc_parser_ignore_current_xml_close (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	gchar* name = NULL;
	ValadocGtkdocToken* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	ValaList* _tmp5_;
	const gchar* _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->content;
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->stack;
	_tmp6_ = name;
	if (vala_collection_contains ((ValaCollection*) _tmp5_, _tmp6_) == FALSE) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static gboolean
valadoc_gtkdoc_parser_check_xml_open_tag (ValadocGtkdocParser* self,
                                          const gchar* tagname)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocTokenType _tmp3_;
	ValaList* _tmp8_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->content;
		_tmp1_ = g_strcmp0 (_tmp5_, tagname) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		_tmp0_ = _tmp7_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->stack;
	vala_list_insert (_tmp8_, 0, tagname);
	result = TRUE;
	return result;
}

static gboolean
valadoc_gtkdoc_parser_check_xml_close_tag (ValadocGtkdocParser* self,
                                           const gchar* tagname)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValadocGtkdocToken* _tmp2_;
	ValadocGtkdocTokenType _tmp3_;
	ValaList* _tmp8_;
	gpointer _tmp9_;
	gchar* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tagname != NULL, FALSE);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->type;
	if (_tmp3_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
		ValadocGtkdocToken* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->content;
		_tmp1_ = g_strcmp0 (_tmp5_, tagname) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		_tmp0_ = _tmp7_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->stack;
	_tmp9_ = vala_list_remove_at (_tmp8_, 0);
	_tmp10_ = (gchar*) _tmp9_;
	_vala_assert (g_strcmp0 (_tmp10_, tagname) == 0, "stack.remove_at (0) == tagname");
	_g_free0 (_tmp10_);
	result = TRUE;
	return result;
}

static void
valadoc_gtkdoc_parser_parse_docbook_spaces (ValadocGtkdocParser* self,
                                            gboolean accept_paragraphs)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValadocGtkdocToken* _tmp0_;
		ValadocGtkdocTokenType _tmp1_;
		_tmp0_ = self->priv->current;
		_tmp1_ = _tmp0_->type;
		if (_tmp1_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE) {
			ValadocGtkdocToken* _tmp2_;
			ValadocGtkdocToken* _tmp3_;
			_tmp2_ = valadoc_gtkdoc_parser_next (self);
			_tmp3_ = _tmp2_;
			_valadoc_gtkdoc_token_unref0 (_tmp3_);
		} else {
			ValadocGtkdocToken* _tmp4_;
			ValadocGtkdocTokenType _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_->type;
			if (_tmp5_ == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
				ValadocGtkdocToken* _tmp6_;
				ValadocGtkdocToken* _tmp7_;
				_tmp6_ = valadoc_gtkdoc_parser_next (self);
				_tmp7_ = _tmp6_;
				_valadoc_gtkdoc_token_unref0 (_tmp7_);
			} else {
				gboolean _tmp8_ = FALSE;
				if (accept_paragraphs) {
					ValadocGtkdocToken* _tmp9_;
					ValadocGtkdocTokenType _tmp10_;
					_tmp9_ = self->priv->current;
					_tmp10_ = _tmp9_->type;
					_tmp8_ = _tmp10_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					ValadocGtkdocToken* _tmp11_;
					ValadocGtkdocToken* _tmp12_;
					_tmp11_ = valadoc_gtkdoc_parser_next (self);
					_tmp12_ = _tmp11_;
					_valadoc_gtkdoc_token_unref0 (_tmp12_);
				} else {
					break;
				}
			}
		}
	}
}

static ValadocContentInline*
valadoc_gtkdoc_parser_parse_docbook_link_tempalte (ValadocGtkdocParser* self,
                                                   const gchar* tagname,
                                                   gboolean is_internal)
{
	GString* builder = NULL;
	GString* _tmp3_;
	gchar* url = NULL;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp31_;
	ValadocContentLink* _tmp32_;
	ValadocContentLink* _tmp35_;
	const gchar* _tmp36_;
	GString* _tmp37_;
	ValadocGtkdocToken* _tmp58_;
	ValadocGtkdocToken* _tmp59_;
	ValadocContentInline* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	if (is_internal) {
		ValadocGtkdocToken* _tmp4_;
		ValaHashMap* _tmp5_;
		gpointer _tmp6_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->attributes;
		_tmp6_ = vala_map_get ((ValaMap*) _tmp5_, "linkend");
		_g_free0 (url);
		url = (gchar*) _tmp6_;
	} else {
		ValadocGtkdocToken* _tmp7_;
		ValaHashMap* _tmp8_;
		gpointer _tmp9_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->attributes;
		_tmp9_ = vala_map_get ((ValaMap*) _tmp8_, "url");
		_g_free0 (url);
		url = (gchar*) _tmp9_;
	}
	_tmp10_ = valadoc_gtkdoc_parser_next (self);
	_tmp11_ = _tmp10_;
	_valadoc_gtkdoc_token_unref0 (_tmp11_);
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocTokenType _tmp15_;
		ValadocGtkdocToken* _tmp20_;
		ValadocGtkdocTokenType _tmp21_;
		ValadocGtkdocToken* _tmp29_;
		ValadocGtkdocToken* _tmp30_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_->type;
		if (_tmp15_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_->content;
			_tmp13_ = g_strcmp0 (_tmp17_, tagname) == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			ValadocGtkdocToken* _tmp18_;
			ValadocGtkdocTokenType _tmp19_;
			_tmp18_ = self->priv->current;
			_tmp19_ = _tmp18_->type;
			_tmp12_ = _tmp19_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->type;
		if (_tmp21_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		} else {
			ValadocGtkdocToken* _tmp22_;
			ValadocGtkdocTokenType _tmp23_;
			_tmp22_ = self->priv->current;
			_tmp23_ = _tmp22_->type;
			if (_tmp23_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			} else {
				ValadocGtkdocToken* _tmp24_;
				ValadocGtkdocTokenType _tmp25_;
				_tmp24_ = self->priv->current;
				_tmp25_ = _tmp24_->type;
				if (_tmp25_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
				} else {
					GString* _tmp26_;
					ValadocGtkdocToken* _tmp27_;
					const gchar* _tmp28_;
					_tmp26_ = builder;
					_tmp27_ = self->priv->current;
					_tmp28_ = _tmp27_->content;
					g_string_append (_tmp26_, _tmp28_);
				}
			}
		}
		_tmp29_ = valadoc_gtkdoc_parser_next (self);
		_tmp30_ = _tmp29_;
		_valadoc_gtkdoc_token_unref0 (_tmp30_);
	}
	_tmp31_ = self->priv->factory;
	_tmp32_ = valadoc_content_content_factory_create_link (_tmp31_);
	link = _tmp32_;
	if (is_internal) {
		ValadocContentLink* _tmp33_;
		ValadocImporterInternalIdRegistrar* _tmp34_;
		_tmp33_ = link;
		_tmp34_ = self->priv->id_registrar;
		valadoc_content_link_set_id_registrar (_tmp33_, _tmp34_);
	}
	_tmp35_ = link;
	_tmp36_ = url;
	valadoc_content_link_set_url (_tmp35_, _tmp36_);
	_tmp37_ = builder;
	if (_tmp37_->len == ((gssize) 0)) {
		ValadocContentLink* _tmp38_;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		ValadocContentContentFactory* _tmp41_;
		const gchar* _tmp42_;
		ValadocContentText* _tmp43_;
		ValadocContentText* _tmp44_;
		_tmp38_ = link;
		_tmp39_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = self->priv->factory;
		_tmp42_ = url;
		_tmp43_ = valadoc_content_content_factory_create_text (_tmp41_, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_collection_add ((ValaCollection*) _tmp40_, (ValadocContentInline*) _tmp44_);
		_g_object_unref0 (_tmp44_);
	} else {
		ValadocContentLink* _tmp45_;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		ValadocContentContentFactory* _tmp48_;
		GString* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		ValadocContentText* _tmp53_;
		ValadocContentText* _tmp54_;
		_tmp45_ = link;
		_tmp46_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->factory;
		_tmp49_ = builder;
		_tmp50_ = _tmp49_->str;
		_tmp51_ = valadoc_gtkdoc_parser_normalize (self, _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = valadoc_content_content_factory_create_text (_tmp48_, _tmp52_);
		_tmp54_ = _tmp53_;
		vala_collection_add ((ValaCollection*) _tmp47_, (ValadocContentInline*) _tmp54_);
		_g_object_unref0 (_tmp54_);
		_g_free0 (_tmp52_);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp55_ = self->priv->current;
		_tmp56_ = g_strdup_printf ("</%s>", tagname);
		_tmp57_ = _tmp56_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp55_, _tmp57_);
		_g_free0 (_tmp57_);
		result = (ValadocContentInline*) link;
		_g_free0 (url);
		_g_string_free0 (builder);
		return result;
	}
	_tmp58_ = valadoc_gtkdoc_parser_next (self);
	_tmp59_ = _tmp58_;
	_valadoc_gtkdoc_token_unref0 (_tmp59_);
	result = (ValadocContentInline*) link;
	_g_free0 (url);
	_g_string_free0 (builder);
	return result;
}

static ValadocContentInlineTaglet*
valadoc_gtkdoc_parser_parse_symbol_link (ValadocGtkdocParser* self,
                                         const gchar* tagname)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocTokenType _tmp5_;
	gboolean _tmp6_;
	ValadocContentInlineTaglet* taglet = NULL;
	gboolean _tmp9_ = FALSE;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocTokenType _tmp11_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	ValadocGtkdocToken* _tmp27_;
	ValadocGtkdocTokenType _tmp28_;
	ValadocGtkdocToken* _tmp44_;
	ValadocGtkdocToken* _tmp45_;
	ValadocGtkdocTokenType _tmp46_;
	gboolean _tmp47_;
	ValadocGtkdocToken* _tmp53_;
	ValadocGtkdocToken* _tmp54_;
	ValadocContentInlineTaglet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->type;
	_tmp6_ = _tmp5_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	if (_tmp6_) {
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocToken* _tmp8_;
		_tmp7_ = valadoc_gtkdoc_parser_next (self);
		_tmp8_ = _tmp7_;
		_valadoc_gtkdoc_token_unref0 (_tmp8_);
	}
	taglet = NULL;
	_tmp10_ = self->priv->current;
	_tmp11_ = _tmp10_->type;
	if (_tmp11_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->content;
		_tmp9_ = g_strcmp0 (_tmp13_, "struct") == 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValadocGtkdocToken* _tmp14_;
		ValadocGtkdocToken* _tmp15_;
		ValadocGtkdocToken* _tmp16_;
		ValadocGtkdocToken* _tmp17_;
		ValadocGtkdocTokenType _tmp18_;
		gboolean _tmp19_;
		_tmp14_ = valadoc_gtkdoc_parser_next (self);
		_tmp15_ = _tmp14_;
		_valadoc_gtkdoc_token_unref0 (_tmp15_);
		_tmp16_ = valadoc_gtkdoc_parser_next (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_->type;
		_tmp19_ = _tmp18_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
		_valadoc_gtkdoc_token_unref0 (_tmp17_);
		if (_tmp19_) {
			ValadocGtkdocToken* _tmp20_;
			ValadocGtkdocToken* _tmp21_;
			_tmp20_ = valadoc_gtkdoc_parser_next (self);
			_tmp21_ = _tmp20_;
			_valadoc_gtkdoc_token_unref0 (_tmp21_);
		}
	}
	_tmp27_ = self->priv->current;
	_tmp28_ = _tmp27_->type;
	if (_tmp28_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
		_tmp26_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp29_;
		ValadocGtkdocTokenType _tmp30_;
		_tmp29_ = self->priv->current;
		_tmp30_ = _tmp29_->type;
		_tmp26_ = _tmp30_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp31_;
		ValadocGtkdocTokenType _tmp32_;
		_tmp31_ = self->priv->current;
		_tmp32_ = _tmp31_->type;
		_tmp25_ = _tmp32_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp33_;
		ValadocGtkdocTokenType _tmp34_;
		_tmp33_ = self->priv->current;
		_tmp34_ = _tmp33_->type;
		_tmp24_ = _tmp34_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp35_;
		ValadocGtkdocTokenType _tmp36_;
		_tmp35_ = self->priv->current;
		_tmp36_ = _tmp35_->type;
		_tmp23_ = _tmp36_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp37_;
		ValadocGtkdocTokenType _tmp38_;
		_tmp37_ = self->priv->current;
		_tmp38_ = _tmp37_->type;
		_tmp22_ = _tmp38_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL;
	}
	if (_tmp22_) {
		ValadocGtkdocToken* _tmp39_;
		const gchar* _tmp40_;
		ValadocContentInline* _tmp41_;
		ValadocContentInlineTaglet* _tmp42_;
		ValadocContentInlineTaglet* _tmp43_;
		_tmp39_ = self->priv->current;
		_tmp40_ = _tmp39_->content;
		_tmp41_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp40_, FALSE);
		_tmp42_ = VALADOC_CONTENT_IS_INLINE_TAGLET (_tmp41_) ? ((ValadocContentInlineTaglet*) _tmp41_) : NULL;
		if (_tmp42_ == NULL) {
			_g_object_unref0 (_tmp41_);
		}
		_g_object_unref0 (taglet);
		taglet = _tmp42_;
		_tmp43_ = taglet;
		_vala_assert (_tmp43_ != NULL, "taglet != null");
	}
	_tmp44_ = valadoc_gtkdoc_parser_next (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_->type;
	_tmp47_ = _tmp46_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
	_valadoc_gtkdoc_token_unref0 (_tmp45_);
	if (_tmp47_) {
		ValadocGtkdocToken* _tmp48_;
		ValadocGtkdocToken* _tmp49_;
		_tmp48_ = valadoc_gtkdoc_parser_next (self);
		_tmp49_ = _tmp48_;
		_valadoc_gtkdoc_token_unref0 (_tmp49_);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp50_ = self->priv->current;
		_tmp51_ = g_strdup_printf ("</%s>", tagname);
		_tmp52_ = _tmp51_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp50_, _tmp52_);
		_g_free0 (_tmp52_);
		result = taglet;
		return result;
	}
	_tmp53_ = valadoc_gtkdoc_parser_next (self);
	_tmp54_ = _tmp53_;
	_valadoc_gtkdoc_token_unref0 (_tmp54_);
	result = taglet;
	return result;
}

static void
valadoc_gtkdoc_parser_parse_anchor (ValadocGtkdocParser* self)
{
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	g_return_if_fail (self != NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "anchor")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<anchor>");
		return;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "id");
	id = (gchar*) _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiNode* _tmp7_;
		_tmp5_ = self->priv->id_registrar;
		_tmp6_ = id;
		_tmp7_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp5_, _tmp6_, _tmp7_);
	}
	_tmp8_ = valadoc_gtkdoc_parser_next (self);
	_tmp9_ = _tmp8_;
	_valadoc_gtkdoc_token_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "anchor")) {
		ValadocGtkdocToken* _tmp10_;
		_tmp10_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, "</anchor>");
		_g_free0 (id);
		return;
	}
	_tmp11_ = valadoc_gtkdoc_parser_next (self);
	_tmp12_ = _tmp11_;
	_valadoc_gtkdoc_token_unref0 (_tmp12_);
	_g_free0 (id);
}

static ValadocContentLink*
valadoc_gtkdoc_parser_parse_xref (ValadocGtkdocParser* self)
{
	gchar* linkend = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocContentLink* link = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentLink* _tmp7_;
	ValadocContentLink* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentContentFactory* _tmp11_;
	const gchar* _tmp12_;
	ValadocContentText* _tmp13_;
	ValadocContentText* _tmp14_;
	ValadocContentLink* _tmp15_;
	ValadocImporterInternalIdRegistrar* _tmp16_;
	ValadocContentLink* _tmp17_;
	const gchar* _tmp18_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocContentLink* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "xref")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<xref>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "linkend");
	linkend = (gchar*) _tmp3_;
	_tmp4_ = valadoc_gtkdoc_parser_next (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_link (_tmp6_);
	link = _tmp7_;
	_tmp8_ = link;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->factory;
	_tmp12_ = linkend;
	_tmp13_ = valadoc_content_content_factory_create_text (_tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = link;
	_tmp16_ = self->priv->id_registrar;
	valadoc_content_link_set_id_registrar (_tmp15_, _tmp16_);
	_tmp17_ = link;
	_tmp18_ = linkend;
	valadoc_content_link_set_url (_tmp17_, _tmp18_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "xref")) {
		ValadocGtkdocToken* _tmp19_;
		_tmp19_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp19_, "</xref>");
		result = link;
		_g_free0 (linkend);
		return result;
	}
	_tmp20_ = valadoc_gtkdoc_parser_next (self);
	_tmp21_ = _tmp20_;
	_valadoc_gtkdoc_token_unref0 (_tmp21_);
	result = link;
	_g_free0 (linkend);
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_highlighted_template (ValadocGtkdocParser* self,
                                                  const gchar* tag_name,
                                                  ValadocContentRunStyle style)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocContentRun* _tmp7_;
	ValadocContentRunStyle _tmp8_;
	ValadocContentRunStyle _tmp9_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp5_;
	_tmp7_ = run;
	_tmp8_ = valadoc_content_run_get_style (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != VALADOC_CONTENT_RUN_STYLE_NONE) {
		ValadocContentRun* _tmp10_;
		ValadocContentRunStyle _tmp11_;
		ValadocContentRunStyle _tmp12_;
		_tmp10_ = run;
		_tmp11_ = valadoc_content_run_get_style (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_ != style;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocContentRun* tmp = NULL;
		ValadocContentContentFactory* _tmp13_;
		ValadocContentRun* _tmp14_;
		ValadocContentRun* _tmp15_;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		ValadocContentRun* _tmp18_;
		ValadocContentRun* _tmp19_;
		ValadocContentRun* _tmp20_;
		_tmp13_ = self->priv->factory;
		_tmp14_ = valadoc_content_content_factory_create_run (_tmp13_, style);
		tmp = _tmp14_;
		_tmp15_ = tmp;
		_tmp16_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = run;
		vala_collection_add ((ValaCollection*) _tmp17_, (ValadocContentInline*) _tmp18_);
		_tmp19_ = tmp;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (run);
		run = _tmp20_;
		_g_object_unref0 (tmp);
	} else {
		ValadocContentRun* _tmp21_;
		_tmp21_ = run;
		valadoc_content_run_set_style (_tmp21_, style);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = self->priv->current;
		_tmp23_ = g_strdup_printf ("</%s>", tag_name);
		_tmp24_ = _tmp23_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp22_, _tmp24_);
		_g_free0 (_tmp24_);
		result = run;
		return result;
	}
	_tmp25_ = valadoc_gtkdoc_parser_next (self);
	_tmp26_ = _tmp25_;
	_valadoc_gtkdoc_token_unref0 (_tmp26_);
	result = run;
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_listitem (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentListItem* _tmp4_;
	ValadocContentListItem* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaCollection* _tmp8_;
	ValaCollection* _tmp9_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "listitem")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<listitem>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list_item (_tmp3_);
	item = _tmp4_;
	_tmp5_ = item;
	_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp9_ = _tmp8_;
	vala_collection_add_all ((ValaCollection*) _tmp7_, _tmp9_);
	_vala_iterable_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "listitem")) {
		ValadocGtkdocToken* _tmp10_;
		_tmp10_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, "</listitem>");
		result = item;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_parser_next (self);
	_tmp12_ = _tmp11_;
	_valadoc_gtkdoc_token_unref0 (_tmp12_);
	result = item;
	return result;
}

static ValadocContentBlockContent*
valadoc_gtkdoc_parser_parse_docbook_information_box_template (ValadocGtkdocParser* self,
                                                              const gchar* tagname,
                                                              ValadocContentBlockContent* container)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* tmp = NULL;
	ValadocGtkdocToken* _tmp42_;
	ValadocGtkdocToken* _tmp43_;
	ValadocContentBlockContent* _tmp44_;
	ValadocContentBlockContent* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagname != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tagname);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	tmp = NULL;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		ValadocGtkdocToken* _tmp10_;
		ValadocGtkdocToken* _tmp11_;
		ValadocContentRun* ic = NULL;
		ValadocContentRun* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValadocContentRun* _tmp14_;
		ValaCollection* bc = NULL;
		ValaCollection* _tmp29_;
		gboolean _tmp30_ = FALSE;
		ValaCollection* _tmp31_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
			ValadocGtkdocToken* _tmp8_;
			ValadocGtkdocTokenType _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->type;
			_tmp5_ = _tmp9_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp10_ = self->priv->current;
		_tmp11_ = _valadoc_gtkdoc_token_ref0 (_tmp10_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp11_;
		_tmp12_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		ic = _tmp12_;
		_tmp14_ = ic;
		if (_tmp14_ != NULL) {
			ValadocContentRun* _tmp15_;
			ValaList* _tmp16_;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp15_ = ic;
			_tmp16_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = _tmp19_ > 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			ValadocContentParagraph* _tmp22_;
			ValaList* _tmp23_;
			ValaList* _tmp24_;
			ValadocContentRun* _tmp25_;
			ValaList* _tmp26_;
			ValaList* _tmp27_;
			ValadocContentParagraph* _tmp28_;
			_tmp20_ = self->priv->factory;
			_tmp21_ = valadoc_content_content_factory_create_paragraph (_tmp20_);
			p = _tmp21_;
			_tmp22_ = p;
			_tmp23_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = ic;
			vala_collection_add ((ValaCollection*) _tmp24_, (ValadocContentInline*) _tmp25_);
			_tmp26_ = valadoc_content_block_content_get_content (container);
			_tmp27_ = _tmp26_;
			_tmp28_ = p;
			vala_collection_add ((ValaCollection*) _tmp27_, (ValadocContentBlock*) _tmp28_);
			_g_object_unref0 (p);
		}
		_tmp29_ = valadoc_gtkdoc_parser_parse_block_content (self);
		bc = _tmp29_;
		_tmp31_ = bc;
		if (_tmp31_ != NULL) {
			ValaCollection* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			_tmp32_ = bc;
			_tmp33_ = vala_collection_get_size (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp30_ = _tmp34_ > 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaList* _tmp35_;
			ValaList* _tmp36_;
			ValaCollection* _tmp37_;
			_tmp35_ = valadoc_content_block_content_get_content (container);
			_tmp36_ = _tmp35_;
			_tmp37_ = bc;
			vala_collection_add_all ((ValaCollection*) _tmp36_, _tmp37_);
		}
		_vala_iterable_unref0 (bc);
		_g_object_unref0 (ic);
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tagname)) {
		ValadocGtkdocToken* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		ValadocContentBlockContent* _tmp41_;
		_tmp38_ = self->priv->current;
		_tmp39_ = g_strdup_printf ("</%s>", tagname);
		_tmp40_ = _tmp39_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp38_, _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = _g_object_ref0 (container);
		result = _tmp41_;
		_valadoc_gtkdoc_token_unref0 (tmp);
		return result;
	}
	_tmp42_ = valadoc_gtkdoc_parser_next (self);
	_tmp43_ = _tmp42_;
	_valadoc_gtkdoc_token_unref0 (_tmp43_);
	_tmp44_ = _g_object_ref0 (container);
	result = _tmp44_;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static ValadocContentNote*
valadoc_gtkdoc_parser_parse_docbook_important (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "important", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValadocContentNote*
valadoc_gtkdoc_parser_parse_docbook_note (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentNote* _tmp4_;
	ValadocContentNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "note", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_NOTE, ValadocContentNote);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static ValadocContentWarning*
valadoc_gtkdoc_parser_parse_docbook_warning (ValadocGtkdocParser* self)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentWarning* _tmp1_;
	ValadocContentWarning* _tmp2_;
	ValadocContentBlockContent* _tmp3_;
	ValadocContentWarning* _tmp4_;
	ValadocContentWarning* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_warning (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_information_box_template (self, "warning", (ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_CONTENT_TYPE_WARNING, ValadocContentWarning);
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_orderedlist (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "orderedlist", VALADOC_CONTENT_LIST_BULLET_ORDERED);
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_itemizedlist (ValadocGtkdocParser* self,
                                                  const gchar* tag_name,
                                                  ValadocContentListBullet bullet_type)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	gboolean _tmp7_ = FALSE;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocTokenType _tmp9_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp15_;
	ValadocContentList* _tmp16_;
	ValadocContentList* _tmp17_;
	ValaCollection* _tmp18_;
	ValadocContentList* _tmp19_;
	ValadocGtkdocToken* _tmp32_;
	ValadocGtkdocToken* _tmp33_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
	content = (ValaCollection*) _tmp6_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp8_ = self->priv->current;
	_tmp9_ = _tmp8_->type;
	if (_tmp9_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->current;
		_tmp11_ = _tmp10_->content;
		_tmp7_ = g_strcmp0 (_tmp11_, "title") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaCollection* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		ValadocContentParagraph* _tmp14_;
		_tmp12_ = content;
		_tmp13_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp14_ = _tmp13_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp12_, (ValadocContentBlock*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp15_ = self->priv->factory;
	_tmp16_ = valadoc_content_content_factory_create_list (_tmp15_);
	list = _tmp16_;
	_tmp17_ = list;
	valadoc_content_list_set_bullet (_tmp17_, bullet_type);
	_tmp18_ = content;
	_tmp19_ = list;
	vala_collection_add (_tmp18_, (ValadocContentBlock*) _tmp19_);
	while (TRUE) {
		ValadocGtkdocToken* _tmp20_;
		ValadocGtkdocTokenType _tmp21_;
		ValadocGtkdocToken* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->type;
		if (!(_tmp21_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_->content;
		if (g_strcmp0 (_tmp23_, "listitem") == 0) {
			ValadocContentList* _tmp24_;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			ValadocContentListItem* _tmp27_;
			ValadocContentListItem* _tmp28_;
			_tmp24_ = list;
			_tmp25_ = valadoc_content_list_get_items (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
			_tmp28_ = _tmp27_;
			vala_collection_add ((ValaCollection*) _tmp26_, _tmp28_);
			_g_object_unref0 (_tmp28_);
		} else {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = self->priv->current;
		_tmp30_ = g_strdup_printf ("</%s>", tag_name);
		_tmp31_ = _tmp30_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp29_, _tmp31_);
		_g_free0 (_tmp31_);
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp32_ = valadoc_gtkdoc_parser_next (self);
	_tmp33_ = _tmp32_;
	_valadoc_gtkdoc_token_unref0 (_tmp33_);
	result = content;
	_g_object_unref0 (list);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentRun* _tmp11_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
		ValadocGtkdocToken* _tmp2_;
		_tmp2_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, "<GTKDOC-PARAGRAPH>");
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_paragraph (_tmp5_);
	p = _tmp6_;
	_tmp7_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp7_;
	_tmp8_ = p;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = run;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp11_);
	result = p;
	_g_object_unref0 (run);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_mixed_content (ValadocGtkdocParser* self)
{
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocGtkdocToken* tmp = NULL;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	tmp = NULL;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocToken* _tmp3_;
		ValadocGtkdocToken* _tmp4_;
		ValadocGtkdocToken* _tmp5_;
		ValadocContentRun* run = NULL;
		ValadocContentRun* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValadocContentRun* _tmp8_;
		ValaCollection* lst = NULL;
		ValaCollection* _tmp22_;
		gboolean _tmp23_ = FALSE;
		ValaCollection* _tmp24_;
		_tmp2_ = tmp;
		_tmp3_ = self->priv->current;
		if (!(_tmp2_ != _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->current;
		_tmp5_ = _valadoc_gtkdoc_token_ref0 (_tmp4_);
		_valadoc_gtkdoc_token_unref0 (tmp);
		tmp = _tmp5_;
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp6_ = valadoc_gtkdoc_parser_parse_inline_content (self);
		run = _tmp6_;
		_tmp8_ = run;
		if (_tmp8_ != NULL) {
			ValadocContentRun* _tmp9_;
			ValaList* _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp9_ = run;
			_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = _tmp13_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValadocContentParagraph* p = NULL;
			ValadocContentContentFactory* _tmp14_;
			ValadocContentParagraph* _tmp15_;
			ValadocContentParagraph* _tmp16_;
			ValaList* _tmp17_;
			ValaList* _tmp18_;
			ValadocContentRun* _tmp19_;
			ValaCollection* _tmp20_;
			ValadocContentParagraph* _tmp21_;
			_tmp14_ = self->priv->factory;
			_tmp15_ = valadoc_content_content_factory_create_paragraph (_tmp14_);
			p = _tmp15_;
			_tmp16_ = p;
			_tmp17_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = run;
			vala_collection_add ((ValaCollection*) _tmp18_, (ValadocContentInline*) _tmp19_);
			_tmp20_ = content;
			_tmp21_ = p;
			vala_collection_add (_tmp20_, (ValadocContentBlock*) _tmp21_);
			_g_object_unref0 (p);
			_g_object_unref0 (run);
			continue;
		}
		_tmp22_ = valadoc_gtkdoc_parser_parse_block_content (self);
		lst = _tmp22_;
		_tmp24_ = lst;
		if (_tmp24_ != NULL) {
			ValaCollection* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp25_ = lst;
			_tmp26_ = vala_collection_get_size (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ > 0;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			ValaCollection* _tmp28_;
			ValaCollection* _tmp29_;
			_tmp28_ = content;
			_tmp29_ = lst;
			vala_collection_add_all (_tmp28_, _tmp29_);
			_vala_iterable_unref0 (lst);
			_g_object_unref0 (run);
			continue;
		}
		_vala_iterable_unref0 (lst);
		_g_object_unref0 (run);
	}
	result = content;
	_valadoc_gtkdoc_token_unref0 (tmp);
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_simpara (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "simpara");
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_para (ValadocGtkdocParser* self,
                                          const gchar* tag_name)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	_tmp5_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp5_;
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp7_;
		ValadocGtkdocTokenType _tmp8_;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->type;
		_tmp6_ = _tmp8_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocGtkdocToken* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->priv->current;
		_tmp10_ = g_strdup_printf ("</%s>", tag_name);
		_tmp11_ = _tmp10_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		result = content;
		return result;
	}
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	result = content;
	return result;
}

static ValadocContentSourceCodeLanguage*
_valadoc_content_source_code_language_dup (ValadocContentSourceCodeLanguage* self)
{
	ValadocContentSourceCodeLanguage* dup;
	dup = g_new0 (ValadocContentSourceCodeLanguage, 1);
	memcpy (dup, self, sizeof (ValadocContentSourceCodeLanguage));
	return dup;
}

static gpointer
__valadoc_content_source_code_language_dup0 (gpointer self)
{
	return self ? _valadoc_content_source_code_language_dup (self) : NULL;
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_gtkdoc_source (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocTokenType _tmp1_;
	GString* builder = NULL;
	GString* _tmp3_;
	ValadocGtkdocToken* source_token = NULL;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocContentSourceCode* code = NULL;
	ValadocContentContentFactory* _tmp27_;
	ValadocContentSourceCode* _tmp28_;
	GMatchInfo* info = NULL;
	const gchar* source = NULL;
	GString* _tmp29_;
	const gchar* _tmp30_;
	GRegex* _tmp31_;
	const gchar* _tmp32_;
	GMatchInfo* _tmp33_ = NULL;
	gboolean _tmp34_;
	ValadocContentSourceCode* _tmp56_;
	const gchar* _tmp57_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp58_;
	ValadocContentParagraph* _tmp59_;
	ValadocContentParagraph* _tmp60_;
	ValaList* _tmp61_;
	ValaList* _tmp62_;
	ValadocContentSourceCode* _tmp63_;
	ValadocGtkdocToken* _tmp64_;
	ValadocGtkdocTokenType _tmp65_;
	ValadocGtkdocToken* _tmp67_;
	ValadocGtkdocToken* _tmp68_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
		ValadocGtkdocToken* _tmp2_;
		_tmp2_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp2_, "|[");
		result = NULL;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	_tmp4_ = self->priv->current;
	_tmp5_ = _valadoc_gtkdoc_token_ref0 (_tmp4_);
	source_token = _tmp5_;
	{
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocToken* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = valadoc_gtkdoc_parser_next (self);
		_tmp7_ = _tmp6_;
		_valadoc_gtkdoc_token_unref0 (_tmp7_);
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			ValadocGtkdocToken* _tmp12_;
			ValadocGtkdocTokenType _tmp13_;
			ValadocGtkdocToken* _tmp16_;
			ValadocGtkdocTokenType _tmp17_;
			if (!_tmp8_) {
				ValadocGtkdocToken* _tmp9_;
				ValadocGtkdocToken* _tmp10_;
				_tmp9_ = valadoc_gtkdoc_parser_next (self);
				_tmp10_ = _tmp9_;
				_valadoc_gtkdoc_token_unref0 (_tmp10_);
			}
			_tmp8_ = FALSE;
			_tmp12_ = self->priv->current;
			_tmp13_ = _tmp12_->type;
			if (_tmp13_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				ValadocGtkdocToken* _tmp14_;
				ValadocGtkdocTokenType _tmp15_;
				_tmp14_ = self->priv->current;
				_tmp15_ = _tmp14_->type;
				_tmp11_ = _tmp15_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp16_ = self->priv->current;
			_tmp17_ = _tmp16_->type;
			if (_tmp17_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp18_;
				ValadocGtkdocToken* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = builder;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_->content;
				g_string_append (_tmp18_, _tmp20_);
			} else {
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp23_;
					ValadocGtkdocToken* _tmp24_;
					const gchar* _tmp25_;
					ValadocGtkdocToken* _tmp26_;
					_tmp23_ = builder;
					_tmp24_ = self->priv->current;
					_tmp25_ = _tmp24_->start;
					_tmp26_ = self->priv->current;
					g_string_append_len (_tmp23_, _tmp25_, (gssize) _tmp26_->length);
				}
			}
		}
	}
	_tmp27_ = self->priv->factory;
	_tmp28_ = valadoc_content_content_factory_create_source_code (_tmp27_);
	code = _tmp28_;
	_tmp29_ = builder;
	_tmp30_ = _tmp29_->str;
	source = _tmp30_;
	_tmp31_ = self->priv->regex_source_lang;
	_tmp32_ = source;
	_tmp34_ = g_regex_match (_tmp31_, _tmp32_, 0, &_tmp33_);
	_g_match_info_unref0 (info);
	info = _tmp33_;
	if (_tmp34_) {
		gchar* lang_name = NULL;
		GMatchInfo* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		ValadocContentSourceCodeLanguage* lang = NULL;
		const gchar* _tmp40_;
		ValadocContentSourceCodeLanguage _tmp41_;
		ValadocContentSourceCodeLanguage* _tmp42_;
		ValadocContentSourceCode* _tmp43_;
		ValadocContentSourceCodeLanguage* _tmp44_;
		ValadocContentSourceCodeLanguage* _tmp45_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		_tmp35_ = info;
		_tmp36_ = g_match_info_fetch (_tmp35_, 1);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_ascii_strdown (_tmp37_, (gssize) -1);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		lang_name = _tmp39_;
		_tmp40_ = lang_name;
		_tmp41_ = valadoc_content_source_code_language_from_string (_tmp40_, FALSE);
		_tmp42_ = __valadoc_content_source_code_language_dup0 (&_tmp41_);
		lang = _tmp42_;
		_tmp43_ = code;
		_tmp44_ = lang;
		valadoc_content_source_code_set_language (_tmp43_, *_tmp44_);
		_tmp45_ = lang;
		if (_tmp45_ == NULL) {
			ValadocGtkdocToken* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp46_ = source_token;
			_tmp47_ = lang_name;
			_tmp48_ = g_strdup_printf ("Unknown language `%s' in source code block |[<!-- language=\"\"", _tmp47_);
			_tmp49_ = _tmp48_;
			valadoc_gtkdoc_parser_report_warning (self, _tmp46_, _tmp49_);
			_g_free0 (_tmp49_);
		}
		_tmp50_ = source;
		_tmp51_ = source;
		_tmp52_ = string_offset (_tmp50_, (glong) (string_index_of_char (_tmp51_, (gunichar) '>', 0) + 1));
		source = _tmp52_;
		_g_free0 (lang);
		_g_free0 (lang_name);
	} else {
		ValadocContentSourceCodeLanguage _tmp53_ = 0;
		const gchar* _tmp54_;
		ValadocContentSourceCode* _tmp55_;
		_tmp54_ = source;
		if (valadoc_highlighter_xml_scanner_is_xml (_tmp54_)) {
			_tmp53_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
		} else {
			_tmp53_ = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
		}
		_tmp55_ = code;
		valadoc_content_source_code_set_language (_tmp55_, _tmp53_);
	}
	_tmp56_ = code;
	_tmp57_ = source;
	valadoc_content_source_code_set_code (_tmp56_, _tmp57_);
	_tmp58_ = self->priv->factory;
	_tmp59_ = valadoc_content_content_factory_create_paragraph (_tmp58_);
	p = _tmp59_;
	_tmp60_ = p;
	_tmp61_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = code;
	vala_collection_add ((ValaCollection*) _tmp62_, (ValadocContentInline*) _tmp63_);
	_tmp64_ = self->priv->current;
	_tmp65_ = _tmp64_->type;
	if (_tmp65_ != VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE) {
		ValadocGtkdocToken* _tmp66_;
		_tmp66_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp66_, "|]");
		result = p;
		_g_match_info_unref0 (info);
		_g_object_unref0 (code);
		_valadoc_gtkdoc_token_unref0 (source_token);
		_g_string_free0 (builder);
		return result;
	}
	_tmp67_ = valadoc_gtkdoc_parser_next (self);
	_tmp68_ = _tmp67_;
	_valadoc_gtkdoc_token_unref0 (_tmp68_);
	result = p;
	_g_match_info_unref0 (info);
	_g_object_unref0 (code);
	_valadoc_gtkdoc_token_unref0 (source_token);
	_g_string_free0 (builder);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_title (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValadocContentRun* content = NULL;
	ValadocContentRun* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	ValadocContentContentFactory* _tmp9_;
	ValadocContentText* _tmp10_;
	ValadocContentText* _tmp11_;
	ValadocContentRun* _tmp12_;
	ValadocContentParagraph* _tmp13_;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	ValadocContentRun* _tmp16_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "title")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<title>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_paragraph (_tmp3_);
	p = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	content = _tmp5_;
	_tmp6_ = content;
	_tmp7_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->factory;
	_tmp10_ = valadoc_content_content_factory_create_text (_tmp9_, ":");
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp8_, (ValadocContentInline*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = content;
	valadoc_content_run_set_style (_tmp12_, VALADOC_CONTENT_RUN_STYLE_BOLD);
	_tmp13_ = p;
	_tmp14_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = content;
	vala_collection_add ((ValaCollection*) _tmp15_, (ValadocContentInline*) _tmp16_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "title")) {
		ValadocGtkdocToken* _tmp17_;
		_tmp17_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp17_, "</title>");
		result = p;
		_g_object_unref0 (content);
		return result;
	}
	_tmp18_ = valadoc_gtkdoc_parser_next (self);
	_tmp19_ = _tmp18_;
	_valadoc_gtkdoc_token_unref0 (_tmp19_);
	result = p;
	_g_object_unref0 (content);
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_graphic (ValadocGtkdocParser* self)
{
	ValadocContentEmbedded* tmp = NULL;
	ValadocContentEmbedded* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp2_;
	ValadocContentParagraph* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValadocContentEmbedded* _tmp7_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "graphic");
	tmp = _tmp0_;
	_tmp1_ = tmp;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (tmp);
		return result;
	}
	_tmp2_ = self->priv->factory;
	_tmp3_ = valadoc_content_content_factory_create_paragraph (_tmp2_);
	p = _tmp3_;
	_tmp4_ = p;
	_tmp5_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = tmp;
	vala_collection_add ((ValaCollection*) _tmp6_, (ValadocContentInline*) _tmp7_);
	result = p;
	_g_object_unref0 (tmp);
	return result;
}

static ValadocContentEmbedded*
valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (ValadocGtkdocParser* self,
                                                   const gchar* tag_name)
{
	ValadocContentEmbedded* e = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentEmbedded* _tmp4_;
	ValadocContentEmbedded* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValaHashMap* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentEmbedded* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_embedded (_tmp3_);
	e = _tmp4_;
	_tmp5_ = e;
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->attributes;
	_tmp8_ = vala_map_get ((ValaMap*) _tmp7_, "fileref");
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = valadoc_gtkdoc_parser_fix_resource_path (self, _tmp9_);
	_tmp11_ = _tmp10_;
	valadoc_content_embedded_set_url (_tmp5_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->priv->current;
		_tmp15_ = g_strdup_printf ("</%s>", tag_name);
		_tmp16_ = _tmp15_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp14_, _tmp16_);
		_g_free0 (_tmp16_);
		result = e;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = e;
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_programlisting (ValadocGtkdocParser* self)
{
	GString* builder = NULL;
	GString* _tmp1_;
	ValadocContentSourceCode* src = NULL;
	ValadocContentContentFactory* _tmp26_;
	ValadocContentSourceCode* _tmp27_;
	ValadocContentSourceCode* _tmp28_;
	ValadocContentSourceCode* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp32_;
	ValadocContentParagraph* _tmp33_;
	ValadocContentParagraph* _tmp34_;
	ValaList* _tmp35_;
	ValaList* _tmp36_;
	ValadocContentSourceCode* _tmp37_;
	ValadocGtkdocToken* _tmp39_;
	ValadocGtkdocToken* _tmp40_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "programlisting")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<programlisting>");
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	{
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocToken* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = valadoc_gtkdoc_parser_next (self);
		_tmp3_ = _tmp2_;
		_valadoc_gtkdoc_token_unref0 (_tmp3_);
		_tmp4_ = TRUE;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			ValadocGtkdocToken* _tmp8_;
			ValadocGtkdocTokenType _tmp9_;
			ValadocGtkdocToken* _tmp15_;
			ValadocGtkdocTokenType _tmp16_;
			if (!_tmp4_) {
				ValadocGtkdocToken* _tmp5_;
				ValadocGtkdocToken* _tmp6_;
				_tmp5_ = valadoc_gtkdoc_parser_next (self);
				_tmp6_ = _tmp5_;
				_valadoc_gtkdoc_token_unref0 (_tmp6_);
			}
			_tmp4_ = FALSE;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->type;
			if (_tmp9_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF) {
				gboolean _tmp10_ = FALSE;
				ValadocGtkdocToken* _tmp11_;
				ValadocGtkdocTokenType _tmp12_;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_->type;
				if (_tmp12_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
					ValadocGtkdocToken* _tmp13_;
					const gchar* _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_->content;
					_tmp10_ = g_strcmp0 (_tmp14_, "programlisting") == 0;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp7_ = !_tmp10_;
			} else {
				_tmp7_ = FALSE;
			}
			if (!_tmp7_) {
				break;
			}
			_tmp15_ = self->priv->current;
			_tmp16_ = _tmp15_->type;
			if (_tmp16_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
				GString* _tmp17_;
				ValadocGtkdocToken* _tmp18_;
				const gchar* _tmp19_;
				_tmp17_ = builder;
				_tmp18_ = self->priv->current;
				_tmp19_ = _tmp18_->content;
				g_string_append (_tmp17_, _tmp19_);
			} else {
				ValadocGtkdocToken* _tmp20_;
				ValadocGtkdocTokenType _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_->type;
				if (_tmp21_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
					GString* _tmp22_;
					ValadocGtkdocToken* _tmp23_;
					const gchar* _tmp24_;
					ValadocGtkdocToken* _tmp25_;
					_tmp22_ = builder;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_->start;
					_tmp25_ = self->priv->current;
					g_string_append_len (_tmp22_, _tmp24_, (gssize) _tmp25_->length);
				}
			}
		}
	}
	_tmp26_ = self->priv->factory;
	_tmp27_ = valadoc_content_content_factory_create_source_code (_tmp26_);
	src = _tmp27_;
	_tmp28_ = src;
	valadoc_content_source_code_set_language (_tmp28_, VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C);
	_tmp29_ = src;
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	valadoc_content_source_code_set_code (_tmp29_, _tmp31_);
	_tmp32_ = self->priv->factory;
	_tmp33_ = valadoc_content_content_factory_create_paragraph (_tmp32_);
	p = _tmp33_;
	_tmp34_ = p;
	_tmp35_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = src;
	vala_collection_add ((ValaCollection*) _tmp36_, (ValadocContentInline*) _tmp37_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "programlisting")) {
		ValadocGtkdocToken* _tmp38_;
		_tmp38_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp38_, "</programlisting>");
		result = p;
		_g_object_unref0 (src);
		_g_string_free0 (builder);
		return result;
	}
	_tmp39_ = valadoc_gtkdoc_parser_next (self);
	_tmp40_ = _tmp39_;
	_valadoc_gtkdoc_token_unref0 (_tmp40_);
	result = p;
	_g_object_unref0 (src);
	_g_string_free0 (builder);
	return result;
}

static inline ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_informalexample (ValadocGtkdocParser* self)
{
	ValaCollection* _tmp0_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "informalexample");
	result = _tmp0_;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_example (ValadocGtkdocParser* self,
                                             const gchar* tag_name)
{
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaCollection* _tmp7_;
	ValaCollection* _tmp8_;
	ValaCollection* _tmp9_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->current;
		_tmp1_ = g_strdup_printf ("<%s>", tag_name);
		_tmp2_ = _tmp1_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_parser_next (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_);
	content = (ValaCollection*) _tmp6_;
	_tmp7_ = content;
	_tmp8_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp9_ = _tmp8_;
	vala_collection_add_all (_tmp7_, _tmp9_);
	_vala_iterable_unref0 (_tmp9_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, tag_name)) {
		ValadocGtkdocToken* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->current;
		_tmp11_ = g_strdup_printf ("</%s>", tag_name);
		_tmp12_ = _tmp11_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		result = content;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	result = content;
	return result;
}

static ValaList*
valadoc_gtkdoc_parser_parse_docbook_refsect2 (ValadocGtkdocParser* self,
                                              gint nr)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp6_;
	ValaHashMap* _tmp7_;
	gpointer _tmp8_;
	const gchar* _tmp9_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValaList* content = NULL;
	GEqualFunc _tmp15_;
	ValaArrayList* _tmp16_;
	ValaList* _tmp17_;
	ValaCollection* _tmp18_;
	ValaCollection* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("refsect%d", nr);
	_tmp1_ = _tmp0_;
	_tmp2_ = !valadoc_gtkdoc_parser_check_xml_open_tag (self, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		ValadocGtkdocToken* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->current;
		_tmp4_ = g_strdup_printf ("<refsect%d>", nr);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp3_, _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->attributes;
	_tmp8_ = vala_map_get ((ValaMap*) _tmp7_, "id");
	id = (gchar*) _tmp8_;
	_tmp9_ = id;
	if (_tmp9_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp10_;
		const gchar* _tmp11_;
		ValadocApiNode* _tmp12_;
		_tmp10_ = self->priv->id_registrar;
		_tmp11_ = id;
		_tmp12_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp10_, _tmp11_, _tmp12_);
	}
	_tmp13_ = valadoc_gtkdoc_parser_next (self);
	_tmp14_ = _tmp13_;
	_valadoc_gtkdoc_token_unref0 (_tmp14_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp15_ = g_direct_equal;
	_tmp16_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp15_);
	content = (ValaList*) _tmp16_;
	_tmp17_ = content;
	_tmp18_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp19_ = _tmp18_;
	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, (ValaCollection*) _tmp17_, _tmp19_);
	_vala_iterable_unref0 (_tmp19_);
	_tmp20_ = g_strdup_printf ("refsect%d", nr);
	_tmp21_ = _tmp20_;
	_tmp22_ = !valadoc_gtkdoc_parser_check_xml_close_tag (self, _tmp21_);
	_g_free0 (_tmp21_);
	if (_tmp22_) {
		ValadocGtkdocToken* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = self->priv->current;
		_tmp24_ = g_strdup_printf ("</refsect%d>", nr);
		_tmp25_ = _tmp24_;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp23_, _tmp25_);
		_g_free0 (_tmp25_);
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp26_ = valadoc_gtkdoc_parser_next (self);
	_tmp27_ = _tmp26_;
	_valadoc_gtkdoc_token_unref0 (_tmp27_);
	result = content;
	_g_free0 (id);
	return result;
}

static ValaList*
valadoc_gtkdoc_parser_parse_docbook_figure (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaList* content = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocTokenType _tmp7_;
	ValadocGtkdocToken* _tmp45_;
	ValadocGtkdocToken* _tmp46_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "figure")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<figure>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	content = (ValaList*) _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->type;
	if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_->content;
		_tmp5_ = g_strcmp0 (_tmp9_, "title") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaList* _tmp10_;
		ValadocContentParagraph* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		_tmp10_ = content;
		_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp12_ = _tmp11_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp10_, (ValadocContentBlock*) _tmp12_);
		_g_object_unref0 (_tmp12_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	while (TRUE) {
		ValadocGtkdocToken* _tmp13_;
		ValadocGtkdocTokenType _tmp14_;
		ValadocGtkdocToken* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->current;
		_tmp14_ = _tmp13_->type;
		if (!(_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN)) {
			break;
		}
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->content;
		if (g_strcmp0 (_tmp16_, "inlinegraphic") == 0) {
			ValadocContentParagraph* _tmp17_ = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			ValadocContentParagraph* p = NULL;
			ValadocContentParagraph* _tmp25_;
			ValadocContentParagraph* _tmp26_;
			_tmp18_ = content;
			_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ > 0) {
				ValaList* _tmp21_;
				gpointer _tmp22_;
				ValadocContentBlock* _tmp23_;
				ValadocContentParagraph* _tmp24_;
				_tmp21_ = content;
				_tmp22_ = vala_list_get (_tmp21_, 0);
				_tmp23_ = (ValadocContentBlock*) _tmp22_;
				_tmp24_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp23_) ? ((ValadocContentParagraph*) _tmp23_) : NULL;
				if (_tmp24_ == NULL) {
					_g_object_unref0 (_tmp23_);
				}
				_g_object_unref0 (_tmp17_);
				_tmp17_ = _tmp24_;
			} else {
				_g_object_unref0 (_tmp17_);
				_tmp17_ = NULL;
			}
			_tmp25_ = _g_object_ref0 (_tmp17_);
			p = _tmp25_;
			_tmp26_ = p;
			if (_tmp26_ == NULL) {
				ValadocContentContentFactory* _tmp27_;
				ValadocContentParagraph* _tmp28_;
				_tmp27_ = self->priv->factory;
				_tmp28_ = valadoc_content_content_factory_create_paragraph (_tmp27_);
				_g_object_unref0 (p);
				p = _tmp28_;
			}
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				ValadocGtkdocToken* _tmp30_;
				ValadocGtkdocTokenType _tmp31_;
				ValadocContentParagraph* _tmp34_;
				ValaList* _tmp35_;
				ValaList* _tmp36_;
				ValadocContentEmbedded* _tmp37_;
				ValadocContentEmbedded* _tmp38_;
				_tmp30_ = self->priv->current;
				_tmp31_ = _tmp30_->type;
				if (_tmp31_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp32_;
					const gchar* _tmp33_;
					_tmp32_ = self->priv->current;
					_tmp33_ = _tmp32_->content;
					_tmp29_ = g_strcmp0 (_tmp33_, "inlinegraphic") == 0;
				} else {
					_tmp29_ = FALSE;
				}
				if (!_tmp29_) {
					break;
				}
				_tmp34_ = p;
				_tmp35_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
				_tmp38_ = _tmp37_;
				vala_collection_add ((ValaCollection*) _tmp36_, (ValadocContentInline*) _tmp38_);
				_g_object_unref0 (_tmp38_);
				valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			}
			_g_object_unref0 (p);
			_g_object_unref0 (_tmp17_);
		} else {
			ValadocGtkdocToken* _tmp39_;
			const gchar* _tmp40_;
			_tmp39_ = self->priv->current;
			_tmp40_ = _tmp39_->content;
			if (g_strcmp0 (_tmp40_, "graphic") == 0) {
				ValaList* _tmp41_;
				ValadocContentParagraph* _tmp42_;
				ValadocContentParagraph* _tmp43_;
				_tmp41_ = content;
				_tmp42_ = valadoc_gtkdoc_parser_parse_docbook_graphic (self);
				_tmp43_ = _tmp42_;
				valadoc_gtkdoc_parser_append_block_content_not_null (self, (ValaCollection*) _tmp41_, (ValadocContentBlock*) _tmp43_);
				_g_object_unref0 (_tmp43_);
			} else {
				break;
			}
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "figure")) {
		ValadocGtkdocToken* _tmp44_;
		_tmp44_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp44_, "</figure>");
		result = content;
		return result;
	}
	_tmp45_ = valadoc_gtkdoc_parser_next (self);
	_tmp46_ = _tmp45_;
	_valadoc_gtkdoc_token_unref0 (_tmp46_);
	result = content;
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_docbook_footnote (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	gint counter = 0;
	ValaList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValadocContentRun* nr = NULL;
	ValadocContentContentFactory* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValadocContentRun* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentContentFactory* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValadocContentText* _tmp14_;
	ValadocContentText* _tmp15_;
	ValaList* content = NULL;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	ValaList* _tmp18_;
	ValaList* _tmp19_;
	ValaList* _tmp20_;
	ValaCollection* _tmp21_;
	ValaCollection* _tmp22_;
	ValadocContentParagraph* _tmp23_ = NULL;
	ValaList* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	ValadocContentParagraph* first = NULL;
	ValadocContentParagraph* _tmp31_;
	ValadocContentParagraph* _tmp32_;
	ValadocContentRun* entry = NULL;
	ValadocContentContentFactory* _tmp37_;
	ValadocContentRun* _tmp38_;
	ValadocContentRun* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	ValadocContentContentFactory* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	ValadocContentText* _tmp47_;
	ValadocContentText* _tmp48_;
	ValadocContentParagraph* _tmp49_;
	ValaList* _tmp50_;
	ValaList* _tmp51_;
	ValadocContentRun* _tmp52_;
	ValadocGtkdocToken* _tmp54_;
	ValadocGtkdocToken* _tmp55_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "footnote")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<footnote>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->footnotes;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	counter = _tmp5_ + 1;
	_tmp6_ = self->priv->factory;
	_tmp7_ = valadoc_content_content_factory_create_run (_tmp6_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	nr = _tmp7_;
	_tmp8_ = nr;
	_tmp9_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->factory;
	_tmp12_ = g_strdup_printf ("[%d] ", counter);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_content_content_factory_create_text (_tmp11_, _tmp13_);
	_tmp15_ = _tmp14_;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentInline*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp16_);
	content = (ValaList*) _tmp17_;
	_tmp18_ = self->priv->footnotes;
	_tmp19_ = content;
	vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
	_tmp20_ = content;
	_tmp21_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	_tmp22_ = _tmp21_;
	vala_collection_add_all ((ValaCollection*) _tmp20_, _tmp22_);
	_vala_iterable_unref0 (_tmp22_);
	_tmp24_ = content;
	_tmp25_ = vala_collection_get_is_empty ((ValaCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		_g_object_unref0 (_tmp23_);
		_tmp23_ = NULL;
	} else {
		ValaList* _tmp27_;
		gpointer _tmp28_;
		ValadocContentBlock* _tmp29_;
		ValadocContentParagraph* _tmp30_;
		_tmp27_ = content;
		_tmp28_ = vala_list_first (_tmp27_);
		_tmp29_ = (ValadocContentBlock*) _tmp28_;
		_tmp30_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp29_) ? ((ValadocContentParagraph*) _tmp29_) : NULL;
		if (_tmp30_ == NULL) {
			_g_object_unref0 (_tmp29_);
		}
		_g_object_unref0 (_tmp23_);
		_tmp23_ = _tmp30_;
	}
	_tmp31_ = _g_object_ref0 (_tmp23_);
	first = _tmp31_;
	_tmp32_ = first;
	if (_tmp32_ == NULL) {
		ValadocContentContentFactory* _tmp33_;
		ValadocContentParagraph* _tmp34_;
		ValaList* _tmp35_;
		ValadocContentParagraph* _tmp36_;
		_tmp33_ = self->priv->factory;
		_tmp34_ = valadoc_content_content_factory_create_paragraph (_tmp33_);
		_g_object_unref0 (first);
		first = _tmp34_;
		_tmp35_ = content;
		_tmp36_ = first;
		vala_list_insert (_tmp35_, 0, (ValadocContentBlock*) _tmp36_);
	}
	_tmp37_ = self->priv->factory;
	_tmp38_ = valadoc_content_content_factory_create_run (_tmp37_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	entry = _tmp38_;
	_tmp39_ = entry;
	_tmp40_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->factory;
	_tmp43_ = g_strdup_printf ("%i", counter);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp44_, ": ", NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = valadoc_content_content_factory_create_text (_tmp42_, _tmp46_);
	_tmp48_ = _tmp47_;
	vala_collection_add ((ValaCollection*) _tmp41_, (ValadocContentInline*) _tmp48_);
	_g_object_unref0 (_tmp48_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_tmp49_ = first;
	_tmp50_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = entry;
	vala_list_insert (_tmp51_, 0, (ValadocContentInline*) _tmp52_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "footnote")) {
		ValadocGtkdocToken* _tmp53_;
		_tmp53_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp53_, "</footnote>");
		result = nr;
		_g_object_unref0 (entry);
		_g_object_unref0 (first);
		_g_object_unref0 (_tmp23_);
		_vala_iterable_unref0 (content);
		return result;
	}
	_tmp54_ = valadoc_gtkdoc_parser_next (self);
	_tmp55_ = _tmp54_;
	_valadoc_gtkdoc_token_unref0 (_tmp55_);
	result = nr;
	_g_object_unref0 (entry);
	_g_object_unref0 (first);
	_g_object_unref0 (_tmp23_);
	_vala_iterable_unref0 (content);
	return result;
}

static inline void
valadoc_gtkdoc_parser_append_block_content_not_null_all (ValadocGtkdocParser* self,
                                                         ValaCollection* run,
                                                         ValaCollection* elements)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	if (elements != NULL) {
		vala_collection_add_all (run, elements);
	}
}

static inline void
valadoc_gtkdoc_parser_append_block_content_not_null (ValadocGtkdocParser* self,
                                                     ValaCollection* run,
                                                     ValadocContentBlock* element)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	if (element != NULL) {
		vala_collection_add (run, element);
	}
}

static ValadocContentTableRow*
valadoc_gtkdoc_parser_parse_docbook_thead (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableRow* row = NULL;
	ValadocContentTableRow* _tmp3_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentTableRow* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "thead")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<thead>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_BOLD);
	row = _tmp3_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "thead")) {
		ValadocGtkdocToken* _tmp4_;
		_tmp4_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp4_, "</thead>");
		result = row;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	result = row;
	return result;
}

static ValadocContentTableCell*
valadoc_gtkdoc_parser_parse_docbook_entry (ValadocGtkdocParser* self,
                                           ValadocContentRunStyle default_style)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableCell* cell = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTableCell* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValadocContentRun* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentRun* _tmp10_;
	ValadocContentRun* _tmp11_;
	ValadocContentTableCell* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValadocContentRun* _tmp15_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentTableCell* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "entry")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<entry>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table_cell (_tmp3_);
	cell = _tmp4_;
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_run (_tmp5_, default_style);
	run = _tmp6_;
	_tmp7_ = run;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp11_ = _tmp10_;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = cell;
	_tmp13_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = run;
	vala_collection_add ((ValaCollection*) _tmp14_, (ValadocContentInline*) _tmp15_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "entry")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</entry>");
		result = cell;
		_g_object_unref0 (run);
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = cell;
	_g_object_unref0 (run);
	return result;
}

static ValadocContentTableRow*
valadoc_gtkdoc_parser_parse_docbook_row (ValadocGtkdocParser* self,
                                         ValadocContentRunStyle default_style)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTableRow* row = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTableRow* _tmp4_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentTableRow* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "row")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<row>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table_row (_tmp3_);
	row = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		ValadocContentTableCell* table_cell = NULL;
		ValadocContentTableCell* _tmp10_;
		ValadocContentTableCell* _tmp11_;
		ValadocContentTableRow* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		ValadocContentTableCell* _tmp15_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->content;
			_tmp5_ = g_strcmp0 (_tmp9_, "entry") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_entry (self, default_style);
		table_cell = _tmp10_;
		_tmp11_ = table_cell;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (table_cell);
			break;
		}
		_tmp12_ = row;
		_tmp13_ = valadoc_content_table_row_get_cells (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = table_cell;
		vala_collection_add ((ValaCollection*) _tmp14_, _tmp15_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (table_cell);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "row")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</row>");
		result = row;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = row;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_tbody (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaCollection* rows = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tbody")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tbody>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_TABLE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	rows = (ValaCollection*) _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp10_;
		ValadocContentTableRow* _tmp11_;
		ValaCollection* _tmp12_;
		ValadocContentTableRow* _tmp13_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->content;
			_tmp5_ = g_strcmp0 (_tmp9_, "row") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_row (self, VALADOC_CONTENT_RUN_STYLE_NONE);
		row = _tmp10_;
		_tmp11_ = row;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (row);
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_tmp12_ = rows;
		_tmp13_ = row;
		vala_collection_add (_tmp12_, _tmp13_);
		_g_object_unref0 (row);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tbody")) {
		ValadocGtkdocToken* _tmp14_;
		_tmp14_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp14_, "</tbody>");
		result = rows;
		return result;
	}
	_tmp15_ = valadoc_gtkdoc_parser_next (self);
	_tmp16_ = _tmp15_;
	_valadoc_gtkdoc_token_unref0 (_tmp16_);
	result = rows;
	return result;
}

static ValadocContentTable*
valadoc_gtkdoc_parser_parse_docbook_tgroup (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTable* table = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentTable* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocTokenType _tmp7_;
	gboolean _tmp16_ = FALSE;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocTokenType _tmp18_;
	ValadocGtkdocToken* _tmp28_;
	ValadocGtkdocToken* _tmp29_;
	ValadocContentTable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tgroup")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tgroup>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_table (_tmp3_);
	table = _tmp4_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->type;
	if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_->content;
		_tmp5_ = g_strcmp0 (_tmp9_, "thead") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValadocContentTableRow* row = NULL;
		ValadocContentTableRow* _tmp10_;
		ValadocContentTableRow* _tmp11_;
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_thead (self);
		row = _tmp10_;
		_tmp11_ = row;
		if (_tmp11_ != NULL) {
			ValadocContentTable* _tmp12_;
			ValaList* _tmp13_;
			ValaList* _tmp14_;
			ValadocContentTableRow* _tmp15_;
			valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
			_tmp12_ = table;
			_tmp13_ = valadoc_content_table_get_rows (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = row;
			vala_collection_add ((ValaCollection*) _tmp14_, _tmp15_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (row);
	}
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->type;
	if (_tmp18_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->content;
		_tmp16_ = g_strcmp0 (_tmp20_, "tbody") == 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaCollection* rows = NULL;
		ValaCollection* _tmp21_;
		ValaCollection* _tmp22_;
		_tmp21_ = valadoc_gtkdoc_parser_parse_docbook_tbody (self);
		rows = _tmp21_;
		_tmp22_ = rows;
		if (_tmp22_ != NULL) {
			ValadocContentTable* _tmp23_;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			ValaCollection* _tmp26_;
			_tmp23_ = table;
			_tmp24_ = valadoc_content_table_get_rows (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = rows;
			vala_collection_add_all ((ValaCollection*) _tmp25_, _tmp26_);
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_vala_iterable_unref0 (rows);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tgroup")) {
		ValadocGtkdocToken* _tmp27_;
		_tmp27_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp27_, "</tgroup>");
		result = table;
		return result;
	}
	_tmp28_ = valadoc_gtkdoc_parser_next (self);
	_tmp29_ = _tmp28_;
	_valadoc_gtkdoc_token_unref0 (_tmp29_);
	result = table;
	return result;
}

static ValadocContentTable*
valadoc_gtkdoc_parser_parse_docbook_informaltable (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentTable* table = NULL;
	ValadocContentTable* _tmp3_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocContentTable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "informaltable")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<informaltable>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = valadoc_gtkdoc_parser_parse_docbook_tgroup (self);
	table = _tmp3_;
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "informaltable")) {
		ValadocGtkdocToken* _tmp4_;
		_tmp4_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp4_, "</informaltable>");
		result = table;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_parser_next (self);
	_tmp6_ = _tmp5_;
	_valadoc_gtkdoc_token_unref0 (_tmp6_);
	result = table;
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_section (ValadocGtkdocParser* self)
{
	gchar* id = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValaCollection* content = NULL;
	ValaCollection* _tmp10_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "section")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<section>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "id");
	id = (gchar*) _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiNode* _tmp7_;
		_tmp5_ = self->priv->id_registrar;
		_tmp6_ = id;
		_tmp7_ = self->priv->element;
		valadoc_importer_internal_id_registrar_register_symbol (_tmp5_, _tmp6_, _tmp7_);
	}
	_tmp8_ = valadoc_gtkdoc_parser_next (self);
	_tmp9_ = _tmp8_;
	_valadoc_gtkdoc_token_unref0 (_tmp9_);
	_tmp10_ = valadoc_gtkdoc_parser_parse_mixed_content (self);
	content = _tmp10_;
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "section")) {
		ValadocGtkdocToken* _tmp11_;
		_tmp11_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp11_, "</section>");
		result = content;
		_g_free0 (id);
		return result;
	}
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	result = content;
	_g_free0 (id);
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_member (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentListItem* item = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentListItem* _tmp4_;
	ValadocContentParagraph* para = NULL;
	ValadocContentContentFactory* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	ValadocContentListItem* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentParagraph* _tmp10_;
	ValadocContentParagraph* _tmp11_;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	ValadocContentRun* _tmp14_;
	ValadocContentRun* _tmp15_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "member")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<member>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list_item (_tmp3_);
	item = _tmp4_;
	_tmp5_ = self->priv->factory;
	_tmp6_ = valadoc_content_content_factory_create_paragraph (_tmp5_);
	para = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = para;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentBlock*) _tmp10_);
	_tmp11_ = para;
	_tmp12_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	_tmp15_ = _tmp14_;
	vala_collection_add ((ValaCollection*) _tmp13_, (ValadocContentInline*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "member")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</member>");
		result = item;
		_g_object_unref0 (para);
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = item;
	_g_object_unref0 (para);
	return result;
}

static ValadocContentList*
valadoc_gtkdoc_parser_parse_docbook_simplelist (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentList* _tmp4_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocContentList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "simplelist")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<simplelist>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_list (_tmp3_);
	list = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		ValadocGtkdocToken* _tmp6_;
		ValadocGtkdocTokenType _tmp7_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp10_;
		ValadocContentListItem* _tmp11_;
		ValadocContentList* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		ValadocContentListItem* _tmp15_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->type;
		if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->content;
			_tmp5_ = g_strcmp0 (_tmp9_, "member") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_member (self);
		item = _tmp10_;
		_tmp11_ = item;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp12_ = list;
		_tmp13_ = valadoc_content_list_get_items (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = item;
		vala_collection_add ((ValaCollection*) _tmp14_, _tmp15_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "simplelist")) {
		ValadocGtkdocToken* _tmp16_;
		_tmp16_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp16_, "</simplelist>");
		result = list;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_parser_next (self);
	_tmp18_ = _tmp17_;
	_valadoc_gtkdoc_token_unref0 (_tmp18_);
	result = list;
	return result;
}

static ValadocContentParagraph*
valadoc_gtkdoc_parser_parse_docbook_term (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValadocContentParagraph* p = NULL;
	ValadocContentContentFactory* _tmp3_;
	ValadocContentParagraph* _tmp4_;
	ValadocContentRun* run = NULL;
	ValadocContentRun* _tmp5_;
	ValadocContentRun* _tmp6_;
	ValadocContentParagraph* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	ValadocContentRun* _tmp10_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocContentParagraph* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "term")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<term>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = self->priv->factory;
	_tmp4_ = valadoc_content_content_factory_create_paragraph (_tmp3_);
	p = _tmp4_;
	_tmp5_ = valadoc_gtkdoc_parser_parse_inline_content (self);
	run = _tmp5_;
	_tmp6_ = run;
	valadoc_content_run_set_style (_tmp6_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	_tmp7_ = p;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = run;
	vala_collection_add ((ValaCollection*) _tmp9_, (ValadocContentInline*) _tmp10_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "term")) {
		ValadocGtkdocToken* _tmp11_;
		_tmp11_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp11_, "</term>");
		result = p;
		_g_object_unref0 (run);
		return result;
	}
	_tmp12_ = valadoc_gtkdoc_parser_next (self);
	_tmp13_ = _tmp12_;
	_valadoc_gtkdoc_token_unref0 (_tmp13_);
	result = p;
	_g_object_unref0 (run);
	return result;
}

static ValadocContentListItem*
valadoc_gtkdoc_parser_parse_docbook_varlistentry (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocTokenType _tmp5_;
	ValadocContentParagraph* term = NULL;
	ValadocContentParagraph* _tmp8_;
	ValadocContentParagraph* _tmp9_;
	ValadocContentListItem* desc = NULL;
	ValadocContentListItem* _tmp10_;
	ValadocContentListItem* _tmp11_;
	ValadocContentListItem* listitem = NULL;
	ValadocContentContentFactory* _tmp12_;
	ValadocContentListItem* _tmp13_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp14_;
	ValadocContentList* _tmp15_;
	ValadocContentListItem* _tmp16_;
	ValaList* _tmp17_;
	ValaList* _tmp18_;
	ValadocContentParagraph* _tmp19_;
	ValadocContentListItem* _tmp20_;
	ValaList* _tmp21_;
	ValaList* _tmp22_;
	ValadocContentList* _tmp23_;
	ValadocContentList* _tmp24_;
	ValaList* _tmp25_;
	ValaList* _tmp26_;
	ValadocContentListItem* _tmp27_;
	ValadocGtkdocToken* _tmp29_;
	ValadocGtkdocToken* _tmp30_;
	ValadocContentListItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "varlistentry")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<varlistentry>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp4_ = self->priv->current;
	_tmp5_ = _tmp4_->type;
	if (_tmp5_ != VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		_tmp3_ = TRUE;
	} else {
		ValadocGtkdocToken* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->content;
		_tmp3_ = g_strcmp0 (_tmp7_, "term") != 0;
	}
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	_tmp8_ = valadoc_gtkdoc_parser_parse_docbook_term (self);
	term = _tmp8_;
	_tmp9_ = term;
	if (_tmp9_ == NULL) {
		result = NULL;
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_listitem (self);
	desc = _tmp10_;
	_tmp11_ = desc;
	if (_tmp11_ == NULL) {
		result = NULL;
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp12_ = self->priv->factory;
	_tmp13_ = valadoc_content_content_factory_create_list_item (_tmp12_);
	listitem = _tmp13_;
	_tmp14_ = self->priv->factory;
	_tmp15_ = valadoc_content_content_factory_create_list (_tmp14_);
	list = _tmp15_;
	_tmp16_ = listitem;
	_tmp17_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = term;
	vala_collection_add ((ValaCollection*) _tmp18_, (ValadocContentBlock*) _tmp19_);
	_tmp20_ = listitem;
	_tmp21_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = list;
	vala_collection_add ((ValaCollection*) _tmp22_, (ValadocContentBlock*) _tmp23_);
	_tmp24_ = list;
	_tmp25_ = valadoc_content_list_get_items (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = desc;
	vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "varlistentry")) {
		ValadocGtkdocToken* _tmp28_;
		_tmp28_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp28_, "</varlistentry>");
		result = listitem;
		_g_object_unref0 (list);
		_g_object_unref0 (desc);
		_g_object_unref0 (term);
		return result;
	}
	_tmp29_ = valadoc_gtkdoc_parser_next (self);
	_tmp30_ = _tmp29_;
	_valadoc_gtkdoc_token_unref0 (_tmp30_);
	result = listitem;
	_g_object_unref0 (list);
	_g_object_unref0 (desc);
	_g_object_unref0 (term);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_docbook_variablelist (ValadocGtkdocParser* self)
{
	ValadocGtkdocToken* _tmp1_;
	ValadocGtkdocToken* _tmp2_;
	ValaCollection* content = NULL;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocTokenType _tmp7_;
	ValadocContentList* list = NULL;
	ValadocContentContentFactory* _tmp13_;
	ValadocContentList* _tmp14_;
	ValaCollection* _tmp15_;
	ValadocContentList* _tmp16_;
	ValadocGtkdocToken* _tmp29_;
	ValadocGtkdocToken* _tmp30_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "variablelist")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<variablelist>");
		result = NULL;
		return result;
	}
	_tmp1_ = valadoc_gtkdoc_parser_next (self);
	_tmp2_ = _tmp1_;
	_valadoc_gtkdoc_token_unref0 (_tmp2_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	content = (ValaCollection*) _tmp4_;
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->type;
	if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
		ValadocGtkdocToken* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_->content;
		_tmp5_ = g_strcmp0 (_tmp9_, "title") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCollection* _tmp10_;
		ValadocContentParagraph* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		_tmp10_ = content;
		_tmp11_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
		_tmp12_ = _tmp11_;
		valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp10_, (ValadocContentBlock*) _tmp12_);
		_g_object_unref0 (_tmp12_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
	}
	_tmp13_ = self->priv->factory;
	_tmp14_ = valadoc_content_content_factory_create_list (_tmp13_);
	list = _tmp14_;
	_tmp15_ = content;
	_tmp16_ = list;
	vala_collection_add (_tmp15_, (ValadocContentBlock*) _tmp16_);
	while (TRUE) {
		gboolean _tmp17_ = FALSE;
		ValadocGtkdocToken* _tmp18_;
		ValadocGtkdocTokenType _tmp19_;
		ValadocContentListItem* item = NULL;
		ValadocContentListItem* _tmp22_;
		ValadocContentListItem* _tmp23_;
		ValadocContentList* _tmp24_;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		ValadocContentListItem* _tmp27_;
		_tmp18_ = self->priv->current;
		_tmp19_ = _tmp18_->type;
		if (_tmp19_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = self->priv->current;
			_tmp21_ = _tmp20_->content;
			_tmp17_ = g_strcmp0 (_tmp21_, "varlistentry") == 0;
		} else {
			_tmp17_ = FALSE;
		}
		if (!_tmp17_) {
			break;
		}
		_tmp22_ = valadoc_gtkdoc_parser_parse_docbook_varlistentry (self);
		item = _tmp22_;
		_tmp23_ = item;
		if (_tmp23_ == NULL) {
			_g_object_unref0 (item);
			break;
		}
		_tmp24_ = list;
		_tmp25_ = valadoc_content_list_get_items (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = item;
		vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, TRUE);
		_g_object_unref0 (item);
	}
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "variablelist")) {
		ValadocGtkdocToken* _tmp28_;
		_tmp28_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp28_, "</variablelist>");
		result = content;
		_g_object_unref0 (list);
		return result;
	}
	_tmp29_ = valadoc_gtkdoc_parser_next (self);
	_tmp30_ = _tmp29_;
	_valadoc_gtkdoc_token_unref0 (_tmp30_);
	result = content;
	_g_object_unref0 (list);
	return result;
}

static ValaCollection*
valadoc_gtkdoc_parser_parse_block_content (ValadocGtkdocParser* self)
{
	ValaCollection* content = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaCollection* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_CONTENT_TYPE_BLOCK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	content = (ValaCollection*) _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocTokenType _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocTokenType _tmp6_;
		_tmp2_ = self->priv->current;
		_tmp3_ = _tmp2_->type;
		if (!(_tmp3_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp4_ = g_strcmp0 (_tmp8_, "itemizedlist") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaCollection* _tmp9_;
			ValaCollection* _tmp10_;
			ValaCollection* _tmp11_;
			_tmp9_ = content;
			_tmp10_ = valadoc_gtkdoc_parser_parse_docbook_itemizedlist (self, "itemizedlist", VALADOC_CONTENT_LIST_BULLET_UNORDERED);
			_tmp11_ = _tmp10_;
			valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp9_, _tmp11_);
			_vala_iterable_unref0 (_tmp11_);
		} else {
			gboolean _tmp12_ = FALSE;
			ValadocGtkdocToken* _tmp13_;
			ValadocGtkdocTokenType _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				_tmp12_ = g_strcmp0 (_tmp16_, "orderedlist") == 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaCollection* _tmp17_;
				ValaCollection* _tmp18_;
				ValaCollection* _tmp19_;
				_tmp17_ = content;
				_tmp18_ = valadoc_gtkdoc_parser_parse_docbook_orderedlist (self);
				_tmp19_ = _tmp18_;
				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp17_, _tmp19_);
				_vala_iterable_unref0 (_tmp19_);
			} else {
				gboolean _tmp20_ = FALSE;
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_->content;
					_tmp20_ = g_strcmp0 (_tmp24_, "variablelist") == 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValaCollection* _tmp25_;
					ValaCollection* _tmp26_;
					ValaCollection* _tmp27_;
					_tmp25_ = content;
					_tmp26_ = valadoc_gtkdoc_parser_parse_docbook_variablelist (self);
					_tmp27_ = _tmp26_;
					valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp25_, _tmp27_);
					_vala_iterable_unref0 (_tmp27_);
				} else {
					gboolean _tmp28_ = FALSE;
					ValadocGtkdocToken* _tmp29_;
					ValadocGtkdocTokenType _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_->type;
					if (_tmp30_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = self->priv->current;
						_tmp32_ = _tmp31_->content;
						_tmp28_ = g_strcmp0 (_tmp32_, "simplelist") == 0;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						ValaCollection* _tmp33_;
						ValadocContentList* _tmp34_;
						ValadocContentList* _tmp35_;
						_tmp33_ = content;
						_tmp34_ = valadoc_gtkdoc_parser_parse_docbook_simplelist (self);
						_tmp35_ = _tmp34_;
						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp33_, (ValadocContentBlock*) _tmp35_);
						_g_object_unref0 (_tmp35_);
					} else {
						gboolean _tmp36_ = FALSE;
						ValadocGtkdocToken* _tmp37_;
						ValadocGtkdocTokenType _tmp38_;
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_->type;
						if (_tmp38_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = self->priv->current;
							_tmp40_ = _tmp39_->content;
							_tmp36_ = g_strcmp0 (_tmp40_, "informaltable") == 0;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							ValaCollection* _tmp41_;
							ValadocContentTable* _tmp42_;
							ValadocContentTable* _tmp43_;
							_tmp41_ = content;
							_tmp42_ = valadoc_gtkdoc_parser_parse_docbook_informaltable (self);
							_tmp43_ = _tmp42_;
							valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp41_, (ValadocContentBlock*) _tmp43_);
							_g_object_unref0 (_tmp43_);
						} else {
							gboolean _tmp44_ = FALSE;
							ValadocGtkdocToken* _tmp45_;
							ValadocGtkdocTokenType _tmp46_;
							_tmp45_ = self->priv->current;
							_tmp46_ = _tmp45_->type;
							if (_tmp46_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp47_;
								const gchar* _tmp48_;
								_tmp47_ = self->priv->current;
								_tmp48_ = _tmp47_->content;
								_tmp44_ = g_strcmp0 (_tmp48_, "programlisting") == 0;
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								ValaCollection* _tmp49_;
								ValadocContentParagraph* _tmp50_;
								ValadocContentParagraph* _tmp51_;
								_tmp49_ = content;
								_tmp50_ = valadoc_gtkdoc_parser_parse_docbook_programlisting (self);
								_tmp51_ = _tmp50_;
								valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp49_, (ValadocContentBlock*) _tmp51_);
								_g_object_unref0 (_tmp51_);
							} else {
								gboolean _tmp52_ = FALSE;
								ValadocGtkdocToken* _tmp53_;
								ValadocGtkdocTokenType _tmp54_;
								_tmp53_ = self->priv->current;
								_tmp54_ = _tmp53_->type;
								if (_tmp54_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp55_;
									const gchar* _tmp56_;
									_tmp55_ = self->priv->current;
									_tmp56_ = _tmp55_->content;
									_tmp52_ = g_strcmp0 (_tmp56_, "para") == 0;
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									ValaCollection* _tmp57_;
									ValaCollection* _tmp58_;
									ValaCollection* _tmp59_;
									_tmp57_ = content;
									_tmp58_ = valadoc_gtkdoc_parser_parse_docbook_para (self, "para");
									_tmp59_ = _tmp58_;
									valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp57_, _tmp59_);
									_vala_iterable_unref0 (_tmp59_);
								} else {
									gboolean _tmp60_ = FALSE;
									ValadocGtkdocToken* _tmp61_;
									ValadocGtkdocTokenType _tmp62_;
									_tmp61_ = self->priv->current;
									_tmp62_ = _tmp61_->type;
									if (_tmp62_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp63_;
										const gchar* _tmp64_;
										_tmp63_ = self->priv->current;
										_tmp64_ = _tmp63_->content;
										_tmp60_ = g_strcmp0 (_tmp64_, "simpara") == 0;
									} else {
										_tmp60_ = FALSE;
									}
									if (_tmp60_) {
										ValaCollection* _tmp65_;
										ValaCollection* _tmp66_;
										ValaCollection* _tmp67_;
										_tmp65_ = content;
										_tmp66_ = valadoc_gtkdoc_parser_parse_docbook_simpara (self);
										_tmp67_ = _tmp66_;
										valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp65_, _tmp67_);
										_vala_iterable_unref0 (_tmp67_);
									} else {
										gboolean _tmp68_ = FALSE;
										ValadocGtkdocToken* _tmp69_;
										ValadocGtkdocTokenType _tmp70_;
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_->type;
										if (_tmp70_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp71_;
											const gchar* _tmp72_;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_->content;
											_tmp68_ = g_strcmp0 (_tmp72_, "informalexample") == 0;
										} else {
											_tmp68_ = FALSE;
										}
										if (_tmp68_) {
											ValaCollection* _tmp73_;
											ValaCollection* _tmp74_;
											ValaCollection* _tmp75_;
											_tmp73_ = content;
											_tmp74_ = valadoc_gtkdoc_parser_parse_docbook_informalexample (self);
											_tmp75_ = _tmp74_;
											valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp73_, _tmp75_);
											_vala_iterable_unref0 (_tmp75_);
										} else {
											gboolean _tmp76_ = FALSE;
											ValadocGtkdocToken* _tmp77_;
											ValadocGtkdocTokenType _tmp78_;
											_tmp77_ = self->priv->current;
											_tmp78_ = _tmp77_->type;
											if (_tmp78_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp79_;
												const gchar* _tmp80_;
												_tmp79_ = self->priv->current;
												_tmp80_ = _tmp79_->content;
												_tmp76_ = g_strcmp0 (_tmp80_, "example") == 0;
											} else {
												_tmp76_ = FALSE;
											}
											if (_tmp76_) {
												ValaCollection* _tmp81_;
												ValaCollection* _tmp82_;
												ValaCollection* _tmp83_;
												_tmp81_ = content;
												_tmp82_ = valadoc_gtkdoc_parser_parse_docbook_example (self, "example");
												_tmp83_ = _tmp82_;
												valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp81_, _tmp83_);
												_vala_iterable_unref0 (_tmp83_);
											} else {
												gboolean _tmp84_ = FALSE;
												ValadocGtkdocToken* _tmp85_;
												ValadocGtkdocTokenType _tmp86_;
												_tmp85_ = self->priv->current;
												_tmp86_ = _tmp85_->type;
												if (_tmp86_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp87_;
													const gchar* _tmp88_;
													_tmp87_ = self->priv->current;
													_tmp88_ = _tmp87_->content;
													_tmp84_ = g_strcmp0 (_tmp88_, "warning") == 0;
												} else {
													_tmp84_ = FALSE;
												}
												if (_tmp84_) {
													ValaCollection* _tmp89_;
													ValadocContentWarning* _tmp90_;
													ValadocContentWarning* _tmp91_;
													_tmp89_ = content;
													_tmp90_ = valadoc_gtkdoc_parser_parse_docbook_warning (self);
													_tmp91_ = _tmp90_;
													valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp89_, (ValadocContentBlock*) _tmp91_);
													_g_object_unref0 (_tmp91_);
												} else {
													gboolean _tmp92_ = FALSE;
													ValadocGtkdocToken* _tmp93_;
													ValadocGtkdocTokenType _tmp94_;
													_tmp93_ = self->priv->current;
													_tmp94_ = _tmp93_->type;
													if (_tmp94_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp95_;
														const gchar* _tmp96_;
														_tmp95_ = self->priv->current;
														_tmp96_ = _tmp95_->content;
														_tmp92_ = g_strcmp0 (_tmp96_, "note") == 0;
													} else {
														_tmp92_ = FALSE;
													}
													if (_tmp92_) {
														ValaCollection* _tmp97_;
														ValadocContentNote* _tmp98_;
														ValadocContentNote* _tmp99_;
														_tmp97_ = content;
														_tmp98_ = valadoc_gtkdoc_parser_parse_docbook_note (self);
														_tmp99_ = _tmp98_;
														valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp97_, (ValadocContentBlock*) _tmp99_);
														_g_object_unref0 (_tmp99_);
													} else {
														gboolean _tmp100_ = FALSE;
														ValadocGtkdocToken* _tmp101_;
														ValadocGtkdocTokenType _tmp102_;
														_tmp101_ = self->priv->current;
														_tmp102_ = _tmp101_->type;
														if (_tmp102_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp103_;
															const gchar* _tmp104_;
															_tmp103_ = self->priv->current;
															_tmp104_ = _tmp103_->content;
															_tmp100_ = g_strcmp0 (_tmp104_, "important") == 0;
														} else {
															_tmp100_ = FALSE;
														}
														if (_tmp100_) {
															ValaCollection* _tmp105_;
															ValadocContentNote* _tmp106_;
															ValadocContentNote* _tmp107_;
															_tmp105_ = content;
															_tmp106_ = valadoc_gtkdoc_parser_parse_docbook_important (self);
															_tmp107_ = _tmp106_;
															valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp105_, (ValadocContentBlock*) _tmp107_);
															_g_object_unref0 (_tmp107_);
														} else {
															gboolean _tmp108_ = FALSE;
															ValadocGtkdocToken* _tmp109_;
															ValadocGtkdocTokenType _tmp110_;
															_tmp109_ = self->priv->current;
															_tmp110_ = _tmp109_->type;
															if (_tmp110_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp111_;
																const gchar* _tmp112_;
																_tmp111_ = self->priv->current;
																_tmp112_ = _tmp111_->content;
																_tmp108_ = g_strcmp0 (_tmp112_, "refsect3") == 0;
															} else {
																_tmp108_ = FALSE;
															}
															if (_tmp108_) {
																ValaCollection* _tmp113_;
																ValaList* _tmp114_;
																ValaList* _tmp115_;
																_tmp113_ = content;
																_tmp114_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 3);
																_tmp115_ = _tmp114_;
																valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp113_, (ValaCollection*) _tmp115_);
																_vala_iterable_unref0 (_tmp115_);
															} else {
																gboolean _tmp116_ = FALSE;
																ValadocGtkdocToken* _tmp117_;
																ValadocGtkdocTokenType _tmp118_;
																_tmp117_ = self->priv->current;
																_tmp118_ = _tmp117_->type;
																if (_tmp118_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp119_;
																	const gchar* _tmp120_;
																	_tmp119_ = self->priv->current;
																	_tmp120_ = _tmp119_->content;
																	_tmp116_ = g_strcmp0 (_tmp120_, "refsect2") == 0;
																} else {
																	_tmp116_ = FALSE;
																}
																if (_tmp116_) {
																	ValaCollection* _tmp121_;
																	ValaList* _tmp122_;
																	ValaList* _tmp123_;
																	_tmp121_ = content;
																	_tmp122_ = valadoc_gtkdoc_parser_parse_docbook_refsect2 (self, 2);
																	_tmp123_ = _tmp122_;
																	valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp121_, (ValaCollection*) _tmp123_);
																	_vala_iterable_unref0 (_tmp123_);
																} else {
																	gboolean _tmp124_ = FALSE;
																	ValadocGtkdocToken* _tmp125_;
																	ValadocGtkdocTokenType _tmp126_;
																	_tmp125_ = self->priv->current;
																	_tmp126_ = _tmp125_->type;
																	if (_tmp126_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp127_;
																		const gchar* _tmp128_;
																		_tmp127_ = self->priv->current;
																		_tmp128_ = _tmp127_->content;
																		_tmp124_ = g_strcmp0 (_tmp128_, "figure") == 0;
																	} else {
																		_tmp124_ = FALSE;
																	}
																	if (_tmp124_) {
																		ValaCollection* _tmp129_;
																		ValaList* _tmp130_;
																		ValaList* _tmp131_;
																		_tmp129_ = content;
																		_tmp130_ = valadoc_gtkdoc_parser_parse_docbook_figure (self);
																		_tmp131_ = _tmp130_;
																		valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp129_, (ValaCollection*) _tmp131_);
																		_vala_iterable_unref0 (_tmp131_);
																	} else {
																		gboolean _tmp132_ = FALSE;
																		ValadocGtkdocToken* _tmp133_;
																		ValadocGtkdocTokenType _tmp134_;
																		_tmp133_ = self->priv->current;
																		_tmp134_ = _tmp133_->type;
																		if (_tmp134_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp135_;
																			const gchar* _tmp136_;
																			_tmp135_ = self->priv->current;
																			_tmp136_ = _tmp135_->content;
																			_tmp132_ = g_strcmp0 (_tmp136_, "title") == 0;
																		} else {
																			_tmp132_ = FALSE;
																		}
																		if (_tmp132_) {
																			ValaCollection* _tmp137_;
																			ValadocContentParagraph* _tmp138_;
																			ValadocContentParagraph* _tmp139_;
																			_tmp137_ = content;
																			_tmp138_ = valadoc_gtkdoc_parser_parse_docbook_title (self);
																			_tmp139_ = _tmp138_;
																			valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp137_, (ValadocContentBlock*) _tmp139_);
																			_g_object_unref0 (_tmp139_);
																		} else {
																			gboolean _tmp140_ = FALSE;
																			ValadocGtkdocToken* _tmp141_;
																			ValadocGtkdocTokenType _tmp142_;
																			_tmp141_ = self->priv->current;
																			_tmp142_ = _tmp141_->type;
																			if (_tmp142_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp143_;
																				const gchar* _tmp144_;
																				_tmp143_ = self->priv->current;
																				_tmp144_ = _tmp143_->content;
																				_tmp140_ = g_strcmp0 (_tmp144_, "section") == 0;
																			} else {
																				_tmp140_ = FALSE;
																			}
																			if (_tmp140_) {
																				ValaCollection* _tmp145_;
																				ValaCollection* _tmp146_;
																				ValaCollection* _tmp147_;
																				_tmp145_ = content;
																				_tmp146_ = valadoc_gtkdoc_parser_parse_docbook_section (self);
																				_tmp147_ = _tmp146_;
																				valadoc_gtkdoc_parser_append_block_content_not_null_all (self, _tmp145_, _tmp147_);
																				_vala_iterable_unref0 (_tmp147_);
																			} else {
																				ValadocGtkdocToken* _tmp148_;
																				ValadocGtkdocTokenType _tmp149_;
																				_tmp148_ = self->priv->current;
																				_tmp149_ = _tmp148_->type;
																				if (_tmp149_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH) {
																					ValaCollection* _tmp150_;
																					ValadocContentParagraph* _tmp151_;
																					ValadocContentParagraph* _tmp152_;
																					_tmp150_ = content;
																					_tmp151_ = valadoc_gtkdoc_parser_parse_gtkdoc_paragraph (self);
																					_tmp152_ = _tmp151_;
																					valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp150_, (ValadocContentBlock*) _tmp152_);
																					_g_object_unref0 (_tmp152_);
																				} else {
																					ValadocGtkdocToken* _tmp153_;
																					ValadocGtkdocTokenType _tmp154_;
																					_tmp153_ = self->priv->current;
																					_tmp154_ = _tmp153_->type;
																					if (_tmp154_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN) {
																						ValaCollection* _tmp155_;
																						ValadocContentParagraph* _tmp156_;
																						ValadocContentParagraph* _tmp157_;
																						_tmp155_ = content;
																						_tmp156_ = valadoc_gtkdoc_parser_parse_gtkdoc_source (self);
																						_tmp157_ = _tmp156_;
																						valadoc_gtkdoc_parser_append_block_content_not_null (self, _tmp155_, (ValadocContentBlock*) _tmp157_);
																						_g_object_unref0 (_tmp157_);
																					} else {
																						break;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = content;
	return result;
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_xml_tag (ValadocGtkdocParser* self)
{
	gchar* _class = NULL;
	ValadocGtkdocToken* _tmp1_;
	ValaHashMap* _tmp2_;
	gpointer _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocTokenType _tmp7_;
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp9_;
	ValadocContentRun* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	ValadocGtkdocToken* _tmp48_;
	ValadocGtkdocToken* _tmp49_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!valadoc_gtkdoc_parser_check_xml_open_tag (self, "tag")) {
		ValadocGtkdocToken* _tmp0_;
		_tmp0_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp0_, "<tag>");
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = _tmp1_->attributes;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp2_, "class");
	_class = (gchar*) _tmp3_;
	_tmp4_ = valadoc_gtkdoc_parser_next (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->type;
	if (_tmp7_ != VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
		ValadocGtkdocToken* _tmp8_;
		_tmp8_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp8_, "<WORD>");
		result = NULL;
		_g_free0 (_class);
		return result;
	}
	_tmp9_ = self->priv->factory;
	_tmp10_ = valadoc_content_content_factory_create_run (_tmp9_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
	run = _tmp10_;
	_tmp12_ = _class;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = _class;
		_tmp11_ = g_strcmp0 (_tmp13_, "starttag") == 0;
	}
	if (_tmp11_) {
		ValadocContentRun* _tmp14_;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		ValadocContentContentFactory* _tmp17_;
		ValadocGtkdocToken* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		ValadocContentText* _tmp24_;
		ValadocContentText* _tmp25_;
		ValadocGtkdocToken* _tmp26_;
		ValadocGtkdocToken* _tmp27_;
		_tmp14_ = run;
		_tmp15_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->factory;
		_tmp18_ = self->priv->current;
		_tmp19_ = _tmp18_->content;
		_tmp20_ = g_strconcat ("<", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ">", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = valadoc_content_content_factory_create_text (_tmp17_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_collection_add ((ValaCollection*) _tmp16_, (ValadocContentInline*) _tmp25_);
		_g_object_unref0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp26_ = valadoc_gtkdoc_parser_next (self);
		_tmp27_ = _tmp26_;
		_valadoc_gtkdoc_token_unref0 (_tmp27_);
	} else {
		const gchar* _tmp28_;
		_tmp28_ = _class;
		if (g_strcmp0 (_tmp28_, "endtag") == 0) {
			ValadocContentRun* _tmp29_;
			ValaList* _tmp30_;
			ValaList* _tmp31_;
			ValadocContentContentFactory* _tmp32_;
			ValadocGtkdocToken* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			ValadocContentText* _tmp39_;
			ValadocContentText* _tmp40_;
			ValadocGtkdocToken* _tmp41_;
			ValadocGtkdocToken* _tmp42_;
			_tmp29_ = run;
			_tmp30_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->factory;
			_tmp33_ = self->priv->current;
			_tmp34_ = _tmp33_->content;
			_tmp35_ = g_strconcat ("</", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp36_, ">", NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = valadoc_content_content_factory_create_text (_tmp32_, _tmp38_);
			_tmp40_ = _tmp39_;
			vala_collection_add ((ValaCollection*) _tmp31_, (ValadocContentInline*) _tmp40_);
			_g_object_unref0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_tmp41_ = valadoc_gtkdoc_parser_next (self);
			_tmp42_ = _tmp41_;
			_valadoc_gtkdoc_token_unref0 (_tmp42_);
		} else {
			ValadocGtkdocToken* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp43_ = self->priv->current;
			_tmp44_ = _class;
			_tmp45_ = g_strdup_printf ("<tag class=\"%s\">", _tmp44_);
			_tmp46_ = _tmp45_;
			valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp43_, _tmp46_);
			_g_free0 (_tmp46_);
			result = run;
			_g_free0 (_class);
			return result;
		}
	}
	valadoc_gtkdoc_parser_parse_docbook_spaces (self, FALSE);
	if (!valadoc_gtkdoc_parser_check_xml_close_tag (self, "tag")) {
		ValadocGtkdocToken* _tmp47_;
		_tmp47_ = self->priv->current;
		valadoc_gtkdoc_parser_report_unexpected_token (self, _tmp47_, "</tag>");
		result = run;
		_g_free0 (_class);
		return result;
	}
	_tmp48_ = valadoc_gtkdoc_parser_next (self);
	_tmp49_ = _tmp48_;
	_valadoc_gtkdoc_token_unref0 (_tmp49_);
	result = run;
	_g_free0 (_class);
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
valadoc_gtkdoc_parser_append_inline_content_string (ValadocGtkdocParser* self,
                                                    ValadocContentRun* run,
                                                    const gchar* current)
{
	ValadocContentText* last_as_text = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocContentText* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (current != NULL);
	last_as_text = NULL;
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gpointer _tmp6_;
		ValadocContentInline* _tmp7_;
		ValadocContentText* _tmp8_;
		_tmp4_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_list_last (_tmp5_);
		_tmp7_ = (ValadocContentInline*) _tmp6_;
		_tmp8_ = VALADOC_CONTENT_IS_TEXT (_tmp7_) ? ((ValadocContentText*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (last_as_text);
		last_as_text = _tmp8_;
	}
	_tmp9_ = last_as_text;
	if (_tmp9_ == NULL) {
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		ValadocContentContentFactory* _tmp12_;
		ValadocContentText* _tmp13_;
		ValadocContentText* _tmp14_;
		_tmp10_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->factory;
		_tmp13_ = valadoc_content_content_factory_create_text (_tmp12_, current);
		_tmp14_ = _tmp13_;
		vala_collection_add ((ValaCollection*) _tmp11_, (ValadocContentInline*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		gboolean _tmp15_ = FALSE;
		if (g_str_has_prefix (current, " ")) {
			ValadocContentText* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = last_as_text;
			_tmp17_ = valadoc_content_text_get_content (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp15_ = g_str_has_suffix (_tmp18_, " ");
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValadocContentText* _tmp19_;
			ValadocContentText* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp19_ = last_as_text;
			_tmp20_ = last_as_text;
			_tmp21_ = valadoc_content_text_get_content (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_chug (current);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			valadoc_content_text_set_content (_tmp20_, _tmp26_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
		} else {
			ValadocContentText* _tmp27_;
			ValadocContentText* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp27_ = last_as_text;
			_tmp28_ = last_as_text;
			_tmp29_ = valadoc_content_text_get_content (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, current, NULL);
			_tmp32_ = _tmp31_;
			valadoc_content_text_set_content (_tmp28_, _tmp32_);
			_g_free0 (_tmp32_);
		}
	}
	_g_object_unref0 (last_as_text);
}

static ValadocContentInline*
valadoc_gtkdoc_parser_create_type_link (ValadocGtkdocParser* self,
                                        const gchar* name,
                                        gboolean c_accept_plural)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValadocContentInline* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_strcmp0 (name, "TRUE") == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (name, "FALSE") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (name, "NULL") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = valadoc_gtkdoc_parser_is_numeric (self, name);
	}
	if (_tmp0_) {
		ValadocContentRun* monospaced = NULL;
		ValadocContentContentFactory* _tmp3_;
		ValadocContentRun* _tmp4_;
		ValadocContentRun* _tmp5_;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		ValadocContentContentFactory* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValadocContentText* _tmp11_;
		ValadocContentText* _tmp12_;
		_tmp3_ = self->priv->factory;
		_tmp4_ = valadoc_content_content_factory_create_run (_tmp3_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
		monospaced = _tmp4_;
		_tmp5_ = monospaced;
		_tmp6_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->factory;
		_tmp9_ = g_ascii_strdown (name, (gssize) -1);
		_tmp10_ = _tmp9_;
		_tmp11_ = valadoc_content_content_factory_create_text (_tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		vala_collection_add ((ValaCollection*) _tmp7_, (ValadocContentInline*) _tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
		result = (ValadocContentInline*) monospaced;
		return result;
	} else {
		ValadocTagletsLink* taglet = NULL;
		ValadocContentContentFactory* _tmp13_;
		ValadocContentTaglet* _tmp14_;
		ValadocTagletsLink* _tmp15_;
		ValadocTagletsLink* _tmp16_;
		ValadocTagletsLink* _tmp17_;
		ValadocTagletsLink* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp13_ = self->priv->factory;
		_tmp14_ = valadoc_content_content_factory_create_taglet (_tmp13_, "link");
		_tmp15_ = VALADOC_TAGLETS_IS_LINK (_tmp14_) ? ((ValadocTagletsLink*) _tmp14_) : NULL;
		if (_tmp15_ == NULL) {
			_g_object_unref0 (_tmp14_);
		}
		taglet = _tmp15_;
		_tmp16_ = taglet;
		_vala_assert (_tmp16_ != NULL, "taglet != null");
		_tmp17_ = taglet;
		valadoc_taglets_link_set_c_accept_plural (_tmp17_, c_accept_plural);
		_tmp18_ = taglet;
		_tmp19_ = g_strconcat ("c::", name, NULL);
		_tmp20_ = _tmp19_;
		valadoc_taglets_link_set_symbol_name (_tmp18_, _tmp20_);
		_g_free0 (_tmp20_);
		result = (ValadocContentInline*) taglet;
		return result;
	}
}

static inline void
valadoc_gtkdoc_parser_append_inline_content_not_null (ValadocGtkdocParser* self,
                                                      ValadocContentRun* run,
                                                      ValadocContentInline* element)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (run != NULL);
	g_return_if_fail (element != NULL);
	if (element != NULL) {
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
		_tmp1_ = _tmp0_;
		vala_collection_add ((ValaCollection*) _tmp1_, element);
	}
}

static ValadocContentRun*
valadoc_gtkdoc_parser_parse_inline_content (ValadocGtkdocParser* self)
{
	ValadocContentRun* run = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_NONE);
	run = _tmp1_;
	while (TRUE) {
		ValadocGtkdocToken* _tmp2_;
		ValadocGtkdocTokenType _tmp3_;
		gboolean _tmp4_ = FALSE;
		ValadocGtkdocToken* _tmp5_;
		ValadocGtkdocTokenType _tmp6_;
		_tmp2_ = self->priv->current;
		_tmp3_ = _tmp2_->type;
		if (!(_tmp3_ != VALADOC_GTKDOC_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
			ValadocGtkdocToken* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->current;
			_tmp8_ = _tmp7_->content;
			_tmp4_ = g_strcmp0 (_tmp8_, "firstterm") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValadocContentRun* _tmp9_;
			ValadocContentRun* _tmp10_;
			ValadocContentRun* _tmp11_;
			_tmp9_ = run;
			_tmp10_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "firstterm", VALADOC_CONTENT_RUN_STYLE_ITALIC);
			_tmp11_ = _tmp10_;
			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp9_, (ValadocContentInline*) _tmp11_);
			_g_object_unref0 (_tmp11_);
		} else {
			gboolean _tmp12_ = FALSE;
			ValadocGtkdocToken* _tmp13_;
			ValadocGtkdocTokenType _tmp14_;
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
				ValadocGtkdocToken* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_->content;
				_tmp12_ = g_strcmp0 (_tmp16_, "abbrev") == 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValadocContentRun* _tmp17_;
				ValadocContentRun* _tmp18_;
				ValadocContentRun* _tmp19_;
				_tmp17_ = run;
				_tmp18_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "abbrev", VALADOC_CONTENT_RUN_STYLE_ITALIC);
				_tmp19_ = _tmp18_;
				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp17_, (ValadocContentInline*) _tmp19_);
				_g_object_unref0 (_tmp19_);
			} else {
				gboolean _tmp20_ = FALSE;
				ValadocGtkdocToken* _tmp21_;
				ValadocGtkdocTokenType _tmp22_;
				_tmp21_ = self->priv->current;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
					ValadocGtkdocToken* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = self->priv->current;
					_tmp24_ = _tmp23_->content;
					_tmp20_ = g_strcmp0 (_tmp24_, "term") == 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValadocContentRun* _tmp25_;
					ValadocContentRun* _tmp26_;
					ValadocContentRun* _tmp27_;
					_tmp25_ = run;
					_tmp26_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "term", VALADOC_CONTENT_RUN_STYLE_ITALIC);
					_tmp27_ = _tmp26_;
					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp25_, (ValadocContentInline*) _tmp27_);
					_g_object_unref0 (_tmp27_);
				} else {
					gboolean _tmp28_ = FALSE;
					ValadocGtkdocToken* _tmp29_;
					ValadocGtkdocTokenType _tmp30_;
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_->type;
					if (_tmp30_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
						ValadocGtkdocToken* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = self->priv->current;
						_tmp32_ = _tmp31_->content;
						_tmp28_ = g_strcmp0 (_tmp32_, "literal") == 0;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						ValadocContentRun* _tmp33_;
						ValadocContentRun* _tmp34_;
						ValadocContentRun* _tmp35_;
						_tmp33_ = run;
						_tmp34_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literal", VALADOC_CONTENT_RUN_STYLE_ITALIC);
						_tmp35_ = _tmp34_;
						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp33_, (ValadocContentInline*) _tmp35_);
						_g_object_unref0 (_tmp35_);
					} else {
						gboolean _tmp36_ = FALSE;
						ValadocGtkdocToken* _tmp37_;
						ValadocGtkdocTokenType _tmp38_;
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_->type;
						if (_tmp38_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
							ValadocGtkdocToken* _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = self->priv->current;
							_tmp40_ = _tmp39_->content;
							_tmp36_ = g_strcmp0 (_tmp40_, "literallayout") == 0;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							ValadocContentRun* _tmp41_;
							ValadocContentRun* _tmp42_;
							ValadocContentRun* _tmp43_;
							_tmp41_ = run;
							_tmp42_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "literallayout", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
							_tmp43_ = _tmp42_;
							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp41_, (ValadocContentInline*) _tmp43_);
							_g_object_unref0 (_tmp43_);
						} else {
							gboolean _tmp44_ = FALSE;
							ValadocGtkdocToken* _tmp45_;
							ValadocGtkdocTokenType _tmp46_;
							_tmp45_ = self->priv->current;
							_tmp46_ = _tmp45_->type;
							if (_tmp46_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
								ValadocGtkdocToken* _tmp47_;
								const gchar* _tmp48_;
								_tmp47_ = self->priv->current;
								_tmp48_ = _tmp47_->content;
								_tmp44_ = g_strcmp0 (_tmp48_, "application") == 0;
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								ValadocContentRun* _tmp49_;
								ValadocContentRun* _tmp50_;
								ValadocContentRun* _tmp51_;
								_tmp49_ = run;
								_tmp50_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "application", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
								_tmp51_ = _tmp50_;
								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp49_, (ValadocContentInline*) _tmp51_);
								_g_object_unref0 (_tmp51_);
							} else {
								gboolean _tmp52_ = FALSE;
								ValadocGtkdocToken* _tmp53_;
								ValadocGtkdocTokenType _tmp54_;
								_tmp53_ = self->priv->current;
								_tmp54_ = _tmp53_->type;
								if (_tmp54_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
									ValadocGtkdocToken* _tmp55_;
									const gchar* _tmp56_;
									_tmp55_ = self->priv->current;
									_tmp56_ = _tmp55_->content;
									_tmp52_ = g_strcmp0 (_tmp56_, "varname") == 0;
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									ValadocContentRun* _tmp57_;
									ValadocContentRun* _tmp58_;
									ValadocContentRun* _tmp59_;
									_tmp57_ = run;
									_tmp58_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "varname", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
									_tmp59_ = _tmp58_;
									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp57_, (ValadocContentInline*) _tmp59_);
									_g_object_unref0 (_tmp59_);
								} else {
									gboolean _tmp60_ = FALSE;
									ValadocGtkdocToken* _tmp61_;
									ValadocGtkdocTokenType _tmp62_;
									_tmp61_ = self->priv->current;
									_tmp62_ = _tmp61_->type;
									if (_tmp62_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
										ValadocGtkdocToken* _tmp63_;
										const gchar* _tmp64_;
										_tmp63_ = self->priv->current;
										_tmp64_ = _tmp63_->content;
										_tmp60_ = g_strcmp0 (_tmp64_, "computeroutput") == 0;
									} else {
										_tmp60_ = FALSE;
									}
									if (_tmp60_) {
										ValadocContentRun* _tmp65_;
										ValadocContentRun* _tmp66_;
										ValadocContentRun* _tmp67_;
										_tmp65_ = run;
										_tmp66_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "computeroutput", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
										_tmp67_ = _tmp66_;
										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp65_, (ValadocContentInline*) _tmp67_);
										_g_object_unref0 (_tmp67_);
									} else {
										gboolean _tmp68_ = FALSE;
										ValadocGtkdocToken* _tmp69_;
										ValadocGtkdocTokenType _tmp70_;
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_->type;
										if (_tmp70_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
											ValadocGtkdocToken* _tmp71_;
											const gchar* _tmp72_;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_->content;
											_tmp68_ = g_strcmp0 (_tmp72_, "emphasis") == 0;
										} else {
											_tmp68_ = FALSE;
										}
										if (_tmp68_) {
											ValadocContentRun* _tmp73_;
											ValadocContentRun* _tmp74_;
											ValadocContentRun* _tmp75_;
											_tmp73_ = run;
											_tmp74_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "emphasis", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
											_tmp75_ = _tmp74_;
											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp73_, (ValadocContentInline*) _tmp75_);
											_g_object_unref0 (_tmp75_);
										} else {
											gboolean _tmp76_ = FALSE;
											ValadocGtkdocToken* _tmp77_;
											ValadocGtkdocTokenType _tmp78_;
											_tmp77_ = self->priv->current;
											_tmp78_ = _tmp77_->type;
											if (_tmp78_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
												ValadocGtkdocToken* _tmp79_;
												const gchar* _tmp80_;
												_tmp79_ = self->priv->current;
												_tmp80_ = _tmp79_->content;
												_tmp76_ = g_strcmp0 (_tmp80_, "pre") == 0;
											} else {
												_tmp76_ = FALSE;
											}
											if (_tmp76_) {
												ValadocContentRun* _tmp81_;
												ValadocContentRun* _tmp82_;
												ValadocContentRun* _tmp83_;
												_tmp81_ = run;
												_tmp82_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "pre", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
												_tmp83_ = _tmp82_;
												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp81_, (ValadocContentInline*) _tmp83_);
												_g_object_unref0 (_tmp83_);
											} else {
												gboolean _tmp84_ = FALSE;
												ValadocGtkdocToken* _tmp85_;
												ValadocGtkdocTokenType _tmp86_;
												_tmp85_ = self->priv->current;
												_tmp86_ = _tmp85_->type;
												if (_tmp86_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
													ValadocGtkdocToken* _tmp87_;
													const gchar* _tmp88_;
													_tmp87_ = self->priv->current;
													_tmp88_ = _tmp87_->content;
													_tmp84_ = g_strcmp0 (_tmp88_, "code") == 0;
												} else {
													_tmp84_ = FALSE;
												}
												if (_tmp84_) {
													ValadocContentRun* _tmp89_;
													ValadocContentRun* _tmp90_;
													ValadocContentRun* _tmp91_;
													_tmp89_ = run;
													_tmp90_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "code", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
													_tmp91_ = _tmp90_;
													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp89_, (ValadocContentInline*) _tmp91_);
													_g_object_unref0 (_tmp91_);
												} else {
													gboolean _tmp92_ = FALSE;
													ValadocGtkdocToken* _tmp93_;
													ValadocGtkdocTokenType _tmp94_;
													_tmp93_ = self->priv->current;
													_tmp94_ = _tmp93_->type;
													if (_tmp94_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
														ValadocGtkdocToken* _tmp95_;
														const gchar* _tmp96_;
														_tmp95_ = self->priv->current;
														_tmp96_ = _tmp95_->content;
														_tmp92_ = g_strcmp0 (_tmp96_, "guimenuitem") == 0;
													} else {
														_tmp92_ = FALSE;
													}
													if (_tmp92_) {
														ValadocContentRun* _tmp97_;
														ValadocContentRun* _tmp98_;
														ValadocContentRun* _tmp99_;
														_tmp97_ = run;
														_tmp98_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "guimenuitem", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
														_tmp99_ = _tmp98_;
														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp97_, (ValadocContentInline*) _tmp99_);
														_g_object_unref0 (_tmp99_);
													} else {
														gboolean _tmp100_ = FALSE;
														ValadocGtkdocToken* _tmp101_;
														ValadocGtkdocTokenType _tmp102_;
														_tmp101_ = self->priv->current;
														_tmp102_ = _tmp101_->type;
														if (_tmp102_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
															ValadocGtkdocToken* _tmp103_;
															const gchar* _tmp104_;
															_tmp103_ = self->priv->current;
															_tmp104_ = _tmp103_->content;
															_tmp100_ = g_strcmp0 (_tmp104_, "command") == 0;
														} else {
															_tmp100_ = FALSE;
														}
														if (_tmp100_) {
															ValadocContentRun* _tmp105_;
															ValadocContentRun* _tmp106_;
															ValadocContentRun* _tmp107_;
															_tmp105_ = run;
															_tmp106_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "command", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
															_tmp107_ = _tmp106_;
															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp105_, (ValadocContentInline*) _tmp107_);
															_g_object_unref0 (_tmp107_);
														} else {
															gboolean _tmp108_ = FALSE;
															ValadocGtkdocToken* _tmp109_;
															ValadocGtkdocTokenType _tmp110_;
															_tmp109_ = self->priv->current;
															_tmp110_ = _tmp109_->type;
															if (_tmp110_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																ValadocGtkdocToken* _tmp111_;
																const gchar* _tmp112_;
																_tmp111_ = self->priv->current;
																_tmp112_ = _tmp111_->content;
																_tmp108_ = g_strcmp0 (_tmp112_, "option") == 0;
															} else {
																_tmp108_ = FALSE;
															}
															if (_tmp108_) {
																ValadocContentRun* _tmp113_;
																ValadocContentRun* _tmp114_;
																ValadocContentRun* _tmp115_;
																_tmp113_ = run;
																_tmp114_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "option", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																_tmp115_ = _tmp114_;
																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp113_, (ValadocContentInline*) _tmp115_);
																_g_object_unref0 (_tmp115_);
															} else {
																gboolean _tmp116_ = FALSE;
																ValadocGtkdocToken* _tmp117_;
																ValadocGtkdocTokenType _tmp118_;
																_tmp117_ = self->priv->current;
																_tmp118_ = _tmp117_->type;
																if (_tmp118_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																	ValadocGtkdocToken* _tmp119_;
																	const gchar* _tmp120_;
																	_tmp119_ = self->priv->current;
																	_tmp120_ = _tmp119_->content;
																	_tmp116_ = g_strcmp0 (_tmp120_, "keycap") == 0;
																} else {
																	_tmp116_ = FALSE;
																}
																if (_tmp116_) {
																	ValadocContentRun* _tmp121_;
																	ValadocContentRun* _tmp122_;
																	ValadocContentRun* _tmp123_;
																	_tmp121_ = run;
																	_tmp122_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycap", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																	_tmp123_ = _tmp122_;
																	valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp121_, (ValadocContentInline*) _tmp123_);
																	_g_object_unref0 (_tmp123_);
																} else {
																	gboolean _tmp124_ = FALSE;
																	ValadocGtkdocToken* _tmp125_;
																	ValadocGtkdocTokenType _tmp126_;
																	_tmp125_ = self->priv->current;
																	_tmp126_ = _tmp125_->type;
																	if (_tmp126_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																		ValadocGtkdocToken* _tmp127_;
																		const gchar* _tmp128_;
																		_tmp127_ = self->priv->current;
																		_tmp128_ = _tmp127_->content;
																		_tmp124_ = g_strcmp0 (_tmp128_, "keycombo") == 0;
																	} else {
																		_tmp124_ = FALSE;
																	}
																	if (_tmp124_) {
																		ValadocContentRun* _tmp129_;
																		ValadocContentRun* _tmp130_;
																		ValadocContentRun* _tmp131_;
																		_tmp129_ = run;
																		_tmp130_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "keycombo", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																		_tmp131_ = _tmp130_;
																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp129_, (ValadocContentInline*) _tmp131_);
																		_g_object_unref0 (_tmp131_);
																	} else {
																		gboolean _tmp132_ = FALSE;
																		ValadocGtkdocToken* _tmp133_;
																		ValadocGtkdocTokenType _tmp134_;
																		_tmp133_ = self->priv->current;
																		_tmp134_ = _tmp133_->type;
																		if (_tmp134_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																			ValadocGtkdocToken* _tmp135_;
																			const gchar* _tmp136_;
																			_tmp135_ = self->priv->current;
																			_tmp136_ = _tmp135_->content;
																			_tmp132_ = g_strcmp0 (_tmp136_, "envar") == 0;
																		} else {
																			_tmp132_ = FALSE;
																		}
																		if (_tmp132_) {
																			ValadocContentRun* _tmp137_;
																			ValadocContentRun* _tmp138_;
																			ValadocContentRun* _tmp139_;
																			_tmp137_ = run;
																			_tmp138_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "envar", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																			_tmp139_ = _tmp138_;
																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp137_, (ValadocContentInline*) _tmp139_);
																			_g_object_unref0 (_tmp139_);
																		} else {
																			gboolean _tmp140_ = FALSE;
																			ValadocGtkdocToken* _tmp141_;
																			ValadocGtkdocTokenType _tmp142_;
																			_tmp141_ = self->priv->current;
																			_tmp142_ = _tmp141_->type;
																			if (_tmp142_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																				ValadocGtkdocToken* _tmp143_;
																				const gchar* _tmp144_;
																				_tmp143_ = self->priv->current;
																				_tmp144_ = _tmp143_->content;
																				_tmp140_ = g_strcmp0 (_tmp144_, "filename") == 0;
																			} else {
																				_tmp140_ = FALSE;
																			}
																			if (_tmp140_) {
																				ValadocContentRun* _tmp145_;
																				ValadocContentRun* _tmp146_;
																				ValadocContentRun* _tmp147_;
																				_tmp145_ = run;
																				_tmp146_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "filename", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																				_tmp147_ = _tmp146_;
																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp145_, (ValadocContentInline*) _tmp147_);
																				_g_object_unref0 (_tmp147_);
																			} else {
																				gboolean _tmp148_ = FALSE;
																				ValadocGtkdocToken* _tmp149_;
																				ValadocGtkdocTokenType _tmp150_;
																				_tmp149_ = self->priv->current;
																				_tmp150_ = _tmp149_->type;
																				if (_tmp150_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																					ValadocGtkdocToken* _tmp151_;
																					const gchar* _tmp152_;
																					_tmp151_ = self->priv->current;
																					_tmp152_ = _tmp151_->content;
																					_tmp148_ = g_strcmp0 (_tmp152_, "parameter") == 0;
																				} else {
																					_tmp148_ = FALSE;
																				}
																				if (_tmp148_) {
																					ValadocContentRun* _tmp153_;
																					ValadocContentRun* _tmp154_;
																					ValadocContentRun* _tmp155_;
																					_tmp153_ = run;
																					_tmp154_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "parameter", VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																					_tmp155_ = _tmp154_;
																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp153_, (ValadocContentInline*) _tmp155_);
																					_g_object_unref0 (_tmp155_);
																				} else {
																					gboolean _tmp156_ = FALSE;
																					ValadocGtkdocToken* _tmp157_;
																					ValadocGtkdocTokenType _tmp158_;
																					_tmp157_ = self->priv->current;
																					_tmp158_ = _tmp157_->type;
																					if (_tmp158_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																						ValadocGtkdocToken* _tmp159_;
																						const gchar* _tmp160_;
																						_tmp159_ = self->priv->current;
																						_tmp160_ = _tmp159_->content;
																						_tmp156_ = g_strcmp0 (_tmp160_, "replaceable") == 0;
																					} else {
																						_tmp156_ = FALSE;
																					}
																					if (_tmp156_) {
																						ValadocContentRun* _tmp161_;
																						ValadocContentRun* _tmp162_;
																						ValadocContentRun* _tmp163_;
																						_tmp161_ = run;
																						_tmp162_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "replaceable", VALADOC_CONTENT_RUN_STYLE_ITALIC);
																						_tmp163_ = _tmp162_;
																						valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp161_, (ValadocContentInline*) _tmp163_);
																						_g_object_unref0 (_tmp163_);
																					} else {
																						gboolean _tmp164_ = FALSE;
																						ValadocGtkdocToken* _tmp165_;
																						ValadocGtkdocTokenType _tmp166_;
																						_tmp165_ = self->priv->current;
																						_tmp166_ = _tmp165_->type;
																						if (_tmp166_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																							ValadocGtkdocToken* _tmp167_;
																							const gchar* _tmp168_;
																							_tmp167_ = self->priv->current;
																							_tmp168_ = _tmp167_->content;
																							_tmp164_ = g_strcmp0 (_tmp168_, "quote") == 0;
																						} else {
																							_tmp164_ = FALSE;
																						}
																						if (_tmp164_) {
																							ValadocContentRun* _tmp169_;
																							ValaList* _tmp170_;
																							ValaList* _tmp171_;
																							ValadocContentContentFactory* _tmp172_;
																							ValadocContentText* _tmp173_;
																							ValadocContentText* _tmp174_;
																							ValadocContentRun* _tmp175_;
																							ValadocContentRun* _tmp176_;
																							ValadocContentRun* _tmp177_;
																							ValadocContentRun* _tmp178_;
																							ValaList* _tmp179_;
																							ValaList* _tmp180_;
																							ValadocContentContentFactory* _tmp181_;
																							ValadocContentText* _tmp182_;
																							ValadocContentText* _tmp183_;
																							_tmp169_ = run;
																							_tmp170_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp169_);
																							_tmp171_ = _tmp170_;
																							_tmp172_ = self->priv->factory;
																							_tmp173_ = valadoc_content_content_factory_create_text (_tmp172_, "“");
																							_tmp174_ = _tmp173_;
																							vala_collection_add ((ValaCollection*) _tmp171_, (ValadocContentInline*) _tmp174_);
																							_g_object_unref0 (_tmp174_);
																							_tmp175_ = run;
																							_tmp176_ = valadoc_gtkdoc_parser_parse_highlighted_template (self, "quote", VALADOC_CONTENT_RUN_STYLE_NONE);
																							_tmp177_ = _tmp176_;
																							valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp175_, (ValadocContentInline*) _tmp177_);
																							_g_object_unref0 (_tmp177_);
																							_tmp178_ = run;
																							_tmp179_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp178_);
																							_tmp180_ = _tmp179_;
																							_tmp181_ = self->priv->factory;
																							_tmp182_ = valadoc_content_content_factory_create_text (_tmp181_, "”");
																							_tmp183_ = _tmp182_;
																							vala_collection_add ((ValaCollection*) _tmp180_, (ValadocContentInline*) _tmp183_);
																							_g_object_unref0 (_tmp183_);
																						} else {
																							gboolean _tmp184_ = FALSE;
																							ValadocGtkdocToken* _tmp185_;
																							ValadocGtkdocTokenType _tmp186_;
																							_tmp185_ = self->priv->current;
																							_tmp186_ = _tmp185_->type;
																							if (_tmp186_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																								ValadocGtkdocToken* _tmp187_;
																								const gchar* _tmp188_;
																								_tmp187_ = self->priv->current;
																								_tmp188_ = _tmp187_->content;
																								_tmp184_ = g_strcmp0 (_tmp188_, "footnote") == 0;
																							} else {
																								_tmp184_ = FALSE;
																							}
																							if (_tmp184_) {
																								ValadocContentRun* _tmp189_;
																								ValadocContentRun* _tmp190_;
																								ValadocContentRun* _tmp191_;
																								_tmp189_ = run;
																								_tmp190_ = valadoc_gtkdoc_parser_parse_docbook_footnote (self);
																								_tmp191_ = _tmp190_;
																								valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp189_, (ValadocContentInline*) _tmp191_);
																								_g_object_unref0 (_tmp191_);
																							} else {
																								gboolean _tmp192_ = FALSE;
																								ValadocGtkdocToken* _tmp193_;
																								ValadocGtkdocTokenType _tmp194_;
																								_tmp193_ = self->priv->current;
																								_tmp194_ = _tmp193_->type;
																								if (_tmp194_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																									ValadocGtkdocToken* _tmp195_;
																									const gchar* _tmp196_;
																									_tmp195_ = self->priv->current;
																									_tmp196_ = _tmp195_->content;
																									_tmp192_ = g_strcmp0 (_tmp196_, "type") == 0;
																								} else {
																									_tmp192_ = FALSE;
																								}
																								if (_tmp192_) {
																									ValadocContentRun* _tmp197_;
																									ValadocContentInlineTaglet* _tmp198_;
																									ValadocContentInlineTaglet* _tmp199_;
																									_tmp197_ = run;
																									_tmp198_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "type");
																									_tmp199_ = _tmp198_;
																									valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp197_, (ValadocContentInline*) _tmp199_);
																									_g_object_unref0 (_tmp199_);
																								} else {
																									gboolean _tmp200_ = FALSE;
																									ValadocGtkdocToken* _tmp201_;
																									ValadocGtkdocTokenType _tmp202_;
																									_tmp201_ = self->priv->current;
																									_tmp202_ = _tmp201_->type;
																									if (_tmp202_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																										ValadocGtkdocToken* _tmp203_;
																										const gchar* _tmp204_;
																										_tmp203_ = self->priv->current;
																										_tmp204_ = _tmp203_->content;
																										_tmp200_ = g_strcmp0 (_tmp204_, "function") == 0;
																									} else {
																										_tmp200_ = FALSE;
																									}
																									if (_tmp200_) {
																										ValadocContentRun* _tmp205_;
																										ValadocContentInlineTaglet* _tmp206_;
																										ValadocContentInlineTaglet* _tmp207_;
																										_tmp205_ = run;
																										_tmp206_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "function");
																										_tmp207_ = _tmp206_;
																										valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp205_, (ValadocContentInline*) _tmp207_);
																										_g_object_unref0 (_tmp207_);
																									} else {
																										gboolean _tmp208_ = FALSE;
																										ValadocGtkdocToken* _tmp209_;
																										ValadocGtkdocTokenType _tmp210_;
																										_tmp209_ = self->priv->current;
																										_tmp210_ = _tmp209_->type;
																										if (_tmp210_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																											ValadocGtkdocToken* _tmp211_;
																											const gchar* _tmp212_;
																											_tmp211_ = self->priv->current;
																											_tmp212_ = _tmp211_->content;
																											_tmp208_ = g_strcmp0 (_tmp212_, "classname") == 0;
																										} else {
																											_tmp208_ = FALSE;
																										}
																										if (_tmp208_) {
																											ValadocContentRun* _tmp213_;
																											ValadocContentInlineTaglet* _tmp214_;
																											ValadocContentInlineTaglet* _tmp215_;
																											_tmp213_ = run;
																											_tmp214_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "classname");
																											_tmp215_ = _tmp214_;
																											valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp213_, (ValadocContentInline*) _tmp215_);
																											_g_object_unref0 (_tmp215_);
																										} else {
																											gboolean _tmp216_ = FALSE;
																											ValadocGtkdocToken* _tmp217_;
																											ValadocGtkdocTokenType _tmp218_;
																											_tmp217_ = self->priv->current;
																											_tmp218_ = _tmp217_->type;
																											if (_tmp218_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																												ValadocGtkdocToken* _tmp219_;
																												const gchar* _tmp220_;
																												_tmp219_ = self->priv->current;
																												_tmp220_ = _tmp219_->content;
																												_tmp216_ = g_strcmp0 (_tmp220_, "structname") == 0;
																											} else {
																												_tmp216_ = FALSE;
																											}
																											if (_tmp216_) {
																												ValadocContentRun* _tmp221_;
																												ValadocContentInlineTaglet* _tmp222_;
																												ValadocContentInlineTaglet* _tmp223_;
																												_tmp221_ = run;
																												_tmp222_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structname");
																												_tmp223_ = _tmp222_;
																												valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp221_, (ValadocContentInline*) _tmp223_);
																												_g_object_unref0 (_tmp223_);
																											} else {
																												gboolean _tmp224_ = FALSE;
																												ValadocGtkdocToken* _tmp225_;
																												ValadocGtkdocTokenType _tmp226_;
																												_tmp225_ = self->priv->current;
																												_tmp226_ = _tmp225_->type;
																												if (_tmp226_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																													ValadocGtkdocToken* _tmp227_;
																													const gchar* _tmp228_;
																													_tmp227_ = self->priv->current;
																													_tmp228_ = _tmp227_->content;
																													_tmp224_ = g_strcmp0 (_tmp228_, "structfield") == 0;
																												} else {
																													_tmp224_ = FALSE;
																												}
																												if (_tmp224_) {
																													ValadocContentRun* _tmp229_;
																													ValadocContentInlineTaglet* _tmp230_;
																													ValadocContentInlineTaglet* _tmp231_;
																													_tmp229_ = run;
																													_tmp230_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "structfield");
																													_tmp231_ = _tmp230_;
																													valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp229_, (ValadocContentInline*) _tmp231_);
																													_g_object_unref0 (_tmp231_);
																												} else {
																													gboolean _tmp232_ = FALSE;
																													ValadocGtkdocToken* _tmp233_;
																													ValadocGtkdocTokenType _tmp234_;
																													_tmp233_ = self->priv->current;
																													_tmp234_ = _tmp233_->type;
																													if (_tmp234_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																														ValadocGtkdocToken* _tmp235_;
																														const gchar* _tmp236_;
																														_tmp235_ = self->priv->current;
																														_tmp236_ = _tmp235_->content;
																														_tmp232_ = g_strcmp0 (_tmp236_, "errorcode") == 0;
																													} else {
																														_tmp232_ = FALSE;
																													}
																													if (_tmp232_) {
																														ValadocContentRun* _tmp237_;
																														ValadocContentInlineTaglet* _tmp238_;
																														ValadocContentInlineTaglet* _tmp239_;
																														_tmp237_ = run;
																														_tmp238_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "errorcode");
																														_tmp239_ = _tmp238_;
																														valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp237_, (ValadocContentInline*) _tmp239_);
																														_g_object_unref0 (_tmp239_);
																													} else {
																														gboolean _tmp240_ = FALSE;
																														ValadocGtkdocToken* _tmp241_;
																														ValadocGtkdocTokenType _tmp242_;
																														_tmp241_ = self->priv->current;
																														_tmp242_ = _tmp241_->type;
																														if (_tmp242_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																															ValadocGtkdocToken* _tmp243_;
																															const gchar* _tmp244_;
																															_tmp243_ = self->priv->current;
																															_tmp244_ = _tmp243_->content;
																															_tmp240_ = g_strcmp0 (_tmp244_, "constant") == 0;
																														} else {
																															_tmp240_ = FALSE;
																														}
																														if (_tmp240_) {
																															ValadocContentRun* _tmp245_;
																															ValadocContentInlineTaglet* _tmp246_;
																															ValadocContentInlineTaglet* _tmp247_;
																															_tmp245_ = run;
																															_tmp246_ = valadoc_gtkdoc_parser_parse_symbol_link (self, "constant");
																															_tmp247_ = _tmp246_;
																															valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp245_, (ValadocContentInline*) _tmp247_);
																															_g_object_unref0 (_tmp247_);
																														} else {
																															gboolean _tmp248_ = FALSE;
																															ValadocGtkdocToken* _tmp249_;
																															ValadocGtkdocTokenType _tmp250_;
																															_tmp249_ = self->priv->current;
																															_tmp250_ = _tmp249_->type;
																															if (_tmp250_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																ValadocGtkdocToken* _tmp251_;
																																const gchar* _tmp252_;
																																_tmp251_ = self->priv->current;
																																_tmp252_ = _tmp251_->content;
																																_tmp248_ = g_strcmp0 (_tmp252_, "inlinegraphic") == 0;
																															} else {
																																_tmp248_ = FALSE;
																															}
																															if (_tmp248_) {
																																ValadocContentRun* _tmp253_;
																																ValadocContentEmbedded* _tmp254_;
																																ValadocContentEmbedded* _tmp255_;
																																_tmp253_ = run;
																																_tmp254_ = valadoc_gtkdoc_parser_parse_docbook_inlinegraphic (self, "inlinegraphic");
																																_tmp255_ = _tmp254_;
																																valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp253_, (ValadocContentInline*) _tmp255_);
																																_g_object_unref0 (_tmp255_);
																															} else {
																																gboolean _tmp256_ = FALSE;
																																ValadocGtkdocToken* _tmp257_;
																																ValadocGtkdocTokenType _tmp258_;
																																_tmp257_ = self->priv->current;
																																_tmp258_ = _tmp257_->type;
																																if (_tmp258_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																	ValadocGtkdocToken* _tmp259_;
																																	const gchar* _tmp260_;
																																	_tmp259_ = self->priv->current;
																																	_tmp260_ = _tmp259_->content;
																																	_tmp256_ = g_strcmp0 (_tmp260_, "anchor") == 0;
																																} else {
																																	_tmp256_ = FALSE;
																																}
																																if (_tmp256_) {
																																	valadoc_gtkdoc_parser_parse_anchor (self);
																																} else {
																																	gboolean _tmp261_ = FALSE;
																																	ValadocGtkdocToken* _tmp262_;
																																	ValadocGtkdocTokenType _tmp263_;
																																	_tmp262_ = self->priv->current;
																																	_tmp263_ = _tmp262_->type;
																																	if (_tmp263_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																		ValadocGtkdocToken* _tmp264_;
																																		const gchar* _tmp265_;
																																		_tmp264_ = self->priv->current;
																																		_tmp265_ = _tmp264_->content;
																																		_tmp261_ = g_strcmp0 (_tmp265_, "link") == 0;
																																	} else {
																																		_tmp261_ = FALSE;
																																	}
																																	if (_tmp261_) {
																																		ValadocContentRun* _tmp266_;
																																		ValadocContentInline* _tmp267_;
																																		ValadocContentInline* _tmp268_;
																																		_tmp266_ = run;
																																		_tmp267_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "link", TRUE);
																																		_tmp268_ = _tmp267_;
																																		valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp266_, _tmp268_);
																																		_g_object_unref0 (_tmp268_);
																																	} else {
																																		gboolean _tmp269_ = FALSE;
																																		ValadocGtkdocToken* _tmp270_;
																																		ValadocGtkdocTokenType _tmp271_;
																																		_tmp270_ = self->priv->current;
																																		_tmp271_ = _tmp270_->type;
																																		if (_tmp271_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																			ValadocGtkdocToken* _tmp272_;
																																			const gchar* _tmp273_;
																																			_tmp272_ = self->priv->current;
																																			_tmp273_ = _tmp272_->content;
																																			_tmp269_ = g_strcmp0 (_tmp273_, "ulink") == 0;
																																		} else {
																																			_tmp269_ = FALSE;
																																		}
																																		if (_tmp269_) {
																																			ValadocContentRun* _tmp274_;
																																			ValadocContentInline* _tmp275_;
																																			ValadocContentInline* _tmp276_;
																																			_tmp274_ = run;
																																			_tmp275_ = valadoc_gtkdoc_parser_parse_docbook_link_tempalte (self, "ulink", FALSE);
																																			_tmp276_ = _tmp275_;
																																			valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp274_, _tmp276_);
																																			_g_object_unref0 (_tmp276_);
																																		} else {
																																			gboolean _tmp277_ = FALSE;
																																			ValadocGtkdocToken* _tmp278_;
																																			ValadocGtkdocTokenType _tmp279_;
																																			_tmp278_ = self->priv->current;
																																			_tmp279_ = _tmp278_->type;
																																			if (_tmp279_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																				ValadocGtkdocToken* _tmp280_;
																																				const gchar* _tmp281_;
																																				_tmp280_ = self->priv->current;
																																				_tmp281_ = _tmp280_->content;
																																				_tmp277_ = g_strcmp0 (_tmp281_, "xref") == 0;
																																			} else {
																																				_tmp277_ = FALSE;
																																			}
																																			if (_tmp277_) {
																																				ValadocContentRun* _tmp282_;
																																				ValadocContentLink* _tmp283_;
																																				ValadocContentLink* _tmp284_;
																																				_tmp282_ = run;
																																				_tmp283_ = valadoc_gtkdoc_parser_parse_xref (self);
																																				_tmp284_ = _tmp283_;
																																				valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp282_, (ValadocContentInline*) _tmp284_);
																																				_g_object_unref0 (_tmp284_);
																																			} else {
																																				gboolean _tmp285_ = FALSE;
																																				ValadocGtkdocToken* _tmp286_;
																																				ValadocGtkdocTokenType _tmp287_;
																																				_tmp286_ = self->priv->current;
																																				_tmp287_ = _tmp286_->type;
																																				if (_tmp287_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN) {
																																					ValadocGtkdocToken* _tmp288_;
																																					const gchar* _tmp289_;
																																					_tmp288_ = self->priv->current;
																																					_tmp289_ = _tmp288_->content;
																																					_tmp285_ = g_strcmp0 (_tmp289_, "tag") == 0;
																																				} else {
																																					_tmp285_ = FALSE;
																																				}
																																				if (_tmp285_) {
																																					ValadocContentRun* _tmp290_;
																																					ValadocContentRun* _tmp291_;
																																					ValadocContentRun* _tmp292_;
																																					_tmp290_ = run;
																																					_tmp291_ = valadoc_gtkdoc_parser_parse_xml_tag (self);
																																					_tmp292_ = _tmp291_;
																																					valadoc_gtkdoc_parser_append_inline_content_not_null (self, _tmp290_, (ValadocContentInline*) _tmp292_);
																																					_g_object_unref0 (_tmp292_);
																																				} else {
																																					ValadocGtkdocToken* _tmp293_;
																																					ValadocGtkdocTokenType _tmp294_;
																																					_tmp293_ = self->priv->current;
																																					_tmp294_ = _tmp293_->type;
																																					if (_tmp294_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION) {
																																						ValadocContentRun* _tmp295_;
																																						ValaList* _tmp296_;
																																						ValaList* _tmp297_;
																																						ValadocGtkdocToken* _tmp298_;
																																						const gchar* _tmp299_;
																																						ValadocContentInline* _tmp300_;
																																						ValadocContentInline* _tmp301_;
																																						ValadocGtkdocToken* _tmp302_;
																																						ValadocGtkdocToken* _tmp303_;
																																						_tmp295_ = run;
																																						_tmp296_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp295_);
																																						_tmp297_ = _tmp296_;
																																						_tmp298_ = self->priv->current;
																																						_tmp299_ = _tmp298_->content;
																																						_tmp300_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp299_, FALSE);
																																						_tmp301_ = _tmp300_;
																																						vala_collection_add ((ValaCollection*) _tmp297_, _tmp301_);
																																						_g_object_unref0 (_tmp301_);
																																						_tmp302_ = valadoc_gtkdoc_parser_next (self);
																																						_tmp303_ = _tmp302_;
																																						_valadoc_gtkdoc_token_unref0 (_tmp303_);
																																					} else {
																																						ValadocGtkdocToken* _tmp304_;
																																						ValadocGtkdocTokenType _tmp305_;
																																						_tmp304_ = self->priv->current;
																																						_tmp305_ = _tmp304_->type;
																																						if (_tmp305_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
																																							ValadocGtkdocToken* _tmp306_;
																																							const gchar* _tmp307_;
																																							const gchar* _tmp308_;
																																							ValadocGtkdocToken* _tmp386_;
																																							ValadocGtkdocToken* _tmp387_;
																																							_tmp306_ = self->priv->current;
																																							_tmp307_ = _tmp306_->content;
																																							_tmp308_ = self->priv->instance_param_name;
																																							if (g_strcmp0 (_tmp307_, _tmp308_) == 0) {
																																								ValadocContentRun* keyword_run = NULL;
																																								ValadocContentContentFactory* _tmp309_;
																																								ValadocContentRun* _tmp310_;
																																								ValadocContentText* text = NULL;
																																								ValadocContentContentFactory* _tmp311_;
																																								ValadocContentText* _tmp312_;
																																								ValadocContentRun* _tmp313_;
																																								ValaList* _tmp314_;
																																								ValaList* _tmp315_;
																																								ValadocContentText* _tmp316_;
																																								ValadocContentRun* _tmp317_;
																																								ValaList* _tmp318_;
																																								ValaList* _tmp319_;
																																								ValadocContentRun* _tmp320_;
																																								_tmp309_ = self->priv->factory;
																																								_tmp310_ = valadoc_content_content_factory_create_run (_tmp309_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																								keyword_run = _tmp310_;
																																								_tmp311_ = self->priv->factory;
																																								_tmp312_ = valadoc_content_content_factory_create_text (_tmp311_, "this");
																																								text = _tmp312_;
																																								_tmp313_ = keyword_run;
																																								_tmp314_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp313_);
																																								_tmp315_ = _tmp314_;
																																								_tmp316_ = text;
																																								vala_collection_add ((ValaCollection*) _tmp315_, (ValadocContentInline*) _tmp316_);
																																								_tmp317_ = run;
																																								_tmp318_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp317_);
																																								_tmp319_ = _tmp318_;
																																								_tmp320_ = keyword_run;
																																								vala_collection_add ((ValaCollection*) _tmp319_, (ValadocContentInline*) _tmp320_);
																																								_g_object_unref0 (text);
																																								_g_object_unref0 (keyword_run);
																																							} else {
																																								gchar* param_array_name = NULL;
																																								gboolean is_return_type_len = FALSE;
																																								gchar* param_name = NULL;
																																								gchar* cname = NULL;
																																								ValadocApiTree* _tmp321_;
																																								ValadocApiNode* _tmp322_;
																																								ValadocGtkdocToken* _tmp323_;
																																								const gchar* _tmp324_;
																																								gchar* _tmp325_ = NULL;
																																								gchar* _tmp326_ = NULL;
																																								gboolean _tmp327_ = FALSE;
																																								gchar* _tmp328_;
																																								ValadocContentRun* current_run = NULL;
																																								ValadocContentContentFactory* _tmp329_;
																																								ValadocContentRun* _tmp330_;
																																								ValadocContentRun* _tmp331_;
																																								ValaList* _tmp332_;
																																								ValaList* _tmp333_;
																																								ValadocContentRun* _tmp334_;
																																								const gchar* _tmp370_;
																																								_tmp321_ = self->priv->tree;
																																								_tmp322_ = self->priv->element;
																																								_tmp323_ = self->priv->current;
																																								_tmp324_ = _tmp323_->content;
																																								_tmp328_ = valadoc_importer_helper_resolve_parameter_ctype (_tmp321_, _tmp322_, _tmp324_, &_tmp325_, &_tmp326_, &_tmp327_);
																																								_g_free0 (param_name);
																																								param_name = _tmp325_;
																																								_g_free0 (param_array_name);
																																								param_array_name = _tmp326_;
																																								is_return_type_len = _tmp327_;
																																								cname = _tmp328_;
																																								_tmp329_ = self->priv->factory;
																																								_tmp330_ = valadoc_content_content_factory_create_run (_tmp329_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
																																								current_run = _tmp330_;
																																								_tmp331_ = run;
																																								_tmp332_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp331_);
																																								_tmp333_ = _tmp332_;
																																								_tmp334_ = current_run;
																																								vala_collection_add ((ValaCollection*) _tmp333_, (ValadocContentInline*) _tmp334_);
																																								if (is_return_type_len) {
																																									ValadocContentRun* keyword_run = NULL;
																																									ValadocContentContentFactory* _tmp335_;
																																									ValadocContentRun* _tmp336_;
																																									ValadocContentRun* _tmp337_;
																																									ValaList* _tmp338_;
																																									ValaList* _tmp339_;
																																									ValadocContentContentFactory* _tmp340_;
																																									ValadocContentText* _tmp341_;
																																									ValadocContentText* _tmp342_;
																																									ValadocContentRun* _tmp343_;
																																									ValaList* _tmp344_;
																																									ValaList* _tmp345_;
																																									ValadocContentRun* _tmp346_;
																																									ValadocContentRun* _tmp347_;
																																									ValaList* _tmp348_;
																																									ValaList* _tmp349_;
																																									ValadocContentContentFactory* _tmp350_;
																																									ValadocContentText* _tmp351_;
																																									ValadocContentText* _tmp352_;
																																									_tmp335_ = self->priv->factory;
																																									_tmp336_ = valadoc_content_content_factory_create_run (_tmp335_, VALADOC_CONTENT_RUN_STYLE_LANG_KEYWORD);
																																									keyword_run = _tmp336_;
																																									_tmp337_ = keyword_run;
																																									_tmp338_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp337_);
																																									_tmp339_ = _tmp338_;
																																									_tmp340_ = self->priv->factory;
																																									_tmp341_ = valadoc_content_content_factory_create_text (_tmp340_, "return");
																																									_tmp342_ = _tmp341_;
																																									vala_collection_add ((ValaCollection*) _tmp339_, (ValadocContentInline*) _tmp342_);
																																									_g_object_unref0 (_tmp342_);
																																									_tmp343_ = current_run;
																																									_tmp344_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp343_);
																																									_tmp345_ = _tmp344_;
																																									_tmp346_ = keyword_run;
																																									vala_collection_add ((ValaCollection*) _tmp345_, (ValadocContentInline*) _tmp346_);
																																									_tmp347_ = current_run;
																																									_tmp348_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp347_);
																																									_tmp349_ = _tmp348_;
																																									_tmp350_ = self->priv->factory;
																																									_tmp351_ = valadoc_content_content_factory_create_text (_tmp350_, ".length");
																																									_tmp352_ = _tmp351_;
																																									vala_collection_add ((ValaCollection*) _tmp349_, (ValadocContentInline*) _tmp352_);
																																									_g_object_unref0 (_tmp352_);
																																									_g_object_unref0 (keyword_run);
																																								} else {
																																									const gchar* _tmp353_;
																																									_tmp353_ = param_array_name;
																																									if (_tmp353_ != NULL) {
																																										ValadocContentRun* _tmp354_;
																																										ValaList* _tmp355_;
																																										ValaList* _tmp356_;
																																										ValadocContentContentFactory* _tmp357_;
																																										const gchar* _tmp358_;
																																										gchar* _tmp359_;
																																										gchar* _tmp360_;
																																										ValadocContentText* _tmp361_;
																																										ValadocContentText* _tmp362_;
																																										_tmp354_ = current_run;
																																										_tmp355_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp354_);
																																										_tmp356_ = _tmp355_;
																																										_tmp357_ = self->priv->factory;
																																										_tmp358_ = param_array_name;
																																										_tmp359_ = g_strconcat (_tmp358_, ".length", NULL);
																																										_tmp360_ = _tmp359_;
																																										_tmp361_ = valadoc_content_content_factory_create_text (_tmp357_, _tmp360_);
																																										_tmp362_ = _tmp361_;
																																										vala_collection_add ((ValaCollection*) _tmp356_, (ValadocContentInline*) _tmp362_);
																																										_g_object_unref0 (_tmp362_);
																																										_g_free0 (_tmp360_);
																																									} else {
																																										ValadocContentRun* _tmp363_;
																																										ValaList* _tmp364_;
																																										ValaList* _tmp365_;
																																										ValadocContentContentFactory* _tmp366_;
																																										const gchar* _tmp367_;
																																										ValadocContentText* _tmp368_;
																																										ValadocContentText* _tmp369_;
																																										_tmp363_ = current_run;
																																										_tmp364_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp363_);
																																										_tmp365_ = _tmp364_;
																																										_tmp366_ = self->priv->factory;
																																										_tmp367_ = param_name;
																																										_tmp368_ = valadoc_content_content_factory_create_text (_tmp366_, _tmp367_);
																																										_tmp369_ = _tmp368_;
																																										vala_collection_add ((ValaCollection*) _tmp365_, (ValadocContentInline*) _tmp369_);
																																										_g_object_unref0 (_tmp369_);
																																									}
																																								}
																																								_tmp370_ = cname;
																																								if (_tmp370_ != NULL) {
																																									ValadocContentRun* _tmp371_;
																																									ValaList* _tmp372_;
																																									ValaList* _tmp373_;
																																									ValadocContentContentFactory* _tmp374_;
																																									ValadocContentText* _tmp375_;
																																									ValadocContentText* _tmp376_;
																																									ValadocTagletsLink* link = NULL;
																																									ValadocContentContentFactory* _tmp377_;
																																									ValadocContentTaglet* _tmp378_;
																																									ValadocTagletsLink* _tmp379_;
																																									ValadocTagletsLink* _tmp380_;
																																									const gchar* _tmp381_;
																																									ValadocContentRun* _tmp382_;
																																									ValaList* _tmp383_;
																																									ValaList* _tmp384_;
																																									ValadocTagletsLink* _tmp385_;
																																									_tmp371_ = run;
																																									_tmp372_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp371_);
																																									_tmp373_ = _tmp372_;
																																									_tmp374_ = self->priv->factory;
																																									_tmp375_ = valadoc_content_content_factory_create_text (_tmp374_, ".");
																																									_tmp376_ = _tmp375_;
																																									vala_collection_add ((ValaCollection*) _tmp373_, (ValadocContentInline*) _tmp376_);
																																									_g_object_unref0 (_tmp376_);
																																									_tmp377_ = self->priv->factory;
																																									_tmp378_ = valadoc_content_content_factory_create_taglet (_tmp377_, "link");
																																									_tmp379_ = VALADOC_TAGLETS_IS_LINK (_tmp378_) ? ((ValadocTagletsLink*) _tmp378_) : NULL;
																																									if (_tmp379_ == NULL) {
																																										_g_object_unref0 (_tmp378_);
																																									}
																																									link = _tmp379_;
																																									_tmp380_ = link;
																																									_tmp381_ = cname;
																																									valadoc_taglets_link_set_symbol_name (_tmp380_, _tmp381_);
																																									_tmp382_ = run;
																																									_tmp383_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp382_);
																																									_tmp384_ = _tmp383_;
																																									_tmp385_ = link;
																																									vala_collection_add ((ValaCollection*) _tmp384_, (ValadocContentInline*) _tmp385_);
																																									_g_object_unref0 (link);
																																								}
																																								_g_object_unref0 (current_run);
																																								_g_free0 (cname);
																																								_g_free0 (param_name);
																																								_g_free0 (param_array_name);
																																							}
																																							_tmp386_ = valadoc_gtkdoc_parser_next (self);
																																							_tmp387_ = _tmp386_;
																																							_valadoc_gtkdoc_token_unref0 (_tmp387_);
																																						} else {
																																							ValadocGtkdocToken* _tmp388_;
																																							ValadocGtkdocTokenType _tmp389_;
																																							_tmp388_ = self->priv->current;
																																							_tmp389_ = _tmp388_->type;
																																							if (_tmp389_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL) {
																																								ValadocContentRun* _tmp390_;
																																								ValaList* _tmp391_;
																																								ValaList* _tmp392_;
																																								ValadocGtkdocToken* _tmp393_;
																																								const gchar* _tmp394_;
																																								gchar* _tmp395_;
																																								gchar* _tmp396_;
																																								ValadocContentInline* _tmp397_;
																																								ValadocContentInline* _tmp398_;
																																								ValadocGtkdocToken* _tmp399_;
																																								ValadocGtkdocToken* _tmp400_;
																																								_tmp390_ = run;
																																								_tmp391_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp390_);
																																								_tmp392_ = _tmp391_;
																																								_tmp393_ = self->priv->current;
																																								_tmp394_ = _tmp393_->content;
																																								_tmp395_ = g_strconcat ("::", _tmp394_, NULL);
																																								_tmp396_ = _tmp395_;
																																								_tmp397_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp396_, TRUE);
																																								_tmp398_ = _tmp397_;
																																								vala_collection_add ((ValaCollection*) _tmp392_, _tmp398_);
																																								_g_object_unref0 (_tmp398_);
																																								_g_free0 (_tmp396_);
																																								_tmp399_ = valadoc_gtkdoc_parser_next (self);
																																								_tmp400_ = _tmp399_;
																																								_valadoc_gtkdoc_token_unref0 (_tmp400_);
																																							} else {
																																								ValadocGtkdocToken* _tmp401_;
																																								ValadocGtkdocTokenType _tmp402_;
																																								_tmp401_ = self->priv->current;
																																								_tmp402_ = _tmp401_->type;
																																								if (_tmp402_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY) {
																																									ValadocContentRun* _tmp403_;
																																									ValaList* _tmp404_;
																																									ValaList* _tmp405_;
																																									ValadocGtkdocToken* _tmp406_;
																																									const gchar* _tmp407_;
																																									gchar* _tmp408_;
																																									gchar* _tmp409_;
																																									ValadocContentInline* _tmp410_;
																																									ValadocContentInline* _tmp411_;
																																									ValadocGtkdocToken* _tmp412_;
																																									ValadocGtkdocToken* _tmp413_;
																																									_tmp403_ = run;
																																									_tmp404_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp403_);
																																									_tmp405_ = _tmp404_;
																																									_tmp406_ = self->priv->current;
																																									_tmp407_ = _tmp406_->content;
																																									_tmp408_ = g_strconcat (":", _tmp407_, NULL);
																																									_tmp409_ = _tmp408_;
																																									_tmp410_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp409_, TRUE);
																																									_tmp411_ = _tmp410_;
																																									vala_collection_add ((ValaCollection*) _tmp405_, _tmp411_);
																																									_g_object_unref0 (_tmp411_);
																																									_g_free0 (_tmp409_);
																																									_tmp412_ = valadoc_gtkdoc_parser_next (self);
																																									_tmp413_ = _tmp412_;
																																									_valadoc_gtkdoc_token_unref0 (_tmp413_);
																																								} else {
																																									ValadocGtkdocToken* _tmp414_;
																																									ValadocGtkdocTokenType _tmp415_;
																																									_tmp414_ = self->priv->current;
																																									_tmp415_ = _tmp414_->type;
																																									if (_tmp415_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST) {
																																										ValadocContentRun* _tmp416_;
																																										ValaList* _tmp417_;
																																										ValaList* _tmp418_;
																																										ValadocGtkdocToken* _tmp419_;
																																										const gchar* _tmp420_;
																																										ValadocContentInline* _tmp421_;
																																										ValadocContentInline* _tmp422_;
																																										ValadocGtkdocToken* _tmp423_;
																																										ValadocGtkdocToken* _tmp424_;
																																										_tmp416_ = run;
																																										_tmp417_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp416_);
																																										_tmp418_ = _tmp417_;
																																										_tmp419_ = self->priv->current;
																																										_tmp420_ = _tmp419_->content;
																																										_tmp421_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp420_, TRUE);
																																										_tmp422_ = _tmp421_;
																																										vala_collection_add ((ValaCollection*) _tmp418_, _tmp422_);
																																										_g_object_unref0 (_tmp422_);
																																										_tmp423_ = valadoc_gtkdoc_parser_next (self);
																																										_tmp424_ = _tmp423_;
																																										_valadoc_gtkdoc_token_unref0 (_tmp424_);
																																									} else {
																																										ValadocGtkdocToken* _tmp425_;
																																										ValadocGtkdocTokenType _tmp426_;
																																										_tmp425_ = self->priv->current;
																																										_tmp426_ = _tmp425_->type;
																																										if (_tmp426_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE) {
																																											ValadocContentRun* _tmp427_;
																																											ValaList* _tmp428_;
																																											ValaList* _tmp429_;
																																											ValadocGtkdocToken* _tmp430_;
																																											const gchar* _tmp431_;
																																											ValadocContentInline* _tmp432_;
																																											ValadocContentInline* _tmp433_;
																																											ValadocGtkdocToken* _tmp434_;
																																											ValadocGtkdocToken* _tmp435_;
																																											_tmp427_ = run;
																																											_tmp428_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp427_);
																																											_tmp429_ = _tmp428_;
																																											_tmp430_ = self->priv->current;
																																											_tmp431_ = _tmp430_->content;
																																											_tmp432_ = valadoc_gtkdoc_parser_create_type_link (self, _tmp431_, TRUE);
																																											_tmp433_ = _tmp432_;
																																											vala_collection_add ((ValaCollection*) _tmp429_, _tmp433_);
																																											_g_object_unref0 (_tmp433_);
																																											_tmp434_ = valadoc_gtkdoc_parser_next (self);
																																											_tmp435_ = _tmp434_;
																																											_valadoc_gtkdoc_token_unref0 (_tmp435_);
																																										} else {
																																											gboolean _tmp436_ = FALSE;
																																											ValadocGtkdocToken* _tmp437_;
																																											ValadocGtkdocTokenType _tmp438_;
																																											_tmp437_ = self->priv->current;
																																											_tmp438_ = _tmp437_->type;
																																											if (_tmp438_ == VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE) {
																																												_tmp436_ = TRUE;
																																											} else {
																																												ValadocGtkdocToken* _tmp439_;
																																												ValadocGtkdocTokenType _tmp440_;
																																												_tmp439_ = self->priv->current;
																																												_tmp440_ = _tmp439_->type;
																																												_tmp436_ = _tmp440_ == VALADOC_GTKDOC_TOKEN_TYPE_SPACE;
																																											}
																																											if (_tmp436_) {
																																												ValadocContentRun* _tmp441_;
																																												ValadocGtkdocToken* _tmp442_;
																																												ValadocGtkdocToken* _tmp443_;
																																												_tmp441_ = run;
																																												valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp441_, " ");
																																												_tmp442_ = valadoc_gtkdoc_parser_next (self);
																																												_tmp443_ = _tmp442_;
																																												_valadoc_gtkdoc_token_unref0 (_tmp443_);
																																											} else {
																																												ValadocGtkdocToken* _tmp444_;
																																												ValadocGtkdocTokenType _tmp445_;
																																												_tmp444_ = self->priv->current;
																																												_tmp445_ = _tmp444_->type;
																																												if (_tmp445_ == VALADOC_GTKDOC_TOKEN_TYPE_WORD) {
																																													ValadocContentRun* _tmp446_;
																																													ValadocGtkdocToken* _tmp447_;
																																													const gchar* _tmp448_;
																																													ValadocGtkdocToken* _tmp449_;
																																													ValadocGtkdocToken* _tmp450_;
																																													_tmp446_ = run;
																																													_tmp447_ = self->priv->current;
																																													_tmp448_ = _tmp447_->content;
																																													valadoc_gtkdoc_parser_append_inline_content_string (self, _tmp446_, _tmp448_);
																																													_tmp449_ = valadoc_gtkdoc_parser_next (self);
																																													_tmp450_ = _tmp449_;
																																													_valadoc_gtkdoc_token_unref0 (_tmp450_);
																																												} else {
																																													gboolean _tmp451_ = FALSE;
																																													ValadocGtkdocToken* _tmp452_;
																																													ValadocGtkdocTokenType _tmp453_;
																																													_tmp452_ = self->priv->current;
																																													_tmp453_ = _tmp452_->type;
																																													if (_tmp453_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE) {
																																														_tmp451_ = valadoc_gtkdoc_parser_ignore_current_xml_close (self);
																																													} else {
																																														_tmp451_ = FALSE;
																																													}
																																													if (_tmp451_) {
																																														ValadocGtkdocToken* _tmp454_;
																																														ValadocGtkdocToken* _tmp455_;
																																														_tmp454_ = valadoc_gtkdoc_parser_next (self);
																																														_tmp455_ = _tmp454_;
																																														_valadoc_gtkdoc_token_unref0 (_tmp455_);
																																													} else {
																																														ValadocGtkdocToken* _tmp456_;
																																														ValadocGtkdocTokenType _tmp457_;
																																														_tmp456_ = self->priv->current;
																																														_tmp457_ = _tmp456_->type;
																																														if (_tmp457_ == VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT) {
																																															ValadocGtkdocToken* _tmp458_;
																																															ValadocGtkdocToken* _tmp459_;
																																															_tmp458_ = valadoc_gtkdoc_parser_next (self);
																																															_tmp459_ = _tmp458_;
																																															_valadoc_gtkdoc_token_unref0 (_tmp459_);
																																														} else {
																																															break;
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = run;
	return result;
}

static gchar*
valadoc_gtkdoc_parser_real_resolve (ValadocResourceLocator* base,
                                    const gchar* path)
{
	ValadocGtkdocParser * self;
	gchar* _tmp0_;
	gchar* result = NULL;
	self = (ValadocGtkdocParser*) base;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_strdup (path);
	result = _tmp0_;
	return result;
}

static void
valadoc_gtkdoc_parser_class_init (ValadocGtkdocParserClass * klass,
                                  gpointer klass_data)
{
	valadoc_gtkdoc_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocGtkdocParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_parser_finalize;
}

static void
valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init (ValadocResourceLocatorIface * iface,
                                                               gpointer iface_data)
{
	valadoc_gtkdoc_parser_valadoc_resource_locator_parent_iface = g_type_interface_peek_parent (iface);
	iface->resolve = (gchar* (*) (ValadocResourceLocator*, const gchar*)) valadoc_gtkdoc_parser_real_resolve;
}

static void
valadoc_gtkdoc_parser_instance_init (ValadocGtkdocParser * self,
                                     gpointer klass)
{
	ValadocGtkdocScanner* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	self->priv = valadoc_gtkdoc_parser_get_instance_private (self);
	_tmp0_ = valadoc_gtkdoc_scanner_new ();
	self->priv->scanner = _tmp0_;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_);
	self->priv->stack = (ValaList*) _tmp2_;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp3_);
	self->priv->footnotes = (ValaList*) _tmp4_;
	self->priv->is_numeric_regex = NULL;
	self->priv->normalize_regex = NULL;
	self->priv->regex_source_lang = NULL;
	self->priv->id_registrar = NULL;
	self->priv->current_metadata = NULL;
}

static void
valadoc_gtkdoc_parser_finalize (GObject * obj)
{
	ValadocGtkdocParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_PARSER, ValadocGtkdocParser);
	_valadoc_gtkdoc_scanner_unref0 (self->priv->scanner);
	_valadoc_gtkdoc_token_unref0 (self->priv->current);
	_vala_iterable_unref0 (self->priv->stack);
	_vala_iterable_unref0 (self->priv->footnotes);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_valadoc_api_tree_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->element);
	_valadoc_api_source_comment_unref0 (self->priv->comment);
	self->priv->comment_lines = (_vala_array_free (self->priv->comment_lines, self->priv->comment_lines_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (self->priv->is_numeric_regex);
	_g_regex_unref0 (self->priv->normalize_regex);
	_g_regex_unref0 (self->priv->regex_source_lang);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	_g_object_unref0 (self->priv->current_metadata);
	G_OBJECT_CLASS (valadoc_gtkdoc_parser_parent_class)->finalize (obj);
}

static GType
valadoc_gtkdoc_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocParser), 0, (GInstanceInitFunc) valadoc_gtkdoc_parser_instance_init, NULL };
	static const GInterfaceInfo valadoc_resource_locator_info = { (GInterfaceInitFunc) valadoc_gtkdoc_parser_valadoc_resource_locator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_gtkdoc_parser_type_id;
	valadoc_gtkdoc_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGtkdocParser", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_gtkdoc_parser_type_id, VALADOC_TYPE_RESOURCE_LOCATOR, &valadoc_resource_locator_info);
	ValadocGtkdocParser_private_offset = g_type_add_instance_private (valadoc_gtkdoc_parser_type_id, sizeof (ValadocGtkdocParserPrivate));
	return valadoc_gtkdoc_parser_type_id;
}

GType
valadoc_gtkdoc_parser_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_parser_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_parser_type_id__volatile)) {
		GType valadoc_gtkdoc_parser_type_id;
		valadoc_gtkdoc_parser_type_id = valadoc_gtkdoc_parser_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_parser_type_id__volatile, valadoc_gtkdoc_parser_type_id);
	}
	return valadoc_gtkdoc_parser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

