#####################################################################
# this file contains some useful procedures for the computation of atan in
# DDE

restart:
Digits := 200:

with (numapprox):with(orthopoly):
read "double-extended.mpl";
read "common-procedures.mpl";

e := 2^(-6.3):
marge := 2^(-30);
P19 := convert(series(arctan(x),x=0,20),polynom):
P18 := (P19-x)/x;
Q18 := polyExact2Ext(P18, 9);
Q9 := -1/3 +1/5*x - 1/7*x^2 + 1/9*x^3 - 1/11*x^4 + 1/13*x^5 - 1/15*x^6 + 1/17*x^7- 1/19*x^8;
Qprime := poly_exact( -x /3 + x^2/5 - x^3/7 + x^4 /9);
#log2 (infnorm( (arctan(x)-x*(1+Q18))/x, x=0..e));

#function taken from the "old" coef_atan to compute interval parameters.
maxx := bi -> simplify( solve( (x-bi) / (1+x*bi) = e ,x) ):
minx := bi -> simplify(solve( (x-bi) /(1+x*bi)=-e ,x)):
nextbi := proc (x) evalf( max(solve( minx(bi) = x ,bi) )*(1-marge)); end:
allbi := proc (n)
local xi,nbi,x,i,j;
global b,a, nbofai, nbofbi, valuefordicho;
    x := e;
    nbi := 0;
    i := 0;
    while(i<n and nbi < 1/e and nbi >= 0) do
        nbi := nearestExt ( nextbi(x) );
        b[i] := evalf( nbi );
        a[i] := x;
        x   := evalf(maxx(nbi));
        i:=i+1;
    od;
    j:=0;
    while ( 2^j < i ) do j:=j+1 od:
    nbofai := i;
    nbofbi := i;
    b[i-1] := nearestExt(1/e+4):
    valuefordicho := 2^j;
    return i,b[0],b[i-1];
end:
allbi(100);
#-------------

#-----------------------
#quick error calc :
#-----Reduction:-------
XredEpsilon := 2^(-64) + 2^(-64) + 2^(-64) + 2^(-64):
Xred2Epsilon := 2*XredEpsilon + 2^(-64);
log[2.](Xred2Epsilon);
errlist:=errlist_quickphase_horner(degree(Qprime),0,0,Xred2Epsilon, 2^(-64));
errorr := compute_horner_rounding_error(Qprime,x,e,errlist,true);
qEpsilon := errorr[1]:
log[2.](qEpsilon);
deltaApprox := e^11/11:
polyDelta := e^3*qEpsilon + 2^(-64)*e+ 3*2^(-64)*e^3:
EpsilonFinal := polyDelta/arctan(e)+2*2^(-64)+deltaApprox/e:
log[2.](EpsilonFinal);
#------no reduction-------
Errlist:=errlist_quickphase_horner(degree(Qprime),0,0,0, 2**(-64)):
qEpsilon:= compute_horner_rounding_error(Qprime,x,e,errlist,true)[1]:
deltaApprox := e^11/5:
EpsilonFinalNoRed := infnorm( (qEpsilon.x^3+2^(-64).x+2^(-64).x^3)/arctan(x),x=2^(-27)..2^(-6) ) + deltaApprox + 2^(-64):
log[2.](EpsilonFinalNoRed);
#-----------------------

# Output :
filename := "atan_ext_itanium.h":
fd := fopen (filename,WRITE,TEXT):
fprintf(fd,"/* file generated by atan_ext.mpl*/\n\n"):
fprintf(fd,"#include \"double_ext.h\"\n"):

fprintf(fd,"#ifdef WORDS_BIGENDIAN\n"):
fprintf(fd, "static const db_number HALFPI = {{0x3FF921FB,0x54442D18}};"):
fprintf(fd,"\n#else\n"):
fprintf(fd, "static const db_number HALFPI = {{0x54442D18,0x3FF921FB}};"):
fprintf(fd,"\n"):
fprintf(fd,"#endif\n"):

fprintf(fd, "#define MIN_REDUCTION_NEEDED %1.50f\n",e):
fprintf(fd,"#define A 0\n"):
fprintf(fd,"#define B 1\n"):
fprintf(fd,"#define ATAN_BHI 2\n"):
fprintf(fd,"#define ATAN_BLO 3\n"):

fprintf(fd,"#define epsilon %1.50e\n", EpsilonFinal):
fprintf(fd,"#define epsilon_no_red %1.50e\n",EpsilonFinalNoRed):
fprintf(fd,"#define TWO_M_64 %1.50e\n",2^(-64)):
fprintf(fd,"#define TWO_10 %1.50e\n",2^10):

fprintf(fd, "static long double const arctan_table[%d][4] = \n{\n" , nbofai );


for i from 0 to nbofai - 1 do
    fprintf(fd, "{\n/*a[%d]     */ ",i):
    fprintf(fd, "%1.50eL",a[i]);
    fprintf(fd," ,\n/*b[%d] :   */ ",i):
    fprintf(fd, "%1.50eL",b[i]);
    fprintf(fd," ,\n/*atan_b[%d]*/ ",i):
    fprintf(fd, "%1.50eL",nearestExt(arctan(b[i])));
    fprintf(fd,",");
    fprintf(fd, "%1.50eL",arctan(b[i])-nearestExt(arctan(b[i])));
    fprintf(fd," ,\n}\n,");
od:
fprintf(fd,"\n};\n"):

fprintf(fd, "/*File generated by atan_exp.mpl*/\n"):
printPolyExt(fd,Q9,4,"coef_poly"):
fclose(fd):
