#include "crlibm.h"
#include "crlibm_private.h"

/*File generated by maple/log-td.mpl*/

#define L 7

#define MAXINDEX 53

#define INDEXMASK 127
#define two52 4.50359962737049600000000000000000000000000000000000e+15
#define log2h 6.93147180559890330187045037746429443359375000000000e-01
#define log2m 5.49792301870850242169664946507035702127907939029683e-14
#define log2l -1.31246984177852556920995753667322295879593697972250e-27
#define ROUNDCST1 1.00277296776935912123020172797003775857085744686284e+00
#define ROUNDCST2 1.00277296776935912123020172797003775857085744686284e+00
#define RDROUNDCST1 1.53329341668337408143884997262066747209318683475599e-19
#define RDROUNDCST2 1.53329341668337408143884997262066747209318683475599e-19


#define c3 3.33333333333333370340767487505218014121055603027344e-01
#define c4 -2.49999999990904886448817023847368545830249786376953e-01
#define c5 1.99999999978980019799124079327157232910394668579102e-01
#define c6 -1.66669050883027802800739891608827747404575347900391e-01
#define c7 1.42860109897981618631845890377007890492677688598633e-01


#define accPolyC3h 3.33333333333333314829616256247390992939472198486328e-01
#define accPolyC3l 1.85037170770859413132312241283212169118117639547054e-17
#define accPolyC4h -2.50000000000000000000000000000000000000000000000000e-01
#define accPolyC4l 4.62199018306924685334006418421322154174127637249391e-33
#define accPolyC5h 2.00000000000000011102230246251565404236316680908203e-01
#define accPolyC5l -1.11022302443127785678379338452126964515833173338601e-17
#define accPolyC6h -1.66666666666666657414808128123695496469736099243164e-01
#define accPolyC6l -9.25185854591372488017120157358742564605503054108327e-18
#define accPolyC7h 1.42857142857142849212692681248881854116916656494141e-01
#define accPolyC7l 7.92868209382438390589949095717120486682310988838960e-18
#define accPolyC8h -1.25000000000000000000000000000000000000000000000000e-01
#define accPolyC8l 3.42769668947376590645174407718339199260639267364101e-21
#define accPolyC9h 1.11111111111111521276839653182832989841699600219727e-01
#define accPolyC9l 4.33331955380787609416227741118274520376899199903317e-18
#define accPolyC10 -1.00000000000000699440505513848620466887950897216797e-01
#define accPolyC11 9.09090908567022348840680479042930528521537780761719e-02
#define accPolyC12 -8.33333332642126056732934102910803630948066711425781e-02
#define accPolyC13 7.69261287585959879775643344146374147385358810424805e-02
#define accPolyC14 -7.14319092953022982683819464000407606363296508789062e-02


typedef struct rri_tag {float ri; double logih; double logim; double logil;} rri;  
static const rri argredtable[128] = {
  { 
    1.00000000000000000000000000000000000000000000000000e+00,   /* r[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logih[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logim[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logil[0] */ 
  } , 
  { 
    9.92248058319091796875000000000000000000000000000000e-01,   /* r[1] */ 
    7.78214416734525436109004559170898573938757181167603e-03, /* logih[1] */ 
    -1.28191618904143681948935996668824218266800862156024e-20, /* logim[1] */ 
    1.17655068600225378123891861200215069271455859581641e-37, /* logil[1] */ 
  } , 
  { 
    9.84615325927734375000000000000000000000000000000000e-01,   /* r[2] */ 
    1.55042461406118062261505485821544425562024116516113e-02, /* logih[2] */ 
    -3.27761516207149627029928635703400435929630184221293e-19, /* logim[2] */ 
    2.95200020707030964072253388818190769795416371257942e-37, /* logil[2] */ 
  } , 
  { 
    9.77099180221557617187500000000000000000000000000000e-01,   /* r[3] */ 
    2.31671170235356708999585606534310500137507915496826e-02, /* logih[3] */ 
    5.57833156048330069504471566938468802334954100224869e-19, /* logim[3] */ 
    4.08416064054113313191746248503653555682943539201798e-35, /* logil[3] */ 
  } , 
  { 
    9.69696998596191406250000000000000000000000000000000e-01,   /* r[4] */ 
    3.07716288644317437217523547587916254997253417968750e-02, /* logih[4] */ 
    1.04316437964092669923942103072089812062131860035492e-18, /* logim[4] */ 
    -8.26837774892530079043982861155759865584698067912967e-36, /* logil[4] */ 
  } , 
  { 
    9.62406039237976074218750000000000000000000000000000e-01,   /* r[5] */ 
    3.83188391564273991840572364253603154793381690979004e-02, /* logih[5] */ 
    1.54512636366303706650320890230224472259662656606095e-18, /* logim[5] */ 
    8.30977110244055528389241824578843983429633068152463e-35, /* logil[5] */ 
  } , 
  { 
    9.55223917961120605468750000000000000000000000000000e-01,   /* r[6] */ 
    4.58094969157468376308450785927561810240149497985840e-02, /* logih[6] */ 
    -3.30123051072550842868548428055668582607719074881820e-18, /* logim[6] */ 
    1.64164772626574162996727598513545022472742050176492e-34, /* logil[6] */ 
  } , 
  { 
    9.48148131370544433593750000000000000000000000000000e-01,   /* r[7] */ 
    5.32445322139413548812036935942160198464989662170410e-02, /* logih[7] */ 
    2.23755385085953619415254057336256700540433618368589e-18, /* logim[7] */ 
    -9.41330315099866735037984721876103977945647219756033e-35, /* logil[7] */ 
  } , 
  { 
    9.41176414489746093750000000000000000000000000000000e-01,   /* r[8] */ 
    6.06246814210813916856679384181916248053312301635742e-02, /* logih[8] */ 
    2.64247317995478646334926909653435556549332769494295e-18, /* logim[8] */ 
    1.55075207452234839722600788456166299408429635417895e-34, /* logil[8] */ 
  } , 
  { 
    9.34306621551513671875000000000000000000000000000000e-01,   /* r[9] */ 
    6.79506060291548280583029395529592875391244888305664e-02, /* logih[9] */ 
    5.65862161871167282533541105359923619273100535513035e-18, /* logim[9] */ 
    -3.57889357320249912090032102867532919048871786355064e-34, /* logil[9] */ 
  } , 
  { 
    9.27536249160766601562500000000000000000000000000000e-01,   /* r[10] */ 
    7.52234026111362058530929175503842998296022415161133e-02, /* logih[10] */ 
    1.00828755349783911736541446332784521904773238841865e-18, /* logim[10] */ 
    7.77966415828014771486738038255868010153689429282538e-36, /* logil[10] */ 
  } , 
  { 
    9.20863270759582519531250000000000000000000000000000e-01,   /* r[11] */ 
    8.24437111205913314426751981045526918023824691772461e-02, /* logih[11] */ 
    -4.27419767632228646217014766651675738804062364961374e-18, /* logim[11] */ 
    3.58539257549786746072726449331073277906948658046759e-34, /* logil[11] */ 
  } , 
  { 
    9.14285659790039062500000000000000000000000000000000e-01,   /* r[12] */ 
    8.96122182943336897942288032936630770564079284667969e-02, /* logih[12] */ 
    -5.42674234758262048883730612286095846547194397615989e-18, /* logim[12] */ 
    -7.94903110897686868047461590865098481976776339992810e-35, /* logil[12] */ 
  } , 
  { 
    9.07801389694213867187500000000000000000000000000000e-01,   /* r[13] */ 
    9.67296581235191493819414176869031507521867752075195e-02, /* logih[13] */ 
    1.17499431052084706890372286741885325822732164697539e-18, /* logim[13] */ 
    -7.47188021694240554877009439429630012902672969107896e-35, /* logil[13] */ 
  } , 
  { 
    9.01408433914184570312500000000000000000000000000000e-01,   /* r[14] */ 
    1.03796812308095232069149460585322231054306030273438e-01, /* logih[14] */ 
    -1.46116759252442942691327623497388991415382979093093e-18, /* logim[14] */ 
    -5.84766064918572844473631496354606243606272630720064e-35, /* logil[14] */ 
  } , 
  { 
    8.95104885101318359375000000000000000000000000000000e-01,   /* r[15] */ 
    1.10814377516161077785739053069846704602241516113281e-01, /* logih[15] */ 
    -5.75514509579248124656596649605847554012818793702281e-18, /* logim[15] */ 
    3.29977719536339952907783192540462408052319847426319e-34, /* logil[15] */ 
  } , 
  { 
    8.88888835906982421875000000000000000000000000000000e-01,   /* r[16] */ 
    1.17783095261030007483427084480354096740484237670898e-01, /* logih[16] */ 
    -1.19709798867727449215060005668653850880775796697715e-18, /* logim[16] */ 
    8.04222018353684236067064017226062133396406008492921e-35, /* logil[16] */ 
  } , 
  { 
    8.82758617401123046875000000000000000000000000000000e-01,   /* r[17] */ 
    1.24703482226247538977581541530526010319590568542480e-01, /* logih[17] */ 
    2.28663295749049514726834658528273231115811065734312e-18, /* logim[17] */ 
    -3.51123005875932392272239647660221882537057244586168e-35, /* logil[17] */ 
  } , 
  { 
    8.76712322235107421875000000000000000000000000000000e-01,   /* r[18] */ 
    1.31576365239299886145118989588809199631214141845703e-01, /* logih[18] */ 
    1.11230010175930229418362785876222391520299564865730e-17, /* logim[18] */ 
    7.27451645836749926637643602480531900716806359121297e-34, /* logil[18] */ 
  } , 
  { 
    8.70748281478881835937500000000000000000000000000000e-01,   /* r[19] */ 
    1.38402343348215994822680841025430709123611450195312e-01, /* logih[19] */ 
    -7.69528416335144553864151614176326744245393995127969e-18, /* logim[19] */ 
    1.14202629230472885861778260955781649682548331183808e-34, /* logil[19] */ 
  } , 
  { 
    8.64864826202392578125000000000000000000000000000000e-01,   /* r[20] */ 
    1.45182054547982469783207193358975928276777267456055e-01, /* logih[20] */ 
    8.24244856152552570070228105635897158979868211170798e-18, /* logim[20] */ 
    -6.13072808770694892835379995250538817854995507648779e-34, /* logil[20] */ 
  } , 
  { 
    8.59060406684875488281250000000000000000000000000000e-01,   /* r[21] */ 
    1.51916037369229123266123337998578790575265884399414e-01, /* logih[21] */ 
    -1.04296908000297145574171199957656893307239877379000e-17, /* logim[21] */ 
    -5.53636436435840586444373230094200986769217138540854e-34, /* logil[21] */ 
  } , 
  { 
    8.53333353996276855468750000000000000000000000000000e-01,   /* r[22] */ 
    1.58605005962251938145257668111298698931932449340820e-01, /* logih[22] */ 
    -8.86065192248216377790637508171938194510660992474042e-19, /* logim[22] */ 
    -5.87995214834401673695486864800931832452468264932844e-35, /* logil[22] */ 
  } , 
  { 
    8.47682118415832519531250000000000000000000000000000e-01,   /* r[23] */ 
    1.65249573826629747586025587224867194890975952148438e-01, /* logih[23] */ 
    -9.66125475305916070790888958698289394696700966750453e-18, /* logim[23] */ 
    1.22853647999759344001960461047755491313341721869856e-34, /* logil[23] */ 
  } , 
  { 
    8.42105269432067871093750000000000000000000000000000e-01,   /* r[24] */ 
    1.71850249476078659194300257695431355386972427368164e-01, /* logih[24] */ 
    -6.02245395887480538795512923412250309472746231920746e-18, /* logim[24] */ 
    1.52961687917434402329553899350235008490821862631877e-34, /* logil[24] */ 
  } , 
  { 
    8.36601257324218750000000000000000000000000000000000e-01,   /* r[25] */ 
    1.78407717077464861299418430462537799030542373657227e-01, /* logih[25] */ 
    -1.24324832026190372515095573175819374097319572461178e-17, /* logim[25] */ 
    -5.99222696564577786410580709003476847421843326905428e-34, /* logil[25] */ 
  } , 
  { 
    8.31168889999389648437500000000000000000000000000000e-01,   /* r[26] */ 
    1.84922267713498816865680396404059138149023056030273e-01, /* logih[26] */ 
    9.96243711860796179875713739627414673019270693540839e-18, /* logim[26] */ 
    -1.99546782893888540832510298706525540082513642365204e-34, /* logil[26] */ 
  } , 
  { 
    8.25806498527526855468750000000000000000000000000000e-01,   /* r[27] */ 
    1.91394796188954025017991966706176754087209701538086e-01, /* logih[27] */ 
    -8.22643020277300444045205706293674132131812201700538e-18, /* logim[27] */ 
    5.69056030867564774930537188285078930441778787828211e-34, /* logil[27] */ 
  } , 
  { 
    8.20512771606445312500000000000000000000000000000000e-01,   /* r[28] */ 
    1.97825802934566419288842098467284813523292541503906e-01, /* logih[28] */ 
    1.28212649590622342007825921152819823725126964367518e-17, /* logim[28] */ 
    4.34712978477783827374998481132430084872238812357849e-34, /* logil[28] */ 
  } , 
  { 
    8.15286636352539062500000000000000000000000000000000e-01,   /* r[29] */ 
    2.04215526527529805944638496839615982025861740112305e-01, /* logih[29] */ 
    2.73382699896480606605004885268461286375739934002155e-18, /* logim[29] */ 
    1.88415596219599490517606146615135776386751947516623e-34, /* logil[29] */ 
  } , 
  { 
    8.10126543045043945312500000000000000000000000000000e-01,   /* r[30] */ 
    2.10564817536124687658016796376614365726709365844727e-01, /* logih[30] */ 
    2.68952644992466202072392146799884466396384136175691e-18, /* logim[30] */ 
    -1.58883120037037559046153789501260274259127656480088e-34, /* logil[30] */ 
  } , 
  { 
    8.05031418800354003906250000000000000000000000000000e-01,   /* r[31] */ 
    2.16873972759550226463431954471161589026451110839844e-01, /* logih[31] */ 
    -1.23625140584833845652640860288020787431726668393088e-17, /* logim[31] */ 
    -1.28369360755661214950804825668450767372141502246786e-34, /* logil[31] */ 
  } , 
  { 
    7.99999952316284179687500000000000000000000000000000e-01,   /* r[32] */ 
    2.23143610918856316605030087885097600519657135009766e-01, /* logih[32] */ 
    -9.09120001124270523314725361445863555491966823753373e-18, /* logim[32] */ 
    1.15945802868784933647836819275496182741822080543604e-34, /* logil[32] */ 
  } , 
  { 
    7.95031070709228515625000000000000000000000000000000e-01,   /* r[33] */ 
    2.29374082438394522043267897970508784055709838867188e-01, /* logih[33] */ 
    -1.08890120418598083770448590672876580941469212582837e-17, /* logim[33] */ 
    4.74877924128943438272197143958394008126523960202900e-34, /* logil[33] */ 
  } , 
  { 
    7.90123462677001953125000000000000000000000000000000e-01,   /* r[34] */ 
    2.35566063862186342303672859088692348450422286987305e-01, /* logih[34] */ 
    -2.39433728738216998660812173360881116827035967139939e-18, /* logim[34] */ 
    -9.62471867414270770251397101906428335828045927610883e-35, /* logil[34] */ 
  } , 
  { 
    7.85276055335998535156250000000000000000000000000000e-01,   /* r[35] */ 
    2.41719960170209802186036540661007165908813476562500e-01, /* logih[35] */ 
    2.39578119451184969695376143676233310543075971208880e-18, /* logim[35] */ 
    1.86231935097448741662637615288316997021879162207127e-34, /* logil[35] */ 
  } , 
  { 
    7.80487775802612304687500000000000000000000000000000e-01,   /* r[36] */ 
    2.47836201157484947721343360171886160969734191894531e-01, /* logih[36] */ 
    -1.24321923457726137680465119406863072977770725701004e-17, /* logim[36] */ 
    -2.09577513970149680056365167860895085898294691979404e-34, /* logil[36] */ 
  } , 
  { 
    7.75757551193237304687500000000000000000000000000000e-01,   /* r[37] */ 
    2.53915241645931488712051304901251569390296936035156e-01, /* logih[37] */ 
    -6.31336333527435824035156315376733999545148217960567e-18, /* logim[37] */ 
    4.63496313971202069379055986715253908538961883067566e-35, /* logil[37] */ 
  } , 
  { 
    7.71084308624267578125000000000000000000000000000000e-01,   /* r[38] */ 
    2.59957561689829752538116736104711890220642089843750e-01, /* logih[38] */ 
    -7.05748899290965383754297836711168798219001736647281e-18, /* logim[38] */ 
    4.27245447011230141916526741370315150982259792796987e-34, /* logil[38] */ 
  } , 
  { 
    7.66467094421386718750000000000000000000000000000000e-01,   /* r[39] */ 
    2.65963511244235673025571031757863238453865051269531e-01, /* logih[39] */ 
    -2.24162125724264292804912034054420308588570407662844e-17, /* logim[39] */ 
    4.90471140265143981765909599584287898945638617268867e-34, /* logil[39] */ 
  } , 
  { 
    7.61904716491699218750000000000000000000000000000000e-01,   /* r[40] */ 
    2.71933775088288309795814257086021825671195983886719e-01, /* logih[40] */ 
    7.83390223779535346513505580003968001040971161798700e-19, /* logim[40] */ 
    -3.02585215101390470982866376614279464778757620082138e-35, /* logil[40] */ 
  } , 
  { 
    7.57396459579467773437500000000000000000000000000000e-01,   /* r[41] */ 
    2.77868437964940373507971571598318405449390411376953e-01, /* logih[41] */ 
    -2.69368711734232128278453248569958166651302969280381e-17, /* logim[41] */ 
    1.27334496810554064003001771076892864921428144153570e-33, /* logil[41] */ 
  } , 
  { 
    7.52941131591796875000000000000000000000000000000000e-01,   /* r[42] */ 
    2.83768232735291170421021433867281302809715270996094e-01, /* logih[42] */ 
    -2.03265852251844689554711830689719609838328388091381e-17, /* logim[42] */ 
    3.99265876662456660849597520210659365811534845502505e-34, /* logil[42] */ 
  } , 
  { 
    7.48538017272949218750000000000000000000000000000000e-01,   /* r[43] */ 
    2.89633285132462114930262941925320774316787719726562e-01, /* logih[43] */ 
    -7.21962253363417273270454867455071277489833577725373e-18, /* logim[43] */ 
    -2.16150227221931053192432009592422674631830770048369e-34, /* logil[43] */ 
  } , 
  { 
    7.44186043739318847656250000000000000000000000000000e-01,   /* r[44] */ 
    2.95464216619126196494704572614864446222782135009766e-01, /* logih[44] */ 
    -1.47072146829197428851717511710908602721304319475328e-17, /* logim[44] */ 
    4.88114627787723832872543510409367916590649903129304e-34, /* logil[44] */ 
  } , 
  { 
    7.39884376525878906250000000000000000000000000000000e-01,   /* r[45] */ 
    3.01261352929903802877475982313626445829868316650391e-01, /* logih[45] */ 
    1.87070681938931680167624656750430985298856099421569e-17, /* logim[45] */ 
    1.51413799416501325421897094776870076323182009328971e-33, /* logil[45] */ 
  } , 
  { 
    7.35632181167602539062500000000000000000000000000000e-01,   /* r[46] */ 
    3.07025039020202172856954803137341514229774475097656e-01, /* logih[46] */ 
    -5.38102227896180596526923200171118043417676846319102e-18, /* logim[46] */ 
    2.06712483430759996475892191286335029882052180959917e-34, /* logil[46] */ 
  } , 
  { 
    7.31428623199462890625000000000000000000000000000000e-01,   /* r[47] */ 
    3.12755639223383730129768309780047275125980377197266e-01, /* logih[47] */ 
    -7.57930782773895721056011815787401170737920404028723e-18, /* logim[47] */ 
    8.39475110593319988799512618628582752750846924050440e-35, /* logil[47] */ 
  } , 
  { 
    7.27272748947143554687500000000000000000000000000000e-01,   /* r[48] */ 
    3.18453701316212645089365196326980367302894592285156e-01, /* logih[48] */ 
    2.71147705440665649189983820006370647423267349507715e-17, /* logim[48] */ 
    4.61673001741568050305139864943649666789926072891368e-34, /* logil[48] */ 
  } , 
  { 
    7.23163843154907226562500000000000000000000000000000e-01,   /* r[49] */ 
    3.24119466791566834817928111078799702227115631103516e-01, /* logih[49] */ 
    -6.22349090807112113628215383245238541760656175683922e-18, /* logim[49] */ 
    -2.94864944946984528585289533414905600786096792764282e-34, /* logil[49] */ 
  } , 
  { 
    7.19101071357727050781250000000000000000000000000000e-01,   /* r[50] */ 
    3.29753359015631464234985514849540777504444122314453e-01, /* logih[50] */ 
    -2.38987037434306035496609341036867889075145964580121e-17, /* logim[50] */ 
    -1.22161021411351376080765213758661026982900357467596e-33, /* logil[50] */ 
  } , 
  { 
    7.15083837509155273437500000000000000000000000000000e-01,   /* r[51] */ 
    3.35355487904429983014864546930766664445400238037109e-01, /* logih[51] */ 
    -2.15530481136091842439480783176785939188081961777809e-17, /* logim[51] */ 
    5.65377778536716902900522531845470344712374772157319e-34, /* logil[51] */ 
  } , 
  { 
    7.11111068725585937500000000000000000000000000000000e-01,   /* r[52] */ 
    3.40926646575239744585417156486073508858680725097656e-01, /* logih[52] */ 
    1.74672070296268393919501631375949801326271042364782e-17, /* logim[52] */ 
    1.28757784323920807504216254145051967795248381758825e-33, /* logil[52] */ 
  } , 
  { 
    1.41436457633972167968750000000000000000000000000000e+00,   /* r[53] */ 
    -3.46680367578929504723816990008344873785972595214844e-01, /* logih[53] */ 
    -2.63487075436177288054440686474043695042741778901884e-17, /* logim[53] */ 
    -1.38972774108545698123375234719775474495262622652200e-33, /* logil[53] */ 
  } , 
  { 
    1.40659332275390625000000000000000000000000000000000e+00,   /* r[54] */ 
    -3.41170697798120592381110327551141381263732910156250e-01, /* logih[54] */ 
    1.93668606486849623510457675345565515553170548397263e-17, /* logim[54] */ 
    -6.31924577586791945681481090971933602378723267089765e-34, /* logil[54] */ 
  } , 
  { 
    1.39890718460083007812500000000000000000000000000000e+00,   /* r[55] */ 
    -3.35691349380139503200126682713744230568408966064453e-01, /* logih[55] */ 
    8.91843232308579533655667936963342665384096382048557e-18, /* logim[55] */ 
    -7.43852632990846244963757376301756885994340719135686e-34, /* logil[55] */ 
  } , 
  { 
    1.39130425453186035156250000000000000000000000000000e+00,   /* r[56] */ 
    -3.30241619815349218836075806393637321889400482177734e-01, /* logih[56] */ 
    -1.69271534756955752333877800530082817995576241189249e-17, /* logim[56] */ 
    -2.05124125474152062675126703058085713735683777118919e-34, /* logil[56] */ 
  } , 
  { 
    1.38378381729125976562500000000000000000000000000000e+00,   /* r[57] */ 
    -3.24821643615624322531942880232236348092555999755859e-01, /* logih[57] */ 
    1.93287622140617006961244731990086787828970688523722e-17, /* logim[57] */ 
    -1.40211415833516824405184666805315188814704601258065e-33, /* logil[57] */ 
  } , 
  { 
    1.37634420394897460937500000000000000000000000000000e+00,   /* r[58] */ 
    -3.19430856448034428130000605960958637297153472900391e-01, /* logih[58] */ 
    5.58442737360353866559969930374464901851229137435661e-18, /* logim[58] */ 
    -2.25313306148742433454599602113064828727792769150620e-34, /* logil[58] */ 
  } , 
  { 
    1.36898398399353027343750000000000000000000000000000e+00,   /* r[59] */ 
    -3.14068847182749744106899925100151449441909790039062e-01, /* logih[59] */ 
    1.74087330539322720259314067705480812845274240645592e-17, /* logim[59] */ 
    2.87763442397890459672608687761118393908121210479900e-34, /* logil[59] */ 
  } , 
  { 
    1.36170220375061035156250000000000000000000000000000e+00,   /* r[60] */ 
    -3.08735537528966208498104606405831873416900634765625e-01, /* logih[60] */ 
    2.31380218279209479391607966489385619371870731511261e-17, /* logim[60] */ 
    5.75649697670342883220331709767832654878804183961435e-34, /* logil[60] */ 
  } , 
  { 
    1.35449743270874023437500000000000000000000000000000e+00,   /* r[61] */ 
    -3.03430487161918061023158088573836721479892730712891e-01, /* logih[61] */ 
    5.88591784280850309549180895879864991445414905765635e-18, /* logim[61] */ 
    3.80740105286783019924475997846877792541810370319751e-34, /* logil[61] */ 
  } , 
  { 
    1.34736847877502441406250000000000000000000000000000e+00,   /* r[62] */ 
    -2.98153415159913837140237546918797306716442108154297e-01, /* logih[62] */ 
    -8.81391967432414632609646763074561636922040597203571e-18, /* logim[62] */ 
    -2.02736910549706342663167850737697734462522018249963e-34, /* logil[62] */ 
  } , 
  { 
    1.34031414985656738281250000000000000000000000000000e+00,   /* r[63] */ 
    -2.92904026677480888718463347686338238418102264404297e-01, /* logih[63] */ 
    1.79356774462556308958502912313675336181211584010969e-17, /* logim[63] */ 
    1.02350086185905899058999882149766002774623879978153e-34, /* logil[63] */ 
  } , 
  { 
    1.33333325386047363281250000000000000000000000000000e+00,   /* r[64] */ 
    -2.87682012847134349620148441317724063992500305175781e-01, /* logih[64] */ 
    -2.60715355783435444041951693925565689223533295668838e-17, /* logim[64] */ 
    -9.83372234709377378449141028490939682198507140512540e-34, /* logil[64] */ 
  } , 
  { 
    1.32642483711242675781250000000000000000000000000000e+00,   /* r[65] */ 
    -2.82487230428967117656924301627441309392452239990234e-01, /* logih[65] */ 
    2.49452771019268745755792758464310261659699707675018e-17, /* logim[65] */ 
    -1.40230272425562150522506576584140991296902734870694e-33, /* logil[65] */ 
  } , 
  { 
    1.31958770751953125000000000000000000000000000000000e+00,   /* r[66] */ 
    -2.77319345020877350282972884087939746677875518798828e-01, /* logih[66] */ 
    7.44521346975934828880026635948320543669274837358637e-18, /* logim[66] */ 
    -5.41922476182319969711469733445405189836277342215443e-34, /* logil[66] */ 
  } , 
  { 
    1.31282043457031250000000000000000000000000000000000e+00,   /* r[67] */ 
    -2.72177826311169102080356196893262676894664764404297e-01, /* logih[67] */ 
    -1.94604737767255604321061638736698666324990178271015e-17, /* logim[67] */ 
    4.93318792723831633917605655356651628446409622108869e-34, /* logil[67] */ 
  } , 
  { 
    1.30612254142761230468750000000000000000000000000000e+00,   /* r[68] */ 
    -2.67062856029558426396164350080653093755245208740234e-01, /* logih[68] */ 
    1.42676910305707233200559864526771082234384991613068e-17, /* logim[68] */ 
    9.40874014190123375853921812584677628111272401841540e-34, /* logil[68] */ 
  } , 
  { 
    1.29949235916137695312500000000000000000000000000000e+00,   /* r[69] */ 
    -2.61973695252477101202970288795768283307552337646484e-01, /* logih[69] */ 
    -1.59130185496344773949627658712806321021374170989957e-17, /* logim[69] */ 
    2.05966526658843352548575822504612882857523370085076e-34, /* logil[69] */ 
  } , 
  { 
    1.29292941093444824218750000000000000000000000000000e+00,   /* r[70] */ 
    -2.56910505054635363020310023784986697137355804443359e-01, /* logih[70] */ 
    -2.32939629151451727444770801596466641031683815428509e-17, /* logim[70] */ 
    -1.43942742464573220634874496721239465737503205324375e-33, /* logil[70] */ 
  } , 
  { 
    1.28643226623535156250000000000000000000000000000000e+00,   /* r[71] */ 
    -2.51872701711453261808060233306605368852615356445312e-01, /* logih[71] */ 
    -2.58573188266130078596915247890597291360969537163785e-17, /* logim[71] */ 
    3.36064630885731507350249551263037246653963144676932e-34, /* logil[71] */ 
  } , 
  { 
    1.27999997138977050781250000000000000000000000000000e+00,   /* r[72] */ 
    -2.46860055579783743695543307694606482982635498046875e-01, /* logih[72] */ 
    -1.36174299951708605118822966558244798958741114531493e-17, /* logim[72] */ 
    -8.23883896198784591738914635896001757021238114385808e-35, /* logil[72] */ 
  } , 
  { 
    1.27363181114196777343750000000000000000000000000000e+00,   /* r[73] */ 
    -2.41872513137422084916750009142560884356498718261719e-01, /* logih[73] */ 
    -2.91827950997726014268071786281330008614392694540440e-18, /* logim[73] */ 
    8.66387628958027677722140876839269007945711340420961e-35, /* logil[73] */ 
  } , 
  { 
    1.26732683181762695312500000000000000000000000000000e+00,   /* r[74] */ 
    -2.36909825309450927655063878773944452404975891113281e-01, /* logih[74] */ 
    4.97049401191734143236484721843489954792294974449682e-18, /* logim[74] */ 
    2.12212094628219632031384179435720857347529888567725e-34, /* logil[74] */ 
  } , 
  { 
    1.26108384132385253906250000000000000000000000000000e+00,   /* r[75] */ 
    -2.31971542737545860513037609962339047342538833618164e-01, /* logih[75] */ 
    1.20064411563385414488688519726171456939870706105353e-17, /* logim[75] */ 
    -5.20241965000144345106493348505238495111737026311766e-34, /* logil[75] */ 
  } , 
  { 
    1.25490188598632812500000000000000000000000000000000e+00,   /* r[76] */ 
    -2.27057391030699523559732710964453872293233871459961e-01, /* logih[76] */ 
    -9.55134517665639461592830714479938653876650013848813e-18, /* logim[76] */ 
    -7.00052160915705629865262646818211330004502638341784e-34, /* logil[76] */ 
  } , 
  { 
    1.24878048896789550781250000000000000000000000000000e+00,   /* r[77] */ 
    -2.22167466272476882283015697794326115399599075317383e-01, /* logih[77] */ 
    1.12308837854924459441805420173945034636561801020789e-17, /* logim[77] */ 
    1.05992689326800868505291338111574353445179905470698e-34, /* logil[77] */ 
  } , 
  { 
    1.24271845817565917968750000000000000000000000000000e+00,   /* r[78] */ 
    -2.17301285003207084178811214769666548818349838256836e-01, /* logih[78] */ 
    -1.37599098464784711367545798871014398359913153389606e-17, /* logim[78] */ 
    -5.44676947016522950876420214713413739910691265570885e-34, /* logil[78] */ 
  } , 
  { 
    1.23671507835388183593750000000000000000000000000000e+00,   /* r[79] */ 
    -2.12458734101899110457978281374380458146333694458008e-01, /* logih[79] */ 
    3.12575020468223244847667531342710056704202576314513e-18, /* logim[79] */ 
    1.27082738610098894087384580413567050181540844264548e-35, /* logil[79] */ 
  } , 
  { 
    1.23076915740966796875000000000000000000000000000000e+00,   /* r[80] */ 
    -2.07639305173597937814733427330793347209692001342773e-01, /* logih[80] */ 
    -1.20531726306040366742269494142059745690218464556184e-17, /* logim[80] */ 
    3.33883514126655983920316543317695602289579500921493e-34, /* logil[80] */ 
  } , 
  { 
    1.22488045692443847656250000000000000000000000000000e+00,   /* r[81] */ 
    -2.02843253050716987306856253781006671488285064697266e-01, /* logih[81] */ 
    -1.66453566992001313940518505696243672056063400746100e-18, /* logim[81] */ 
    2.78446239404510241881587234176263335863162887428131e-35, /* logil[81] */ 
  } , 
  { 
    1.21904754638671875000000000000000000000000000000000e+00,   /* r[82] */ 
    -1.98069854157447239328959653903439175337553024291992e-01, /* logih[82] */ 
    -3.74277289637934596837745314540095849706853736054736e-18, /* logim[82] */ 
    2.20940287174632344749918330821286328950105212564345e-34, /* logil[82] */ 
  } , 
  { 
    1.21327018737792968750000000000000000000000000000000e+00,   /* r[83] */ 
    -1.93319348256398265695210625381150748580694198608398e-01, /* logih[83] */ 
    -4.63045754803609100012916107813305239709411987466506e-18, /* logim[83] */ 
    3.81311992624323390610440652445847060246376140730432e-34, /* logil[83] */ 
  } , 
  { 
    1.20754718780517578125000000000000000000000000000000e+00,   /* r[84] */ 
    -1.88591184708711112616441596401273272931575775146484e-01, /* logih[84] */ 
    7.43216311628945500204739783937941202296964434266492e-18, /* logim[84] */ 
    -4.02931080995428730719681936637527024502063366412999e-34, /* logil[84] */ 
  } , 
  { 
    1.20187783241271972656250000000000000000000000000000e+00,   /* r[85] */ 
    -1.83885194019779485419263664880418218672275543212891e-01, /* logih[85] */ 
    4.12613043545869607985270580107985887836449099592842e-18, /* logim[85] */ 
    -1.13080344207561908198013613253456946184091830340475e-34, /* logil[85] */ 
  } , 
  { 
    1.19626164436340332031250000000000000000000000000000e+00,   /* r[86] */ 
    -1.79201397792742966874612875471939332783222198486328e-01, /* logih[86] */ 
    1.25197515140082668570664893296659406065442168045883e-17, /* logim[86] */ 
    2.08673445558311131685127966451011169090072111640797e-34, /* logil[86] */ 
  } , 
  { 
    1.19069766998291015625000000000000000000000000000000e+00,   /* r[87] */ 
    -1.74539412626609380385644954003510065376758575439453e-01, /* logih[87] */ 
    8.52219781255028950312107624449830634785785378861392e-18, /* logim[87] */ 
    5.46720442033771639415150684633589460164820712880324e-34, /* logil[87] */ 
  } , 
  { 
    1.18518519401550292968750000000000000000000000000000e+00,   /* r[88] */ 
    -1.69899044245978042555478282338299322873353958129883e-01, /* logih[88] */ 
    4.86800738580472456380134000450154397097303177737598e-19, /* logim[88] */ 
    -4.48365665383134519709151659261825733866549119396251e-36, /* logil[88] */ 
  } , 
  { 
    1.17972350120544433593750000000000000000000000000000e+00,   /* r[89] */ 
    -1.65280090007780350314092743246874306350946426391602e-01, /* logih[89] */ 
    1.05991222445546499578510819426998369466676418510398e-18, /* logim[89] */ 
    2.15535973016890499002202117947684925307171077322261e-36, /* logil[89] */ 
  } , 
  { 
    1.17431187629699707031250000000000000000000000000000e+00,   /* r[90] */ 
    -1.60682338849634120947484916541725397109985351562500e-01, /* logih[90] */ 
    5.38493323815703006679696841052856196024573538758454e-18, /* logim[90] */ 
    1.60200163876329179080224417109933041789065267300895e-34, /* logil[90] */ 
  } , 
  { 
    1.16894984245300292968750000000000000000000000000000e+00,   /* r[91] */ 
    -1.56105775199027185795586092353914864361286163330078e-01, /* logih[91] */ 
    1.32405772531609804709122583998125231935523184710352e-17, /* logim[91] */ 
    4.88933388697666736600942679327919927438390701656817e-35, /* logil[91] */ 
  } , 
  { 
    1.16363644599914550781250000000000000000000000000000e+00,   /* r[92] */ 
    -1.51549968907714105448292229993967339396476745605469e-01, /* logih[92] */ 
    1.77181633478899593214922561799512844823326841018122e-18, /* logim[92] */ 
    5.44951453107128861626798538797020344311568819287008e-35, /* logil[92] */ 
  } , 
  { 
    1.15837097167968750000000000000000000000000000000000e+00,   /* r[93] */ 
    -1.47014683357163111754317696977523155510425567626953e-01, /* logih[93] */ 
    4.46701777108311388441189058844554903695616000674812e-18, /* logim[93] */ 
    -1.53168389834566630100313932781112142055948393405761e-34, /* logil[93] */ 
  } , 
  { 
    1.15315318107604980468750000000000000000000000000000e+00,   /* r[94] */ 
    -1.42500086821669674774781810810964088886976242065430e-01, /* logih[94] */ 
    -2.21668083020505832726646787146199970227457581911830e-18, /* logim[94] */ 
    -4.73140768447350921077611938776759805597533720242102e-36, /* logil[94] */ 
  } , 
  { 
    1.14798212051391601562500000000000000000000000000000e+00,   /* r[95] */ 
    -1.38005723310861472263866289722500368952751159667969e-01, /* logih[95] */ 
    -9.06035372834454229539393713977175584764482079542462e-18, /* logim[95] */ 
    -6.58482110068426815722709702700082916058774211791842e-34, /* logil[95] */ 
  } , 
  { 
    1.14285707473754882812500000000000000000000000000000e+00,   /* r[96] */ 
    -1.33531333019876075063336884340969845652580261230469e-01, /* logih[96] */ 
    3.66452824974217778950176131406293356640863401093569e-18, /* logim[96] */ 
    6.15050085774566840615703784135477182311292227710416e-35, /* logil[96] */ 
  } , 
  { 
    1.13777780532836914062500000000000000000000000000000e+00,   /* r[97] */ 
    -1.29077066489528990977930789085803553462028503417969e-01, /* logih[97] */ 
    7.97904258955058431558707127373439732289437010877585e-19, /* logim[97] */ 
    -4.72584148771245137732808879600361038781792271619664e-35, /* logil[97] */ 
  } , 
  { 
    1.13274335861206054687500000000000000000000000000000e+00,   /* r[98] */ 
    -1.24642441481986290807704165217728586867451667785645e-01, /* logih[98] */ 
    -1.12998120773332791412288663337308123303520797473827e-18, /* logim[98] */ 
    5.04751909879024305911295754405025108738663901055449e-35, /* logil[98] */ 
  } , 
  { 
    1.12775325775146484375000000000000000000000000000000e+00,   /* r[99] */ 
    -1.20227386019965673535914163494453532621264457702637e-01, /* logih[99] */ 
    -4.10132123403305460439841682733159064509468253505934e-18, /* logim[99] */ 
    1.89802934268459828223199224893946334512039168636632e-34, /* logil[99] */ 
  } , 
  { 
    1.12280702590942382812500000000000000000000000000000e+00,   /* r[100] */ 
    -1.15831822975702269928888199501670897006988525390625e-01, /* logih[100] */ 
    -4.33848450767153009712329850176816190393287866962401e-18, /* logim[100] */ 
    -3.16979691573058896647113947407157157214490081484725e-34, /* logil[100] */ 
  } , 
  { 
    1.11790394783020019531250000000000000000000000000000e+00,   /* r[101] */ 
    -1.11455456757806464773707944004854653030633926391602e-01, /* logih[101] */ 
    -5.25227837292521929481451677551514755953859335394548e-18, /* logim[101] */ 
    -1.35455162271740897316919848287529722248286557667632e-34, /* logil[101] */ 
  } , 
  { 
    1.11304354667663574218750000000000000000000000000000e+00,   /* r[102] */ 
    -1.07098197023655139492603893813793547451496124267578e-01, /* logih[102] */ 
    3.47169710366632825350486634041554320998659998614468e-18, /* logim[102] */ 
    4.16291803858237783591365989446195611338780307382474e-35, /* logil[102] */ 
  } , 
  { 
    1.10822510719299316406250000000000000000000000000000e+00,   /* r[103] */ 
    -1.02759733026446364867467764270259067416191101074219e-01, /* logih[103] */ 
    5.14131173582414775653668171432178439238499706689565e-18, /* logim[103] */ 
    -2.03511710633920722432014459953905354472733979743122e-34, /* logil[103] */ 
  } , 
  { 
    1.10344839096069335937500000000000000000000000000000e+00,   /* r[104] */ 
    -9.84401771213754411826712953370588365942239761352539e-02, /* logih[104] */ 
    4.43863133643792238822177111529042861410430977956950e-18, /* logim[104] */ 
    3.12055863098469149547827014037274497005231280699218e-34, /* logil[104] */ 
  } , 
  { 
    1.09871244430541992187500000000000000000000000000000e+00,   /* r[105] */ 
    -9.41389890512167593072945237508974969387054443359375e-02, /* logih[105] */ 
    2.37342936135295683496202513568031672884920488134173e-19, /* logim[105] */ 
    2.33721773003055253003147894270712826153088420940698e-35, /* logil[105] */ 
  } , 
  { 
    1.09401702880859375000000000000000000000000000000000e+00,   /* r[106] */ 
    -8.98562695172144959565585509153606835752725601196289e-02, /* logih[106] */ 
    6.27446602451052736319026996501069657057280086335290e-19, /* logim[106] */ 
    -3.52284010127094716016693656249620808330731317587528e-35, /* logil[106] */ 
  } , 
  { 
    1.08936166763305664062500000000000000000000000000000e+00,   /* r[107] */ 
    -8.55918986704354706196440361054555978626012802124023e-02, /* logih[107] */ 
    -5.03513826084130895904008327416965851388338774947593e-18, /* logim[107] */ 
    6.86424026896698901114373288904478288437409959196820e-35, /* logil[107] */ 
  } , 
  { 
    1.08474564552307128906250000000000000000000000000000e+00,   /* r[108] */ 
    -8.13455314205279167438789045263547450304031372070312e-02, /* logih[108] */ 
    1.86223784192593707654359268192644483006930996779864e-18, /* logim[108] */ 
    -9.08215611660981343459991418247070342987317386688394e-35, /* logil[108] */ 
  } , 
  { 
    1.08016872406005859375000000000000000000000000000000e+00,   /* r[109] */ 
    -7.71172549156562414651716608204878866672515869140625e-02, /* logih[109] */ 
    4.37349590112793692636976332290601524356283649435490e-18, /* logim[109] */ 
    -2.43638510650083687411626047741666976256819270953612e-34, /* logil[109] */ 
  } , 
  { 
    1.07563018798828125000000000000000000000000000000000e+00,   /* r[110] */ 
    -7.29067112034412351251333461732428986579179763793945e-02, /* logih[110] */ 
    6.30693084361487082247322771068486204374546343933133e-18, /* logim[110] */ 
    3.44825082371128400572272238979928316738696119124015e-34, /* logil[110] */ 
  } , 
  { 
    1.07112979888916015625000000000000000000000000000000e+00,   /* r[111] */ 
    -6.87139782297249979148290321973036043345928192138672e-02, /* logih[111] */ 
    -4.40922228882126717948257852084234011599535648658716e-18, /* logim[111] */ 
    2.00071285755297414487130516445636815235532199087333e-34, /* logil[111] */ 
  } , 
  { 
    1.06666660308837890625000000000000000000000000000000e+00,   /* r[112] */ 
    -6.45384615329246263959461771264614071696996688842773e-02, /* logih[112] */ 
    6.47055724777502681297997296903095954212491541204973e-18, /* logim[112] */ 
    -3.53995576621708408093066388957026321212073337996708e-34, /* logil[112] */ 
  } , 
  { 
    1.06224060058593750000000000000000000000000000000000e+00,   /* r[113] */ 
    -6.03804513842609302809449900450999848544597625732422e-02, /* logih[113] */ 
    2.15703432342306119511642925211564389619524247753812e-18, /* logim[113] */ 
    -3.99051054966201464148223117427430962485432571249835e-35, /* logil[113] */ 
  } , 
  { 
    1.05785131454467773437500000000000000000000000000000e+00,   /* r[114] */ 
    -5.62397891033892469159205518280941760167479515075684e-02, /* logih[114] */ 
    3.28339677990388790029372693220459728960401288179580e-18, /* logim[114] */ 
    1.51915205677141595589208947882243470550543557886170e-35, /* logil[114] */ 
  } , 
  { 
    1.05349802970886230468750000000000000000000000000000e+00,   /* r[115] */ 
    -5.21160840267197236763685452842764789238572120666504e-02, /* logih[115] */ 
    -2.76876652450490527514912306264172616345243137067863e-19, /* logim[115] */ 
    4.97747635693761803951848478678221385327287067714555e-36, /* logil[115] */ 
  } , 
  { 
    1.04918026924133300781250000000000000000000000000000e+00,   /* r[116] */ 
    -4.80091633070045681330739739678392652422189712524414e-02, /* logih[116] */ 
    -1.43903217358996287866324353045636173989420593009940e-18, /* logim[116] */ 
    9.24533961563047616614044310774847027299245259235749e-35, /* logil[116] */ 
  } , 
  { 
    1.04489803314208984375000000000000000000000000000000e+00,   /* r[117] */ 
    -4.39193047153486545997047585387917933985590934753418e-02, /* logih[117] */ 
    -1.76247347066130256555880115492006953917590179181782e-18, /* logim[117] */ 
    2.95067167680037492936848210009098107643918346324819e-35, /* logil[117] */ 
  } , 
  { 
    1.04065036773681640625000000000000000000000000000000e+00,   /* r[118] */ 
    -3.98458712942959952796329048396728467196226119995117e-02, /* logih[118] */ 
    3.12956491324511750770873688790894657687633404551217e-18, /* logim[118] */ 
    9.08530842942513514982993220469010912494881545842223e-35, /* logil[118] */ 
  } , 
  { 
    1.03643727302551269531250000000000000000000000000000e+00,   /* r[119] */ 
    -3.57891329972944774451271143789199413731694221496582e-02, /* logih[119] */ 
    -2.94786708868720304892365707065135221787713948130908e-19, /* logim[119] */ 
    1.84384763058385810856389175018656477977822636794864e-35, /* logil[119] */ 
  } , 
  { 
    1.03225803375244140625000000000000000000000000000000e+00,   /* r[120] */ 
    -3.17486685122574663342476242178236134350299835205078e-02, /* logih[120] */ 
    -3.03821748520802146852642560679641488082417537178322e-18, /* logim[120] */ 
    6.90127669441551609256721347857289051065660383455449e-35, /* logil[120] */ 
  } , 
  { 
    1.02811241149902343750000000000000000000000000000000e+00,   /* r[121] */ 
    -2.77245107619511835239656249996187398210167884826660e-02, /* logih[121] */ 
    1.56537436220084983093655029081028016172956628311065e-18, /* logim[121] */ 
    -4.26959324792631463690822650182944301609062827136870e-35, /* logil[121] */ 
  } , 
  { 
    1.02399992942810058593750000000000000000000000000000e+00,   /* r[122] */ 
    -2.37164576994431455791989549197751330211758613586426e-02, /* logih[122] */ 
    -1.57190014657555079881764699090245893269914973184857e-19, /* logim[122] */ 
    4.62721637019171363059082221740445258999073602747011e-36, /* logil[122] */ 
  } , 
  { 
    1.01992034912109375000000000000000000000000000000000e+00,   /* r[123] */ 
    -1.97245351501005340699723689112943247891962528228760e-02, /* logih[123] */ 
    1.34458916305708123412045028332259969564528051018263e-18, /* logim[123] */ 
    -6.02768376061644464555810636396264987280148524662430e-35, /* logil[123] */ 
  } , 
  { 
    1.01587295532226562500000000000000000000000000000000e+00,   /* r[124] */ 
    -1.57482973634926158579272481574662378989160060882568e-02, /* logih[124] */ 
    -1.00208727697080412925749596659626020152032796409604e-18, /* logim[124] */ 
    7.75790823155383991507800579878754988160969197338737e-35, /* logil[124] */ 
  } , 
  { 
    1.01185774803161621093750000000000000000000000000000e+00,   /* r[125] */ 
    -1.17879957989121472716753658005472971126437187194824e-02, /* logih[125] */ 
    2.12843993900806841444093729096134188145078357457959e-19, /* logim[125] */ 
    -7.36236149534638490756917054603187520349493909791838e-36, /* logil[125] */ 
  } , 
  { 
    1.00787401199340820312500000000000000000000000000000e+00,   /* r[126] */ 
    -7.84317373573558719590526067122482345439493656158447e-03, /* logih[126] */ 
    -2.76470798179560918828283984091643257584228907545928e-19, /* logim[126] */ 
    1.46121103426200283031313413564673422143931331178612e-35, /* logil[126] */ 
  } , 
  { 
    1.00392150878906250000000000000000000000000000000000e+00,   /* r[127] */ 
    -3.91383971648977691676352108629544090945273637771606e-03, /* logih[127] */ 
    -4.28019276224719221462393891683495367484578724177817e-19, /* logim[127] */ 
    -2.25272542183557712010826889962617244762256960750126e-35, /* logil[127] */ 
  } }; 
 
