/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2009 Wayne Stambaugh <stambaughw@verizon.net>
 * Copyright (C) 2014 KiCad Developers, see CHANGELOG.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef __dialog_lib_edit_draw_item__
#define __dialog_lib_edit_draw_item__

/**
 * @file
 * Subclass of DIALOG_LIB_EDIT_DRAW_ITEM_BASE, which is generated by
 * wxFormBuilder.
 */

class LIB_DRAW_ITEM;


#include <dialog_lib_edit_draw_item_base.h>


/**
 * Dialog to edit library component graphic items.
 */
class DIALOG_LIB_EDIT_DRAW_ITEM : public DIALOG_LIB_EDIT_DRAW_ITEM_BASE
{
public:
    /** Constructor */
    DIALOG_LIB_EDIT_DRAW_ITEM( wxWindow* parent, const wxString& itemName );

    wxString GetWidth( void );
    void SetWidth( const wxString& width );

    bool GetApplyToAllConversions( void );
    void SetApplyToAllConversions( bool applyToAll );
    void EnableApplyToAllConversions( bool enable = true );

    bool GetApplyToAllUnits( void );
    void SetApplyToAllUnits( bool applyToAll );
    void EnableApplyToAllUnits( bool enable = true );

    int GetFillStyle( void );
    void SetFillStyle( int fillStyle );
    void EnableFillStyle( bool enable = true );

    void SetWidthUnits( const wxString& units );
};

#endif // __dialog_lib_edit_draw_item__
