/*
 *
 *   Copyright (c) 2016 Samuel Degrande
 *
 *
 *  This file is part of Freedroid
 *
 *  Freedroid is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Freedroid is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Freedroid; see the file COPYING. If not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 */

#ifndef _savegame_h
#define _savegame_h

#include "../system.h"

#include "../defs.h"
#include "../struct.h"
#include "../global.h"
#include "../proto.h"

//=====
// Internal definitions
//=====

// Return code of a savegame filter function
enum filter_code {
	FILTER_NOT_NEEDED  = 0,
	FILTER_APPLIED     = 1,
	FILTER_NOT_APPLIED = 2,
	FILTER_ABORT       = 3  // Major error found, whole conversion must be aborted
};

struct savegame_info
{
	int version;
	int revision;
	char *code_signature;
};

struct converter; // forward declaration

struct savegame_data {
	struct savegame_info info;
	char *sav_buffer;
	int sav_buffer_size;
	struct converter *running_converter;
};

typedef int (*filter_t)(struct savegame_data *, struct auto_string *);

struct converter {
	char *id;
	int from_version;     // This converter applies if savegame version/revision matches
	int from_revision;
	int to_version;       // Savegame version/revision generated by this converter
	int to_revision;
	filter_t filters[10]; // Change array size if more than 10 filter functions are needed
};

//=====
// External API
//=====

extern int convert_old_savegame(char **, int *);

#endif
