/*
 * Copyright (C) 2007-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_USB_BUS_H_INCLUDED
#define __SIG_USB_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"
#include "sig_std_logic.h"

struct sig_usb_bus_funcs {
	void (*reset_set)(void *s, int val);
	void (*speed_set)(void *s, int val);
	void (*recv_token)(void *s, int pid, int addr, int endp);
	void (*recv_sof)(void *s, int frame_num);
	void (*recv_data)(void *s, int pid, unsigned int length, uint8_t *data,
			uint16_t crc16);
	void (*recv_handshake)(void *s, int pid);
};
struct sig_usb_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_usb_bus_funcs *f;
	} member[16];
	unsigned int member_count;
};

struct sig_usb_bus_merge {
	struct sig_usb_bus *s0;
	struct sig_usb_bus *s1;
};

extern int
sig_usb_bus_reset_set(struct sig_usb_bus *b, void *s, int val);

extern int
sig_usb_bus_speed_set(struct sig_usb_bus *b, void *s, int val);

extern int
sig_usb_bus_send_token(struct sig_usb_bus *b, void *s,
		int pid, int addr, int endp);

extern int
sig_usb_bus_send_sof(struct sig_usb_bus *b, void *s, int frame_num);

extern int
sig_usb_bus_send_data(struct sig_usb_bus *b, void *s,
		int pid, unsigned int length, uint8_t *data, uint16_t crc16);

extern int
sig_usb_bus_send_handshake(struct sig_usb_bus *b, void *s, int pid);

extern void
sig_usb_bus_connect(struct sig_usb_bus *b,
	void *s,
	const struct sig_usb_bus_funcs *f);

struct sig_usb_bus_merge *
sig_usb_bus_merge(struct sig_usb_bus *s0, struct sig_usb_bus *s1);
extern void
sig_usb_bus_split(struct sig_usb_bus_merge *m);

extern struct sig_usb_bus *
sig_usb_bus_create(const char *name);
extern void
sig_usb_bus_destroy(struct sig_usb_bus *b);

extern void
sig_usb_bus_suspend(struct sig_usb_bus *b, FILE *fp);
extern void
sig_usb_bus_resume(struct sig_usb_bus *b, FILE *fp);

#endif /* __SIG_USB_BUS_H_INCLUDED */
