/*
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * Implemenation of the monitor component simulator.
 *
 * NOTE:
 * For some info see:
 * - output log of Xserver
 * - source of program parse-edid (part of read-edid package).
 */

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <unistd.h>

int
main(void)
{
	struct edid {
	/* 00 */ uint8_t header[8];
	/* 08 */ uint8_t vendor_sign[2];
	/* 0a */ uint8_t monitor_id[2];
	/* 0c */ uint8_t serial[4];
	/* 10 */ uint8_t manufacture_week;
	/* 11 */ uint8_t manufacture_year;
	/* 12 */ uint8_t edid_version;
	/* 13 */ uint8_t edid_revision;
	/* 14 */ uint8_t input;
	/* 15 */ uint8_t width;
	/* 16 */ uint8_t height;
	/* 17 */ uint8_t gamma;
	/* 18 */ uint8_t dpms_flags;
	/* 19 */ uint8_t color[10];
	/* 23 */ uint8_t est_timing[3];
	/* 26 */ uint8_t std_timing[8][2];
	/* 36 */ uint8_t info[4][18];
	/* 7e */ uint8_t dummy;
	/* 7f */ uint8_t checksum;
	} x;
	uint16_t vendor_sign;
	uint8_t sum;
	uint8_t *ptr;
	int ret;

	assert(sizeof(x) == 128);

	/* Header */
	x.header[0] = 0x00;
	x.header[1] = 0xff;
	x.header[2] = 0xff;
	x.header[3] = 0xff;
	x.header[4] = 0xff;
	x.header[5] = 0xff;
	x.header[6] = 0xff;
	x.header[7] = 0x00;

	/* Vendor Sign */
	vendor_sign = (('E' & 0x1f) << 10)
		| (('I' & 0x1f) << 5)
		| (('Z' & 0x1f) << 0);
	x.vendor_sign[0] = vendor_sign >> 8;
	x.vendor_sign[1] = vendor_sign & 0xff;

	/* Monitor ID */
	x.monitor_id[0] = 0x13;
	x.monitor_id[1] = 0x10;

	/* Serial Number */
	x.serial[0] = (0x17118424 >> 24) & 0xff;
	x.serial[1] = (0x17118424 >> 16) & 0xff;
	x.serial[2] = (0x17118423 >> 8) & 0xff;
	x.serial[3] = (0x17118423 >> 0) & 0xff;

	/* ? */
	x.manufacture_week = 59;
	x.manufacture_year = 2180 - 1990;

	/* Version/Revision */
	x.edid_version = 1;
	x.edid_revision = 1;

	/* Video Input Definition */
	x.input = 0x0e; /* analog? FIXME */

	/* Monitor Size */
	x.width = 36/*cm*/;
	x.height = 27/*cm*/;

	/* Gamma */
	x.gamma = 0x50; /* 1.80 - FIXME */

	/* DPMS Capabilities */
	x.dpms_flags = 0;
	x.dpms_flags |= 1 << 7; /* Standby */
	x.dpms_flags |= 1 << 6; /* Suspend */
	x.dpms_flags |= 1 << 5; /* Active off */
	x.dpms_flags |= 1 << 3; /* RGB/Color - correct? FIXME */

	/* Color Characteristics */
	/* redX: 0.625 redY: 0.340   greenX: 0.285 greenY: 0.600 */
	/* blueX: 0.150 blueY: 0.065   whiteX: 0.283 whiteY: 0.298 */
	/* FIXME */
	x.color[0] = 0x02;
	x.color[1] = 0xb9;
	x.color[2] = 0xa0;
	x.color[3] = 0x57;
	x.color[4] = 0x49;
	x.color[5] = 0x99;
	x.color[6] = 0x26;
	x.color[7] = 0x10;
	x.color[8] = 0x48;
	x.color[9] = 0x4c;

	/* Established Timings */
	x.est_timing[0] = 0xff;
	x.est_timing[1] = 0xff;
	x.est_timing[2] = 0x80;

	/* Standard Timing Identification */
	/* 1024x768 75 Hz */
	x.std_timing[0][0] = (1024 - 248) / 8;	/* Horizontal Resolution */
	x.std_timing[0][1] = (0b01 << 6)	/* Aspect Ration: 4:3 */
			| (85 - 60);		/* Vertical Frequency */

	/* 1152x864 75 Hz */
	x.std_timing[1][0] = (1152 - 248) / 8;	/* Horizontal Resolution */
	x.std_timing[1][1] = (0b01 << 6)	/* Aspect Ration: 4:3 */
			| (75 - 60);		/* Vertical Frequency */

	/* 1152x864 85 Hz */
	x.std_timing[2][0] = (1152 - 248) / 8;	/* Horizontal Resolution */
	x.std_timing[2][1] = (0b01 << 6)	/* Aspect Ration: 4:3 */
			| (85 - 60);		/* Vertical Frequency */

	/* 1280x1024 85 Hz */
	x.std_timing[3][0] = (1280 - 248) / 8;	/* Horizontal Resolution */
	x.std_timing[3][1] = (0b10 << 6)	/* Aspect Ration: 5:4 */
			| (85 - 60);		/* Vertical Frequency */

	/* 1600x1200 75 Hz */
	x.std_timing[4][0] = (1600 - 248) / 8;	/* Horizontal Resolution */
	x.std_timing[4][1] = (0b01 << 6)	/* Aspect Ration: 4:3 */
			| (75 - 60);		/* Vertical Frequency */

	x.std_timing[5][0] = 1;			/* Unused */
	x.std_timing[5][1] = 1;			/* Unused */
	x.std_timing[6][0] = 1;			/* Unused */
	x.std_timing[6][1] = 1;			/* Unused */
	x.std_timing[7][0] = 1;			/* Unused */
	x.std_timing[7][1] = 1;			/* Unused */

	/* Serial Number */
	x.info[0][0] = 0x00;
	x.info[0][1] = 0x00;
	x.info[0][2] = 0x00;
	x.info[0][3] = 0xff;		/* Serial Number */
	x.info[0][4] = 0x00;
	x.info[0][5] = '2';
	x.info[0][6] = '3';
	x.info[0][7] = '8';
	x.info[0][8] = '4';
	x.info[0][9] = '1';
	x.info[0][10] = '1';
	x.info[0][11] = '1';
	x.info[0][12] = '7';
	x.info[0][13] = '\n';
	x.info[0][14] = ' ';
	x.info[0][15] = ' ';
	x.info[0][16] = ' ';
	x.info[0][17] = ' ';

	/* Monitor Limits */
	x.info[1][0] = 0x00;
	x.info[1][1] = 0x00;
	x.info[1][2] = 0x00;
	x.info[1][3] = 0xfd;		/* Monitor Limits */
	x.info[1][4] = 0x00;
	x.info[1][5] = 50;		/* V_MIN_RATE */
	x.info[1][6] = 160;		/* V_MAX_RATE */
	x.info[1][7] = 30;		/* H_MIN_RATE */
	x.info[1][8] = 96;		/* H_MAX_RATE */
	x.info[1][9] = 220 / 10;	/* MAX_PIXEL_CLOCK */
	x.info[1][10] = 0;		/* GTF_SUPPORT */
	x.info[1][11] = '\n';		/* End-Of-Entry */
	x.info[1][12] = ' ';
	x.info[1][13] = ' ';
	x.info[1][14] = ' ';
	x.info[1][15] = ' ';
	x.info[1][16] = ' ';
	x.info[1][17] = ' ';

	/* Monitor Name */
	x.info[2][0] = 0x00;
	x.info[2][1] = 0x00;
	x.info[2][2] = 0x00;
	x.info[2][3] = 0xfc;		/* Monitor Name */
	x.info[2][4] = 0x00;
	x.info[2][5] = 'E';
	x.info[2][6] = 'I';
	x.info[2][7] = 'Z';
	x.info[2][8] = 'O';
	x.info[2][9] = ' ';
	x.info[2][10] = 'F';
	x.info[2][11] = 'l';
	x.info[2][12] = 'e';
	x.info[2][13] = 'x';
	x.info[2][14] = 'S';
	x.info[2][15] = 'c';
	x.info[2][16] = 'a';
	x.info[2][17] = 'n';

	/* Monitor Name (Second Part) */
	x.info[3][0] = 0x00;
	x.info[3][1] = 0x00;
	x.info[3][2] = 0x00;
	x.info[3][3] = 0xfc;		/* Monitor Name */
	x.info[3][4] = 0x00;
	x.info[3][5] = ' ';
	x.info[3][6] = 'F';
	x.info[3][7] = '6';
	x.info[3][8] = '7';
	x.info[3][9] = '\n';		/* End-Of-Entry */
	x.info[3][10] = ' ';
	x.info[3][11] = ' ';
	x.info[3][12] = ' ';
	x.info[3][13] = ' ';
	x.info[3][14] = ' ';
	x.info[3][15] = ' ';
	x.info[3][16] = ' ';
	x.info[3][17] = ' ';

	sum = 0;
	for (ptr = (uint8_t *) &x; ptr < (uint8_t *) &x + sizeof(x); ptr++) {
		sum += *ptr;
	}
	x.dummy = 0x00;
	x.checksum -= sum;

	ret = write(1, &x, sizeof(x));
	assert(ret == sizeof(x));

	return 0;
}
