/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __STRING_TOOLS_H_INCLUDED
#define __STRING_TOOLS_H_INCLUDED

#include <string.h>

static inline const char* str_nchr(const char *string, int c, int len)
{
	if (len == -1) {
		len = strlen(string);
	}
	while (len > 0) {
		if (string[0] == c) {
			return string;
		}
		string++;
		len--;
	}
	return NULL;
}
static inline const char* str_nrchr(const char *string, int c, int len)
{
	if (len == -1) {
		len = strlen(string);
	}
	len--;
	while (len >= 0) {
		if (string[len] == c) {
			return string+len;
		}
		len--;
	}
	return NULL;
}

static inline char* str_nrchr_mutable(char *string, int c, int len)
{
	if (len == -1) {
		len = strlen(string);
	}
	len--;
	while (len >= 0) {
		if (string[len] == c) {
			return string+len;
		}
		len--;
	}
	return NULL;
}

#endif /* __STRING_TOOLS_H_INCLUDED */
