/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
#ifdef IND0
	unsigned int state_ind0;
#endif
#ifdef IND1
	unsigned int state_ind1;
#endif
#ifdef IND2
	unsigned int state_ind2;
#endif
#ifdef INR
	unsigned int state_inr;
#endif
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

static void
NAME_(update)(struct cpssp *cpssp)
{
	unsigned int res;

#ifdef HIGH
#ifdef INR
	switch (cpssp->NAME.state_inr) {
	case SIG_STD_LOGIC_Z:
		/* res = SIG_STD_LOGIC_Z; FIXME */
		res = SIG_STD_LOGIC_H;
		break;
	case SIG_STD_LOGIC_U:
	case SIG_STD_LOGIC_X:
		res = SIG_STD_LOGIC_X;
		break;
	default:
		if (SIG_mV(cpssp->NAME.state_inr) < 2000) {
			res = SIG_STD_LOGIC_L;
		} else {
			res = SIG_STD_LOGIC_H;
		}
		break;
	}
#else /* ! INR */
	/* res = SIG_STD_LOGIC_Z; FIXME */
	res = SIG_STD_LOGIC_H;
#endif /* ! INR */

#else /* ! HIGH */
	res = SIG_STD_LOGIC_H;
#endif /* ! HIGH */

#ifdef IND0
	switch (cpssp->NAME.state_ind0) {
	case SIG_STD_LOGIC_Z:
		/* res = res; */
		break;
	case SIG_STD_LOGIC_U:
	case SIG_STD_LOGIC_X:
		res = SIG_STD_LOGIC_X;
		break;
	default:
		if (SIG_mV(cpssp->NAME.state_ind0) < 2000) {
			res = SIG_STD_LOGIC_0;
		}
		break;
	}
#endif

#ifdef IND1
	switch (cpssp->NAME.state_ind1) {
	case SIG_STD_LOGIC_Z:
		/* res = res; */
		break;
	case SIG_STD_LOGIC_U:
	case SIG_STD_LOGIC_X:
		res = SIG_STD_LOGIC_X;
		break;
	default:
		if (SIG_mV(cpssp->NAME.state_ind1) < 2000) {
			res = SIG_STD_LOGIC_0;
		}
		break;
	}
#endif

#ifdef IND2
	switch (cpssp->NAME.state_ind2) {
	case SIG_STD_LOGIC_Z:
		/* res = res; */
		break;
	case SIG_STD_LOGIC_U:
	case SIG_STD_LOGIC_X:
		res = SIG_STD_LOGIC_X;
		break;
	default:
		if (SIG_mV(cpssp->NAME.state_ind2) < 2000) {
			res = SIG_STD_LOGIC_0;
		}
		break;
	}
#endif

	EVALUATOR(NAME, OUT, out_set)(cpssp, res);
}

#ifdef IND0
static void
EVALUATOR(NAME, IND0, in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_ind0 = val;
	NAME_(update)(cpssp);
}
#endif

#ifdef IND1
static void
EVALUATOR(NAME, IND1, in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_ind1 = val;
	NAME_(update)(cpssp);
}
#endif

#ifdef IND2
static void
EVALUATOR(NAME, IND2, in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_ind2 = val;
	NAME_(update)(cpssp);
}
#endif

#ifdef INR
static void
EVALUATOR(NAME, INR, in_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_inr = val;
	NAME_(update)(cpssp);
}
#endif

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef IND0
	cpssp->NAME.state_ind0 = SIG_STD_LOGIC_Z;
#endif
#ifdef IND1
	cpssp->NAME.state_ind1 = SIG_STD_LOGIC_Z;
#endif
#ifdef IND2
	cpssp->NAME.state_ind2 = SIG_STD_LOGIC_Z;
#endif
#ifdef INR
	cpssp->NAME.state_inr = SIG_STD_LOGIC_Z;
#endif

	/* Make gcc happy... */
	if (0) {
#ifdef IND0
		EVALUATOR(NAME, IND0, in_set)(cpssp, 0);
#endif
#ifdef IND1
		EVALUATOR(NAME, IND1, in_set)(cpssp, 0);
#endif
#ifdef IND2
		EVALUATOR(NAME, IND2, in_set)(cpssp, 0);
#endif
#ifdef INR
		EVALUATOR(NAME, INR, in_set)(cpssp, 0);
#endif
	}
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/
