/*
 * Copyright (C) 2003-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#include "glue.h"
#include "umutil.h"

#include "chip_philips_pcx8582X_2.h"

#define COMP		chip_philips_pcx8582X_2
#define COMP_(x)	chip_philips_pcx8582X_2_ ## x
#define SCOMP		"chip_philips_pcx8582X_2"

struct cpssp {
#define NAME	spd_eeprom
#define STATE
#include "arch_philips_pcx8582X-2.c"
#undef STATE
#undef NAME
};

#define NAME		spd_eeprom
#define NAME_(x)	spd_eeprom_ ## x
#define BEHAVIOR
#include "arch_philips_pcx8582X-2.c"
#undef BEHAVIOR
#undef NAME_
#undef NAME

static void
COMP_(a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	spd_eeprom_a0_set(cpssp, val);
}

static void
COMP_(a1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	spd_eeprom_a1_set(cpssp, val);
}

static void
COMP_(a2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	spd_eeprom_a2_set(cpssp, val);
}


static void
COMP_(stop_transaction)(void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	spd_eeprom_stop_transaction(cpssp);
}

static void
COMP_(read_byte)(void *_cpssp, unsigned char *val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	spd_eeprom_read_byte(cpssp, val);
}

static bool
COMP_(write_byte)(void *_cpssp, unsigned char val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return spd_eeprom_write_byte(cpssp, val);
}

static bool
COMP_(ack_addr)(void *_cpssp, unsigned char addr)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	return spd_eeprom_ack_addr(cpssp, addr);
}

void *
COMP_(create)(
	const char *name,
	const char *img,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_a0,
	struct sig_std_logic *port_a1,
	struct sig_std_logic *port_a2,
	struct sig_i2c_bus *port_bus
)
{
	static const struct sig_i2c_bus_funcs spd_funcs = {
		.ack_addr = COMP_(ack_addr),
		.stop_transaction = COMP_(stop_transaction),
		.read_byte = COMP_(read_byte),
		.write_byte = COMP_(write_byte),
	};
	static const struct sig_std_logic_funcs a0_funcs = {
		.boolean_or_set = COMP_(a0_set),
	};
	static const struct sig_std_logic_funcs a1_funcs = {
		.boolean_or_set = COMP_(a1_set),
	};
	static const struct sig_std_logic_funcs a2_funcs = {
		.boolean_or_set = COMP_(a2_set),
	};
	struct cpssp *cpssp;
	const char *path;
	uint8_t contents[256];
	int fd;
	int ret;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	path = buildpath(ROMDIR, img);
	fd = open(path, O_RDONLY);
	assert(0 <= fd);

	ret = read(fd, contents, sizeof(contents));
	assert(ret == sizeof(contents));

	ret = close(fd);
	assert(0 <= ret);

	spd_eeprom_init(cpssp, contents);

	sig_std_logic_connect_in(port_a0, cpssp, &a0_funcs);
	sig_std_logic_connect_in(port_a1, cpssp, &a1_funcs);
	sig_std_logic_connect_in(port_a2, cpssp, &a2_funcs);

	sig_i2c_bus_connect_cooked(port_bus, cpssp, &spd_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
