/*
SMS Server Tools 3
Copyright (C) Keijo Kasvi
http://smstools3.kekekasvi.com/

Based on SMS Server Tools 2 from Stefan Frings
http://www.meinemullemaus.de/
SMS Server Tools version 2 and below are Copyright (C) Stefan Frings.

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.
*/

#ifndef SMSD_CFG_H
#define SMSD_CFG_H

/* **************************************************
SOME DEFINITIONS ARE USED IN THE VERSION >= 3.1 ONLY.
************************************************** */

#define DATETIME_DEFAULT "%y-%m-%d %H:%M:%S"

#define CONCATENATED_DIR_FNAME "%s/%s-concatenated"

#define PROVIDER 16 
#define DEVICES 64
#define NUMS 64

// Maximum size of a message text
#define MAXTEXT 39016

// Maxmum size of a single sms, can be 160/140 or less
#define maxsms_pdu 160
#define maxsms_ucs2 140
#define maxsms_binary 140

// Sizes for some buffers:
#define SIZE_TO 100
#define SIZE_FROM 100
#define SIZE_SMSC 100
#define SIZE_QUEUENAME 100
#define SIZE_UDH_DATA 500
#define SIZE_UDH_TYPE 4096
#define SIZE_RR_CMD 513
#define SIZE_MACROS 4096
#define SIZE_HEADER 101
#define SIZE_MESSAGEIDS 4096

#include <limits.h>
#include <sys/types.h>

char process_title[32];         // smsd for main task, name of a modem for other tasks.
int process_id;                 // -1 for main task, all other have numbers starting with 0.
                                // This is the same as device, can be used like devices[process_id]...
int modem;                      // Handle for modem.

int put_command_timeouts;

typedef struct
{
  char name[32]; 		// Name of the queue
  char numbers[NUMS][16];	// Phone numbers assigned to this queue
  char directory[PATH_MAX];		// Queue directory
} _queue;

typedef struct
{
  char name[32];		// Name of the modem
  char device[PATH_MAX];	// Serial port name
  char identity[SIZE_TO];       // Identification asked from the modem (CIMI)
  //char identity_header[SIZE_TO];// Title of current identification (IMSI)
  char queues[PROVIDER][32];	// Assigned queues
  int incoming; 		// Try to receive SMS. 0=No, 1=Low priority, 2=High priority
  int outgoing;                 // = 0 if a modem is not used to send messages.
  int report; 			// Ask for delivery report 0 or 1 (experimental state)
  int phonecalls;               // Check for phonebook status for calls, 0 or 1
  char pin[16];			// SIM PIN
  int pinsleeptime;             // Number of seconds to sleep after a PIN is entered.
  char mode[10]; 		// Command set version old or new
  char smsc[16];		// Number of SMSC
  int baudrate;			// Baudrate
  int send_delay;		// Makes sending characters slower (milliseconds)
  int cs_convert; 		// Convert character set  0 or 1 (iso-9660)
  char initstring[100];		// first Init String
  char initstring2[100];        // second Init String
  char eventhandler[PATH_MAX];	// event handler program or script
  int rtscts;			// hardware handshake RTS/CTS, 0 or 1
  int read_memory_start;	// first memory space for sms
  char primary_memory[10];      // primary memory, if dual-memory handler is used
  char secondary_memory[10];    // secondary memory, if dual-memory handler is used
  int secondary_memory_max;     // max value for secondary memory, if dual-memory handler is used and modem does not tell correct max value
  char pdu_from_file[PATH_MAX]; // for testing purposes: incoming pdu can be read from file if this is set.
  int sending_disabled;         // 1 = do not actually send a message. For testing purposes.
  int modem_disabled;           // 1 = disables modem handling. For testing purposes. Outgoing side acts like with sending_disabled,
                                // incoming side reads messages only from file (if defined). NOTE: device name should still be defined
                                // as it's opened and closed. You can use some regular file for this. Must be an existing file.
  int decode_unicode_text;      // 1 if unicode text is decoded internally.
  int internal_combine;         // 1 if multipart message is combined internally.
  int pre_init;                 // 1 if pre-initialization is used with a modem.
  int check_network;            // 0 if a modem does not support AT+CREG command.
  char admin_to[SIZE_TO];       // Destination number for administrative messages.
  int message_limit;            // Limit counter for outgoing messages. 0 = no limit.
  int message_count_clear;      // Period to automatically clear message counter. Value is MINUTES. 
  int keep_open;                // 1 = do not close modem while idle.
  char dev_rr[PATH_MAX];        // Script/program which is run regularly.
  int dev_rr_interval;          // Number of seconds between running a regular_run script/progdam.
  char dev_rr_cmdfile[PATH_MAX];// 
  char dev_rr_cmd[SIZE_RR_CMD]; //
  char dev_rr_logfile[PATH_MAX];
  int dev_rr_loglevel; // defaults to 5, LOG_NOTICE. Has only effect when a main log is used.
  char dev_rr_statfile[PATH_MAX];
  char logfile[PATH_MAX];       // Name or Handle of Log File
  int loglevel;                 // Log Level (9=highest). Verbosity of log file.
} _device;

// NOTE for regular run intervals: effective value is at least delaytime.

char configfile[PATH_MAX];	// Path to config file
char d_spool[PATH_MAX];		// Spool directory
char d_failed[PATH_MAX];	// Failed spool directory
char d_incoming[PATH_MAX];	// Incoming spool directory
char d_report[PATH_MAX];	// Incoming report spool directory
char d_phonecalls[PATH_MAX];    // Incoming phonecalls data directory
char d_saved[PATH_MAX];         // Directory for smsd's internal use, concatenation storage files etc.
char d_sent[PATH_MAX];		// Sent spool directory
char d_checked[PATH_MAX];	// Spool directory for checked messages (only used when no provider queues used)
char eventhandler[PATH_MAX];	// Global event handler program or script
char alarmhandler[PATH_MAX];	// Global alarm handler program or script
char checkhandler[PATH_MAX];    // Handler that checks if the sms file is valid.
int alarmlevel;			// Alarm Level (9=highest). Verbosity of alarm handler.
char logfile[PATH_MAX];		// Name or Handle of Log File
int  loglevel;			// Log Level (9=highest). Verbosity of log file.
_queue queues[PROVIDER];	// Queues
_device devices[DEVICES];	// Modem devices
int delaytime;			// sleep-time after workless
int blocktime;			// sleep-time after multiple errors
int blockafter;                 // Block modem after n errors
int errorsleeptime;		// sleep-time after each error
int autosplit;			// Splitting of large text messages 0=no, 1=yes 2=number with text, 3=number with UDH
int receive_before_send;	// if 1 smsd tries to receive one message before sending
int store_received_pdu;         // 0=no, 1=unsupported pdu's only, 2=unsupported and 8bit/unicode, 3=all
int store_sent_pdu;             // 0=no, 1=failed pdu's only, 2=failed and 8bit/unicode, 3=all
int validity_period;            // Validity period for messages.
int decode_unicode_text;        // 1 if unicode text is decoded internally.
int internal_combine;           // 1 if multipart message is combined internally.
int keep_filename;              // 0 if unique filename is created to each directory when a message file is moved.
int store_original_filename;    // 1 if an original filename is saved to message file when it's moved from
                                // outgoing directory to spooler. Works together with keep_filename.
int date_filename;              // 1 or 2 if YYYYMMDD is included to the filename of incoming message.
char regular_run[PATH_MAX];     // Script/program which is run regularly.
int regular_run_interval;       // Number of seconds between running a regular_run script/progdam.
char admin_to[SIZE_TO];         // Destination number for administrative messages.
int filename_preview;           // Number of chars of message text to concatenate to filename.
int incoming_utf8;              // 1 if incoming files are saved using UTF-8 character set.
int outgoing_utf8;              // 1 if outgoing files are automatically converted from UTF-8 to ISO and GSM.
int log_charconv;               // 1 if character set conversion is logged.
int log_single_lines;           // 1 if linefeeds are removed from the modem response to be logged.
int message_count;              // Counter for sent messages. Multipart message is one message.

int terminate;                  // The current process terminates if this is 1

char username[65];              // user and group name which are used to run.
char groupname[65];             // (max length is just a guess)

char infofile[PATH_MAX];        // Hepler file for stopping the smsd smoothly.
char pidfile[PATH_MAX];         // File where a process id is stored.

// Command line arguments:
char arg_username[65];
char arg_groupname[65];
char arg_infofile[PATH_MAX];
char arg_pidfile[PATH_MAX];
char arg_logfile[PATH_MAX];
int arg_terminal;

int terminal;                   // 1 if smsd is communicating with terminal.
pid_t device_pids[DEVICES];     // Pid's of modem processes.
char run_info[PATH_MAX];        // Information about external script/program execution.

char communicate[32];           // Device name for terminal communication mode.

// Storage for startup errors:
char *startup_err_str;
int startup_err_count;

// Storage for PDU's:
char *incoming_pdu_store;
char *outgoing_pdu_store;

// Storage for getfile errors:
char *getfile_err_store;

// Text buffer for error messages:
char tb[1024];

int os_cygwin;                  // 1 if we are on Cygwin.

char language_file[PATH_MAX];   // File name of translated headers.
char yes_chars[SIZE_HEADER];    // Characters which mean "yes" in the yesno() question.
char no_chars[SIZE_HEADER];     // See details inside read_translation() function.
char yes_word[SIZE_HEADER];     // "yes" printed as an output.
char no_word[SIZE_HEADER];      // "no"
char datetime_format[SIZE_HEADER]; // strftime format string for time stamps (not inside status reports).
int translate_incoming;         // 0 if incoming message headers are NOT transtaled.

/* initialize all variable with default values */

void initcfg();


/* read the config file */

int readcfg();


/* Retuns the array-index and the directory of a queue or -1 if
   not found. Name is the name of the queue or a phone number. */

int getqueue(char* name, char* directory);


/* Returns the array-index of a device or -1 if not found */

int getdevice(char* name);


/* Show help */

void help();

/* parse arguments */

void parsearguments(int argc,char** argv);

int startup_check(int result);

void abnormal_termination(int all);

char *tb_sprintf(char* format, ...);

#endif
