/*
	Description: stdout viewer

	Author: Marco Costalba (C) 2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef CONSOLEIMPL_H
#define CONSOLEIMPL_H

#include <qguardedptr.h>
#include "consolebase.h"

class MyProcess;
class Git;

class ConsoleImpl : public Console {
Q_OBJECT
public:
	ConsoleImpl(const QString& nm, Git* g);
	bool start(const QString& cmd,const QString& args);

signals:
	void customAction_exited(const QString& name);

public slots:
	void on_procDataReady(const QByteArray& data);
	void on_eof();

protected slots:
	void pushButtonStop_clicked();
	void pushButtonOk_clicked();
	void closeEvent(QCloseEvent* ce);

private:
	QString name;
	Git* git;
	QGuardedPtr<MyProcess> proc;
	QString inpBuf;
};

#endif
