/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef DATALOADER_H
#define DATALOADER_H

#include <qobject.h>
#include <qprocess.h>
#include <qcstring.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qptrvector.h>

class Git;

class DataLoader : public QObject {
Q_OBJECT
public:
	DataLoader(Git* g, bool isHistory);
	~DataLoader();
	bool start(const QString& cmd, const QString& wd);

signals:
	void newDataReady();
	void loaded(ulong,const QTime&,bool,const QString&,const QString&);

private slots:
	void on_cancel();
	void on_readyReadStdout();
	void on_processExited();
	void on_timeout();

private:
	void parseSingleBuffer(const QByteArray& ba);
	void updateIndex(int* idx, int* prevIdx, const QByteArray& ba);

	Git* git;
	bool isHistory;
	QProcess proc;
	QString halfChunks;
	QPtrVector<QByteArray> buffersRing;
	uint buffersRingHead, buffersRingTail;
	ulong grandTot;
	QTime loadTime;
	QTimer guiUpdateTimer;
	bool isProcExited;
	bool parsing;
	bool canceling;
};

#endif
