#!/usr/bin/env python
# arch-tag: 40961aaa-c397-4571-9e92-97998a510c7c
# Copyright (C) 2004 David Allouche <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Test suite for getting and setting my-id."""

import pybaz as arch

import framework
import fixtures


class MyId(framework.NewTestCase):
    tests = []
    fixture = fixtures.EmptySandboxFixture()
    my_id = fixtures.MyIdFixture().my_id

    def default_my_id_empty(self):
        """my_id returns None when unset."""
        my_id = arch.my_id()
        self.failUnlessEqual(None, my_id)
    tests.append('default_my_id_empty')

    def set_my_id(self):
        """set_my_id effects arch.my_id()."""
        arch.set_my_id(self.my_id)
        my_id = arch.my_id()
        self.failUnlessEqual(my_id, self.my_id)
    tests.append('set_my_id')

    def set_invalid_myid(self):
        """set_my_id fails for invalid id and preserves current id."""
        arch.set_my_id(self.my_id)
        invalid_id = "not a valid email address"
        self.assertRaises(arch.ExecProblem, arch.set_my_id, invalid_id)
        self.failUnlessEqual(arch.my_id(), self.my_id)
    tests.append('set_invalid_myid')


framework.register(__name__)
