#ifndef CS_GPGOP_H
#define CS_GPGOP_H

#include"openpgp.h"

class GpgOp : public QObject
{
	Q_OBJECT
public:
	enum { Check = 0, SecretKeyringFile, PublicKeyringFile, SecretKeys, PublicKeys, Encrypt, Decrypt, Sign, Verify };
	GpgOp(const QString &bin, QObject *parent=0);
	~GpgOp();

	bool isActive() const;
	int op() const;
	const OpenPGP::KeyList & keys() const;
	const QString & keyringFile() const;
	const QString & keyID() const;
	const QDateTime & timestamp() const;
	int verifyResult() const;
	bool badPassphrase() const;
	const QString & encrypted() const;
	const QByteArray & decrypted() const;
	const QString & signature() const;

	void doCheck();
	void doSecretKeyringFile();
	void doPublicKeyringFile();
	void doSecretKeys();
	void doPublicKeys();
	void doEncrypt(const QByteArray &in, const QStringList &keys);
	void doDecrypt(const QString &in);
	void doSign(const QByteArray &in, const QString &keyID);
	void doVerify(const QByteArray &in, const QString &sig);
	void stop();

	void submitPassphrase(const QString &);
	void setTryAgent(bool);

signals:
	void finished(bool);
	void needPassphrase();

private slots:
	void proc_readyReadStdout();
	void proc_readyReadStderr();
	void proc_wroteToStdin();
	void proc_statusLine(const QString &);
	void proc_processExited();

	void doFail();

private:
	class Private;
	Private *d;

	void reset();

	bool launchGPG(const QStringList &, bool useExtra=true);
	void processResult(bool clean, int code, const QByteArray &out, const QByteArray &err);

	QString fixIncomingLines(const QString &);
	QString fixOutgoingLines(const QString &);
	bool stringToKeyList(const QString &, OpenPGP::KeyList *, QString *);
	bool findKeyringFilename(const QString &, QString *);
};

#endif
