/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qtextcodec.h>
#include "ekg_cmds.h"
#include "powerkadu.h"
#include "cmdline.h"

#include "chat.h"
#include "chat_manager.h"
#include "chat_message.h"
#include "misc.h"
#include "debug.h"

EKGCmds::EKGCmds(QObject *parent, const char *name)
{
	kdebugf();
	powerKadu->cmds()->addCmd("busy", this, SLOT( busyCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("invisible", this, SLOT( invisibleCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("offline",this, SLOT( offlineCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("online",this, SLOT( onlineCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("clear", this, SLOT( clearCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("close", this, SLOT( closeCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("minimize", this, SLOT( minimizeCmd(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	powerKadu->cmds()->addCmd("massmsg", this, SLOT( massMsg(Chat*, const UserGroup*, QString&, QStringList&, QCString&) ));
	kdebugf2();
}

EKGCmds::~EKGCmds()
{
}
void EKGCmds::busyCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("busy");
	gadu->status().setBusy(args.join(" "));
	kdebugf2();
}

void EKGCmds::invisibleCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("invisible");
	gadu->status().setInvisible(args.join(" "));
	kdebugf2();
}

void EKGCmds::offlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("offline");
	gadu->status().setOffline(args.join(" "));
	kdebugf2();
}

void EKGCmds::onlineCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("online");
	gadu->status().setOnline(args.join(" "));
	kdebugf2();
}

void EKGCmds::clearCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
        kdebugf();
        CHECK_CMD("clear");
	chat->clearChatWindow();
	kdebugf2();
}
void EKGCmds::closeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("close");
	chat->close();
	kdebugf2();
}
void EKGCmds::minimizeCmd(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("minimize");
	chat->showMinimized();
	kdebugf2();
}

void EKGCmds::massMsg(Chat* chat, const UserGroup* users, QString &cmd, QStringList &args, QCString &msg)
{
	kdebugf();
	CHECK_CMD("massmsg");
	QTextCodec *codec = QTextCodec::codecForName("CP1250");
	// Truncate the "/massmsg " prefix
	QString command = codec->toUnicode(msg.right(msg.length() - 9).data());
	
	for(ChatList::ConstIterator it = chat_manager->chats().begin(); it != chat_manager->chats().end(); ++it)
	{
		(*it)->edit()->clear();
		(*it)->edit()->insertLine(command);
		(*it)->sendMessage();
	}
	kdebugf2();
}
