#include <kapp.h>
#include <dcopclient.h>
#include <qregexp.h>

#include "gadu.h"
#include "misc.h"
#include "modules.h"
#include "kadu.h"
#include "userlist.h"
#include "chat.h"
#include "history.h"
#include "search.h"
#include "pending_msgs.h"
#include "config_dialog.h"
#include "modules/notify/notify.h"
#include "modules/sms/sms.h"
#include "modules/sms/sms.h"
#include "modules/dcc/file_transfer.h"
#include "debug.h"
#include "message_box.h"
#include "groups_manager.h"
#include "pending_msgs.h"
#include "chat_manager.h"

#include "DCOPExport.h"

#define MODULE_DCOPEXPORT_VERSION 0.11.3

DCOPExport *dcopexport = 0;

extern "C" int dcopexport_init()
{
	dcopexport = new DCOPExport ();

	return 0;
}

extern "C" void dcopexport_close()
{
	if (dcopexport) {
		kdebugm (KDEBUG_INFO, "deleting dcopexport\n");
		delete dcopexport;
	}
}

DCOPExport::DCOPExport ():
	DCOPObject ("kadu"), installGGProcess(0)
{
	kdebugf ();
	
	bool qtdcopbridge = config_file.readBoolEntry ("dcopexport", "qt-dcop-bridge", true);
	bool acceptCalls = config_file.readBoolEntry ("dcopexport", "accept-calls", true);

	ConfigDialog::addTab ("dcopexport", dataPath ("kadu/modules/data/dcopexport/dcopexport.png"));
	ConfigDialog::addCheckBox (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Enable Qt-DCOP bridge"),
		"qt-dcop-bridge",
		qtdcopbridge,
		QT_TRANSLATE_NOOP("@default", "Public functions and properties of Qt objects will be accessible via DCOP")
	);
	ConfigDialog::addCheckBox (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Accept DCOP calls"),
		"accept-calls",
		qtdcopbridge,
		QT_TRANSLATE_NOOP("@default", "When you are connected to foreign DCOP server \nyou probably want to _disable_ Qt-DCOP bridge above")
	);
	ConfigDialog::addPushButton (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Install gg:// protocol in Konqueror")
	);
	ConfigDialog::connectSlot (
		"dcopexport", 
		"Install gg:// protocol in Konqueror",
		SIGNAL(clicked()),
		this, 
		SLOT(installGGInKonqueror())
	);
	ConfigDialog::addPushButton (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Install gg:// protocol in Firefox")
	);
	ConfigDialog::connectSlot (
		"dcopexport", 
		"Install gg:// protocol in Firefox", 
		SIGNAL(clicked()),
		this, 
		SLOT(installGGInFirefox())
	);
	ConfigDialog::addPushButton (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Install gg:// protocol in Opera")
	);
	ConfigDialog::connectSlot (
		"dcopexport", 
		"Install gg:// protocol in Opera", 
		SIGNAL(clicked()),
		this, 
		SLOT(installGGInOpera())
	);
	ConfigDialog::addPushButton (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Install description change from Konqueror")
	);
	ConfigDialog::connectSlot (
		"dcopexport", 
		"Install description change from Konqueror", 
		SIGNAL(clicked()),
		this, 
		SLOT(installKaduSetDescription())
	);
	ConfigDialog::addCheckBox (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Allow to read secret data"),
		"read-secrets",
		config_file.readBoolEntry ("dcopexport", "read-secrets", true),
		QT_TRANSLATE_NOOP("@default", "Allow reading secret data (like passwords etc)")
	);
	ConfigDialog::addCheckBox (
		"dcopexport",
		"dcopexport",
		QT_TRANSLATE_NOOP("@default", "Allow to write secret data"),
		"write-secrets",
		config_file.readBoolEntry ("dcopexport", "write-secrets", true),
		QT_TRANSLATE_NOOP("@default", "Allow writing secret data (like passwords etc)")
	);
	ConfigDialog::registerSlotOnApplyTab ("dcopexport", this, SLOT(applyConfig()));

	DCOPClient *dcopcl = KApplication::dcopClient ();
	if (dcopcl) {
		connect (dcopcl,
			SIGNAL(attachFailed (const QString &)),
			this,
			SLOT(attachFailed (const QString &))
		);
	}
	
	connectToDCOP (qtdcopbridge, acceptCalls);

	kdebugf2 ();
}

DCOPExport::~DCOPExport ()
{
	kdebugf ();

	cleanupForKadu ();

	DCOPClient *dcopcl = KApplication::dcopClient ();
	if (dcopcl) {
		disconnect (dcopcl,
			 SIGNAL(attachFailed (const QString &)),
			 this,
			 SLOT(attachFailed (const QString &))
		);
	}
		
	ConfigDialog::unregisterSlotOnApplyTab ("dcopexport", this, SLOT(applyConfig()));

	ConfigDialog::removeControl ("dcopexport", "Enable Qt-DCOP bridge");
	ConfigDialog::removeControl ("dcopexport", "Accept DCOP calls");
	ConfigDialog::removeControl ("dcopexport", "Install gg:// protocol in Konqueror");
	ConfigDialog::removeControl ("dcopexport", "Install gg:// protocol in Firefox");
	ConfigDialog::removeControl ("dcopexport", "Install gg:// protocol in Opera");
	ConfigDialog::removeControl ("dcopexport", "Allow to read secret data");
	ConfigDialog::removeControl ("dcopexport", "Allow to write secret data");
	ConfigDialog::removeControl ("dcopexport", "Install description change from Konqueror");
	ConfigDialog::removeTab ("dcopexport");

	if (installGGProcess) {
		delete installGGProcess;
	}
	
	kdebugf2 ();
}

void DCOPExport::connectToDCOP (bool qtdcopbridge, bool acceptcalls)
{
	kdebugf ();

	DCOPClient *dcopcl = KApplication::dcopClient ();
	if (dcopcl) {
		if (dcopcl->attach ()) {
			dcopcl->setQtBridgeEnabled (qtdcopbridge);
			dcopcl->setAcceptCalls (acceptcalls);
			
			appId = dcopcl->registerAs ("kadu", false);
	
			if (dcopcl->isRegistered ()) {
				kdebugm (KDEBUG_INFO, "kadu registered: %s\n", appId.data ());
			} else {
				kdebugm (KDEBUG_INFO, "kadu not registered!\n");
			}
		} else {
			kdebugm (KDEBUG_INFO, "kadu not attached!\n");
		}
	} else {
		kdebugm (KDEBUG_PANIC, "No DCOP client available!\n");
	}

	kdebugf2 ();
}

void DCOPExport::applyConfig ()
{
	kdebugf ();

	KApplication::dcopClient ()->setQtBridgeEnabled (
		config_file.readBoolEntry ("dcopexport", "qt-dcop-bridge", true)
	);
	KApplication::dcopClient ()->setAcceptCalls (
		config_file.readBoolEntry ("dcopexport", "accept-calls", false)
	);

	kdebugf2 ();
}

void DCOPExport::attachFailed (const QString &msg)
{
	kdebugm (KDEBUG_INFO, "attach failed: %s\n", msg.local8Bit().data());
}

void DCOPExport::installGGInKonqueror ()
{
	if (installGGProcess) {
		delete installGGProcess;
	}
	installGGProcess = new QProcess(libPath ("kadu/modules/bin/dcopexport/install-konqueror-gg.sh"));
	installGGProcess->setCommunication (QProcess::Stdout | QProcess::Stderr);
	connect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	kdebugm (KDEBUG_INFO, "starting install process\n");
	if (! installGGProcess->start ()) {
		kdebugm (KDEBUG_WARNING, "install process could not be started\n");
		disconnect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	}
}

void DCOPExport::installGGInFirefox ()
{
	if (installGGProcess) {
		delete installGGProcess;
	}
	installGGProcess = new QProcess(libPath ("kadu/modules/bin/dcopexport/install-firefox-gg.sh"));
	installGGProcess->addArgument ("noninteractive");
	installGGProcess->setCommunication (QProcess::Stdout | QProcess::Stderr);
	connect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	kdebugm (KDEBUG_INFO, "starting install process\n");
	if (! installGGProcess->start ()) {
		kdebugm (KDEBUG_WARNING, "install process could not be started\n");
		disconnect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	}
}
	
void DCOPExport::installGGInOpera ()
{
	if (installGGProcess) {
		delete installGGProcess;
	}
	installGGProcess = new QProcess(libPath ("kadu/modules/bin/dcopexport/install-opera-gg.sh"));
	installGGProcess->setCommunication (QProcess::Stdout | QProcess::Stderr);
	connect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	kdebugm (KDEBUG_INFO, "starting install process\n");
	if (! installGGProcess->start ()) {
		kdebugm (KDEBUG_WARNING, "install process could not be started\n");
		disconnect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	}
}

void DCOPExport::installKaduSetDescription ()
{
	if (installGGProcess) {
		delete installGGProcess;
	}
	installGGProcess = new QProcess(libPath ("kadu/modules/bin/dcopexport/install-konqueror-setAsKaduDesc.sh"));
	installGGProcess->setCommunication (QProcess::Stdout | QProcess::Stderr);
	connect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	kdebugm (KDEBUG_INFO, "starting install process\n");
	if (! installGGProcess->start ()) {
		kdebugm (KDEBUG_WARNING, "install process could not be started\n");
		disconnect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
	}
}

void DCOPExport::installGGProcessExited()
{
	if (installGGProcess->normalExit () && (installGGProcess->exitStatus () == 0)) {
		MessageBox::msg (tr("Installation succesfull"));
	} else {
		QString info;
		info += installGGProcess->readStdout ();
		info += installGGProcess->readStderr ();
		
		MessageBox::wrn (tr("Installation not succesfull:\n") + info);
	}
	disconnect (installGGProcess, SIGNAL(processExited()), this, SLOT(installGGProcessExited()));
}

void DCOPExport::cleanupForKadu ()
{
	kdebugf ();

	kdebugm (KDEBUG_INFO, "retriving DCOP client ...\n");
	DCOPClient *dcopcl = KApplication::dcopClient ();
	if (dcopcl) {
		kdebugm (KDEBUG_INFO, "DCOPClient->appId () == %s\n", dcopcl->appId ().data ());

		if (dcopcl->isRegistered ()) {
			kdebugm (KDEBUG_INFO, "kadu registered, detaching ...\n");
			if (dcopcl->detach ()) {
				kdebugm (KDEBUG_INFO, "kadu detached\n");
			} else {
				kdebugm (KDEBUG_INFO, "kadu not detached (??)\n");
			}
		} else {
			kdebugm (KDEBUG_INFO, "kadu not registered, not detaching\n");
		}
	} else {
		kdebugm (KDEBUG_PANIC, "No DCOP client available!\n");
	}

	kdebugf2 ();
}

void DCOPExport::sendMessage (const QString &uin, const QString &message)
{
#if 0
	UinsList recv;
	recv.append (uin.toUInt ());
#endif
	UserListElements recv;
	recv.append (userlist->byID ("Gadu", uin));

	if (! gadu->currentStatus().isOffline ()) {
		if (gadu->sendMessage (recv, unicode2cp (message)) == -1) {
			kdebugm (KDEBUG_WARNING, "couldn't send message\n");
		}
	}
}

void DCOPExport::sendMessageWithHistory (const QString &uin, const QString &message)
{
#if 0
	UinsList recv;
	recv.append (uin.toUInt ());
#endif
	UserListElements recv;
	recv.append (userlist->byID ("Gadu", uin));

	if (! gadu->currentStatus().isOffline ()) {
		if (gadu->sendMessage (recv, unicode2cp (message)) == -1) {
			kdebugm (KDEBUG_WARNING, "couldn't send message\n");
		} else {
			UinsList recver;
			recver.append (uin.toUInt ()); //config_file.readNumEntry ("General", "UIN"));
			history->addMyMessage (recver, message);
		}
	}
}

QStringList DCOPExport::getGroups ()
{
	kdebugf ();

	QStringList groupsList = groups_manager->groups ();
#if 0
	for (int i=0; i < kadu->groupBar()->count(); ++i)
		groupsList << kadu->groupBar()->tabAt(i)->text();
#endif
	kdebugf2 ();
	return groupsList;
}

QStringList DCOPExport::getUsersInGroup (QString group)
{
	kdebugf ();

	QStringList usersList;
#if 0
	if (group == qApp->translate("Kadu", "All")) {
		for (UserList::ConstIterator i = userlist.begin(); i != userlist.end(); ++i) {
			usersList.append (QString::number((*i).uin ()) + ":" + (*i).altNick());
		}
	} else {
		for (UserList::ConstIterator i = userlist.begin(); i != userlist.end(); ++i) {
			QString user_groups = (*i).group();
			QString user_group;

			for (int g = 0; (user_group = user_groups.section(',',g,g)) != ""; ++g)
				if (user_group == group)
					usersList.append (QString::number((*i).uin ()) + ":" + (*i).altNick());
		}
	}
#endif
	UserGroup *users = groups_manager->group (group);
	if (users) {
		for (
			UserGroup::const_iterator ugci = users->constBegin ();
			ugci != users->constEnd ();
			++ ugci
		) {
			usersList.append (QString("%1:%2").arg ((*ugci).ID ("Gadu")).arg ((*ugci).altNick ()));
		}
	}
	
	kdebugf2 ();
	return usersList;
}

QStringList DCOPExport::getUserInfo (QString uin)
{
	kdebugf ();
	
	QStringList userInfo;
	
#if 0
	if (userlist.containsUin (UinsList(uin)[0])) {
		UserListElement ule = userlist.byUin (UinsList(uin)[0]);
#endif
	if (userlist->contains ("Gadu", uin)) {
		UserListElement ule = userlist->byID ("Gadu", uin);
		userInfo << QString("Uin: %1").arg (uin);
		userInfo << QString("Nick: %1").arg (ule.nickName ());
		userInfo << QString("AltNick: %1").arg (ule.altNick ());
		userInfo << QString("FirstName: %1").arg (ule.firstName ());
		userInfo << QString("LastName: %1").arg (ule.lastName ());
		userInfo << QString("Mobile: %1").arg (ule.mobile ());
		userInfo << QString("Email: %1").arg (ule.email ());
#if 0
		userInfo << QString("Status: %1").arg (ule.status ().index ());
		userInfo << QString("Desc: %1").arg (ule.status ().description ());
#endif
		userInfo << QString("Status: %1").arg (ule.status ("Gadu").index ());
		userInfo << QString("Desc: %1").arg (ule.status ("Gadu").description ());
#if 0
		userInfo << QString("IP: %1:%2").arg (ule.ip ().toString ()).arg (ule.port ());
#endif
		userInfo << QString("IP: %1:%2").arg (ule.IP ("Gadu").toString ()).arg (ule.port ("Gadu"));
	}
	
	kdebugf2 ();
	return userInfo;
}

QString DCOPExport::description ()
{
	return gadu->currentStatus ().description ();
}

void DCOPExport::setDescription (QString desc)
{
	gadu->status ().setDescription (desc);
}

void DCOPExport::setOnline ()
{
	setOnline ("");
}

void DCOPExport::setOnline (const QString& desc)
{
	gadu->status ().setOnline (desc);
}

bool DCOPExport::isOnline ()
{
	return gadu->currentStatus ().isOnline ();
}

void DCOPExport::setBusy ()
{
	setBusy ("");
}

void DCOPExport::setBusy (const QString& desc)
{
	gadu->status ().setBusy (desc);
}

bool DCOPExport::isBusy ()
{
	return gadu->currentStatus ().isBusy ();
}

void DCOPExport::setInvisible ()
{
	setInvisible ("");
}

void DCOPExport::setInvisible (const QString& desc)
{
	gadu->status ().setInvisible (desc);
}

bool DCOPExport::isInvisible ()
{
	return gadu->currentStatus ().isInvisible ();
}

void DCOPExport::setOffline ()
{
	setOffline ("");
}

void DCOPExport::setOffline (const QString& desc)
{
	gadu->status ().setOffline (desc);
}

bool DCOPExport::isOffline ()
{
	return gadu->currentStatus ().isOffline ();
}

void DCOPExport::setFriendsOnly (bool b)
{
	gadu->status ().setFriendsOnly (b);
}

bool DCOPExport::isFriendsOnly ()
{
	return gadu->currentStatus ().isFriendsOnly ();
}

void DCOPExport::openChat(QString uins)
{
#if 0
	UinsList ul (uins);
#endif
	QStringList ulist = QStringList::split (",", uins);
	UserListElements ul;
	for (
		QStringList::const_iterator slci = ulist.begin ();
		slci != ulist.end ();
		++ slci
	) {
		ul.append (userlist->byID ("Gadu", *slci));
	}
	if (pending.pendingMsgs (ul[0])) {
		chat_manager->openPendingMsgs (ul);
	} else {
		chat_manager->openChat ("Gadu", ul);
	}
}

void DCOPExport::openSearchDialog (QString uin)
{
	(new SearchDialog(0, "DCOP search dialog", uin.toUInt()))->show();
}

void DCOPExport::showHistory (QString uins)
{
	(new History(UinsList (uins)))->show();
}

void DCOPExport::openUrl (const QString& url)
{
	kdebugf ();

	QRegExp uins("^gg:/{0,2}(\\d+(,\\d+)*)");

	int p = uins.search (url);

	if (p != -1) {
		QStringList texts = uins.capturedTexts ();

		kdebugm (KDEBUG_INFO, "%s\n", texts[1].local8Bit().data());

		openChat (texts[1]);
	}

	kdebugf2 ();
}

QString DCOPExport::readEntry(const QString &group, const QString &name, const QString &def)
{
	if (! config_file.readBoolEntry ("dcopexport", "read-secrets", true) 
			 && name.endsWith ("Password")) {
		kdebugm (KDEBUG_INFO, "Access denied for reading: %s/%s\n", group.local8Bit().data(), name.local8Bit().data());
		return QString::null;
	} else
		return config_file.readEntry(group, name, def);
}

int DCOPExport::readNumEntry(const QString &group, const QString &name, int def)
{
	if (! config_file.readBoolEntry ("dcopexport", "read-secrets", true) 
			 && name.endsWith ("Password")) {
		kdebugm (KDEBUG_INFO, "Access denied for reading: %s/%s\n", group.local8Bit().data(), name.local8Bit().data());
		return 0;
	} else
		return config_file.readNumEntry(group, name, def);
}

double DCOPExport::readDoubleNumEntry(const QString &group, const QString &name, double def)
{
	if (! config_file.readBoolEntry ("dcopexport", "read-secrets", true) 
			 && name.endsWith ("Password")) {
		kdebugm (KDEBUG_INFO, "Access denied for reading: %s/%s\n", group.local8Bit().data(), name.local8Bit().data());
		return 0.0;
	} else
		return config_file.readDoubleNumEntry(group, name, def);
}

bool DCOPExport::readBoolEntry(const QString &group, const QString &name, bool def)
{
	return config_file.readBoolEntry(group, name, def);
}

void DCOPExport::writeEntry(const QString &group, const QString &name, const QString &value)
{
	if (! config_file.readBoolEntry ("dcopexport", "write-secrets", true) 
			 && name.endsWith ("Password")) {
		kdebugm (KDEBUG_INFO, "Access denied for writing: %s/%s\n", group.local8Bit().data(), name.local8Bit().data());
	} else
		config_file.writeEntry(group, name, value);
}

QString DCOPExport::passwordHash (const QString &s)
{
	return pwHash (s);
}

void DCOPExport::showMessage (QString type, QString text)
{
	notify->emitMessage("DCOP", type, text);
}

QStringList DCOPExport::getMessageTypes ()
{
	return notify->notifiersList();
}

void DCOPExport::sendFile (const QString &uin, const QString &path)
{
	kdebugf();

	if (! gadu->currentStatus ().isOffline ()) {
		file_transfer_manager->sendFile (uin.toUInt (), path);
	} else {
		kdebugm (KDEBUG_INFO, "I won't send a file when offline, go online first");
	}
	
	kdebugf();
}


bool DCOPExport::exportUserList ()
{
	kdebugf();
	
	bool result;

	if (gadu->currentStatus ().isOffline ()) {
		result = false;
	} else {
		/* To nie jest dobrze rozwizane */
		result = gadu->doExportUserList (*userlist);
	}
	
	kdebugf2();
	
	return result;
}

bool DCOPExport::sendUserSMS (const QString &sender, const QString &altnick, const QString &message)
{
	kdebugf();
	
	bool retval = true;
	SmsGateway *smsgateway;
	QString number;
	
	if (userlist->containsAltNick (altnick)) {
		number = userlist->byAltNick (altnick).mobile ();
		
		if ((smsgateway = smsslots->getGateway (number)) != 0) {
				smsgateway->send (number, message, QString::null, sender);
		} else {
			retval = false;
		}
	} else {
		retval = false;
	}
	
	kdebugf2();
	
	return retval;
}

bool DCOPExport::sendSMS (const QString &sender, const QString &number, const QString &message)
{
	kdebugf();
	
	bool retval = true;
	SmsGateway *smsgateway;
	
	if ((smsgateway = smsslots->getGateway (number)) != 0) {
			smsgateway->send (number, message, QString::null, sender);
	} else {
		retval = false;
	}
	
	kdebugf2();
	
	return retval;
}

void DCOPExport::quit ()
{
	kadu->quit ();
}

