#!/usr/bin/make -f

LOCALE := fr_FR.UTF-8
HAS_LOCALE := $(shell locale -a | grep $(LOCALE:UTF-8=utf8))

debian/locales/%:
	mkdir -p debian/locales
	localedef -f $(word 2,$(subst ., ,$(notdir $@))) -i $(word 1,$(subst ., ,$(notdir $@))) $@

APP_TESTS := reftest crashtest
TESTS := check xpcshell-tests $(APP_TESTS)

override_dh_auto_test: $(TESTS)

ifndef HAS_LOCALE
xpcshell-tests: export LOCPATH = $(CURDIR)/debian/locales
endif
xpcshell-tests: export LC_ALL=$(LOCALE)
$(APP_TESTS): export EXTRA_TEST_ARGS += --appname=$(CURDIR)/build-iceweasel/dist/bin/firefox
$(APP_TESTS): export GRE_HOME = $(CURDIR)/build-xulrunner/dist/bin
$(APP_TESTS): XVFB_RUN = xvfb-run -s "-screen 0 1024x768x24"

ifeq ($(DEB_BUILD_ARCH),armel)
# Force armel JIT to compile ARMv4T instructions at runtime even when the buildd
# is > ARMv4T
$(TESTS): export ARM_FORCE_PLATFORM=4
endif

$(TESTS):
	GNOME22_USER_DIR="$(CURDIR)/build-xulrunner/dist/.gnome2" \
	HOME="$(CURDIR)/build-xulrunner/dist" \
	$(XVFB_RUN) $(MAKE) -C build-xulrunner $@ 2>&1 | sed -u 's/^/$@> /'

xpcshell-tests: $(if $(HAS_LOCALE),,debian/locales/$(LOCALE))

xpcshell-tests-skip:
# APNG is not supported
	rm -f build-xulrunner/_tests/xpcshell/test_libpr0n/unit/test_encoder_apng.js
# This one fails because it relies on a sqlite bug that is fixed in the system one
# See http://hg.mozilla.org/mozilla-central/raw-rev/1192461c259d
	rm -f build-xulrunner/_tests/xpcshell/test_storage/unit/test_storage_combined_sharing.js
# This one fails because it supposes some kind of preexisting gnome/mailcap configuration
	rm -f build-xulrunner/_tests/xpcshell/test_uriloader_exthandler/unit/test_handlerService.js

override_dh_auto_clean::
	rm -rf debian/locales

$(TESTS): %: %-skip

.PHONY: test $(TESTS) $(TESTS:%=%-skip)
