package GCPlugins::GCMovieClubFR;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginMovieClubFR;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^product_info\.php\?products_id=/)
                {
                   my $url = $attr->{href} . "&language=fr"; 
                   $self->{isMovie} = 1;
                   $self->{isInfo} = 1;
                   $self->{movieIdx}++ if ($self->{movieIdx} < 0) || ($url ne $self->{movieList}[$self->{movieIdx}]->{"url"});
                   $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
        }
        else
        {
						if ($tagname eq "img")
						{
								if (($attr->{src} =~ /images\/\w*\.jpg/) && ($attr->{border} eq "0") && (!$self->{inside}->{a}))
								{
									$self->{curInfo}->{image} = "http://www.movieclub.be/catalog/" . $attr->{src} if !$self->{curInfo}->{image};
								}
						}
						elsif ($tagname eq "span")
						{
								$self->{insideName} = 1 if $attr->{class} eq "titrepers";
						}
						elsif ($tagname eq "font")
						{
								$self->{insideOrig} = 1 if ($attr->{size} eq "1") && ($attr->{color} eq "");
								$self->{insideDateOrSynopsis} = 1 if ($attr->{size} eq "2") && ($attr->{color} eq "");
						}
						elsif ($tagname eq "a")
						{
								$self->{insideActors} = 1 if $attr->{href} =~ /^product_infolist\.php\?person_id=[0-9]*&language_id=[0-9]&choice=1$/;
								$self->{insideDirector} = 1 if $attr->{href} =~ /^product_infolist\.php\?person_id=[0-9]*&language_id=[0-9]&choice=2$/;
								$self->{insideNatOrType} = 1 if $attr->{href} =~ /^\/catalog\/default\.php\?cPath=[0-9]*_[0-9]*$/;
						}
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;
            $origtext =~ s/\n//g if !$self->{insideSynopsis};

           	if ($self->{insideName})
           	{
          	  $self->{curInfo}->{title} = $origtext;
							$self->{insideName} = 0;
						}
           	elsif ($self->{insideDateOrSynopsis})
           	{
							if ($origtext =~ /^[0-9]{4}$/)
							{
          	  	$self->{curInfo}->{date} = $origtext;
							}
							else
							{
          	  	$self->{curInfo}->{synopsis} = $origtext if !$self->{curInfo}->{synopsis};
							}
							$self->{insideDateOrSynopsis} = 0;
						}
           	elsif ($self->{insideActors})
           	{
              $self->{curInfo}->{actors} .= ', ' . $origtext if ($self->{actorsCounter} < $GCPluginParser::MAX_ACTORS);
              $self->{actorsCounter}++;
              $self->{curInfo}->{actors} =~ s/^, //;
							$self->{insideActors} = 0;
						}
           	elsif ($self->{insideDirector})
           	{
              $self->{curInfo}->{director} .= ', ' .  $origtext;
              $self->{curInfo}->{director} =~ s/^, //;
							$self->{insideDirector} = 0;
						}
           	elsif ($self->{insideNatOrType})
           	{
              $self->{curInfo}->{nat} = $origtext if !$self->{curInfo}->{nat};
              $self->{curInfo}->{type} = $origtext if $self->{curInfo}->{nat} ne $origtext && !$self->{curInfo}->{type};

							$self->{insideNatOrType} = 0;
						}
          	elsif ($self->{insideTime})
           	{
          	  $self->{curInfo}->{time} = $origtext;
							$self->{insideTime} = 0;
						}
           	elsif ($self->{insideOrig})
           	{
          	  $self->{curInfo}->{orig} = $1 if $origtext =~ /\((.*)\)$/;
							$self->{insideOrig} = 0;
						}
						elsif ($self->{inside}->{strong})
						{
							$self->{insideTime} = 1 if $origtext =~ /Durée \:/;
						}
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
				$html =~ s/<a href=product_info\.php\?products_id=[0-9]*>Voir la fiche<\/a>//g;
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.movieclub.be/catalog/advanced_search.php?titre=title&textfield=$word&language=fr";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.movieclub.be/catalog/" . $url;
    }

    sub getName
    {
        return "MovieClub FR";
    }
    
    sub getImageFile
    {
        return "movieclub.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }

    sub getLang
    {
        return 'FR';
    }
    
    sub hasSearchYear
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }

    sub hasSearchActors
    {
        return 0;
    }
    
}

1;
