{
    package GCLang;
    
###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

    use strict;
    
    use base 'Exporter';
	our @EXPORT = qw(%langs @langsNames);

    use File::Basename;
    use FindBin qw($RealBin $Script);

    my $baseDir = $RealBin;
    $baseDir .= '/bin' if $Script =~ m/install$/;
    $baseDir = '..' if $Script eq '-e';
    
    our %langs;

    use Cwd;
    my $oldCwd = getcwd;
    chdir $baseDir;
    use lib '../lib/gcfilms/';
    foreach (glob "../lib/gcfilms/GCLang/*.pm")
    {
        my $lang = basename($_, '.pm');
        eval "use GCLang::$lang";
        my %tmpLang;
        eval "%tmpLang = %GCLang::${lang}::lang";
        $langs{$lang} = \%tmpLang;
    }
    chdir $oldCwd;
    our @langsNames;
    foreach (keys %langs)
    {
        push @langsNames, $langs{$_}->{LangName};
    }
    @langsNames = sort @langsNames;
    

sub addGeneratedStrings
{
    my ($lang, $hasPictures) = @_;
    
    foreach my $key(keys %{$lang->{FieldsList}})
    {
        my $value = $lang->{FieldsList}->{$key};
        $value =~ s/^.*?$lang->{Separator}(.*)$/$1/;
        #Strings in dialog box to select what has to be displayed
        # and in lists
        $lang->{Displayed}->{$key} = $value;
        $value .= $lang->{Separator} unless 
            ($key eq 'seen')
         || ($key eq 'history')
         || ($key eq 'borrower')
         || ($key eq 'lendDate')
         || ($key eq 'audio')
         || ($key eq 'subt');
        #Strings displayed in panel
        $lang->{Panel}->{$key} = $value;
    }
    $lang->{Panel}->{encoding} = $lang->{PanelEncoding};
    $lang->{Panel}->{returnDate} = $lang->{PanelReturnDate};
    #Strings in dialog box to select what has to be displayed
    $lang->{Displayed}->{actions} = $lang->{DisplayOptionsActions};
    $lang->{Displayed}->{search} = $lang->{DisplayOptionsSearch};
    ($lang->{Displayed}->{mail} = $lang->{MailTitle}) =~ s/_//g;
    $lang->{Displayed}->{info} = $lang->{PanelMovieInfo};
    $lang->{Displayed}->{perso} = $lang->{PanelPrivateInfo};
    $lang->{Displayed}->{borrowings} = $lang->{PanelLendInfo};
    $lang->{Panel}->{info} = $lang->{PanelMovieInfo};
    $lang->{Panel}->{perso} = $lang->{PanelPrivateInfo};
    $lang->{Panel}->{borrowings} = $lang->{PanelLendInfo};
    if (!$hasPictures)
    {
        $lang->{AboutLicense} =~ s/^(.*)\n.*$/$1/m;
    }
}
    
# Used to check languages (which translation are missing)
# Usage: perl -e "use GCLang; GCLang::checkLangs"
sub checkLangs
{
    my $ref = 'FR';
    my $otherRef = 'EN';
    my %results;
    
    foreach (sort keys %{$langs{$ref}})
    {
        foreach my $langName(keys %langs)
        {
            next if $langName eq $ref;
            if (! exists $langs{$langName}->{$_})
            {
                push @{$results{$langName}{error}}, $_;
            }
            else
            {
                next if $langName eq $otherRef;
                push @{$results{$langName}{warning}}, $_
                    if ($langs{$langName}->{$_} eq $langs{$ref}->{$_})
                    || ($langs{$langName}->{$_} eq $langs{$otherRef}->{$_});
            }
        }
    }
    
    foreach (keys %results)
    {
        print "\n\nLang $_\n-------\n\n";
        print "Errors:\n\n";
        foreach my $value(@{$results{$_}{error}})
        {
            print "'$value' => '",$langs{$otherRef}->{$value},"',\n";
        }
        print "\nWarnings:\n\n";
        foreach my $value(@{$results{$_}{warning}})
        {
            print "'$value' => '",$langs{$_}->{$value},"',\n";
        }
    }
}

    
}


1;
