%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2008-2010. All Rights Reserved.
%%
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%%
%% %CopyrightEnd%
%%
-module(re_testoutput1_replacement_test).
-compile(export_all).
-compile(no_native).
-include("test_server.hrl").
%% This file is generated by running run_pcre_tests:gen_repl_test("re_SUITE_data/testoutput1")
run() ->
?line <<"WkCthe quick brown foxtthe quick brown foxjthe quick brown foxPpfmthe quick brown foxthe quick brown foxy">> = iolist_to_binary(re:replace("the quick brown fox","the quick brown fox","WkC&t\\1\\1&j&Ppfm&&y",[])), 
?line <<"WkCthe quick brown foxtthe quick brown foxjthe quick brown foxPpfmthe quick brown foxthe quick brown foxy">> = iolist_to_binary(re:replace("the quick brown fox","the quick brown fox","WkC&t\\1\\1&j&Ppfm&&y",[global])), 
?line <<"The quick brown FOX">> = iolist_to_binary(re:replace("The quick brown FOX","the quick brown fox","in&&CSwx",[])), 
?line <<"The quick brown FOX">> = iolist_to_binary(re:replace("The quick brown FOX","the quick brown fox","in&&CSwx",[global])), 
?line <<"What do you know about ORtMvuTRHtLthe quick brown foxiYthe quick brown foxGi?">> = iolist_to_binary(re:replace("What do you know about the quick brown fox?","the quick brown fox","ORtMvuTRHtL&iY&Gi",[])), 
?line <<"What do you know about ORtMvuTRHtLthe quick brown foxiYthe quick brown foxGi?">> = iolist_to_binary(re:replace("What do you know about the quick brown fox?","the quick brown fox","ORtMvuTRHtL&iY&Gi",[global])), 
?line <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(re:replace("What do you know about THE QUICK BROWN FOX?","the quick brown fox","\\1nfTnvooMaxHdXgGO",[])), 
?line <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(re:replace("What do you know about THE QUICK BROWN FOX?","the quick brown fox","\\1nfTnvooMaxHdXgGO",[global])), 
?line <<"hSniFQTqBU">> = iolist_to_binary(re:replace("the quick brown fox","The quick brown fox","hSniFQTqBU",[caseless])), 
?line <<"hSniFQTqBU">> = iolist_to_binary(re:replace("the quick brown fox","The quick brown fox","hSniFQTqBU",[caseless,
                                                                                                                                                                                                                                           global])), 
?line <<"q">> = iolist_to_binary(re:replace("The quick brown FOX","The quick brown fox","q",[caseless])), 
?line <<"q">> = iolist_to_binary(re:replace("The quick brown FOX","The quick brown fox","q",[caseless,
                                                                                                                                                                                                                         global])), 
?line <<"What do you know about uJnke?">> = iolist_to_binary(re:replace("What do you know about the quick brown fox?","The quick brown fox","uJ\\1nke",[caseless])), 
?line <<"What do you know about uJnke?">> = iolist_to_binary(re:replace("What do you know about the quick brown fox?","The quick brown fox","uJ\\1nke",[caseless,
                                                                                                                                                                                                                                                                                        global])), 
?line <<"What do you know about VRUTHE QUICK BROWN FOXYgJqUVfiTHE QUICK BROWN FOXqb?">> = iolist_to_binary(re:replace("What do you know about THE QUICK BROWN FOX?","The quick brown fox","VRU&YgJqUVfi&\\1qb",[caseless])), 
?line <<"What do you know about VRUTHE QUICK BROWN FOXYgJqUVfiTHE QUICK BROWN FOXqb?">> = iolist_to_binary(re:replace("What do you know about THE QUICK BROWN FOX?","The quick brown fox","VRU&YgJqUVfi&\\1qb",[caseless,
                                                                                                                                                                                                                                                                                                              global])), 
?line <<"jeUmEaUYOfHpPURCabcd	

9;$\\?caxyz">> = iolist_to_binary(re:replace("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz","jeUmEaUYOfHpPURC&",[])), 
?line <<"jeUmEaUYOfHpPURCabcd	

9;$\\?caxyz">> = iolist_to_binary(re:replace("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz","jeUmEaUYOfHpPURC&",[global])), 
?line <<"YVh">> = iolist_to_binary(re:replace("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","YVh",[])), 
?line <<"YVh">> = iolist_to_binary(re:replace("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","YVh",[global])), 
?line <<"wDCxbqXSqpabxyzpqrrrabbxyyyypqAzzX">> = iolist_to_binary(re:replace("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","wDCxbqXSqp&X",[])), 
?line <<"wDCxbqXSqpabxyzpqrrrabbxyyyypqAzzX">> = iolist_to_binary(re:replace("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","wDCxbqXSqp&X",[global])), 
?line <<"XOnDbhuPYPfGm">> = iolist_to_binary(re:replace("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1XOnDbhuP\\1Y\\1PfGm",[])), 
?line <<"XOnDbhuPYPfGm">> = iolist_to_binary(re:replace("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1XOnDbhuP\\1Y\\1PfGm",[global])), 
?line <<"vgswmIcA">> = iolist_to_binary(re:replace("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","vgswmI\\1cA",[])), 
?line <<"vgswmIcA">> = iolist_to_binary(re:replace("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","vgswmI\\1cA",[global])), 
?line <<"YaaaabxyzpqrrrabbxyyyypqAzzOXXRaa">> = iolist_to_binary(re:replace("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","Y&OXXRaa",[])), 
?line <<"YaaaabxyzpqrrrabbxyyyypqAzzOXXRaa">> = iolist_to_binary(re:replace("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","Y&OXXRaa",[global])), 
?line <<"CAeqsXe">> = iolist_to_binary(re:replace("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1CAeq\\1s\\1Xe",[])), 
?line <<"CAeqsXe">> = iolist_to_binary(re:replace("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1CAeq\\1s\\1Xe",[global])), 
?line <<"cDLaApdgW">> = iolist_to_binary(re:replace("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","cDLaApdgW",[])), 
?line <<"cDLaApdgW">> = iolist_to_binary(re:replace("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","cDLaApdgW",[global])), 
?line <<"aLfXiUYS">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","aLf\\1XiUYS",[])), 
?line <<"aLfXiUYS">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","aLf\\1XiUYS",[global])), 
?line <<"aaabcxyzpqrrrabbxyyyypqAzzBcaaabcxyzpqrrrabbxyyyypqAzzDAyoYqGn">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1&Bc&DAyoYqGn",[])), 
?line <<"aaabcxyzpqrrrabbxyyyypqAzzBcaaabcxyzpqrrrabbxyyyypqAzzDAyoYqGn">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1&Bc&DAyoYqGn",[global])), 
?line <<"aaabcxyzpqrrrabbxyyyypqqAzzijaaabcxyzpqrrrabbxyyyypqqAzzdIBcB">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&ij&dI\\1BcB",[])), 
?line <<"aaabcxyzpqrrrabbxyyyypqqAzzijaaabcxyzpqrrrabbxyyyypqqAzzdIBcB">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&ij&dI\\1BcB",[global])), 
?line <<"qrxTuPSgEjNvkaaabcxyzpqrrrabbxyyyypqqqAzz">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1qrx\\1\\1TuPSgEjNvk&",[])), 
?line <<"qrxTuPSgEjNvkaaabcxyzpqrrrabbxyyyypqqqAzz">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1qrx\\1\\1TuPSgEjNvk&",[global])), 
?line <<"oWxyrN">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1oWx\\1y\\1rN",[])), 
?line <<"oWxyrN">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1oWx\\1y\\1rN",[global])), 
?line <<"TPbeAcarX">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1T\\1PbeAcarX",[])), 
?line <<"TPbeAcarX">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1T\\1PbeAcarX",[global])), 
?line <<"xWhhgaaabcxyzpqrrrabbxyyyypqqqqqqAzzsHcQaaabcxyzpqrrrabbxyyyypqqqqqqAzzAeU">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","xWh\\1hg&sHcQ&AeU",[])), 
?line <<"xWhhgaaabcxyzpqrrrabbxyyyypqqqqqqAzzsHcQaaabcxyzpqrrrabbxyyyypqqqqqqAzzAeU">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","xWh\\1hg&sHcQ&AeU",[global])), 
?line <<"HasuDgVdEpaaaabcxyzpqrrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","Hasu\\1\\1DgV\\1dEp&",[])), 
?line <<"HasuDgVdEpaaaabcxyzpqrrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","Hasu\\1\\1DgV\\1dEp&",[global])), 
?line <<"XWMcabxyzzpqrrrabbxyyyypqAzzIUK">> = iolist_to_binary(re:replace("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","XWMc&\\1IUK",[])), 
?line <<"XWMcabxyzzpqrrrabbxyyyypqAzzIUK">> = iolist_to_binary(re:replace("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","XWMc&\\1IUK",[global])), 
?line <<"UBljDAPnposGdT">> = iolist_to_binary(re:replace("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","UBljDAPnposGdT",[])), 
?line <<"UBljDAPnposGdT">> = iolist_to_binary(re:replace("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","UBljDAPnposGdT",[global])), 
?line <<"boTxGt">> = iolist_to_binary(re:replace("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","boTxGt",[])), 
?line <<"boTxGt">> = iolist_to_binary(re:replace("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","boTxGt",[global])), 
?line <<"mnBWBx">> = iolist_to_binary(re:replace("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","mnB\\1\\1WBx",[])), 
?line <<"mnBWBx">> = iolist_to_binary(re:replace("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","mnB\\1\\1WBx",[global])), 
?line <<"lcgIVpnY">> = iolist_to_binary(re:replace("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","lcgIVpnY\\1",[])), 
?line <<"lcgIVpnY">> = iolist_to_binary(re:replace("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","lcgIVpnY\\1",[global])), 
?line <<"aabcxyzzzpqrrrabbxyyyypqAzznutiQsQaabcxyzzzpqrrrabbxyyyypqAzzokm">> = iolist_to_binary(re:replace("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&n\\1\\1utiQsQ&o\\1km",[])), 
?line <<"aabcxyzzzpqrrrabbxyyyypqAzznutiQsQaabcxyzzzpqrrrabbxyyyypqAzzokm">> = iolist_to_binary(re:replace("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&n\\1\\1utiQsQ&o\\1km",[global])), 
?line <<"rshbaaabcxyzzzzpqrrrabbxyyyypqAzzyCaaabcxyzzzzpqrrrabbxyyyypqAzzFuphTaaabcxyzzzzpqrrrabbxyyyypqAzzb">> = iolist_to_binary(re:replace("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","rshb&yC&FuphT&b",[])), 
?line <<"rshbaaabcxyzzzzpqrrrabbxyyyypqAzzyCaaabcxyzzzzpqrrrabbxyyyypqAzzFuphTaaabcxyzzzzpqrrrabbxyyyypqAzzb">> = iolist_to_binary(re:replace("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","rshb&yC&FuphT&b",[global])), 
?line <<"aaaabcxyzzzzpqrrrabbxyyyypqAzzDpUaaaabcxyzzzzpqrrrabbxyyyypqAzzWxWLwIQUnS">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&DpU&WxW\\1LwIQUnS",[])), 
?line <<"aaaabcxyzzzzpqrrrabbxyyyypqAzzDpUaaaabcxyzzzzpqrrrabbxyyyypqAzzWxWLwIQUnS">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&DpU&WxW\\1LwIQUnS",[global])), 
?line <<"maaaabcxyzzzzpqrrrabbbxyyyypqAzzaaaabcxyzzzzpqrrrabbbxyyyypqAzzdV">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","m\\1&&dV",[])), 
?line <<"maaaabcxyzzzzpqrrrabbbxyyyypqAzzaaaabcxyzzzzpqrrrabbbxyyyypqAzzdV">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","m\\1&&dV",[global])), 
?line <<"qABAquMpjbGrEQl">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","qAB\\1A\\1quMpjbGrEQl",[])), 
?line <<"qABAquMpjbGrEQl">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","qAB\\1A\\1quMpjbGrEQl",[global])), 
?line <<"XEmwtsQHVhnjgxANa">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","XEmw\\1tsQHVhn\\1jgx\\1ANa",[])), 
?line <<"XEmwtsQHVhnjgxANa">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","XEmw\\1tsQHVhn\\1jgx\\1ANa",[global])), 
?line <<"agMMGdMqblL">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","agMMGdMq\\1blL\\1",[])), 
?line <<"agMMGdMqblL">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","agMMGdMq\\1blL\\1",[global])), 
?line <<">>>EFCLJKUGJXH">> = iolist_to_binary(re:replace(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","EFCLJKUGJXH",[])), 
?line <<">>>EFCLJKUGJXH">> = iolist_to_binary(re:replace(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","EFCLJKUGJXH",[global])), 
?line <<">IW">> = iolist_to_binary(re:replace(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1IW",[])), 
?line <<">IW">> = iolist_to_binary(re:replace(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1IW",[global])), 
?line <<">>>>uiixDteuEA">> = iolist_to_binary(re:replace(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1uiixD\\1teuEA",[])), 
?line <<">>>>uiixDteuEA">> = iolist_to_binary(re:replace(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","\\1uiixD\\1teuEA",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","vayXo\\1eo\\1H",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","vayXo\\1eo\\1H",[global])), 
?line <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","nJK",[])), 
?line <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","nJK",[global])), 
?line <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","msrV\\1",[])), 
?line <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","msrV\\1",[global])), 
?line <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","nVAVmEdY&rfTu",[])), 
?line <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(re:replace("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","nVAVmEdY&rfTu",[global])), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&G&\\1eyiM",[])), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","&G&\\1eyiM",[global])), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","AIYq\\1nFUePr&s\\1s",[])), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(re:replace("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","AIYq\\1nFUePr&s\\1s",[global])), 
?line <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","G\\1\\1XF\\1XcTk&D&Vd",[])), 
?line <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(re:replace("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz","G\\1\\1XF\\1XcTk&D&Vd",[global])), 
?line <<"NMabcYpabcatqabczzabczzReBo">> = iolist_to_binary(re:replace("abczz","^(abc){1,2}zz","NM\\1Yp\\1atq&&ReBo",[])), 
?line <<"NMabcYpabcatqabczzabczzReBo">> = iolist_to_binary(re:replace("abczz","^(abc){1,2}zz","NM\\1Yp\\1atq&&ReBo",[global])), 
?line <<"PabcabczzabcsubxWpWrabcCabcabczzBDsb">> = iolist_to_binary(re:replace("abcabczz","^(abc){1,2}zz","P&\\1subxWpWr\\1C&BDsb",[])), 
?line <<"PabcabczzabcsubxWpWrabcCabcabczzBDsb">> = iolist_to_binary(re:replace("abcabczz","^(abc){1,2}zz","P&\\1subxWpWr\\1C&BDsb",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(abc){1,2}zz","u&MSQ\\1MwaXNEFxKb\\1v\\1r",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(abc){1,2}zz","u&MSQ\\1MwaXNEFxKb\\1v\\1r",[global])), 
?line <<"zz">> = iolist_to_binary(re:replace("zz","^(abc){1,2}zz","&XIfLMiKJsG&X",[])), 
?line <<"zz">> = iolist_to_binary(re:replace("zz","^(abc){1,2}zz","&XIfLMiKJsG&X",[global])), 
?line <<"abcabcabczz">> = iolist_to_binary(re:replace("abcabcabczz","^(abc){1,2}zz","k\\1S&UT&HR\\1\\1MHKIh&mv",[])), 
?line <<"abcabcabczz">> = iolist_to_binary(re:replace("abcabcabczz","^(abc){1,2}zz","k\\1S&UT&HR\\1\\1MHKIh&mv",[global])), 
?line <<">>abczz">> = iolist_to_binary(re:replace(">>abczz","^(abc){1,2}zz","R\\1GKCdWtC&\\1ULoV",[])), 
?line <<">>abczz">> = iolist_to_binary(re:replace(">>abczz","^(abc){1,2}zz","R\\1GKCdWtC&\\1ULoV",[global])), 
?line <<"bcbcvRuVbMbcbcOSuQfOJbc">> = iolist_to_binary(re:replace("bc","^(b+?|a){1,2}?c","&bcvRuV\\1M&&OSuQfOJ\\1c",[])), 
?line <<"bcbcvRuVbMbcbcOSuQfOJbc">> = iolist_to_binary(re:replace("bc","^(b+?|a){1,2}?c","&bcvRuV\\1M&&OSuQfOJ\\1c",[global])), 
?line <<"L">> = iolist_to_binary(re:replace("bbc","^(b+?|a){1,2}?c","L",[])), 
?line <<"L">> = iolist_to_binary(re:replace("bbc","^(b+?|a){1,2}?c","L",[global])), 
?line <<"pFFAeA">> = iolist_to_binary(re:replace("bbbc","^(b+?|a){1,2}?c","pFFAeA",[])), 
?line <<"pFFAeA">> = iolist_to_binary(re:replace("bbbc","^(b+?|a){1,2}?c","pFFAeA",[global])), 
?line <<"OpEK">> = iolist_to_binary(re:replace("bac","^(b+?|a){1,2}?c","OpEK",[])), 
?line <<"OpEK">> = iolist_to_binary(re:replace("bac","^(b+?|a){1,2}?c","OpEK",[global])), 
?line <<"bbacQeabbactAVaalybbacdBwbbac">> = iolist_to_binary(re:replace("bbac","^(b+?|a){1,2}?c","&Qe\\1&tAV\\1\\1ly&dBw&",[])), 
?line <<"bbacQeabbactAVaalybbacdBwbbac">> = iolist_to_binary(re:replace("bbac","^(b+?|a){1,2}?c","&Qe\\1&tAV\\1\\1ly&dBw&",[global])), 
?line <<"atVuxqLMNgBtlattKaT">> = iolist_to_binary(re:replace("aac","^(b+?|a){1,2}?c","\\1tVuxqLMNgBtl\\1ttKaT",[])), 
?line <<"atVuxqLMNgBtlattKaT">> = iolist_to_binary(re:replace("aac","^(b+?|a){1,2}?c","\\1tVuxqLMNgBtl\\1ttKaT",[global])), 
?line <<"Y">> = iolist_to_binary(re:replace("abbbbbbbbbbbc","^(b+?|a){1,2}?c","Y",[])), 
?line <<"Y">> = iolist_to_binary(re:replace("abbbbbbbbbbbc","^(b+?|a){1,2}?c","Y",[global])), 
?line <<"bbbbbbbbbbbactDhmKI">> = iolist_to_binary(re:replace("bbbbbbbbbbbac","^(b+?|a){1,2}?c","&tDhmKI",[])), 
?line <<"bbbbbbbbbbbactDhmKI">> = iolist_to_binary(re:replace("bbbbbbbbbbbac","^(b+?|a){1,2}?c","&tDhmKI",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b+?|a){1,2}?c","qVVVR&C\\1&etAsmWh",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b+?|a){1,2}?c","qVVVR&C\\1&etAsmWh",[global])), 
?line <<"aaac">> = iolist_to_binary(re:replace("aaac","^(b+?|a){1,2}?c","jD\\1&q&KCdV&RhT",[])), 
?line <<"aaac">> = iolist_to_binary(re:replace("aaac","^(b+?|a){1,2}?c","jD\\1&q&KCdV&RhT",[global])), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(re:replace("abbbbbbbbbbbac","^(b+?|a){1,2}?c","\\1jT&nRG",[])), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(re:replace("abbbbbbbbbbbac","^(b+?|a){1,2}?c","\\1jT&nRG",[global])), 
?line <<"bcXfvbIubUfhmIRev">> = iolist_to_binary(re:replace("bc","^(b+|a){1,2}c","&Xfv\\1IubUfhmIRev",[])), 
?line <<"bcXfvbIubUfhmIRev">> = iolist_to_binary(re:replace("bc","^(b+|a){1,2}c","&Xfv\\1IubUfhmIRev",[global])), 
?line <<"EbbbbcwbbWbbcVuAOqROLkbbcwbbc">> = iolist_to_binary(re:replace("bbc","^(b+|a){1,2}c","E\\1&w\\1W&VuAOqROLk&w&",[])), 
?line <<"EbbbbcwbbWbbcVuAOqROLkbbcwbbc">> = iolist_to_binary(re:replace("bbc","^(b+|a){1,2}c","E\\1&w\\1W&VuAOqROLk&w&",[global])), 
?line <<"I">> = iolist_to_binary(re:replace("bbbc","^(b+|a){1,2}c","I",[])), 
?line <<"I">> = iolist_to_binary(re:replace("bbbc","^(b+|a){1,2}c","I",[global])), 
?line <<"dctSELQIPb">> = iolist_to_binary(re:replace("bac","^(b+|a){1,2}c","dctSELQIPb",[])), 
?line <<"dctSELQIPb">> = iolist_to_binary(re:replace("bac","^(b+|a){1,2}c","dctSELQIPb",[global])), 
?line <<"kbdarKarpbbacbbacbDO">> = iolist_to_binary(re:replace("bbac","^(b+|a){1,2}c","kbd\\1rK\\1rp&&bDO",[])), 
?line <<"kbdarKarpbbacbbacbDO">> = iolist_to_binary(re:replace("bbac","^(b+|a){1,2}c","kbd\\1rK\\1rp&&bDO",[global])), 
?line <<"aFIlpaasKQWsFRadP">> = iolist_to_binary(re:replace("aac","^(b+|a){1,2}c","\\1FIlp\\1\\1sKQWsFR\\1dP",[])), 
?line <<"aFIlpaasKQWsFRadP">> = iolist_to_binary(re:replace("aac","^(b+|a){1,2}c","\\1FIlp\\1\\1sKQWsFR\\1dP",[global])), 
?line <<"bbbbbbbbbbbfbbbbbbbbbbbHo">> = iolist_to_binary(re:replace("abbbbbbbbbbbc","^(b+|a){1,2}c","\\1f\\1Ho",[])), 
?line <<"bbbbbbbbbbbfbbbbbbbbbbbHo">> = iolist_to_binary(re:replace("abbbbbbbbbbbc","^(b+|a){1,2}c","\\1f\\1Ho",[global])), 
?line <<"bbbbbbbbbbbacOuqvbbbbbbbbbbbaclVwIa">> = iolist_to_binary(re:replace("bbbbbbbbbbbac","^(b+|a){1,2}c","&Ouqv&lVwI\\1",[])), 
?line <<"bbbbbbbbbbbacOuqvbbbbbbbbbbbaclVwIa">> = iolist_to_binary(re:replace("bbbbbbbbbbbac","^(b+|a){1,2}c","&Ouqv&lVwI\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b+|a){1,2}c","\\1sSSP\\1Tw&R&byI\\1TN",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b+|a){1,2}c","\\1sSSP\\1Tw&R&byI\\1TN",[global])), 
?line <<"aaac">> = iolist_to_binary(re:replace("aaac","^(b+|a){1,2}c","lBeqV\\1ygD\\1oXXqs",[])), 
?line <<"aaac">> = iolist_to_binary(re:replace("aaac","^(b+|a){1,2}c","lBeqV\\1ygD\\1oXXqs",[global])), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(re:replace("abbbbbbbbbbbac","^(b+|a){1,2}c","HVL\\1kIEVrx\\1hyh\\1&eY\\1R",[])), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(re:replace("abbbbbbbbbbbac","^(b+|a){1,2}c","HVL\\1kIEVrx\\1hyh\\1&eY\\1R",[global])), 
?line <<"ScHjJbbcrs">> = iolist_to_binary(re:replace("bbc","^(b+|a){1,2}?bc","ScHjJ&rs",[])), 
?line <<"ScHjJbbcrs">> = iolist_to_binary(re:replace("bbc","^(b+|a){1,2}?bc","ScHjJ&rs",[global])), 
?line <<"xbabcCeyVbabcbaXLUCoov">> = iolist_to_binary(re:replace("babc","^(b*|ba){1,2}?bc","x&CeyV&\\1XLUCoov",[])), 
?line <<"xbabcCeyVbabcbaXLUCoov">> = iolist_to_binary(re:replace("babc","^(b*|ba){1,2}?bc","x&CeyV&\\1XLUCoov",[global])), 
?line <<"HbPsbrWbbabcba">> = iolist_to_binary(re:replace("bbabc","^(b*|ba){1,2}?bc","HbPsbrW&\\1",[])), 
?line <<"HbPsbrWbbabcba">> = iolist_to_binary(re:replace("bbabc","^(b*|ba){1,2}?bc","HbPsbrW&\\1",[global])), 
?line <<"IpbababcRBSkmAw">> = iolist_to_binary(re:replace("bababc","^(b*|ba){1,2}?bc","Ip&RBSkmAw",[])), 
?line <<"IpbababcRBSkmAw">> = iolist_to_binary(re:replace("bababc","^(b*|ba){1,2}?bc","Ip&RBSkmAw",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b*|ba){1,2}?bc","e\\1\\1Tx",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(b*|ba){1,2}?bc","e\\1\\1Tx",[global])), 
?line <<"bababbc">> = iolist_to_binary(re:replace("bababbc","^(b*|ba){1,2}?bc","llyNxYhfjNKiNYM\\1&Ko",[])), 
?line <<"bababbc">> = iolist_to_binary(re:replace("bababbc","^(b*|ba){1,2}?bc","llyNxYhfjNKiNYM\\1&Ko",[global])), 
?line <<"babababc">> = iolist_to_binary(re:replace("babababc","^(b*|ba){1,2}?bc","R&TKD\\1JpYJGqtjf",[])), 
?line <<"babababc">> = iolist_to_binary(re:replace("babababc","^(b*|ba){1,2}?bc","R&TKD\\1JpYJGqtjf",[global])), 
?line <<"babcfHFubaafbYLoJba">> = iolist_to_binary(re:replace("babc","^(ba|b*){1,2}?bc","&fHFu\\1afbYLoJ\\1",[])), 
?line <<"babcfHFubaafbYLoJba">> = iolist_to_binary(re:replace("babc","^(ba|b*){1,2}?bc","&fHFu\\1afbYLoJ\\1",[global])), 
?line <<"ewhbbabc">> = iolist_to_binary(re:replace("bbabc","^(ba|b*){1,2}?bc","ewh&",[])), 
?line <<"ewhbbabc">> = iolist_to_binary(re:replace("bbabc","^(ba|b*){1,2}?bc","ewh&",[global])), 
?line <<"L">> = iolist_to_binary(re:replace("bababc","^(ba|b*){1,2}?bc","L",[])), 
?line <<"L">> = iolist_to_binary(re:replace("bababc","^(ba|b*){1,2}?bc","L",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(ba|b*){1,2}?bc","\\1wv",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(ba|b*){1,2}?bc","\\1wv",[global])), 
?line <<"bababbc">> = iolist_to_binary(re:replace("bababbc","^(ba|b*){1,2}?bc","&F",[])), 
?line <<"bababbc">> = iolist_to_binary(re:replace("bababbc","^(ba|b*){1,2}?bc","&F",[global])), 
?line <<"babababc">> = iolist_to_binary(re:replace("babababc","^(ba|b*){1,2}?bc","Yk",[])), 
?line <<"babababc">> = iolist_to_binary(re:replace("babababc","^(ba|b*){1,2}?bc","Yk",[global])), 
?line <<"rdI;zTYuI;zcdx">> = iolist_to_binary(re:replace(";z","^\\ca\\cA\\c[\\c{\\c:","rdI&TYuI&cdx\\1",[])), 
?line <<"rdI;zTYuI;zcdx">> = iolist_to_binary(re:replace(";z","^\\ca\\cA\\c[\\c{\\c:","rdI&TYuI&cdx\\1",[global])), 
?line <<"XgOhHATXLthing">> = iolist_to_binary(re:replace("athing","^[ab\\]cde]","XgO\\1hHATXL",[])), 
?line <<"XgOhHATXLthing">> = iolist_to_binary(re:replace("athing","^[ab\\]cde]","XgO\\1hHATXL",[global])), 
?line <<"xIBYFthing">> = iolist_to_binary(re:replace("bthing","^[ab\\]cde]","xIBYF",[])), 
?line <<"xIBYFthing">> = iolist_to_binary(re:replace("bthing","^[ab\\]cde]","xIBYF",[global])), 
?line <<"]lthing">> = iolist_to_binary(re:replace("]thing","^[ab\\]cde]","&l",[])), 
?line <<"]lthing">> = iolist_to_binary(re:replace("]thing","^[ab\\]cde]","&l",[global])), 
?line <<"qbsthing">> = iolist_to_binary(re:replace("cthing","^[ab\\]cde]","\\1qbs",[])), 
?line <<"qbsthing">> = iolist_to_binary(re:replace("cthing","^[ab\\]cde]","\\1qbs",[global])), 
?line <<"gyOCYsthing">> = iolist_to_binary(re:replace("dthing","^[ab\\]cde]","gyOCYs",[])), 
?line <<"gyOCYsthing">> = iolist_to_binary(re:replace("dthing","^[ab\\]cde]","gyOCYs",[global])), 
?line <<"DrUmPIeSUthing">> = iolist_to_binary(re:replace("ething","^[ab\\]cde]","DrUmP\\1IeSU",[])), 
?line <<"DrUmPIeSUthing">> = iolist_to_binary(re:replace("ething","^[ab\\]cde]","DrUmP\\1IeSU",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[ab\\]cde]","Xi\\1luACtdK",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[ab\\]cde]","Xi\\1luACtdK",[global])), 
?line <<"fthing">> = iolist_to_binary(re:replace("fthing","^[ab\\]cde]","&u&Y\\1obNLU\\1tyonhH",[])), 
?line <<"fthing">> = iolist_to_binary(re:replace("fthing","^[ab\\]cde]","&u&Y\\1obNLU\\1tyonhH",[global])), 
?line <<"[thing">> = iolist_to_binary(re:replace("[thing","^[ab\\]cde]","TVEAE&ooeuGQJgKnrqW",[])), 
?line <<"[thing">> = iolist_to_binary(re:replace("[thing","^[ab\\]cde]","TVEAE&ooeuGQJgKnrqW",[global])), 
?line <<"\\thing">> = iolist_to_binary(re:replace("\\thing","^[ab\\]cde]","vRby\\1&",[])), 
?line <<"\\thing">> = iolist_to_binary(re:replace("\\thing","^[ab\\]cde]","vRby\\1&",[global])), 
?line <<"]n]ExaxasbKqYi]CHthing">> = iolist_to_binary(re:replace("]thing","^[]cde]","&n&Ex\\1axa\\1sbKqYi&CH",[])), 
?line <<"]n]ExaxasbKqYi]CHthing">> = iolist_to_binary(re:replace("]thing","^[]cde]","&n&Ex\\1axa\\1sbKqYi&CH",[global])), 
?line <<"nLnsthing">> = iolist_to_binary(re:replace("cthing","^[]cde]","nLns",[])), 
?line <<"nLnsthing">> = iolist_to_binary(re:replace("cthing","^[]cde]","nLns",[global])), 
?line <<"dOETLdnanQKLkkVthing">> = iolist_to_binary(re:replace("dthing","^[]cde]","\\1&OET\\1L&nanQKLkkV",[])), 
?line <<"dOETLdnanQKLkkVthing">> = iolist_to_binary(re:replace("dthing","^[]cde]","\\1&OET\\1L&nanQKLkkV",[global])), 
?line <<"UKthing">> = iolist_to_binary(re:replace("ething","^[]cde]","UK",[])), 
?line <<"UKthing">> = iolist_to_binary(re:replace("ething","^[]cde]","UK",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[]cde]","OEN&h&RDky",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[]cde]","OEN&h&RDky",[global])), 
?line <<"athing">> = iolist_to_binary(re:replace("athing","^[]cde]","ADIYuoD\\1PwBWBN",[])), 
?line <<"athing">> = iolist_to_binary(re:replace("athing","^[]cde]","ADIYuoD\\1PwBWBN",[global])), 
?line <<"fthing">> = iolist_to_binary(re:replace("fthing","^[]cde]","H&UGGJFd\\1Ys\\1xgEg",[])), 
?line <<"fthing">> = iolist_to_binary(re:replace("fthing","^[]cde]","H&UGGJFd\\1Ys\\1xgEg",[global])), 
?line <<"yipHChvHfthing">> = iolist_to_binary(re:replace("fthing","^[^ab\\]cde]","yi\\1pHC\\1hvH&",[])), 
?line <<"yipHChvHfthing">> = iolist_to_binary(re:replace("fthing","^[^ab\\]cde]","yi\\1pHC\\1hvH&",[global])), 
?line <<"pthing">> = iolist_to_binary(re:replace("[thing","^[^ab\\]cde]","p",[])), 
?line <<"pthing">> = iolist_to_binary(re:replace("[thing","^[^ab\\]cde]","p",[global])), 
?line <<"nvbthing">> = iolist_to_binary(re:replace("\\thing","^[^ab\\]cde]","n\\1v\\1b",[])), 
?line <<"nvbthing">> = iolist_to_binary(re:replace("\\thing","^[^ab\\]cde]","n\\1v\\1b",[global])), 
?line <<"o*r*CQayoALTVo** Failers">> = iolist_to_binary(re:replace("*** Failers","^[^ab\\]cde]","o&r&CQa\\1yoALTVo\\1",[])), 
?line <<"o*r*CQayoALTVo** Failers">> = iolist_to_binary(re:replace("*** Failers","^[^ab\\]cde]","o&r&CQa\\1yoALTVo\\1",[global])), 
?line <<"athing">> = iolist_to_binary(re:replace("athing","^[^ab\\]cde]","k\\1&MCQ",[])), 
?line <<"athing">> = iolist_to_binary(re:replace("athing","^[^ab\\]cde]","k\\1&MCQ",[global])), 
?line <<"bthing">> = iolist_to_binary(re:replace("bthing","^[^ab\\]cde]","XKeFQEPnv",[])), 
?line <<"bthing">> = iolist_to_binary(re:replace("bthing","^[^ab\\]cde]","XKeFQEPnv",[global])), 
?line <<"]thing">> = iolist_to_binary(re:replace("]thing","^[^ab\\]cde]","\\1",[])), 
?line <<"]thing">> = iolist_to_binary(re:replace("]thing","^[^ab\\]cde]","\\1",[global])), 
?line <<"cthing">> = iolist_to_binary(re:replace("cthing","^[^ab\\]cde]","NU",[])), 
?line <<"cthing">> = iolist_to_binary(re:replace("cthing","^[^ab\\]cde]","NU",[global])), 
?line <<"dthing">> = iolist_to_binary(re:replace("dthing","^[^ab\\]cde]","GVUo\\1m&I",[])), 
?line <<"dthing">> = iolist_to_binary(re:replace("dthing","^[^ab\\]cde]","GVUo\\1m&I",[global])), 
?line <<"ething">> = iolist_to_binary(re:replace("ething","^[^ab\\]cde]","Ms\\1&GwiawlCHng&EEX",[])), 
?line <<"ething">> = iolist_to_binary(re:replace("ething","^[^ab\\]cde]","Ms\\1&GwiawlCHng&EEX",[global])), 
?line <<"lqtFwcAYthing">> = iolist_to_binary(re:replace("athing","^[^]cde]","lqtFwcAY",[])), 
?line <<"lqtFwcAYthing">> = iolist_to_binary(re:replace("athing","^[^]cde]","lqtFwcAY",[global])), 
?line <<"Fxtpjthing">> = iolist_to_binary(re:replace("fthing","^[^]cde]","Fxt\\1pj",[])), 
?line <<"Fxtpjthing">> = iolist_to_binary(re:replace("fthing","^[^]cde]","Fxt\\1pj",[global])), 
?line <<"xT*oD*U** Failers">> = iolist_to_binary(re:replace("*** Failers","^[^]cde]","xT&oD\\1&U",[])), 
?line <<"xT*oD*U** Failers">> = iolist_to_binary(re:replace("*** Failers","^[^]cde]","xT&oD\\1&U",[global])), 
?line <<"]thing">> = iolist_to_binary(re:replace("]thing","^[^]cde]","R\\1M&\\1m",[])), 
?line <<"]thing">> = iolist_to_binary(re:replace("]thing","^[^]cde]","R\\1M&\\1m",[global])), 
?line <<"cthing">> = iolist_to_binary(re:replace("cthing","^[^]cde]","\\1tF\\1WOFN&fB",[])), 
?line <<"cthing">> = iolist_to_binary(re:replace("cthing","^[^]cde]","\\1tF\\1WOFN&fB",[global])), 
?line <<"dthing">> = iolist_to_binary(re:replace("dthing","^[^]cde]","y\\1I&MoqRPG&GQa\\1l",[])), 
?line <<"dthing">> = iolist_to_binary(re:replace("dthing","^[^]cde]","y\\1I&MoqRPG&GQa\\1l",[global])), 
?line <<"ething">> = iolist_to_binary(re:replace("ething","^[^]cde]","AsxwUn\\1GqkWNdgRJk",[])), 
?line <<"ething">> = iolist_to_binary(re:replace("ething","^[^]cde]","AsxwUn\\1GqkWNdgRJk",[global])), 
?line <<"RornKmOnaFrtWgtW">> = iolist_to_binary(re:replace("","^\\","R\\1o\\1r\\1nKmOnaFr&tWgtW",[])), 
?line <<"RornKmOnaFrtWgtW">> = iolist_to_binary(re:replace("","^\\","R\\1o\\1r\\1nKmOnaFr&tWgtW",[global])), 
?line <<"ufbmbfOYuKwfEdx">> = iolist_to_binary(re:replace("","^","ufbmbfOYuK&wf&E&\\1dx",[])), 
?line <<"ufbmbfOYuKwfEdx">> = iolist_to_binary(re:replace("","^","ufbmbfOYuK&wf&E&\\1dx",[global])), 
?line <<"oAdJme0jw">> = iolist_to_binary(re:replace("0","^[0-9]+$","oAdJme\\1&jw",[])), 
?line <<"oAdJme0jw">> = iolist_to_binary(re:replace("0","^[0-9]+$","oAdJme\\1&jw",[global])), 
?line <<"1aoKN">> = iolist_to_binary(re:replace("1","^[0-9]+$","&aoKN",[])), 
?line <<"1aoKN">> = iolist_to_binary(re:replace("1","^[0-9]+$","&aoKN",[global])), 
?line <<"tIHn">> = iolist_to_binary(re:replace("2","^[0-9]+$","tIHn\\1",[])), 
?line <<"tIHn">> = iolist_to_binary(re:replace("2","^[0-9]+$","tIHn\\1",[global])), 
?line <<"wgA3cJbrrCyMvMXM3">> = iolist_to_binary(re:replace("3","^[0-9]+$","wgA&cJbrrCyMv\\1M\\1XM&",[])), 
?line <<"wgA3cJbrrCyMvMXM3">> = iolist_to_binary(re:replace("3","^[0-9]+$","wgA&cJbrrCyMv\\1M\\1XM&",[global])), 
?line <<"huUpJ">> = iolist_to_binary(re:replace("4","^[0-9]+$","huUpJ",[])), 
?line <<"huUpJ">> = iolist_to_binary(re:replace("4","^[0-9]+$","huUpJ",[global])), 
?line <<"Fe5F5">> = iolist_to_binary(re:replace("5","^[0-9]+$","F\\1e&F&",[])), 
?line <<"Fe5F5">> = iolist_to_binary(re:replace("5","^[0-9]+$","F\\1e&F&",[global])), 
?line <<"HJ">> = iolist_to_binary(re:replace("6","^[0-9]+$","HJ",[])), 
?line <<"HJ">> = iolist_to_binary(re:replace("6","^[0-9]+$","HJ",[global])), 
?line <<"e">> = iolist_to_binary(re:replace("7","^[0-9]+$","e",[])), 
?line <<"e">> = iolist_to_binary(re:replace("7","^[0-9]+$","e",[global])), 
?line <<"Fmds88NtMX">> = iolist_to_binary(re:replace("8","^[0-9]+$","F\\1mds&&Nt\\1MX",[])), 
?line <<"Fmds88NtMX">> = iolist_to_binary(re:replace("8","^[0-9]+$","F\\1mds&&Nt\\1MX",[global])), 
?line <<"99cE9SqMch">> = iolist_to_binary(re:replace("9","^[0-9]+$","&&cE&\\1SqMch",[])), 
?line <<"99cE9SqMch">> = iolist_to_binary(re:replace("9","^[0-9]+$","&&cE&\\1SqMch",[global])), 
?line <<"xhR">> = iolist_to_binary(re:replace("10","^[0-9]+$","xhR",[])), 
?line <<"xhR">> = iolist_to_binary(re:replace("10","^[0-9]+$","xhR",[global])), 
?line <<"j100">> = iolist_to_binary(re:replace("100","^[0-9]+$","j&",[])), 
?line <<"j100">> = iolist_to_binary(re:replace("100","^[0-9]+$","j&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[0-9]+$","SR&tOYsEgJid&hfCF",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[0-9]+$","SR&tOYsEgJid&hfCF",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","^[0-9]+$","JK&",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","^[0-9]+$","JK&",[global])), 
?line <<"rXjkB">> = iolist_to_binary(re:replace("enter","^.*nter","rXjkB",[])), 
?line <<"rXjkB">> = iolist_to_binary(re:replace("enter","^.*nter","rXjkB",[global])), 
?line <<"oOEtqV">> = iolist_to_binary(re:replace("inter","^.*nter","oO\\1EtqV",[])), 
?line <<"oOEtqV">> = iolist_to_binary(re:replace("inter","^.*nter","oO\\1EtqV",[global])), 
?line <<"">> = iolist_to_binary(re:replace("uponter","^.*nter","\\1",[])), 
?line <<"">> = iolist_to_binary(re:replace("uponter","^.*nter","\\1",[global])), 
?line <<"SODUcOgFnbuQEN">> = iolist_to_binary(re:replace("xxx0","^xxx[0-9]+$","\\1\\1SODU\\1\\1cOgFnbuQEN",[])), 
?line <<"SODUcOgFnbuQEN">> = iolist_to_binary(re:replace("xxx0","^xxx[0-9]+$","\\1\\1SODU\\1\\1cOgFnbuQEN",[global])), 
?line <<"hsacOxxx1234kudxxx1234sEIrIdI">> = iolist_to_binary(re:replace("xxx1234","^xxx[0-9]+$","hsacO\\1&kud&s\\1EIrIdI\\1",[])), 
?line <<"hsacOxxx1234kudxxx1234sEIrIdI">> = iolist_to_binary(re:replace("xxx1234","^xxx[0-9]+$","hsacO\\1&kud&s\\1EIrIdI\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^xxx[0-9]+$","e",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^xxx[0-9]+$","e",[global])), 
?line <<"xxx">> = iolist_to_binary(re:replace("xxx","^xxx[0-9]+$","oSBYD&M",[])), 
?line <<"xxx">> = iolist_to_binary(re:replace("xxx","^xxx[0-9]+$","oSBYD&M",[global])), 
?line <<"x123HgGUYCx123PowSBtYb">> = iolist_to_binary(re:replace("x123","^.+[0-9][0-9][0-9]$","&HgGUYC&PowSBtY\\1b",[])), 
?line <<"x123HgGUYCx123PowSBtYb">> = iolist_to_binary(re:replace("x123","^.+[0-9][0-9][0-9]$","&HgGUYC&PowSBtY\\1b",[global])), 
?line <<"mEVxx123SNuYPQIaJ">> = iolist_to_binary(re:replace("xx123","^.+[0-9][0-9][0-9]$","mE\\1V\\1&SNuYPQIa\\1J",[])), 
?line <<"mEVxx123SNuYPQIaJ">> = iolist_to_binary(re:replace("xx123","^.+[0-9][0-9][0-9]$","mE\\1V\\1&SNuYPQIa\\1J",[global])), 
?line <<"l123456O123456">> = iolist_to_binary(re:replace("123456","^.+[0-9][0-9][0-9]$","l&O&",[])), 
?line <<"l123456O123456">> = iolist_to_binary(re:replace("123456","^.+[0-9][0-9][0-9]$","l&O&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.+[0-9][0-9][0-9]$","MX&hxvs",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.+[0-9][0-9][0-9]$","MX&hxvs",[global])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^.+[0-9][0-9][0-9]$","RBYgTXkgO&TLdWqjEUps",[])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^.+[0-9][0-9][0-9]$","RBYgTXkgO&TLdWqjEUps",[global])), 
?line <<"fgx1234">> = iolist_to_binary(re:replace("x1234","^.+[0-9][0-9][0-9]$","fg&",[])), 
?line <<"fgx1234">> = iolist_to_binary(re:replace("x1234","^.+[0-9][0-9][0-9]$","fg&",[global])), 
?line <<"FLbkgx123RdPrD">> = iolist_to_binary(re:replace("x123","^.+?[0-9][0-9][0-9]$","FLbkg&R\\1dPrD",[])), 
?line <<"FLbkgx123RdPrD">> = iolist_to_binary(re:replace("x123","^.+?[0-9][0-9][0-9]$","FLbkg&R\\1dPrD",[global])), 
?line <<"C">> = iolist_to_binary(re:replace("xx123","^.+?[0-9][0-9][0-9]$","C",[])), 
?line <<"C">> = iolist_to_binary(re:replace("xx123","^.+?[0-9][0-9][0-9]$","C",[global])), 
?line <<"oWjVDKTAoaLU">> = iolist_to_binary(re:replace("123456","^.+?[0-9][0-9][0-9]$","oW\\1jVDK\\1TAoaLU",[])), 
?line <<"oWjVDKTAoaLU">> = iolist_to_binary(re:replace("123456","^.+?[0-9][0-9][0-9]$","oW\\1jVDK\\1TAoaLU",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.+?[0-9][0-9][0-9]$","xA&\\1sIV",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.+?[0-9][0-9][0-9]$","xA&\\1sIV",[global])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^.+?[0-9][0-9][0-9]$","ONX&",[])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^.+?[0-9][0-9][0-9]$","ONX&",[global])), 
?line <<"oLgQtiSmGx1234wqbuoRB">> = iolist_to_binary(re:replace("x1234","^.+?[0-9][0-9][0-9]$","\\1oLgQtiSm\\1\\1G&wqbuoRB",[])), 
?line <<"oLgQtiSmGx1234wqbuoRB">> = iolist_to_binary(re:replace("x1234","^.+?[0-9][0-9][0-9]$","\\1oLgQtiSm\\1\\1G&wqbuoRB",[global])), 
?line <<"mcpuCvaabc!pqr=apquxz.ixr.zzz.ac.ukgabc!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","mcpuCva&g&",[])), 
?line <<"mcpuCvaabc!pqr=apquxz.ixr.zzz.ac.ukgabc!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","mcpuCva&g&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","J&a\\1HaapJjylMMyeA\\1e",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","J&a\\1HaapJjylMMyeA\\1e",[global])), 
?line <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","FOOFh&nQLU\\1c",[])), 
?line <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","FOOFh&nQLU\\1c",[global])), 
?line <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","H\\1G",[])), 
?line <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","H\\1G",[global])), 
?line <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","&tBS&",[])), 
?line <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(re:replace("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","&tBS&",[global])), 
?line <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(re:replace("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","Gd&\\1CN\\1",[])), 
?line <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(re:replace("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$","Gd&\\1CN\\1",[global])), 
?line <<"Well, we need a colonGTdcJbUips: somewhere">> = iolist_to_binary(re:replace("Well, we need a colon: somewhere",":","GTdc\\1J\\1bUips\\1&",[])), 
?line <<"Well, we need a colonGTdcJbUips: somewhere">> = iolist_to_binary(re:replace("Well, we need a colon: somewhere",":","GTdc\\1J\\1bUips\\1&",[global])), 
?line <<"*** Fail if we don't">> = iolist_to_binary(re:replace("*** Fail if we don't",":","d",[])), 
?line <<"*** Fail if we don't">> = iolist_to_binary(re:replace("*** Fail if we don't",":","d",[global])), 
?line <<"0abcDqVs0abc0abcptNR">> = iolist_to_binary(re:replace("0abc","([\\da-f:]+)$","\\1DqVs\\1\\1ptNR",[caseless])), 
?line <<"0abcDqVs0abc0abcptNR">> = iolist_to_binary(re:replace("0abc","([\\da-f:]+)$","\\1DqVs\\1\\1ptNR",[caseless,
                                                                                                                                                                                                                    global])), 
?line <<"abctJK">> = iolist_to_binary(re:replace("abc","([\\da-f:]+)$","&tJK",[caseless])), 
?line <<"abctJK">> = iolist_to_binary(re:replace("abc","([\\da-f:]+)$","&tJK",[caseless,
                                                                                                                                                                                      global])), 
?line <<"quighClnfedRB">> = iolist_to_binary(re:replace("fed","([\\da-f:]+)$","quighCln\\1RB",[caseless])), 
?line <<"quighClnfedRB">> = iolist_to_binary(re:replace("fed","([\\da-f:]+)$","quighCln\\1RB",[caseless,
                                                                                                                                                                                                        global])), 
?line <<"ENd">> = iolist_to_binary(re:replace("E","([\\da-f:]+)$","\\1Nd",[caseless])), 
?line <<"ENd">> = iolist_to_binary(re:replace("E","([\\da-f:]+)$","\\1Nd",[caseless,
                                                                                                                                                                                    global])), 
?line <<"o::U::lkIj::XoRWPah::s">> = iolist_to_binary(re:replace("::","([\\da-f:]+)$","o&U&lkIj\\1XoRWPah&s",[caseless])), 
?line <<"o::U::lkIj::XoRWPah::s">> = iolist_to_binary(re:replace("::","([\\da-f:]+)$","o&U&lkIj\\1XoRWPah&s",[caseless,
                                                                                                                                                                                                                       global])), 
?line <<"ab5f03:12C0::932eONbt5f03:12C0::932ehnfLI5f03:12C0::932esqYx5f03:12C0::932e">> = iolist_to_binary(re:replace("5f03:12C0::932e","([\\da-f:]+)$","ab&ONbt\\1hnfLI\\1sqYx&",[caseless])), 
?line <<"ab5f03:12C0::932eONbt5f03:12C0::932ehnfLI5f03:12C0::932esqYx5f03:12C0::932e">> = iolist_to_binary(re:replace("5f03:12C0::932e","([\\da-f:]+)$","ab&ONbt\\1hnfLI\\1sqYx&",[caseless,
                                                                                                                                                                                                                                                       global])), 
?line <<"fed OAMdefijvdef">> = iolist_to_binary(re:replace("fed def","([\\da-f:]+)$","OAM\\1ijv&",[caseless])), 
?line <<"fed OAMdefijvdef">> = iolist_to_binary(re:replace("fed def","([\\da-f:]+)$","OAM\\1ijv&",[caseless,
                                                                                                                                                                                                           global])), 
?line <<"Any old stuSVffaffeYffCjDlYffhWTMo">> = iolist_to_binary(re:replace("Any old stuff","([\\da-f:]+)$","SV&a\\1eY&CjDlY&hWTMo",[caseless])), 
?line <<"Any old stuSVffaffeYffCjDlYffhWTMo">> = iolist_to_binary(re:replace("Any old stuff","([\\da-f:]+)$","SV&a\\1eY&CjDlY&hWTMo",[caseless,
                                                                                                                                                                                                                                               global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","([\\da-f:]+)$","j&R\\1oXiR",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","([\\da-f:]+)$","j&R\\1oXiR",[caseless,
                                                                                                                                                                                                                   global])), 
?line <<"0zzz">> = iolist_to_binary(re:replace("0zzz","([\\da-f:]+)$","&HUuWH\\1&VEg",[caseless])), 
?line <<"0zzz">> = iolist_to_binary(re:replace("0zzz","([\\da-f:]+)$","&HUuWH\\1&VEg",[caseless,
                                                                                                                                                                                                            global])), 
?line <<"gzzz">> = iolist_to_binary(re:replace("gzzz","([\\da-f:]+)$","l&n&p&DKUsLBFC",[caseless])), 
?line <<"gzzz">> = iolist_to_binary(re:replace("gzzz","([\\da-f:]+)$","l&n&p&DKUsLBFC",[caseless,
                                                                                                                                                                                                              global])), 
?line <<"fed ">> = iolist_to_binary(re:replace("fed ","([\\da-f:]+)$","KuLffd&Y",[caseless])), 
?line <<"fed ">> = iolist_to_binary(re:replace("fed ","([\\da-f:]+)$","KuLffd&Y",[caseless,
                                                                                                                                                                                                global])), 
?line <<"Any old rubbish">> = iolist_to_binary(re:replace("Any old rubbish","([\\da-f:]+)$","Mid\\1",[caseless])), 
?line <<"Any old rubbish">> = iolist_to_binary(re:replace("Any old rubbish","([\\da-f:]+)$","Mid\\1",[caseless,
                                                                                                                                                                                                                  global])), 
?line <<"g.1.2.3WLxQ1s">> = iolist_to_binary(re:replace(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","g&WLxQ\\1s",[])), 
?line <<"g.1.2.3WLxQ1s">> = iolist_to_binary(re:replace(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","g&WLxQ\\1s",[global])), 
?line <<"12Oy">> = iolist_to_binary(re:replace("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","\\1Oy",[])), 
?line <<"12Oy">> = iolist_to_binary(re:replace("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","\\1Oy",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","eX\\1nRbXcnyEu",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","eX\\1nRbXcnyEu",[global])), 
?line <<".1.2.3333">> = iolist_to_binary(re:replace(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","&iIBylLhNq",[])), 
?line <<".1.2.3333">> = iolist_to_binary(re:replace(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","&iIBylLhNq",[global])), 
?line <<"1.2.3">> = iolist_to_binary(re:replace("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","\\1G&pFELr\\1\\1&\\1HPX",[])), 
?line <<"1.2.3">> = iolist_to_binary(re:replace("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","\\1G&pFELr\\1\\1&\\1HPX",[global])), 
?line <<"1234.2.3">> = iolist_to_binary(re:replace("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","&qtoJnh\\1h",[])), 
?line <<"1234.2.3">> = iolist_to_binary(re:replace("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$","&qtoJnh\\1h",[global])), 
?line <<"eaSBc111LbN">> = iolist_to_binary(re:replace("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","eaSBc\\1\\1\\1LbN",[])), 
?line <<"eaSBc111LbN">> = iolist_to_binary(re:replace("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","eaSBc\\1\\1\\1LbN",[global])), 
?line <<"1    IN    SOA    non-sp1    non-sp2   (yranl1    IN    SOA    non-sp1    non-sp2   (kU">> = iolist_to_binary(re:replace("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","&yranl&kU",[])), 
?line <<"1    IN    SOA    non-sp1    non-sp2   (yranl1    IN    SOA    non-sp1    non-sp2   (kU">> = iolist_to_binary(re:replace("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","&yranl&kU",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","W",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","W",[global])), 
?line <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(re:replace("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","UyNVyrR",[])), 
?line <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(re:replace("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$","UyNVyrR",[global])), 
?line <<"pbeGIhIlhvhv">> = iolist_to_binary(re:replace("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","pbeGIhIl\\1hvhv",[])), 
?line <<"pbeGIhIlhvhv">> = iolist_to_binary(re:replace("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","pbeGIhIl\\1hvhv",[global])), 
?line <<"gFDyTxSYOppWiRv">> = iolist_to_binary(re:replace("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","gFDyTxSYOppWiR\\1v",[])), 
?line <<"gFDyTxSYOppWiRv">> = iolist_to_binary(re:replace("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","gFDyTxSYOppWiR\\1v",[global])), 
?line <<"HSc2.vOMD">> = iolist_to_binary(re:replace("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","HSc&\\1vO\\1MD\\1",[])), 
?line <<"HSc2.vOMD">> = iolist_to_binary(re:replace("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","HSc&\\1vO\\1MD\\1",[global])), 
?line <<".pq-rd.pq-rG.pq-rUab-c.pq-r.HCGaTI">> = iolist_to_binary(re:replace("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","\\1d\\1G\\1U&HCGaTI",[])), 
?line <<".pq-rd.pq-rG.pq-rUab-c.pq-r.HCGaTI">> = iolist_to_binary(re:replace("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","\\1d\\1G\\1U&HCGaTI",[global])), 
?line <<"RwF">> = iolist_to_binary(re:replace("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","RwF",[])), 
?line <<"RwF">> = iolist_to_binary(re:replace("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","RwF",[global])), 
?line <<"oAJdUx-.y-.GMx-.y-.iBCRNx-.y-.wBW">> = iolist_to_binary(re:replace("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","oAJdU&GM&iBCRN&wBW",[])), 
?line <<"oAJdUx-.y-.GMx-.y-.iBCRNx-.y-.wBW">> = iolist_to_binary(re:replace("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","oAJdU&GM&iBCRN&wBW",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","wwA&\\1snkRSCcfnG&S",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","wwA&\\1snkRSCcfnG&S",[global])), 
?line <<"-abc.peq.">> = iolist_to_binary(re:replace("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","YaFu&cvVYqVy",[])), 
?line <<"-abc.peq.">> = iolist_to_binary(re:replace("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$","YaFu&cvVYqVy",[global])), 
?line <<"*.aXojEWCW">> = iolist_to_binary(re:replace("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","&\\1XojEWCW",[])), 
?line <<"*.aXojEWCW">> = iolist_to_binary(re:replace("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","&\\1XojEWCW",[global])), 
?line <<"djXR0-a0-aFXv*.b0-awEtv">> = iolist_to_binary(re:replace("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","djXR\\1\\1FXv&wEtv",[])), 
?line <<"djXR0-a0-aFXv*.b0-awEtv">> = iolist_to_binary(re:replace("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","djXR\\1\\1FXv&wEtv",[global])), 
?line <<"*.c3-b.cregb">> = iolist_to_binary(re:replace("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","&regb",[])), 
?line <<"*.c3-b.cregb">> = iolist_to_binary(re:replace("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","&regb",[global])), 
?line <<"Vlm">> = iolist_to_binary(re:replace("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","Vlm",[])), 
?line <<"Vlm">> = iolist_to_binary(re:replace("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","Vlm",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","Vxm\\1SKnM",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","Vxm\\1SKnM",[global])), 
?line <<"*.0">> = iolist_to_binary(re:replace("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","n\\1",[])), 
?line <<"*.0">> = iolist_to_binary(re:replace("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","n\\1",[global])), 
?line <<"*.a-">> = iolist_to_binary(re:replace("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","SbmRQSxio",[])), 
?line <<"*.a-">> = iolist_to_binary(re:replace("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","SbmRQSxio",[global])), 
?line <<"*.a-b.c-">> = iolist_to_binary(re:replace("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","xINKaLRww\\1&\\1",[])), 
?line <<"*.a-b.c-">> = iolist_to_binary(re:replace("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","xINKaLRww\\1&\\1",[global])), 
?line <<"*.c-a.0-c">> = iolist_to_binary(re:replace("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","akuY\\1pMWNGWjJ\\1oFTV\\1t",[])), 
?line <<"*.c-a.0-c">> = iolist_to_binary(re:replace("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$","akuY\\1pMWNGWjJ\\1oFTV\\1t",[global])), 
?line <<"Dy">> = iolist_to_binary(re:replace("abde","^(?=ab(de))(abd)(e)","Dy",[])), 
?line <<"Dy">> = iolist_to_binary(re:replace("abde","^(?=ab(de))(abd)(e)","Dy",[global])), 
?line <<"Sf">> = iolist_to_binary(re:replace("abdf","^(?!(ab)de|x)(abd)(f)","Sf",[])), 
?line <<"Sf">> = iolist_to_binary(re:replace("abdf","^(?!(ab)de|x)(abd)(f)","Sf",[global])), 
?line <<"IabcdJcd">> = iolist_to_binary(re:replace("abcd","^(?=(ab(cd)))(ab)","I\\1J",[])), 
?line <<"IabcdJcd">> = iolist_to_binary(re:replace("abcd","^(?=(ab(cd)))(ab)","I\\1J",[global])), 
?line <<"rvnE.d">> = iolist_to_binary(re:replace("a.b.c.d","^[\\da-f](\\.[\\da-f])*$","rvnE\\1",[caseless])), 
?line <<"rvnE.d">> = iolist_to_binary(re:replace("a.b.c.d","^[\\da-f](\\.[\\da-f])*$","rvnE\\1",[caseless,
                                                                                                                                                                                                                            global])), 
?line <<"niA.B.C.DL.DCGxjcuA.B.C.DhA.B.C.DT.DA.B.C.D.DM">> = iolist_to_binary(re:replace("A.B.C.D","^[\\da-f](\\.[\\da-f])*$","ni&L\\1CGxjcu&h&T\\1&\\1M",[caseless])), 
?line <<"niA.B.C.DL.DCGxjcuA.B.C.DhA.B.C.DT.DA.B.C.D.DM">> = iolist_to_binary(re:replace("A.B.C.D","^[\\da-f](\\.[\\da-f])*$","ni&L\\1CGxjcu&h&T\\1&\\1M",[caseless,
                                                                                                                                                                                                                                                                      global])), 
?line <<"wARa.b.c.1.2.3.Ca.b.c.1.2.3.C.CpUAa.b.c.1.2.3.Cg">> = iolist_to_binary(re:replace("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$","wAR&&\\1pUA&g",[caseless])), 
?line <<"wARa.b.c.1.2.3.Ca.b.c.1.2.3.C.CpUAa.b.c.1.2.3.Cg">> = iolist_to_binary(re:replace("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$","wAR&&\\1pUA&g",[caseless,
                                                                                                                                                                                                                                                       global])), 
?line <<"a">> = iolist_to_binary(re:replace("\"1234\"","^\\\".*\\\"\\s*(;.*)?$","\\1a",[])), 
?line <<"a">> = iolist_to_binary(re:replace("\"1234\"","^\\\".*\\\"\\s*(;.*)?$","\\1a",[global])), 
?line <<"CIv">> = iolist_to_binary(re:replace("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$","CIv",[])), 
?line <<"CIv">> = iolist_to_binary(re:replace("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$","CIv",[global])), 
?line <<"; rhubarbK">> = iolist_to_binary(re:replace("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$","\\1K",[])), 
?line <<"; rhubarbK">> = iolist_to_binary(re:replace("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$","\\1K",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\\".*\\\"\\s*(;.*)?$","aWrdsUS\\1QSjQ&dFoGfF",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\\".*\\\"\\s*(;.*)?$","aWrdsUS\\1QSjQ&dFoGfF",[global])), 
?line <<"\"1234\" : things">> = iolist_to_binary(re:replace("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$","khMGlmiUM&d\\1\\1GGb",[])), 
?line <<"\"1234\" : things">> = iolist_to_binary(re:replace("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$","khMGlmiUM&d\\1\\1GGb",[global])), 
?line <<"ddsaVnvP">> = iolist_to_binary(re:replace("","^$","ddsaVnvP",[])), 
?line <<"ddsaVnvP">> = iolist_to_binary(re:replace("","^$","ddsaVnvP",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^$","d\\1yl\\1chv&DYUrRBp",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^$","d\\1yl\\1chv&DYUrRBp",[global])), 
?line <<"ubIEeu">> = iolist_to_binary(re:replace("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","ubIEeu",[extended])), 
?line <<"ubIEeu">> = iolist_to_binary(re:replace("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","ubIEeu",[extended,
                                                                                                                                                                                                                                                                                                       global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","hTyFd&e\\1&PttRSXjwggW",[extended])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","hTyFd&e\\1&PttRSXjwggW",[extended,
                                                                                                                                                                                                                                                                                                                                                        global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","RUKr",[extended])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","RUKr",[extended,
                                                                                                                                                                                                                                                                                                 global])), 
?line <<"ab cde">> = iolist_to_binary(re:replace("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","&wELTyPo&oJqp&vLg\\1T",[extended])), 
?line <<"ab cde">> = iolist_to_binary(re:replace("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","&wELTyPo&oJqp&vLg\\1T",[extended,
                                                                                                                                                                                                                                                                                                                                             global])), 
?line <<"NNDSkqab cNfQkVqmWj">> = iolist_to_binary(re:replace("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","NN\\1DSk\\1q&NfQkVqmWj",[])), 
?line <<"NNDSkqab cNfQkVqmWj">> = iolist_to_binary(re:replace("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","NN\\1DSk\\1q&NfQkVqmWj",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","vkwk\\1js\\1pepFK\\1\\1Wa&g",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","vkwk\\1js\\1pepFK\\1\\1Wa&g",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","\\1&fYSPEB",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","\\1&fYSPEB",[global])), 
?line <<"ab cde">> = iolist_to_binary(re:replace("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","\\1D\\1\\1\\1by&lUP\\1jTlVc",[])), 
?line <<"ab cde">> = iolist_to_binary(re:replace("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)","\\1D\\1\\1\\1by&lUP\\1jTlVc",[global])), 
?line <<"Pca bcdDXLbDTDa bcdja bcdTa bcdX">> = iolist_to_binary(re:replace("a bcd","^   a\\ b[c ]d       $","Pc&DXLbDTD&j&T&X\\1",[extended])), 
?line <<"Pca bcdDXLbDTDa bcdja bcdTa bcdX">> = iolist_to_binary(re:replace("a bcd","^   a\\ b[c ]d       $","Pc&DXLbDTD&j&T&X\\1",[extended,
                                                                                                                                                                                                                                              global])), 
?line <<"cbruWa b dWvF">> = iolist_to_binary(re:replace("a b d","^   a\\ b[c ]d       $","cbruW&WvF\\1",[extended])), 
?line <<"cbruWa b dWvF">> = iolist_to_binary(re:replace("a b d","^   a\\ b[c ]d       $","cbruW&WvF\\1",[extended,
                                                                                                                                                                                                                             global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^   a\\ b[c ]d       $","xLsLvmNGGbWjEqU\\1q",[extended])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^   a\\ b[c ]d       $","xLsLvmNGGbWjEqU\\1q",[extended,
                                                                                                                                                                                                                                                      global])), 
?line <<"abcd">> = iolist_to_binary(re:replace("abcd","^   a\\ b[c ]d       $","QvID",[extended])), 
?line <<"abcd">> = iolist_to_binary(re:replace("abcd","^   a\\ b[c ]d       $","QvID",[extended,
                                                                                                                                                                                                         global])), 
?line <<"ab d">> = iolist_to_binary(re:replace("ab d","^   a\\ b[c ]d       $","CEUu&Jt",[extended])), 
?line <<"ab d">> = iolist_to_binary(re:replace("ab d","^   a\\ b[c ]d       $","CEUu&Jt",[extended,
                                                                                                                                                                                                                global])), 
?line <<"ohu">> = iolist_to_binary(re:replace("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$","ohu",[])), 
?line <<"ohu">> = iolist_to_binary(re:replace("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$","ohu",[global])), 
?line <<"rbcmNabcdefhijklmabcdefhijklmNGkLNbcabcdefhijklmxnbclO">> = iolist_to_binary(re:replace("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$","r\\1mN&&NGkLN\\1&xn\\1lO",[])), 
?line <<"rbcmNabcdefhijklmabcdefhijklmNGkLNbcabcdefhijklmxnbclO">> = iolist_to_binary(re:replace("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$","r\\1mN&&NGkLN\\1&xn\\1lO",[global])), 
?line <<"I">> = iolist_to_binary(re:replace("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]","I",[])), 
?line <<"I">> = iolist_to_binary(re:replace("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]","I",[global])), 
?line <<"ANdwkyHnc">> = iolist_to_binary(re:replace(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+","ANdwkyHnc",[])), 
?line <<"ANdwkyHnc">> = iolist_to_binary(re:replace(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+","ANdwkyHnc",[global])), 
?line <<"Dx">> = iolist_to_binary(re:replace("z","^a*\\w","Dx",[])), 
?line <<"Dx">> = iolist_to_binary(re:replace("z","^a*\\w","Dx",[global])), 
?line <<"OpVTjQkTaz">> = iolist_to_binary(re:replace("az","^a*\\w","OpVTjQkT&",[])), 
?line <<"OpVTjQkTaz">> = iolist_to_binary(re:replace("az","^a*\\w","OpVTjQkT&",[global])), 
?line <<"LexbuooAmFDifW">> = iolist_to_binary(re:replace("aaaz","^a*\\w","LexbuooAm\\1FDifW",[])), 
?line <<"LexbuooAmFDifW">> = iolist_to_binary(re:replace("aaaz","^a*\\w","LexbuooAm\\1FDifW",[global])), 
?line <<"arpLCDAadYpPkb">> = iolist_to_binary(re:replace("a","^a*\\w","arpLCDAadYpPk\\1b",[])), 
?line <<"arpLCDAadYpPkb">> = iolist_to_binary(re:replace("a","^a*\\w","arpLCDAadYpPk\\1b",[global])), 
?line <<"CyElaaTHfV">> = iolist_to_binary(re:replace("aa","^a*\\w","CyEl&T\\1HfV",[])), 
?line <<"CyElaaTHfV">> = iolist_to_binary(re:replace("aa","^a*\\w","CyEl&T\\1HfV",[global])), 
?line <<"v">> = iolist_to_binary(re:replace("aaaa","^a*\\w","v\\1\\1",[])), 
?line <<"v">> = iolist_to_binary(re:replace("aaaa","^a*\\w","v\\1\\1",[global])), 
?line <<"COSWtMTXCLic+">> = iolist_to_binary(re:replace("a+","^a*\\w","COSWtMTXCLic",[])), 
?line <<"COSWtMTXCLic+">> = iolist_to_binary(re:replace("a+","^a*\\w","COSWtMTXCLic",[global])), 
?line <<"kaaDuaauKGaaIaaFUK+">> = iolist_to_binary(re:replace("aa+","^a*\\w","k&Du&uKG\\1&I&FU\\1\\1K\\1",[])), 
?line <<"kaaDuaauKGaaIaaFUK+">> = iolist_to_binary(re:replace("aa+","^a*\\w","k&Du&uKG\\1&I&FU\\1\\1K\\1",[global])), 
?line <<"Pttz">> = iolist_to_binary(re:replace("z","^a*?\\w","Ptt&",[])), 
?line <<"Pttz">> = iolist_to_binary(re:replace("z","^a*?\\w","Ptt&",[global])), 
?line <<"QEHxyFSkkaz">> = iolist_to_binary(re:replace("az","^a*?\\w","QEHxyFSkk&",[])), 
?line <<"QEHxyFSkkaz">> = iolist_to_binary(re:replace("az","^a*?\\w","QEHxyFSkk&",[global])), 
?line <<"atHEjpaKrKaaz">> = iolist_to_binary(re:replace("aaaz","^a*?\\w","&tHE\\1jp&KrK",[])), 
?line <<"atHEjpaKrKaaz">> = iolist_to_binary(re:replace("aaaz","^a*?\\w","&tHE\\1jp&KrK",[global])), 
?line <<"YaSeqaaeBiLO">> = iolist_to_binary(re:replace("a","^a*?\\w","Y&Seq\\1&&eBiLO",[])), 
?line <<"YaSeqaaeBiLO">> = iolist_to_binary(re:replace("a","^a*?\\w","Y&Seq\\1&&eBiLO",[global])), 
?line <<"UlaGeGnImSoQaHibARka">> = iolist_to_binary(re:replace("aa","^a*?\\w","Ul&GeGnImSoQ&HibARk",[])), 
?line <<"UlaGeGnImSoQaHibARka">> = iolist_to_binary(re:replace("aa","^a*?\\w","Ul&GeGnImSoQ&HibARk",[global])), 
?line <<"upDbxncvqbwvaaa">> = iolist_to_binary(re:replace("aaaa","^a*?\\w","upDbxncvqb\\1wv",[])), 
?line <<"upDbxncvqbwvaaa">> = iolist_to_binary(re:replace("aaaa","^a*?\\w","upDbxncvqb\\1wv",[global])), 
?line <<"MalqdUPrj+">> = iolist_to_binary(re:replace("a+","^a*?\\w","M&\\1lqdUPr\\1j\\1\\1",[])), 
?line <<"MalqdUPrj+">> = iolist_to_binary(re:replace("a+","^a*?\\w","M&\\1lqdUPr\\1j\\1\\1",[global])), 
?line <<"JTa+">> = iolist_to_binary(re:replace("aa+","^a*?\\w","JT",[])), 
?line <<"JTa+">> = iolist_to_binary(re:replace("aa+","^a*?\\w","JT",[global])), 
?line <<"nnvJUazdlV">> = iolist_to_binary(re:replace("az","^a+\\w","\\1nnvJU&dlV",[])), 
?line <<"nnvJUazdlV">> = iolist_to_binary(re:replace("az","^a+\\w","\\1nnvJU&dlV",[global])), 
?line <<"aaaz">> = iolist_to_binary(re:replace("aaaz","^a+\\w","\\1&",[])), 
?line <<"aaaz">> = iolist_to_binary(re:replace("aaaz","^a+\\w","\\1&",[global])), 
?line <<"daaRBaauOlL">> = iolist_to_binary(re:replace("aa","^a+\\w","d&RB&uO\\1lL",[])), 
?line <<"daaRBaauOlL">> = iolist_to_binary(re:replace("aa","^a+\\w","d&RB&uO\\1lL",[global])), 
?line <<"uaaaajkPXJqfBddNNYaaaa">> = iolist_to_binary(re:replace("aaaa","^a+\\w","u&jkPXJqfBddNNY&",[])), 
?line <<"uaaaajkPXJqfBddNNYaaaa">> = iolist_to_binary(re:replace("aaaa","^a+\\w","u&jkPXJqfBddNNY&",[global])), 
?line <<"YAJlePYgQb+">> = iolist_to_binary(re:replace("aa+","^a+\\w","YAJlePYgQb",[])), 
?line <<"YAJlePYgQb+">> = iolist_to_binary(re:replace("aa+","^a+\\w","YAJlePYgQb",[global])), 
?line <<"MXsW">> = iolist_to_binary(re:replace("az","^a+?\\w","MXsW",[])), 
?line <<"MXsW">> = iolist_to_binary(re:replace("az","^a+?\\w","MXsW",[global])), 
?line <<"GaaMGsaaPiMScaz">> = iolist_to_binary(re:replace("aaaz","^a+?\\w","G&MGs&P\\1i\\1MSc",[])), 
?line <<"GaaMGsaaPiMScaz">> = iolist_to_binary(re:replace("aaaz","^a+?\\w","G&MGs&P\\1i\\1MSc",[global])), 
?line <<"aaYUHgT">> = iolist_to_binary(re:replace("aa","^a+?\\w","&YUHgT",[])), 
?line <<"aaYUHgT">> = iolist_to_binary(re:replace("aa","^a+?\\w","&YUHgT",[global])), 
?line <<"ePknVhaa">> = iolist_to_binary(re:replace("aaaa","^a+?\\w","ePknVh\\1",[])), 
?line <<"ePknVhaa">> = iolist_to_binary(re:replace("aaaa","^a+?\\w","ePknVh\\1",[global])), 
?line <<"+">> = iolist_to_binary(re:replace("aa+","^a+?\\w","\\1",[])), 
?line <<"+">> = iolist_to_binary(re:replace("aa+","^a+?\\w","\\1",[global])), 
?line <<"AFRGuhtn1234567890rEtjU">> = iolist_to_binary(re:replace("1234567890","^\\d{8}\\w{2,}","\\1AFRGuhtn&rEtjU",[])), 
?line <<"AFRGuhtn1234567890rEtjU">> = iolist_to_binary(re:replace("1234567890","^\\d{8}\\w{2,}","\\1AFRGuhtn&rEtjU",[global])), 
?line <<"nNSL12345678abRY">> = iolist_to_binary(re:replace("12345678ab","^\\d{8}\\w{2,}","nNSL&RY",[])), 
?line <<"nNSL12345678abRY">> = iolist_to_binary(re:replace("12345678ab","^\\d{8}\\w{2,}","nNSL&RY",[global])), 
?line <<"12345678__JUDy">> = iolist_to_binary(re:replace("12345678__","^\\d{8}\\w{2,}","&JUDy",[])), 
?line <<"12345678__JUDy">> = iolist_to_binary(re:replace("12345678__","^\\d{8}\\w{2,}","&JUDy",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\d{8}\\w{2,}","&OcK\\1P&XNvgrP",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\d{8}\\w{2,}","&OcK\\1P&XNvgrP",[global])), 
?line <<"1234567">> = iolist_to_binary(re:replace("1234567","^\\d{8}\\w{2,}","&Mo",[])), 
?line <<"1234567">> = iolist_to_binary(re:replace("1234567","^\\d{8}\\w{2,}","&Mo",[global])), 
?line <<"O">> = iolist_to_binary(re:replace("uoie","^[aeiou\\d]{4,5}$","O",[])), 
?line <<"O">> = iolist_to_binary(re:replace("uoie","^[aeiou\\d]{4,5}$","O",[global])), 
?line <<"1234b1234n">> = iolist_to_binary(re:replace("1234","^[aeiou\\d]{4,5}$","&b&n",[])), 
?line <<"1234b1234n">> = iolist_to_binary(re:replace("1234","^[aeiou\\d]{4,5}$","&b&n",[global])), 
?line <<"YBp12345Ul">> = iolist_to_binary(re:replace("12345","^[aeiou\\d]{4,5}$","YBp&Ul",[])), 
?line <<"YBp12345Ul">> = iolist_to_binary(re:replace("12345","^[aeiou\\d]{4,5}$","YBp&Ul",[global])), 
?line <<"SVHQqBtcrMAtQxy">> = iolist_to_binary(re:replace("aaaaa","^[aeiou\\d]{4,5}$","SVHQqBtcrMAtQxy\\1",[])), 
?line <<"SVHQqBtcrMAtQxy">> = iolist_to_binary(re:replace("aaaaa","^[aeiou\\d]{4,5}$","SVHQqBtcrMAtQxy\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[aeiou\\d]{4,5}$","ne",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[aeiou\\d]{4,5}$","ne",[global])), 
?line <<"123456">> = iolist_to_binary(re:replace("123456","^[aeiou\\d]{4,5}$","QA&F\\1LJ",[])), 
?line <<"123456">> = iolist_to_binary(re:replace("123456","^[aeiou\\d]{4,5}$","QA&F\\1LJ",[global])), 
?line <<"gKGpFvTeUK">> = iolist_to_binary(re:replace("uoie","^[aeiou\\d]{4,5}?","gKGpFvTeUK",[])), 
?line <<"gKGpFvTeUK">> = iolist_to_binary(re:replace("uoie","^[aeiou\\d]{4,5}?","gKGpFvTeUK",[global])), 
?line <<"LCEqvLxHGWXWrexD">> = iolist_to_binary(re:replace("1234","^[aeiou\\d]{4,5}?","LCE\\1qvL\\1xHGWXWrexD",[])), 
?line <<"LCEqvLxHGWXWrexD">> = iolist_to_binary(re:replace("1234","^[aeiou\\d]{4,5}?","LCE\\1qvL\\1xHGWXWrexD",[global])), 
?line <<"QWV1234vhndnkkT1234l5">> = iolist_to_binary(re:replace("12345","^[aeiou\\d]{4,5}?","\\1QWV&\\1vhndnkk\\1T&l",[])), 
?line <<"QWV1234vhndnkkT1234l5">> = iolist_to_binary(re:replace("12345","^[aeiou\\d]{4,5}?","\\1QWV&\\1vhndnkk\\1T&l",[global])), 
?line <<"aaaaIaaaayaaaaEoAPYra">> = iolist_to_binary(re:replace("aaaaa","^[aeiou\\d]{4,5}?","&I&y&E\\1oAPYr",[])), 
?line <<"aaaaIaaaayaaaaEoAPYra">> = iolist_to_binary(re:replace("aaaaa","^[aeiou\\d]{4,5}?","&I&y&E\\1oAPYr",[global])), 
?line <<"xKUWgRs56">> = iolist_to_binary(re:replace("123456","^[aeiou\\d]{4,5}?","xKUWgRs",[])), 
?line <<"xKUWgRs56">> = iolist_to_binary(re:replace("123456","^[aeiou\\d]{4,5}?","xKUWgRs",[global])), 
?line <<"JlUywcabcvRabcPFPabcYSXE">> = iolist_to_binary(re:replace("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z","JlUywc\\1vR\\1PFP\\1YSXE",[])), 
?line <<"JlUywcabcvRabcPFPabcYSXE">> = iolist_to_binary(re:replace("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z","JlUywc\\1vR\\1PFP\\1YSXE",[global])), 
?line <<"def=defdefdefbucdef=defdefdef">> = iolist_to_binary(re:replace("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z","&buc&",[])), 
?line <<"def=defdefdefbucdef=defdefdef">> = iolist_to_binary(re:replace("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z","&buc&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z","AYuyHUCDlwjQc\\1OS",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z","AYuyHUCDlwjQc\\1OS",[global])), 
?line <<"abc=defdef">> = iolist_to_binary(re:replace("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z","PM&h\\1\\1xD\\1&",[])), 
?line <<"abc=defdef">> = iolist_to_binary(re:replace("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z","PM&h\\1\\1xD\\1&",[global])), 
?line <<"UFhaagoHObvFc">> = iolist_to_binary(re:replace("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$","UFh\\1\\1goHObvFc",[])), 
?line <<"UFhaagoHObvFc">> = iolist_to_binary(re:replace("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$","UFh\\1\\1goHObvFc",[global])), 
?line <<"aabcdefghijkkkkcda2abcdefghijkkkkcda2abcdefghijkkkkcda2vuYabcdefghijkkkkcda2xdabcdefghijkkkkcda2njaJQEF">> = iolist_to_binary(re:replace("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$","\\1&&&vuY&xd&nj\\1JQEF",[])), 
?line <<"aabcdefghijkkkkcda2abcdefghijkkkkcda2abcdefghijkkkkcda2vuYabcdefghijkkkkcda2xdabcdefghijkkkkcda2njaJQEF">> = iolist_to_binary(re:replace("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$","\\1&&&vuY&xd&nj\\1JQEF",[global])), 
?line <<"mcataractcataract cataract23YTkMcataract cataract23">> = iolist_to_binary(re:replace("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","m\\1&YTkM&",[])), 
?line <<"mcataractcataract cataract23YTkMcataract cataract23">> = iolist_to_binary(re:replace("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","m\\1&YTkM&",[global])), 
?line <<"OXcatatonicoHKaXHQpryKFyhVcatatonic">> = iolist_to_binary(re:replace("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","OX\\1oHKaXHQpryKFyhV\\1",[])), 
?line <<"OXcatatonicoHKaXHQpryKFyhVcatatonic">> = iolist_to_binary(re:replace("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","OX\\1oHKaXHQpryKFyhV\\1",[global])), 
?line <<"caterpillarcaterpillar caterpillar23foVlhvplLSebcaterpillar">> = iolist_to_binary(re:replace("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","\\1&foVlhvplLSeb\\1",[])), 
?line <<"caterpillarcaterpillar caterpillar23foVlhvplLSebcaterpillar">> = iolist_to_binary(re:replace("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)","\\1&foVlhvplLSeb\\1",[global])), 
?line <<"From abcd  Mon Sep 01 12:33TNVlANgYabcdabcdFrom abcd  Mon Sep 01 12:33aIFrom abcd  Mon Sep 01 12:33TqsabcdQ:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]","&TNVlANgY\\1\\1&aI&Tqs\\1Q",[])), 
?line <<"From abcd  Mon Sep 01 12:33TNVlANgYabcdabcdFrom abcd  Mon Sep 01 12:33aIFrom abcd  Mon Sep 01 12:33TqsabcdQ:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]","&TNVlANgY\\1\\1&aI&Tqs\\1Q",[global])), 
?line <<"isKrFrom abcd  Mon Sep 01 12:33:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","isKr&",[])), 
?line <<"isKrFrom abcd  Mon Sep 01 12:33:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","isKr&",[global])), 
?line <<"lNtEJS:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","lNtEJS",[])), 
?line <<"lNtEJS:02 1997">> = iolist_to_binary(re:replace("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","lNtEJS",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","aR\\1i&Fxe",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","aR\\1i&Fxe",[global])), 
?line <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(re:replace("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","\\1NsrJ&\\1&PtWlXT",[])), 
?line <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(re:replace("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d","\\1NsrJ&\\1&PtWlXT",[global])), 
?line <<"nGixKixjMO12
34BhoReSp">> = iolist_to_binary(re:replace("12
34","^12.34","nGixKixjMO&BhoReSp",[dotall])), 
?line <<"nGixKixjMO12
34BhoReSp">> = iolist_to_binary(re:replace("12
34","^12.34","nGixKixjMO&BhoReSp",[dotall,global])), 
?line <<"12
34OBfpF12
3412
34fh">> = iolist_to_binary(re:replace("12
34","^12.34","&OBfpF&&fh",[dotall])), 
?line <<"12
34OBfpF12
3412
34fh">> = iolist_to_binary(re:replace("12
34","^12.34","&OBfpF&&fh",[dotall,
                                                                                                                                                                                        global])), 
?line <<"the quick brownhubrownbrownubrownQ	 fox">> = iolist_to_binary(re:replace("the quick brown	 fox","\\w+(?=\\t)","&hu&&u&Q",[])), 
?line <<"the quick brownhubrownbrownubrownQ	 fox">> = iolist_to_binary(re:replace("the quick brown	 fox","\\w+(?=\\t)","&hu&&u&Q",[global])), 
?line <<"foobar is uqH">> = iolist_to_binary(re:replace("foobar is foolish see?","foo(?!bar)(.*)","uqH",[])), 
?line <<"foobar is uqH">> = iolist_to_binary(re:replace("foobar is foolish see?","foo(?!bar)(.*)","uqH",[global])), 
?line <<"foobar cn">> = iolist_to_binary(re:replace("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)","n",[])), 
?line <<"foobar cn">> = iolist_to_binary(re:replace("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)","n",[global])), 
?line <<"CpDjibh">> = iolist_to_binary(re:replace("barrel","(?:(?!foo)...|^.{0,2})bar(.*)","CpDjibh",[])), 
?line <<"CpDjibh">> = iolist_to_binary(re:replace("barrel","(?:(?!foo)...|^.{0,2})bar(.*)","CpDjibh",[global])), 
?line <<"wlcfLrelprelgrelD">> = iolist_to_binary(re:replace("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)","wlcfL\\1p\\1g\\1D",[])), 
?line <<"wlcfLrelprelgrelD">> = iolist_to_binary(re:replace("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)","wlcfL\\1p\\1g\\1D",[global])), 
?line <<"wbDA barrelYA barrelcQA barrelplrelA barrelXPrel">> = iolist_to_binary(re:replace("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)","wbD&Y&cQ&pl\\1&XP\\1",[])), 
?line <<"wbDA barrelYA barrelcQA barrelplrelA barrelXPrel">> = iolist_to_binary(re:replace("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)","wbD&Y&cQ&pl\\1&XP\\1",[global])), 
?line <<"PJMqUabctmoSPC456">> = iolist_to_binary(re:replace("abc456","^(\\D*)(?=\\d)(?!123)","PJMqU\\1tmoSPC",[])), 
?line <<"PJMqUabctmoSPC456">> = iolist_to_binary(re:replace("abc456","^(\\D*)(?=\\d)(?!123)","PJMqU\\1tmoSPC",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\D*)(?=\\d)(?!123)","k\\1&lgXOi",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\D*)(?=\\d)(?!123)","k\\1&lgXOi",[global])), 
?line <<"abc123">> = iolist_to_binary(re:replace("abc123","^(\\D*)(?=\\d)(?!123)","UgE&XTVNX&ygyaQdYO&",[])), 
?line <<"abc123">> = iolist_to_binary(re:replace("abc123","^(\\D*)(?=\\d)(?!123)","UgE&XTVNX&ygyaQdYO&",[global])), 
?line <<"CByu1234Oj12341234">> = iolist_to_binary(re:replace("1234","^1234(?# test newlines
  inside)","CByu&Oj&&",[])), 
?line <<"CByu1234Oj12341234">> = iolist_to_binary(re:replace("1234","^1234(?# test newlines
  inside)","CByu&Oj&&",[global])), 
?line <<"AVF1234DSEvHi">> = iolist_to_binary(re:replace("1234","^1234 #comment in extended re
  ","AVF&DSEvHi",[extended])), 
?line <<"AVF1234DSEvHi">> = iolist_to_binary(re:replace("1234","^1234 #comment in extended re
  ","AVF&DSEvHi",[extended,global])), 
?line <<"wiUNsYJdROkkkabcdSabcdjvS">> = iolist_to_binary(re:replace("abcd","#rhubarb
  abcd","wiUNsYJdROkkk&S&jvS",[extended])), 
?line <<"wiUNsYJdROkkkabcdSabcdjvS">> = iolist_to_binary(re:replace("abcd","#rhubarb
  abcd","wiUNsYJdROkkk&S&jvS",[extended,global])), 
?line <<"wxabcdyOpSDe">> = iolist_to_binary(re:replace("abcd","^abcd#rhubarb","wx&yOpSDe",[extended])), 
?line <<"wxabcdyOpSDe">> = iolist_to_binary(re:replace("abcd","^abcd#rhubarb","wx&yOpSDe",[extended,
                                                                                                                                                                                                global])), 
?line <<"aqfaaaab">> = iolist_to_binary(re:replace("aaab","^(a)\\1{2,3}(.)","\\1qf\\1&",[])), 
?line <<"aqfaaaab">> = iolist_to_binary(re:replace("aaab","^(a)\\1{2,3}(.)","\\1qf\\1&",[global])), 
?line <<"aLGaaaabhavaLLxaIaaaabJaaaabidaaaab">> = iolist_to_binary(re:replace("aaaab","^(a)\\1{2,3}(.)","\\1LG&h\\1v\\1LLx\\1I&J&id&",[])), 
?line <<"aLGaaaabhavaLLxaIaaaabJaaaabidaaaab">> = iolist_to_binary(re:replace("aaaab","^(a)\\1{2,3}(.)","\\1LG&h\\1v\\1LLx\\1I&J&id&",[global])), 
?line <<"aaaaaEaaaaagaawPOaNaaaaab">> = iolist_to_binary(re:replace("aaaaab","^(a)\\1{2,3}(.)","&E&g\\1\\1wPO\\1N&",[])), 
?line <<"aaaaaEaaaaagaawPOaNaaaaab">> = iolist_to_binary(re:replace("aaaaab","^(a)\\1{2,3}(.)","&E&g\\1\\1wPO\\1N&",[global])), 
?line <<"QwegtaHxecVVVaaaaaab">> = iolist_to_binary(re:replace("aaaaaab","^(a)\\1{2,3}(.)","QwegtaHxecVVV&",[])), 
?line <<"QwegtaHxecVVVaaaaaab">> = iolist_to_binary(re:replace("aaaaaab","^(a)\\1{2,3}(.)","QwegtaHxecVVV&",[global])), 
?line <<"the EcabcmU">> = iolist_to_binary(re:replace("the abc","(?!^)abc","Ec&mU",[])), 
?line <<"the EcabcmU">> = iolist_to_binary(re:replace("the abc","(?!^)abc","Ec&mU",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?!^)abc","NA",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?!^)abc","NA",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(?!^)abc","yjhaoMMFW\\1",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(?!^)abc","yjhaoMMFW\\1",[global])), 
?line <<"PKCfTNYlWMooD">> = iolist_to_binary(re:replace("abc","(?=^)abc","\\1PK\\1CfTNYlWMooD",[])), 
?line <<"PKCfTNYlWMooD">> = iolist_to_binary(re:replace("abc","(?=^)abc","\\1PK\\1CfTNYlWMooD",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?=^)abc","fR\\1ltffBHNVYixMX",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?=^)abc","fR\\1ltffBHNVYixMX",[global])), 
?line <<"the abc">> = iolist_to_binary(re:replace("the abc","(?=^)abc","L\\1JJFtgfU&l",[])), 
?line <<"the abc">> = iolist_to_binary(re:replace("the abc","(?=^)abc","L\\1JJFtgfU&l",[global])), 
?line <<"aabbvbOdaabbyVtUjIbqObbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}(ab*|b)","&v\\1Od&yVtUjI\\1qO\\1",[])), 
?line <<"aabbvbOdaabbyVtUjIbqObbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}(ab*|b)","&v\\1Od&yVtUjI\\1qO\\1",[global])), 
?line <<"PLPJVxaabbbbbYrEOEywwHFp">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}?(ab*|b)","PLPJVxa\\1YrEOEywwHFp",[])), 
?line <<"PLPJVxaabbbbbYrEOEywwHFp">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}?(ab*|b)","PLPJVxa\\1YrEOEywwHFp",[global])), 
?line <<"VmghaaMBBitDaaaRnWKaaaAbbbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}?(ab*?|b)","Vmgh&MBBitD&\\1RnWK&\\1A",[])), 
?line <<"VmghaaMBBitDaaaRnWKaaaAbbbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}?(ab*?|b)","Vmgh&MBBitD&\\1RnWK&\\1A",[global])), 
?line <<"baabblNbbLhaabbtbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}(ab*?|b)","\\1&lNb\\1Lh&t",[])), 
?line <<"baabblNbbLhaabbtbbb">> = iolist_to_binary(re:replace("aabbbbb","^[ab]{1,3}(ab*?|b)","\\1&lNb\\1Lh&t",[global])), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(re:replace("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","Ag",[extended])), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(re:replace("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","Ag",[extended,
                                                                      global])), 
?line <<"<user.ain>">> = iolist_to_binary(re:replace("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","OcN\\1",[extended])), 
?line <<"<user.ain>">> = iolist_to_binary(re:replace("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","OcN\\1",[extended,
                                                                            global])), 
?line <<"user.ain">> = iolist_to_binary(re:replace("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","P\\1\\1",[extended])), 
?line <<"user.ain">> = iolist_to_binary(re:replace("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","P\\1\\1",[extended,
                                                                               global])), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","tFTD&XMAPNeq",[extended])), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","tFTD&XMAPNeq",[extended,
                                                                                global])), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","c\\1&C&YTXnfnhWs\\1g",[extended])), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","c\\1&C&YTXnfnhWs\\1g",[extended,
                                                                                            global])), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(re:replace("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","\\1R&P&\\1aCnlgH",[extended])), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(re:replace("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","\\1R&P&\\1aCnlgH",[extended,
                                                                                        global])), 
?line <<"A missing angle <user.where">> = iolist_to_binary(re:replace("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","p\\1u\\1REy&",[extended])), 
?line <<"A missing angle <user.where">> = iolist_to_binary(re:replace("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","p\\1u\\1REy&",[extended,
                                                                                    global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","qytCjuWj\\1fpNNv\\1&ya",[extended])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","qytCjuWj\\1fpNNv\\1&ya",[extended,
                                                                                              global])), 
?line <<"The quick brown fox">> = iolist_to_binary(re:replace("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","L",[extended])), 
?line <<"The quick brown fox">> = iolist_to_binary(re:replace("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment","L",[extended,
                                                                     global])), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(re:replace("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","\\1",[extended])), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(re:replace("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","\\1",[extended,global])), 
?line <<"<user.ain>">> = iolist_to_binary(re:replace("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","On",[extended])), 
?line <<"<user.ain>">> = iolist_to_binary(re:replace("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","On",[extended,global])), 
?line <<"user.ain">> = iolist_to_binary(re:replace("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","OLL\\1TqepmsD\\1V\\1\\1h\\1DsD",[extended])), 
?line <<"user.ain">> = iolist_to_binary(re:replace("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","OLL\\1TqepmsD\\1V\\1\\1h\\1DsD",[extended,global])), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","SHuKuC\\1Td",[extended])), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","SHuKuC\\1Td",[extended,global])), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","D&t&LSQGMfQpSXj",[extended])), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(re:replace("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","D&t&LSQGMfQpSXj",[extended,global])), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(re:replace("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","qDSGw",[extended])), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(re:replace("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","qDSGw",[extended,global])), 
?line <<"A missing angle <user.where">> = iolist_to_binary(re:replace("A missing angle <user.where","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","SOYovQniOUVJIil\\1",[extended])), 
?line <<"A missing angle <user.where">> = iolist_to_binary(re:replace("A missing angle <user.where","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","SOYovQniOUVJIil\\1",[extended,global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","D\\1",[extended])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","D\\1",[extended,global])), 
?line <<"The quick brown fox">> = iolist_to_binary(re:replace("The quick brown fox","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","X&ayUGYrNMDenjwrkvT",[extended])), 
?line <<"The quick brown fox">> = iolist_to_binary(re:replace("The quick brown fox","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)","X&ayUGYrNMDenjwrkvT",[extended,global])), 
?line <<"abcdefpqrxyz0AB">> = iolist_to_binary(re:replace("abcdefpqrxyz0AB","abc\\0def\\00pqr\\000xyz\\0000AB","bYVVTfV",[])), 
?line <<"abcdefpqrxyz0AB">> = iolist_to_binary(re:replace("abcdefpqrxyz0AB","abc\\0def\\00pqr\\000xyz\\0000AB","bYVVTfV",[global])), 
?line <<"abc456 abcdefpqrxyz0ABCDE">> = iolist_to_binary(re:replace("abc456 abcdefpqrxyz0ABCDE","abc\\0def\\00pqr\\000xyz\\0000AB","ALc",[])), 
?line <<"abc456 abcdefpqrxyz0ABCDE">> = iolist_to_binary(re:replace("abc456 abcdefpqrxyz0ABCDE","abc\\0def\\00pqr\\000xyz\\0000AB","ALc",[global])), 
?line <<"abc
efpqr0xyz00AB">> = iolist_to_binary(re:replace("abc
efpqr0xyz00AB","abc\\x0def\\x00pqr\\x000xyz\\x0000AB","FJjJa&MUN",[])), 
?line <<"abc
efpqr0xyz00AB">> = iolist_to_binary(re:replace("abc
efpqr0xyz00AB","abc\\x0def\\x00pqr\\x000xyz\\x0000AB","FJjJa&MUN",[global])), 
?line <<"abc456 abc
efpqr0xyz00ABCDE">> = iolist_to_binary(re:replace("abc456 abc
efpqr0xyz00ABCDE","abc\\x0def\\x00pqr\\x000xyz\\x0000AB","IsJK",[])), 
?line <<"abc456 abc
efpqr0xyz00ABCDE">> = iolist_to_binary(re:replace("abc456 abc
efpqr0xyz00ABCDE","abc\\x0def\\x00pqr\\x000xyz\\x0000AB","IsJK",[global])), 
?line <<"A">> = iolist_to_binary(re:replace("A","^[\\000-\\037]","&&&l&oFiYRb&dwnRVIB",[])), 
?line <<"A">> = iolist_to_binary(re:replace("A","^[\\000-\\037]","&&&l&oFiYRb&dwnRVIB",[global])), 
?line <<"pJINBIVHkbsQpNB">> = iolist_to_binary(re:replace("B","^[\\000-\\037]","p\\1JINBIVHkbs&QpN",[])), 
?line <<"pJINBIVHkbsQpNB">> = iolist_to_binary(re:replace("B","^[\\000-\\037]","p\\1JINBIVHkbs&QpN",[global])), 
?line <<"qnaxlKtxgBKMC">> = iolist_to_binary(re:replace("C","^[\\000-\\037]","qnax&lKtxgB&KM",[])), 
?line <<"qnaxlKtxgBKMC">> = iolist_to_binary(re:replace("C","^[\\000-\\037]","qnax&lKtxgB&KM",[global])), 
?line <<"WuuRxIy">> = iolist_to_binary(re:replace("","\\0*","Wu&uRxIy",[])), 
?line <<"WuuRxIy">> = iolist_to_binary(re:replace("","\\0*","Wu&uRxIy",[global])), 
?line <<"The AZ">> = iolist_to_binary(re:replace("The AZ","A\\x0{2,3}Z","ggJSniphIbt",[])), 
?line <<"The AZ">> = iolist_to_binary(re:replace("The AZ","A\\x0{2,3}Z","ggJSniphIbt",[global])), 
?line <<"An AZ">> = iolist_to_binary(re:replace("An AZ","A\\x0{2,3}Z","s&\\1Bwkjj",[])), 
?line <<"An AZ">> = iolist_to_binary(re:replace("An AZ","A\\x0{2,3}Z","s&\\1Bwkjj",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","A\\x0{2,3}Z","\\1eJyYpl",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","A\\x0{2,3}Z","\\1eJyYpl",[global])), 
?line <<"AZ">> = iolist_to_binary(re:replace("AZ","A\\x0{2,3}Z","aK\\1qVDC\\1uB",[])), 
?line <<"AZ">> = iolist_to_binary(re:replace("AZ","A\\x0{2,3}Z","aK\\1qVDC\\1uB",[global])), 
?line <<"AZ">> = iolist_to_binary(re:replace("AZ","A\\x0{2,3}Z","DMN&CNdjTe",[])), 
?line <<"AZ">> = iolist_to_binary(re:replace("AZ","A\\x0{2,3}Z","DMN&CNdjTe",[global])), 
?line <<"cowcowbelldrlcowNSbcowcowbelladivdcowcowbell">> = iolist_to_binary(re:replace("cowcowbell","^(cow|)\\1(bell)","&drl\\1NSb&adivd&",[])), 
?line <<"cowcowbelldrlcowNSbcowcowbelladivdcowcowbell">> = iolist_to_binary(re:replace("cowcowbell","^(cow|)\\1(bell)","&drl\\1NSb&adivd&",[global])), 
?line <<"UUUBpbellPtC">> = iolist_to_binary(re:replace("bell","^(cow|)\\1(bell)","UUUBp&P\\1tC",[])), 
?line <<"UUUBpbellPtC">> = iolist_to_binary(re:replace("bell","^(cow|)\\1(bell)","UUUBp&P\\1tC",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(cow|)\\1(bell)","\\1\\1L\\1foe&LDaKY",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(cow|)\\1(bell)","\\1\\1L\\1foe&LDaKY",[global])), 
?line <<"cowbell">> = iolist_to_binary(re:replace("cowbell","^(cow|)\\1(bell)","&pE",[])), 
?line <<"cowbell">> = iolist_to_binary(re:replace("cowbell","^(cow|)\\1(bell)","&pE",[global])), 
?line <<"KEPMMarMefAQoabc">> = iolist_to_binary(re:replace(" abc","^\\s","KEP\\1MMa\\1rMefAQ\\1\\1\\1o",[])), 
?line <<"KEPMMarMefAQoabc">> = iolist_to_binary(re:replace(" abc","^\\s","KEP\\1MMa\\1rMefAQ\\1\\1\\1o",[global])), 
?line <<"mdPwbKbGabc">> = iolist_to_binary(re:replace("abc","^\\s","mdPwbKbG",[])), 
?line <<"mdPwbKbGabc">> = iolist_to_binary(re:replace("abc","^\\s","mdPwbKbG",[global])), 
?line <<"Ed
FNgfabc">> = iolist_to_binary(re:replace("
abc","^\\s","Ed&FNgf",[])), 
?line <<"Ed
FNgfabc">> = iolist_to_binary(re:replace("
abc","^\\s","Ed&FNgf",[global])), 
?line <<"iYCabc">> = iolist_to_binary(re:replace("
abc","^\\s","iYC",[])), 
?line <<"iYCabc">> = iolist_to_binary(re:replace("
abc","^\\s","iYC",[global])), 
?line <<"Y	KyKjBtWUscEoeabc">> = iolist_to_binary(re:replace("	abc","^\\s","Y\\1&\\1KyKjBtWUscEoe",[])), 
?line <<"Y	KyKjBtWUscEoeabc">> = iolist_to_binary(re:replace("	abc","^\\s","Y\\1&\\1KyKjBtWUscEoe",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\s","fMXHNBeT",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\s","fMXHNBeT",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","^\\s","GF\\1s&cS\\1yGC",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","^\\s","GF\\1s&cS\\1yGC",[global])), 
?line <<"Ur">> = iolist_to_binary(re:replace("abc","^a	b
      c","Ur",[extended])), 
?line <<"Ur">> = iolist_to_binary(re:replace("abc","^a	b
      c","Ur",[extended,global])), 
?line <<"UQqfOFVevBwaga">> = iolist_to_binary(re:replace("ab","^(a|)\\1*b","UQqfOFVevBwag\\1",[])), 
?line <<"UQqfOFVevBwaga">> = iolist_to_binary(re:replace("ab","^(a|)\\1*b","UQqfOFVevBwag\\1",[global])), 
?line <<"cAc">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1*b","cAc",[])), 
?line <<"cAc">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1*b","cAc",[global])), 
?line <<"QGbTLPFbbYYwpIhdW">> = iolist_to_binary(re:replace("b","^(a|)\\1*b","QG&TLPF&&YYwp\\1Ih\\1dW",[])), 
?line <<"QGbTLPFbbYYwpIhdW">> = iolist_to_binary(re:replace("b","^(a|)\\1*b","QG&TLPF&&YYwp\\1Ih\\1dW",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1*b","wY",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1*b","wY",[global])), 
?line <<"acb">> = iolist_to_binary(re:replace("acb","^(a|)\\1*b","IpD\\1tRUS",[])), 
?line <<"acb">> = iolist_to_binary(re:replace("acb","^(a|)\\1*b","IpD\\1tRUS",[global])), 
?line <<"PMaabaRKsKVgnxCiJtgp">> = iolist_to_binary(re:replace("aab","^(a|)\\1+b","PM&\\1RKsKVgnxCiJtgp",[])), 
?line <<"PMaabaRKsKVgnxCiJtgp">> = iolist_to_binary(re:replace("aab","^(a|)\\1+b","PM&\\1RKsKVgnxCiJtgp",[global])), 
?line <<"quaJPXxLfMHlVxH">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1+b","qu\\1JPXxLfMHlVxH",[])), 
?line <<"quaJPXxLfMHlVxH">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1+b","qu\\1JPXxLfMHlVxH",[global])), 
?line <<"b">> = iolist_to_binary(re:replace("b","^(a|)\\1+b","&",[])), 
?line <<"b">> = iolist_to_binary(re:replace("b","^(a|)\\1+b","&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1+b","ywXwC",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1+b","ywXwC",[global])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1+b","hwwbvhOrVEaVOsD\\1",[])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1+b","hwwbvhOrVEaVOsD\\1",[global])), 
?line <<"tNvaWAg">> = iolist_to_binary(re:replace("ab","^(a|)\\1?b","tNv\\1WAg",[])), 
?line <<"tNvaWAg">> = iolist_to_binary(re:replace("ab","^(a|)\\1?b","tNv\\1WAg",[global])), 
?line <<"K">> = iolist_to_binary(re:replace("aab","^(a|)\\1?b","K",[])), 
?line <<"K">> = iolist_to_binary(re:replace("aab","^(a|)\\1?b","K",[global])), 
?line <<"bRibsTbLcleUeb">> = iolist_to_binary(re:replace("b","^(a|)\\1?b","&Ri\\1&sT&L\\1cl\\1e\\1Ue&",[])), 
?line <<"bRibsTbLcleUeb">> = iolist_to_binary(re:replace("b","^(a|)\\1?b","&Ri\\1&sT&L\\1cl\\1e\\1Ue&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1?b","&CGRslcRfjatPWbOMT",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1?b","&CGRslcRfjatPWbOMT",[global])), 
?line <<"acb">> = iolist_to_binary(re:replace("acb","^(a|)\\1?b","&k\\1aoVMtug&hJsI",[])), 
?line <<"acb">> = iolist_to_binary(re:replace("acb","^(a|)\\1?b","&k\\1aoVMtug&hJsI",[global])), 
?line <<"gaaabFGtJRckPahi">> = iolist_to_binary(re:replace("aaab","^(a|)\\1{2}b","g&FGtJRckP\\1hi",[])), 
?line <<"gaaabFGtJRckPahi">> = iolist_to_binary(re:replace("aaab","^(a|)\\1{2}b","g&FGtJRckP\\1hi",[global])), 
?line <<"bINnRM">> = iolist_to_binary(re:replace("b","^(a|)\\1{2}b","bINnR\\1M",[])), 
?line <<"bINnRM">> = iolist_to_binary(re:replace("b","^(a|)\\1{2}b","bINnR\\1M",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1{2}b","cm",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1{2}b","cm",[global])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1{2}b","yT\\1\\1NlFQVleuHkXnE\\1",[])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1{2}b","yT\\1\\1NlFQVleuHkXnE\\1",[global])), 
?line <<"aab">> = iolist_to_binary(re:replace("aab","^(a|)\\1{2}b","PwBRhyP\\1txXQhbjE\\1a",[])), 
?line <<"aab">> = iolist_to_binary(re:replace("aab","^(a|)\\1{2}b","PwBRhyP\\1txXQhbjE\\1a",[global])), 
?line <<"aaaab">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1{2}b","cxo",[])), 
?line <<"aaaab">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1{2}b","cxo",[global])), 
?line <<"aaabXaaabMaaabdHhnqsiti">> = iolist_to_binary(re:replace("aaab","^(a|)\\1{2,3}b","&X&M&dHhnqsiti",[])), 
?line <<"aaabXaaabMaaabdHhnqsiti">> = iolist_to_binary(re:replace("aaab","^(a|)\\1{2,3}b","&X&M&dHhnqsiti",[global])), 
?line <<"QaaaablaaaabNnVdaaaabpaQEaaaaab">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1{2,3}b","Q&l&NnVd&p\\1QE\\1&",[])), 
?line <<"QaaaablaaaabNnVdaaaabpaQEaaaaab">> = iolist_to_binary(re:replace("aaaab","^(a|)\\1{2,3}b","Q&l&NnVd&p\\1QE\\1&",[global])), 
?line <<"bCw">> = iolist_to_binary(re:replace("b","^(a|)\\1{2,3}b","&Cw",[])), 
?line <<"bCw">> = iolist_to_binary(re:replace("b","^(a|)\\1{2,3}b","&Cw",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1{2,3}b","\\1&puY",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a|)\\1{2,3}b","\\1&puY",[global])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1{2,3}b","pbextvQnRWgXs",[])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a|)\\1{2,3}b","pbextvQnRWgXs",[global])), 
?line <<"aab">> = iolist_to_binary(re:replace("aab","^(a|)\\1{2,3}b","fHRaaYYIr\\1l\\1",[])), 
?line <<"aab">> = iolist_to_binary(re:replace("aab","^(a|)\\1{2,3}b","fHRaaYYIr\\1l\\1",[global])), 
?line <<"aaaaab">> = iolist_to_binary(re:replace("aaaaab","^(a|)\\1{2,3}b","nXt&Aw\\1XCfLg\\1GGPmN",[])), 
?line <<"aaaaab">> = iolist_to_binary(re:replace("aaaaab","^(a|)\\1{2,3}b","nXt&Aw\\1XCfLg\\1GGPmN",[global])), 
?line <<"eRwvgLU">> = iolist_to_binary(re:replace("abbbbc","ab{1,3}bc","eRwvgLU",[])), 
?line <<"eRwvgLU">> = iolist_to_binary(re:replace("abbbbc","ab{1,3}bc","eRwvgLU",[global])), 
?line <<"mDnlkabbbcfTJ">> = iolist_to_binary(re:replace("abbbc","ab{1,3}bc","m\\1Dnl\\1k&fTJ",[])), 
?line <<"mDnlkabbbcfTJ">> = iolist_to_binary(re:replace("abbbc","ab{1,3}bc","m\\1Dnl\\1k&fTJ",[global])), 
?line <<"QabbcqIjjWabbchabbcBrTp">> = iolist_to_binary(re:replace("abbc","ab{1,3}bc","Q&qIjjW&h\\1&BrTp",[])), 
?line <<"QabbcqIjjWabbchabbcBrTp">> = iolist_to_binary(re:replace("abbc","ab{1,3}bc","Q&qIjjW&h\\1&BrTp",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{1,3}bc","\\1Wj&Y&ML\\1RBiGiweww",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{1,3}bc","\\1Wj&Y&ML\\1RBiGiweww",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","ab{1,3}bc","HmlRU&NUwwokL",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","ab{1,3}bc","HmlRU&NUwwokL",[global])), 
?line <<"abbbbbc">> = iolist_to_binary(re:replace("abbbbbc","ab{1,3}bc","FUyCCDShGVXhEHX\\1V\\1bK",[])), 
?line <<"abbbbbc">> = iolist_to_binary(re:replace("abbbbbc","ab{1,3}bc","FUyCCDShGVXhEHX\\1V\\1bK",[global])), 
?line <<"track1astrack1track1tIDhtrack1.title:TBlah blah blahiA">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[T ]+(.*)","\\1as\\1\\1tIDh&iA",[])), 
?line <<"track1astrack1track1tIDhtrack1.title:TBlah blah blahiA">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[T ]+(.*)","\\1as\\1\\1tIDh&iA",[global])), 
?line <<"wUVSR">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[T ]+(.*)","wUVSR",[caseless])), 
?line <<"wUVSR">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[T ]+(.*)","wUVSR",[caseless,
                                                                                                                                                                                                                                                                    global])), 
?line <<"htrack1TCNtrack1.title:TBlah blah blahpLtrack1.title:TBlah blah blahtrack1.title:TBlah blah blahFnNtrack1jOBdd">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[t ]+(.*)","h\\1TCN&pL&&FnN\\1jOBdd",[caseless])), 
?line <<"htrack1TCNtrack1.title:TBlah blah blahpLtrack1.title:TBlah blah blahtrack1.title:TBlah blah blahFnNtrack1jOBdd">> = iolist_to_binary(re:replace("track1.title:TBlah blah blah","([^.]*)\\.([^:]*):[t ]+(.*)","h\\1TCN&pL&&FnN\\1jOBdd",[caseless,
                                                                                                                                                                                                                                                                                                             global])), 
?line <<"OKnYPU">> = iolist_to_binary(re:replace("WXY_^abc","^[W-c]+$","OKnYPU",[])), 
?line <<"OKnYPU">> = iolist_to_binary(re:replace("WXY_^abc","^[W-c]+$","OKnYPU",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-c]+$","\\1GX\\1YVV&\\1WF",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-c]+$","\\1GX\\1YVV&\\1WF",[global])), 
?line <<"wxy">> = iolist_to_binary(re:replace("wxy","^[W-c]+$","Uax\\1F",[])), 
?line <<"wxy">> = iolist_to_binary(re:replace("wxy","^[W-c]+$","Uax\\1F",[global])), 
?line <<"WXY_^abcARKQ">> = iolist_to_binary(re:replace("WXY_^abc","^[W-c]+$","&ARK\\1Q",[caseless])), 
?line <<"WXY_^abcARKQ">> = iolist_to_binary(re:replace("WXY_^abc","^[W-c]+$","&ARK\\1Q",[caseless,
                                                                                                                                                                                              global])), 
?line <<"fIwxy_^ABCwxy_^ABCGwxy_^ABCwAHLMA">> = iolist_to_binary(re:replace("wxy_^ABC","^[W-c]+$","fI&&G&w\\1AHL\\1MA",[caseless])), 
?line <<"fIwxy_^ABCwxy_^ABCGwxy_^ABCwAHLMA">> = iolist_to_binary(re:replace("wxy_^ABC","^[W-c]+$","fI&&G&w\\1AHL\\1MA",[caseless,
                                                                                                                                                                                                                     global])), 
?line <<"WXY_^abcrgsgXuYrmtfAuS">> = iolist_to_binary(re:replace("WXY_^abc","^[\\x3f-\\x5F]+$","&rgsgXuYrmtfAuS",[caseless])), 
?line <<"WXY_^abcrgsgXuYrmtfAuS">> = iolist_to_binary(re:replace("WXY_^abc","^[\\x3f-\\x5F]+$","&rgsgXuYrmtfAuS",[caseless,
                                                                                                                                                                                                                             global])), 
?line <<"FmwJKwxy_^ABCyluQcjQVnwQ">> = iolist_to_binary(re:replace("wxy_^ABC","^[\\x3f-\\x5F]+$","FmwJK&yluQcjQVnwQ",[caseless])), 
?line <<"FmwJKwxy_^ABCyluQcjQVnwQ">> = iolist_to_binary(re:replace("wxy_^ABC","^[\\x3f-\\x5F]+$","FmwJK&yluQcjQVnwQ",[caseless,
                                                                                                                                                                                                                                 global])), 
?line <<"abcabcMObxlD">> = iolist_to_binary(re:replace("abc","^abc$","&\\1&MObxlD",[multiline])), 
?line <<"abcabcMObxlD">> = iolist_to_binary(re:replace("abc","^abc$","&\\1&MObxlD",[multiline,
                                                                                                                                                                                     global])), 
?line <<"qqq
wgabc">> = iolist_to_binary(re:replace("qqq
abc","^abc$","wg&",[multiline])), 
?line <<"qqq
wgabc">> = iolist_to_binary(re:replace("qqq
abc","^abc$","wg&",[multiline,global])), 
?line <<"abcwXeRgabcKmklKpYiE
zzz">> = iolist_to_binary(re:replace("abc
zzz","^abc$","&wXe\\1Rg&K\\1mklKpYiE",[multiline])), 
?line <<"abcwXeRgabcKmklKpYiE
zzz">> = iolist_to_binary(re:replace("abc
zzz","^abc$","&wXe\\1Rg&K\\1mklKpYiE",[multiline,global])), 
?line <<"qqq
CabcCKxlJamS
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","^abc$","C&CKxlJam\\1S",[multiline])), 
?line <<"qqq
CabcCKxlJamS
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","^abc$","C&CKxlJam\\1S",[multiline,global])), 
?line <<"MLKPlabcY">> = iolist_to_binary(re:replace("abc","^abc$","MLKPl&\\1Y",[])), 
?line <<"MLKPlabcY">> = iolist_to_binary(re:replace("abc","^abc$","MLKPl&\\1Y",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","\\1uRnMNc&\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","\\1uRnMNc&\\1",[global])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","^abc$","b\\1",[])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","^abc$","b\\1",[global])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","^abc$","RAJ\\1a&Mvoue\\1d",[])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","^abc$","RAJ\\1a&Mvoue\\1d",[global])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","^abc$","\\1NghvSn\\1GSQvu&&grYN",[])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","^abc$","\\1NghvSn\\1GSQvu&&grYN",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","\\Aabc\\Z","&",[multiline])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","\\Aabc\\Z","&",[multiline,
                                                                                                                                                                        global])), 
?line <<"XQevmabcHXD">> = iolist_to_binary(re:replace("abc","\\Aabc\\Z","XQevm&HXD",[multiline])), 
?line <<"XQevmabcHXD">> = iolist_to_binary(re:replace("abc","\\Aabc\\Z","XQevm&HXD",[multiline,
                                                                                                                                                                                        global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\Aabc\\Z","plNA&&\\1Myw&e",[multiline])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\Aabc\\Z","plNA&&\\1Myw&e",[multiline,
                                                                                                                                                                                                                     global])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","\\Aabc\\Z","tActj",[multiline])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","\\Aabc\\Z","tActj",[multiline,global])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","\\Aabc\\Z","&PAnUmSADdk",[multiline])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","\\Aabc\\Z","&PAnUmSADdk",[multiline,global])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","\\Aabc\\Z","O&&GYJA",[multiline])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","\\Aabc\\Z","O&&GYJA",[multiline,global])), 
?line <<"ejfGpamjOGidXfWabc
defiXJg">> = iolist_to_binary(re:replace("abc
def","\\A(.)*\\Z","ej\\1GpamjOGidX\\1W&iXJg",[dotall])), 
?line <<"ejfGpamjOGidXfWabc
defiXJg">> = iolist_to_binary(re:replace("abc
def","\\A(.)*\\Z","ej\\1GpamjOGidX\\1W&iXJg",[dotall,global])), 
?line <<"UTI*** FailersagVgtIFYe*** Failerss*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\A(.)*\\Z","UTI&agVgtIFYe&\\1&",[multiline])), 
?line <<"UTI*** FailersagVgtIFYe*** Failerss*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\A(.)*\\Z","UTI&agVgtIFYe&\\1&",[multiline,
                                                                                                                                                                                                                               global])), 
?line <<"abc
def">> = iolist_to_binary(re:replace("abc
def","\\A(.)*\\Z","&PHW&rh&xcxs\\1Cy&Chhd",[multiline])), 
?line <<"abc
def">> = iolist_to_binary(re:replace("abc
def","\\A(.)*\\Z","&PHW&rh&xcxs\\1Cy&Chhd",[multiline,global])), 
?line <<"cjOwaTTW::c">> = iolist_to_binary(re:replace("b::c","(?:b)|(?::+)","cjOwaTTW",[])), 
?line <<"cjOwaTTWcjOwaTTWc">> = iolist_to_binary(re:replace("b::c","(?:b)|(?::+)","cjOwaTTW",[global])), 
?line <<"c::ReJbWufqTUdDqlXQb">> = iolist_to_binary(re:replace("c::b","(?:b)|(?::+)","\\1&ReJbWufqTUdDqlXQ",[])), 
?line <<"c::ReJbWufqTUdDqlXQbReJbWufqTUdDqlXQ">> = iolist_to_binary(re:replace("c::b","(?:b)|(?::+)","\\1&ReJbWufqTUdDqlXQ",[global])), 
?line <<"az-uaz-obYOlaz-DVbrqaz-y">> = iolist_to_binary(re:replace("az-","[-az]+","&u&obYOl&DVbrq&y",[])), 
?line <<"az-uaz-obYOlaz-DVbrqaz-y">> = iolist_to_binary(re:replace("az-","[-az]+","&u&obYOl&DVbrq&y",[global])), 
?line <<"*** FAlNlPvDnUXilers">> = iolist_to_binary(re:replace("*** Failers","[-az]+","AlNlPvDn\\1UX",[])), 
?line <<"*** FAlNlPvDnUXilers">> = iolist_to_binary(re:replace("*** Failers","[-az]+","AlNlPvDn\\1UX",[global])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[-az]+","&xa\\1Q\\1BSaQG",[])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[-az]+","&xa\\1Q\\1BSaQG",[global])), 
?line <<"rJXv">> = iolist_to_binary(re:replace("za-","[az-]+","\\1rJXv",[])), 
?line <<"rJXv">> = iolist_to_binary(re:replace("za-","[az-]+","\\1rJXv",[global])), 
?line <<"*** FIQWDsCilers">> = iolist_to_binary(re:replace("*** Failers","[az-]+","IQWD\\1\\1sC",[])), 
?line <<"*** FIQWDsCilers">> = iolist_to_binary(re:replace("*** Failers","[az-]+","IQWD\\1\\1sC",[global])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[az-]+","G\\1TcEO\\1EAeKKLc&eOBg",[])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[az-]+","G\\1TcEO\\1EAeKKLc&eOBg",[global])), 
?line <<"DsdWoREvsWCDpa-z">> = iolist_to_binary(re:replace("a-z","[a\\-z]+","Dsd\\1WoREvsWCD\\1p&",[])), 
?line <<"DsdWoREvsWCDpa-z">> = iolist_to_binary(re:replace("a-z","[a\\-z]+","Dsd\\1WoREvsWCD\\1p&",[global])), 
?line <<"*** FaUqEUvbeKTpilers">> = iolist_to_binary(re:replace("*** Failers","[a\\-z]+","&U\\1qEUvbeKTp",[])), 
?line <<"*** FaUqEUvbeKTpilers">> = iolist_to_binary(re:replace("*** Failers","[a\\-z]+","&U\\1qEUvbeKTp",[global])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[a\\-z]+","IdIH&",[])), 
?line <<"b">> = iolist_to_binary(re:replace("b","[a\\-z]+","IdIH&",[global])), 
?line <<"CHIiEabcdxyzAXhIPVabcdxyz">> = iolist_to_binary(re:replace("abcdxyz","[a-z]+","CHIiE&AXhIPV&",[])), 
?line <<"CHIiEabcdxyzAXhIPVabcdxyz">> = iolist_to_binary(re:replace("abcdxyz","[a-z]+","CHIiE&AXhIPV&",[global])), 
?line <<"Tk12-34ptREc12-34dF">> = iolist_to_binary(re:replace("12-34","[\\d-]+","Tk&ptREc&dF\\1",[])), 
?line <<"Tk12-34ptREc12-34dF">> = iolist_to_binary(re:replace("12-34","[\\d-]+","Tk&ptREc&dF\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\d-]+","PO\\1\\1HuRnqA\\1miVVsKv",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\d-]+","PO\\1\\1HuRnqA\\1miVVsKv",[global])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","[\\d-]+","QMUbdeC\\1fKgUg",[])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","[\\d-]+","QMUbdeC\\1fKgUg",[global])), 
?line <<"YypJ">> = iolist_to_binary(re:replace("12-34z","[\\d-z]+","YypJ",[])), 
?line <<"YypJ">> = iolist_to_binary(re:replace("12-34z","[\\d-z]+","YypJ",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\d-z]+","d&ErDHl\\1&GDjyQy",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\d-z]+","d&ErDHl\\1&GDjyQy",[global])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","[\\d-z]+","EVkS",[])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","[\\d-z]+","EVkS",[global])), 
?line <<"cHd\\ltkGr\\BqrhP ">> = iolist_to_binary(re:replace("\\ ","\\x5c","cHd&ltkGr&Bqr\\1hP",[])), 
?line <<"cHd\\ltkGr\\BqrhP ">> = iolist_to_binary(re:replace("\\ ","\\x5c","cHd&ltkGr&Bqr\\1hP",[global])), 
?line <<"the Z Z ZciyfJLvoo">> = iolist_to_binary(re:replace("the Zoo","\\x20Z","&&&ciyf\\1JLv",[])), 
?line <<"the Z Z ZciyfJLvoo">> = iolist_to_binary(re:replace("the Zoo","\\x20Z","&&&ciyf\\1JLv",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\x20Z","ry\\1S\\1&\\1\\1MkYc",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\x20Z","ry\\1S\\1&\\1\\1MkYc",[global])), 
?line <<"Zulu">> = iolist_to_binary(re:replace("Zulu","\\x20Z","b\\1Wc&RB\\1&&pO&Dd\\1&A",[])), 
?line <<"Zulu">> = iolist_to_binary(re:replace("Zulu","\\x20Z","b\\1Wc&RB\\1&&pO&Dd\\1&A",[global])), 
?line <<"aabcabcUxryabcAPabcabcDGgL">> = iolist_to_binary(re:replace("abcabc","(abc)\\1","a&Uxry\\1AP&DGgL",[caseless])), 
?line <<"aabcabcUxryabcAPabcabcDGgL">> = iolist_to_binary(re:replace("abcabc","(abc)\\1","a&Uxry\\1AP&DGgL",[caseless,
                                                                                                                                                                                                           global])), 
?line <<"oStOWABCvVHVfFqojojfABC">> = iolist_to_binary(re:replace("ABCabc","(abc)\\1","oStOW\\1vVHVfFqojojf\\1",[caseless])), 
?line <<"oStOWABCvVHVfFqojojfABC">> = iolist_to_binary(re:replace("ABCabc","(abc)\\1","oStOW\\1vVHVfFqojojf\\1",[caseless,
                                                                                                                                                                                                                        global])), 
?line <<"GabcABCrGLdSabcABCWnHabcabcABCP">> = iolist_to_binary(re:replace("abcABC","(abc)\\1","G&rGLdS&WnH\\1&P",[caseless])), 
?line <<"GabcABCrGLdSabcABCWnHabcabcABCP">> = iolist_to_binary(re:replace("abcABC","(abc)\\1","G&rGLdS&WnH\\1&P",[caseless,
                                                                                                                                                                                                            global])), 
?line <<"KVwWyab{3cdEWMab{3cdPr">> = iolist_to_binary(re:replace("ab{3cd","ab{3cd","KVwWy&\\1EWM&Pr",[])), 
?line <<"KVwWyab{3cdEWMab{3cdPr">> = iolist_to_binary(re:replace("ab{3cd","ab{3cd","KVwWy&\\1EWM&Pr",[global])), 
?line <<"KuJab{3,cd">> = iolist_to_binary(re:replace("ab{3,cd","ab{3,cd","KuJ&",[])), 
?line <<"KuJab{3,cd">> = iolist_to_binary(re:replace("ab{3,cd","ab{3,cd","KuJ&",[global])), 
?line <<"squJfab{3,4a}cd">> = iolist_to_binary(re:replace("ab{3,4a}cd","ab{3,4a}cd","squ\\1Jf&",[])), 
?line <<"squJfab{3,4a}cd">> = iolist_to_binary(re:replace("ab{3,4a}cd","ab{3,4a}cd","squ\\1Jf&",[global])), 
?line <<"{4,5a}bc{4,5a}bcH">> = iolist_to_binary(re:replace("{4,5a}bc","{4,5a}bc","&&H",[])), 
?line <<"{4,5a}bc{4,5a}bcH">> = iolist_to_binary(re:replace("{4,5a}bc","{4,5a}bc","&&H",[global])), 
?line <<"nb">> = iolist_to_binary(re:replace("abc","abc$","nb",[])), 
?line <<"nb">> = iolist_to_binary(re:replace("abc","abc$","nb",[global])), 
?line <<"aabcTslrEK">> = iolist_to_binary(re:replace("abc","abc$","a&TslrEK",[])), 
?line <<"aabcTslrEK">> = iolist_to_binary(re:replace("abc","abc$","a&TslrEK",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc$","rVkXRL&nq&w\\1NDuHM\\1dj",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc$","rVkXRL&nq&w\\1NDuHM\\1dj",[global])), 
?line <<"abc
def">> = iolist_to_binary(re:replace("abc
def","abc$","M",[])), 
?line <<"abc
def">> = iolist_to_binary(re:replace("abc
def","abc$","M",[global])), 
?line <<"abcWCabcSYXGPjRugTabcVGabcSX">> = iolist_to_binary(re:replace("abcS","(abc)\\123","\\1WC&YXGPjRugT\\1VG&X",[])), 
?line <<"abcWCabcSYXGPjRugTabcVGabcSX">> = iolist_to_binary(re:replace("abcS","(abc)\\123","\\1WC&YXGPjRugT\\1VG&X",[global])), 
?line <<"fabcUabcUmiqabceCsabcabc">> = iolist_to_binary(re:replace("abc","(abc)\\223","f&U&Umiq\\1eCs\\1&",[])), 
?line <<"fabcUabcUmiqabceCsabcabc">> = iolist_to_binary(re:replace("abc","(abc)\\223","f&U&Umiq\\1eCs\\1&",[global])), 
?line <<"JRFabcxnbabcVkabcfWigQMuaY">> = iolist_to_binary(re:replace("abc","(abc)\\323","JRF\\1xnb&Vk&fWigQMuaY",[])), 
?line <<"JRFabcxnbabcVkabcfWigQMuaY">> = iolist_to_binary(re:replace("abc","(abc)\\323","JRF\\1xnb&Vk&fWigQMuaY",[global])), 
?line <<"vgabc@QQ">> = iolist_to_binary(re:replace("abc@","(abc)\\100","vg&QQ",[])), 
?line <<"vgabc@QQ">> = iolist_to_binary(re:replace("abc@","(abc)\\100","vg&QQ",[global])), 
?line <<"abc@OkvNytabc@abcabc@a">> = iolist_to_binary(re:replace("abc@","(abc)\\100","&OkvNyt&\\1&a",[])), 
?line <<"abc@OkvNytabc@abcabc@a">> = iolist_to_binary(re:replace("abc@","(abc)\\100","&OkvNyt&\\1&a",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","P&kRot\\1ILA",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","P&kRot\\1ILA",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","iULjBTiVDW&K\\1p&bj",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","iULjBTiVDW&K\\1p&bj",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","cplYw\\1iuv\\1Okstb\\1p",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","cplYw\\1iuv\\1Okstb\\1p",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","LDaRV&lAu\\1i",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","LDaRV&lAu\\1i",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","K\\1",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","K\\1",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","cXHTTaJLMXvR&\\1",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","(abc)\\1000","cXHTTaJLMXvR&\\1",[global])), 
?line <<"abc81">> = iolist_to_binary(re:replace("abc81","abc\\81","\\1kB&oGS\\1\\1lPn",[])), 
?line <<"abc81">> = iolist_to_binary(re:replace("abc81","abc\\81","\\1kB&oGS\\1\\1lPn",[global])), 
?line <<"abc81">> = iolist_to_binary(re:replace("abc81","abc\\81","\\1",[])), 
?line <<"abc81">> = iolist_to_binary(re:replace("abc81","abc\\81","\\1",[global])), 
?line <<"abc91">> = iolist_to_binary(re:replace("abc91","abc\\91","\\1GKLIQYEGVpGIxagx&&",[])), 
?line <<"abc91">> = iolist_to_binary(re:replace("abc91","abc\\91","\\1GKLIQYEGVpGIxagx&&",[global])), 
?line <<"abc91">> = iolist_to_binary(re:replace("abc91","abc\\91","og&&Tlj&jCLkmrllagN",[])), 
?line <<"abc91">> = iolist_to_binary(re:replace("abc91","abc\\91","og&&Tlj&jCLkmrllagN",[global])), 
?line <<"xMFEgabcdefghijkllSDGabcdefghijkllSN">> = iolist_to_binary(re:replace("abcdefghijkllS","(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)\\12\\123","xMFEg&DG&N",[])), 
?line <<"xMFEgabcdefghijkllSDGabcdefghijkllSN">> = iolist_to_binary(re:replace("abcdefghijkllS","(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)(l)\\12\\123","xMFEg&DG&N",[global])), 
?line <<"WyroFQabcdefghijk
SNfabcdefghijk
SahyoPabcdefghijk
Sqfbs">> = iolist_to_binary(re:replace("abcdefghijk
S","(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\12\\123","WyroFQ&Nf&ahyoP&qfbs",[])), 
?line <<"WyroFQabcdefghijk
SNfabcdefghijk
SahyoPabcdefghijk
Sqfbs">> = iolist_to_binary(re:replace("abcdefghijk
S","(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\12\\123","WyroFQ&Nf&ahyoP&qfbs",[global])), 
?line <<"fCnqsFE">> = iolist_to_binary(re:replace("abidef","ab\\idef","fCnqs\\1FE",[])), 
?line <<"fCnqsFE">> = iolist_to_binary(re:replace("abidef","ab\\idef","fCnqs\\1FE",[global])), 
?line <<"QFATItqr">> = iolist_to_binary(re:replace("bc","a{0}bc","Q\\1FAT\\1Itqr",[])), 
?line <<"QFATItqr">> = iolist_to_binary(re:replace("bc","a{0}bc","Q\\1FAT\\1Itqr",[global])), 
?line <<"DnNn">> = iolist_to_binary(re:replace("xyz","(a|(bc)){0,0}?xyz","DnNn",[])), 
?line <<"DnNn">> = iolist_to_binary(re:replace("xyz","(a|(bc)){0,0}?xyz","DnNn",[global])), 
?line <<"GlvWIgK">> = iolist_to_binary(re:replace("abcde","abc[\\10]de","GlvW\\1\\1IgK",[])), 
?line <<"GlvWIgK">> = iolist_to_binary(re:replace("abcde","abc[\\10]de","GlvW\\1\\1IgK",[global])), 
?line <<"KDyabcdeXgxxbvI">> = iolist_to_binary(re:replace("abcde","abc[\\1]de","KDy&XgxxbvI",[])), 
?line <<"KDyabcdeXgxxbvI">> = iolist_to_binary(re:replace("abcde","abc[\\1]de","KDy&XgxxbvI",[global])), 
?line <<"abcSYuXabcUabckewfJS">> = iolist_to_binary(re:replace("abcde","(abc)[\\1]de","\\1SYuX\\1U\\1kewfJS",[])), 
?line <<"abcSYuXabcUabckewfJS">> = iolist_to_binary(re:replace("abcde","(abc)[\\1]de","\\1SYuX\\1U\\1kewfJS",[global])), 
?line <<"a
b">> = iolist_to_binary(re:replace("a
b","(?s)a.b","&",[])), 
?line <<"a
b">> = iolist_to_binary(re:replace("a
b","(?s)a.b","&",[global])), 
?line <<"sILYgbGPUbaNOTcccceynxed">> = iolist_to_binary(re:replace("baNOTccccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","sILYg\\1GPU&eynxe",[])), 
?line <<"sILYgbGPUbaNOTcccceynxed">> = iolist_to_binary(re:replace("baNOTccccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","sILYg\\1GPU&eynxe",[global])), 
?line <<"bURwd">> = iolist_to_binary(re:replace("baNOTcccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","\\1URw",[])), 
?line <<"bURwd">> = iolist_to_binary(re:replace("baNOTcccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","\\1URw",[global])), 
?line <<"rRcqtdVUmd">> = iolist_to_binary(re:replace("baNOTccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","rRcqtdVUm",[])), 
?line <<"rRcqtdVUmd">> = iolist_to_binary(re:replace("baNOTccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","rRcqtdVUm",[global])), 
?line <<"lYsStJbdoraarRd">> = iolist_to_binary(re:replace("bacccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","lYsStJ\\1doraarR",[])), 
?line <<"lYsStJbdoraarRd">> = iolist_to_binary(re:replace("bacccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","lYsStJ\\1doraarR",[global])), 
?line <<"*** Failersyu**c*** Failers*KH">> = iolist_to_binary(re:replace("*** Failers","^([^a])([^\\b])([^c]*)([^d]{3,4})","&yu\\1\\1c&\\1KH",[])), 
?line <<"*** Failersyu**c*** Failers*KH">> = iolist_to_binary(re:replace("*** Failers","^([^a])([^\\b])([^c]*)([^d]{3,4})","&yu\\1\\1c&\\1KH",[global])), 
?line <<"anything">> = iolist_to_binary(re:replace("anything","^([^a])([^\\b])([^c]*)([^d]{3,4})","&xLcPYkjD\\1YuJHCYWAIc",[])), 
?line <<"anything">> = iolist_to_binary(re:replace("anything","^([^a])([^\\b])([^c]*)([^d]{3,4})","&xLcPYkjD\\1YuJHCYWAIc",[global])), 
?line <<"bc">> = iolist_to_binary(re:replace("bc","^([^a])([^\\b])([^c]*)([^d]{3,4})","l\\1RIA&evjlHaNPGsYSx",[])), 
?line <<"bc">> = iolist_to_binary(re:replace("bc","^([^a])([^\\b])([^c]*)([^d]{3,4})","l\\1RIA&evjlHaNPGsYSx",[global])), 
?line <<"baccd">> = iolist_to_binary(re:replace("baccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","SfTsSTMDCrU",[])), 
?line <<"baccd">> = iolist_to_binary(re:replace("baccd","^([^a])([^\\b])([^c]*)([^d]{3,4})","SfTsSTMDCrU",[global])), 
?line <<"KqAssSsdXronRAsbc">> = iolist_to_binary(re:replace("Abc","[^a]","Kq&s\\1sSsdXronR&s\\1",[])), 
?line <<"KqAssSsdXronRAsKqbssSsdXronRbsKqcssSsdXronRcs">> = iolist_to_binary(re:replace("Abc","[^a]","Kq&s\\1sSsdXronR&s\\1",[global])), 
?line <<"AXxbehbnMtJMOjc">> = iolist_to_binary(re:replace("Abc","[^a]","Xx&eh&nMtJMOj",[caseless])), 
?line <<"AXxbehbnMtJMOjXxcehcnMtJMOj">> = iolist_to_binary(re:replace("Abc","[^a]","Xx&eh&nMtJMOj",[caseless,
                                                                                                                                                                                     global])), 
?line <<"owGHnKmdtjnrJgSkEfaAbc">> = iolist_to_binary(re:replace("AAAaAbc","[^a]+","owGHnKmdtjnrJgSkEf",[])), 
?line <<"owGHnKmdtjnrJgSkEfaowGHnKmdtjnrJgSkEf">> = iolist_to_binary(re:replace("AAAaAbc","[^a]+","owGHnKmdtjnrJgSkEf",[global])), 
?line <<"AAAaAkm">> = iolist_to_binary(re:replace("AAAaAbc","[^a]+","\\1km",[caseless])), 
?line <<"AAAaAkm">> = iolist_to_binary(re:replace("AAAaAbc","[^a]+","\\1km",[caseless,
                                                                                                                                                                              global])), 
?line <<"iBIdW">> = iolist_to_binary(re:replace("bbb
ccc","[^a]+","iB\\1I\\1d\\1\\1W",[])), 
?line <<"iBIdW">> = iolist_to_binary(re:replace("bbb
ccc","[^a]+","iB\\1I\\1d\\1\\1W",[global])), 
?line <<"abDIvvGgnrbcKkaSCbuiv">> = iolist_to_binary(re:replace("abc","[^k]$","DIvvGgnrb&KkaSCbuiv\\1",[])), 
?line <<"abDIvvGgnrbcKkaSCbuiv">> = iolist_to_binary(re:replace("abc","[^k]$","DIvvGgnrb&KkaSCbuiv\\1",[global])), 
?line <<"*** FailerbswvPHxEss">> = iolist_to_binary(re:replace("*** Failers","[^k]$","b&wvPH\\1xE&&",[])), 
?line <<"*** FailerbswvPHxEss">> = iolist_to_binary(re:replace("*** Failers","[^k]$","b&wvPH\\1xE&&",[global])), 
?line <<"abk">> = iolist_to_binary(re:replace("abk","[^k]$","nWvCPNUa\\1iDnbay",[])), 
?line <<"abk">> = iolist_to_binary(re:replace("abk","[^k]$","nWvCPNUa\\1iDnbay",[global])), 
?line <<"HWSo">> = iolist_to_binary(re:replace("abc","[^k]{2,3}$","HWSo\\1",[])), 
?line <<"HWSo">> = iolist_to_binary(re:replace("abc","[^k]{2,3}$","HWSo\\1",[global])), 
?line <<"kNKYkjbsvgnUOybcsuN">> = iolist_to_binary(re:replace("kbc","[^k]{2,3}$","NKYkjbsvgn\\1UO\\1y&suN",[])), 
?line <<"kNKYkjbsvgnUOybcsuN">> = iolist_to_binary(re:replace("kbc","[^k]{2,3}$","NKYkjbsvgn\\1UO\\1y&suN",[global])), 
?line <<"kDhBIRhnabc">> = iolist_to_binary(re:replace("kabc","[^k]{2,3}$","DhBIRhn&",[])), 
?line <<"kDhBIRhnabc">> = iolist_to_binary(re:replace("kabc","[^k]{2,3}$","DhBIRhn&",[global])), 
?line <<"*** FailQmVy">> = iolist_to_binary(re:replace("*** Failers","[^k]{2,3}$","QmVy",[])), 
?line <<"*** FailQmVy">> = iolist_to_binary(re:replace("*** Failers","[^k]{2,3}$","QmVy",[global])), 
?line <<"abk">> = iolist_to_binary(re:replace("abk","[^k]{2,3}$","L&e",[])), 
?line <<"abk">> = iolist_to_binary(re:replace("abk","[^k]{2,3}$","L&e",[global])), 
?line <<"akb">> = iolist_to_binary(re:replace("akb","[^k]{2,3}$","\\1aD\\1u&",[])), 
?line <<"akb">> = iolist_to_binary(re:replace("akb","[^k]{2,3}$","\\1aD\\1u&",[global])), 
?line <<"akk">> = iolist_to_binary(re:replace("akk","[^k]{2,3}$","lPwfbQvWcRAypQ&",[])), 
?line <<"akk">> = iolist_to_binary(re:replace("akk","[^k]{2,3}$","lPwfbQvWcRAypQ&",[global])), 
?line <<"12345678.b.c.d">> = iolist_to_binary(re:replace("12345678.b.c.d","^\\d{8,}\\@.+[^k]$","VKe&\\1iCfITU\\1&nqEh",[])), 
?line <<"12345678.b.c.d">> = iolist_to_binary(re:replace("12345678.b.c.d","^\\d{8,}\\@.+[^k]$","VKe&\\1iCfITU\\1&nqEh",[global])), 
?line <<"123456789.y.z">> = iolist_to_binary(re:replace("123456789.y.z","^\\d{8,}\\@.+[^k]$","aW\\1Jg&g",[])), 
?line <<"123456789.y.z">> = iolist_to_binary(re:replace("123456789.y.z","^\\d{8,}\\@.+[^k]$","aW\\1Jg&g",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\d{8,}\\@.+[^k]$","lHO",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^\\d{8,}\\@.+[^k]$","lHO",[global])), 
?line <<"12345678.y.uk">> = iolist_to_binary(re:replace("12345678.y.uk","^\\d{8,}\\@.+[^k]$","uVLRBqgT\\1c&\\1",[])), 
?line <<"12345678.y.uk">> = iolist_to_binary(re:replace("12345678.y.uk","^\\d{8,}\\@.+[^k]$","uVLRBqgT\\1c&\\1",[global])), 
?line <<"1234567.b.c.d">> = iolist_to_binary(re:replace("1234567.b.c.d","^\\d{8,}\\@.+[^k]$","VRE&uJDdtsECL",[])), 
?line <<"1234567.b.c.d">> = iolist_to_binary(re:replace("1234567.b.c.d","^\\d{8,}\\@.+[^k]$","VRE&uJDdtsECL",[global])), 
?line <<"XJnEEHYdC">> = iolist_to_binary(re:replace("aaaaaaaaa","(a)\\1{8,}","XJnEEHYdC",[])), 
?line <<"XJnEEHYdC">> = iolist_to_binary(re:replace("aaaaaaaaa","(a)\\1{8,}","XJnEEHYdC",[global])), 
?line <<"eviBaaaaaaaaaaaKMfaysHkyJyKi">> = iolist_to_binary(re:replace("aaaaaaaaaa","(a)\\1{8,}","eviB\\1&KMfaysHkyJyKi",[])), 
?line <<"eviBaaaaaaaaaaaKMfaysHkyJyKi">> = iolist_to_binary(re:replace("aaaaaaaaaa","(a)\\1{8,}","eviB\\1&KMfaysHkyJyKi",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a)\\1{8,}","DjllScfItkb&J&&Nv\\1\\1C",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a)\\1{8,}","DjllScfItkb&J&&Nv\\1\\1C",[global])), 
?line <<"aaaaaaa">> = iolist_to_binary(re:replace("aaaaaaa","(a)\\1{8,}","W&Bp\\1Bem",[])), 
?line <<"aaaaaaa">> = iolist_to_binary(re:replace("aaaaaaa","(a)\\1{8,}","W&Bp\\1Bem",[global])), 
?line <<"aaaaIEWbcd">> = iolist_to_binary(re:replace("aaaabcd","[^a]","IEW\\1&",[])), 
?line <<"aaaaIEWbIEWcIEWd">> = iolist_to_binary(re:replace("aaaabcd","[^a]","IEW\\1&",[global])), 
?line <<"aarhjHFaNDBbwVabcd">> = iolist_to_binary(re:replace("aaAabcd","[^a]","r\\1hjHFaNDBbwV",[])), 
?line <<"aarhjHFaNDBbwVarhjHFaNDBbwVrhjHFaNDBbwVrhjHFaNDBbwV">> = iolist_to_binary(re:replace("aaAabcd","[^a]","r\\1hjHFaNDBbwV",[global])), 
?line <<"aaaaUVFcd">> = iolist_to_binary(re:replace("aaaabcd","[^a]","U\\1V\\1F",[caseless])), 
?line <<"aaaaUVFUVFUVF">> = iolist_to_binary(re:replace("aaaabcd","[^a]","U\\1V\\1F",[caseless,
                                                                                                                                                                                     global])), 
?line <<"aaAacbLmqbDepcd">> = iolist_to_binary(re:replace("aaAabcd","[^a]","c&Lmq&De\\1p",[caseless])), 
?line <<"aaAacbLmqbDepccLmqcDepcdLmqdDep">> = iolist_to_binary(re:replace("aaAabcd","[^a]","c&Lmq&De\\1p",[caseless,
                                                                                                                                                                                            global])), 
?line <<"aaaaFtrLcd">> = iolist_to_binary(re:replace("aaaabcd","[^az]","Ftr\\1L",[])), 
?line <<"aaaaFtrLFtrLFtrL">> = iolist_to_binary(re:replace("aaaabcd","[^az]","Ftr\\1L",[global])), 
?line <<"aaxQoACFyabcd">> = iolist_to_binary(re:replace("aaAabcd","[^az]","xQo&C\\1Fy",[])), 
?line <<"aaxQoACFyaxQobCFyxQocCFyxQodCFy">> = iolist_to_binary(re:replace("aaAabcd","[^az]","xQo&C\\1Fy",[global])), 
?line <<"aaaawiJAqfcd">> = iolist_to_binary(re:replace("aaaabcd","[^az]","wiJ\\1Aq\\1f",[caseless])), 
?line <<"aaaawiJAqfwiJAqfwiJAqf">> = iolist_to_binary(re:replace("aaaabcd","[^az]","wiJ\\1Aq\\1f",[caseless,
                                                                                                                                                                                             global])), 
?line <<"aaAabheGsmSFcd">> = iolist_to_binary(re:replace("aaAabcd","[^az]","bheGsmSF",[caseless])), 
?line <<"aaAabheGsmSFbheGsmSFbheGsmSF">> = iolist_to_binary(re:replace("aaAabcd","[^az]","bheGsmSF",[caseless,
                                                                                                                                                                                   global])), 
?line <<"xxxxxxxxxxxINrCehGlgxfQWogKhXjxxxxxxxxx">> = iolist_to_binary(re:replace("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx","P[^*]TAIRE[^*]{1,6}?LL","INrCe\\1hGlgxfQWogKhXj",[])), 
?line <<"xxxxxxxxxxxINrCehGlgxfQWogKhXjxxxxxxxxx">> = iolist_to_binary(re:replace("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx","P[^*]TAIRE[^*]{1,6}?LL","INrCe\\1hGlgxfQWogKhXj",[global])), 
?line <<"xxxxxxxxxxxSxxxxxxxxx">> = iolist_to_binary(re:replace("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx","P[^*]TAIRE[^*]{1,}?LL","S",[])), 
?line <<"xxxxxxxxxxxSxxxxxxxxx">> = iolist_to_binary(re:replace("xxxxxxxxxxxPSTAIREISLLxxxxxxxxx","P[^*]TAIRE[^*]{1,}?LL","S",[global])), 
?line <<"1yO.230003938DJNUSE">> = iolist_to_binary(re:replace("1.230003938","(\\.\\d\\d[1-9]?)\\d+","yO&DJNUSE",[])), 
?line <<"1yO.230003938DJNUSE">> = iolist_to_binary(re:replace("1.230003938","(\\.\\d\\d[1-9]?)\\d+","yO&DJNUSE",[global])), 
?line <<"1J.875RCmc.875000282SWmWrLgf">> = iolist_to_binary(re:replace("1.875000282","(\\.\\d\\d[1-9]?)\\d+","J\\1RCmc&SWmWrLgf",[])), 
?line <<"1J.875RCmc.875000282SWmWrLgf">> = iolist_to_binary(re:replace("1.875000282","(\\.\\d\\d[1-9]?)\\d+","J\\1RCmc&SWmWrLgf",[global])), 
?line <<"1QhH.23A.235j">> = iolist_to_binary(re:replace("1.235","(\\.\\d\\d[1-9]?)\\d+","QhH\\1A&j",[])), 
?line <<"1QhH.23A.235j">> = iolist_to_binary(re:replace("1.235","(\\.\\d\\d[1-9]?)\\d+","QhH\\1A&j",[global])), 
?line <<"1ASoXGLgq.23gkJkohg.23pCC0003938">> = iolist_to_binary(re:replace("1.230003938","(\\.\\d\\d((?=0)|\\d(?=\\d)))","ASoXGLgq\\1gkJkohg\\1pCC",[])), 
?line <<"1ASoXGLgq.23gkJkohg.23pCC0003938">> = iolist_to_binary(re:replace("1.230003938","(\\.\\d\\d((?=0)|\\d(?=\\d)))","ASoXGLgq\\1gkJkohg\\1pCC",[global])), 
?line <<"1rmMcAlqV000282">> = iolist_to_binary(re:replace("1.875000282","(\\.\\d\\d((?=0)|\\d(?=\\d)))","rmMcAlqV",[])), 
?line <<"1rmMcAlqV000282">> = iolist_to_binary(re:replace("1.875000282","(\\.\\d\\d((?=0)|\\d(?=\\d)))","rmMcAlqV",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(\\.\\d\\d((?=0)|\\d(?=\\d)))","wpfYj&AA",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(\\.\\d\\d((?=0)|\\d(?=\\d)))","wpfYj&AA",[global])), 
?line <<"1.235">> = iolist_to_binary(re:replace("1.235","(\\.\\d\\d((?=0)|\\d(?=\\d)))","Kq&VgFL",[])), 
?line <<"1.235">> = iolist_to_binary(re:replace("1.235","(\\.\\d\\d((?=0)|\\d(?=\\d)))","Kq&VgFL",[global])), 
?line <<"JabwbScGoababcabE">> = iolist_to_binary(re:replace("ab","a(?)b","J&wbSc\\1Go&\\1\\1&c&E",[])), 
?line <<"JabwbScGoababcabE">> = iolist_to_binary(re:replace("ab","a(?)b","J&wbSc\\1Go&\\1\\1&c&E",[global])), 
?line <<"Food is on the Qfoo tableygvPjujxbaDigfoo tablegCefoo table">> = iolist_to_binary(re:replace("Food is on the foo table","\\b(foo)\\s+(\\w+)","Q&ygvPjujxbaDig&gCe&",[caseless])), 
?line <<"Food is on the Qfoo tableygvPjujxbaDigfoo tablegCefoo table">> = iolist_to_binary(re:replace("Food is on the foo table","\\b(foo)\\s+(\\w+)","Q&ygvPjujxbaDig&gCe&",[caseless,
                                                                                                                                                                                                                                                                             global])), 
?line <<"The pBETCXLfood is under the bar in the barWwWn.">> = iolist_to_binary(re:replace("The food is under the bar in the barn.","foo(.*)bar","pBETCXL&WwW",[])), 
?line <<"The pBETCXLfood is under the bar in the barWwWn.">> = iolist_to_binary(re:replace("The food is under the bar in the barn.","foo(.*)bar","pBETCXL&WwW",[global])), 
?line <<"The nfood is under the barnSrtWBfood is under the barXapfood is under the barr in the barn.">> = iolist_to_binary(re:replace("The food is under the bar in the barn.","foo(.*?)bar","n&nSrtWB&Xap&r",[])), 
?line <<"The nfood is under the barnSrtWBfood is under the barXapfood is under the barr in the barn.">> = iolist_to_binary(re:replace("The food is under the bar in the barn.","foo(.*?)bar","n&nSrtWB&Xap&r",[global])), 
?line <<"GI have 2 numbers: 53147mNBu">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d*)","G&mNBu",[])), 
?line <<"GI have 2 numbers: 53147mNBuGmNBu">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d*)","G&mNBu",[global])), 
?line <<"SI have 2 numbers: 53147">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d+)","S&",[])), 
?line <<"SI have 2 numbers: 53147">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d+)","S&",[global])), 
?line <<"bGeEvMOYIVDQHJHuI have 2 numbers: 53147">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d*)","bGeEvMO\\1YIVDQ&HJHu",[])), 
?line <<"bGeEvMOYIVDQHJHubGeEvMOIYIVDQIHJHubGeEvMOYIVDQHJHubGeEvMO YIVDQ HJHubGeEvMOYIVDQHJHubGeEvMOhYIVDQhHJHubGeEvMOYIVDQHJHubGeEvMOaYIVDQaHJHubGeEvMOYIVDQHJHubGeEvMOvYIVDQvHJHubGeEvMOYIVDQHJHubGeEvMOeYIVDQeHJHubGeEvMOYIVDQHJHubGeEvMO YIVDQ 2HJHubGeEvMOYIVDQHJHubGeEvMO YIVDQ HJHubGeEvMOYIVDQHJHubGeEvMOnYIVDQnHJHubGeEvMOYIVDQHJHubGeEvMOuYIVDQuHJHubGeEvMOYIVDQHJHubGeEvMOmYIVDQmHJHubGeEvMOYIVDQHJHubGeEvMObYIVDQbHJHubGeEvMOYIVDQHJHubGeEvMOeYIVDQeHJHubGeEvMOYIVDQHJHubGeEvMOrYIVDQrHJHubGeEvMOYIVDQHJHubGeEvMOsYIVDQsHJHubGeEvMOYIVDQHJHubGeEvMO:YIVDQ:HJHubGeEvMOYIVDQHJHubGeEvMO YIVDQ 53147HJHubGeEvMOYIVDQHJHu">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d*)","bGeEvMO\\1YIVDQ&HJHu",[global])), 
?line <<"I have tsI have cgpNHsI have I have U numbers: 53147">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d+)","\\1ts\\1cgpNHs\\1\\1U",[])), 
?line <<"I have tsI have cgpNHsI have I have U numbers: ts numbers: cgpNHs numbers:  numbers: U">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d+)","\\1ts\\1cgpNHs\\1\\1U",[global])), 
?line <<"mwinCVPlFdkqGucU">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d+)$","mwinCVPlFdkqGucU",[])), 
?line <<"mwinCVPlFdkqGucU">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)(\\d+)$","mwinCVPlFdkqGucU",[global])), 
?line <<"I have 2 numbers: 53147I have 2 numbers: 53147I have 2 numbers: 53147pEI have 2 numbers: 53147o">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d+)$","&&&pE&o",[])), 
?line <<"I have 2 numbers: 53147I have 2 numbers: 53147I have 2 numbers: 53147pEI have 2 numbers: 53147o">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*?)(\\d+)$","&&&pE&o",[global])), 
?line <<"ym">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)\\b(\\d+)$","ym",[])), 
?line <<"ym">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*)\\b(\\d+)$","ym",[global])), 
?line <<"FI have 2 numbers: 53147QSb">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*\\D)(\\d+)$","F&QSb",[])), 
?line <<"FI have 2 numbers: 53147QSb">> = iolist_to_binary(re:replace("I have 2 numbers: 53147","(.*\\D)(\\d+)$","F&QSb",[global])), 
?line <<"ABDGFHjyNAtuJTC123">> = iolist_to_binary(re:replace("ABC123","^\\D*(?!123)","&DGFHjyNAtu\\1JT",[])), 
?line <<"ABDGFHjyNAtuJTC123">> = iolist_to_binary(re:replace("ABC123","^\\D*(?!123)","&DGFHjyNAtu\\1JT",[global])), 
?line <<"ABCUxCRnmWFAQVrawlJ445">> = iolist_to_binary(re:replace("ABC445","^(\\D*)(?=\\d)(?!123)","\\1UxCRnmWFAQVrawlJ",[])), 
?line <<"ABCUxCRnmWFAQVrawlJ445">> = iolist_to_binary(re:replace("ABC445","^(\\D*)(?=\\d)(?!123)","\\1UxCRnmWFAQVrawlJ",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\D*)(?=\\d)(?!123)","X\\1uOv\\1PUbsw&IOcqB",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(\\D*)(?=\\d)(?!123)","X\\1uOv\\1PUbsw&IOcqB",[global])), 
?line <<"ABC123">> = iolist_to_binary(re:replace("ABC123","^(\\D*)(?=\\d)(?!123)","&efpcH\\1vtp",[])), 
?line <<"ABC123">> = iolist_to_binary(re:replace("ABC123","^(\\D*)(?=\\d)(?!123)","&efpcH\\1vtp",[global])), 
?line <<"X789">> = iolist_to_binary(re:replace("W46]789","^[W-]46]","X",[])), 
?line <<"X789">> = iolist_to_binary(re:replace("W46]789","^[W-]46]","X",[global])), 
?line <<"-46]GqowvnKBMivOCTQ789">> = iolist_to_binary(re:replace("-46]789","^[W-]46]","&GqowvnKBMiv\\1\\1OCTQ",[])), 
?line <<"-46]GqowvnKBMivOCTQ789">> = iolist_to_binary(re:replace("-46]789","^[W-]46]","&GqowvnKBMiv\\1\\1OCTQ",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-]46]","VkkVbQHsQJe\\1Oqgp",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-]46]","VkkVbQHsQJe\\1Oqgp",[global])), 
?line <<"Wall">> = iolist_to_binary(re:replace("Wall","^[W-]46]","A\\1",[])), 
?line <<"Wall">> = iolist_to_binary(re:replace("Wall","^[W-]46]","A\\1",[global])), 
?line <<"Zebra">> = iolist_to_binary(re:replace("Zebra","^[W-]46]","D\\1Gh&rRMY",[])), 
?line <<"Zebra">> = iolist_to_binary(re:replace("Zebra","^[W-]46]","D\\1Gh&rRMY",[global])), 
?line <<"42">> = iolist_to_binary(re:replace("42","^[W-]46]","&NkVKe",[])), 
?line <<"42">> = iolist_to_binary(re:replace("42","^[W-]46]","&NkVKe",[global])), 
?line <<"[abcd]">> = iolist_to_binary(re:replace("[abcd]","^[W-]46]","UhUNReBRM\\1AIyjJpNT",[])), 
?line <<"[abcd]">> = iolist_to_binary(re:replace("[abcd]","^[W-]46]","UhUNReBRM\\1AIyjJpNT",[global])), 
?line <<"]abcd[">> = iolist_to_binary(re:replace("]abcd[","^[W-]46]","&GSivk\\1PUgboDgD\\1Q&\\1",[])), 
?line <<"]abcd[">> = iolist_to_binary(re:replace("]abcd[","^[W-]46]","&GSivk\\1PUgboDgD\\1Q&\\1",[global])), 
?line <<"CiPKWjJuYp46]789">> = iolist_to_binary(re:replace("W46]789","^[W-\\]46]","CiPK&jJuYp",[])), 
?line <<"CiPKWjJuYp46]789">> = iolist_to_binary(re:replace("W46]789","^[W-\\]46]","CiPK&jJuYp",[global])), 
?line <<"WWGQUxNBall">> = iolist_to_binary(re:replace("Wall","^[W-\\]46]","&&G\\1QUxN\\1\\1B",[])), 
?line <<"WWGQUxNBall">> = iolist_to_binary(re:replace("Wall","^[W-\\]46]","&&G\\1QUxN\\1\\1B",[global])), 
?line <<"BBmKOIEOebra">> = iolist_to_binary(re:replace("Zebra","^[W-\\]46]","BBmKOI\\1E\\1O",[])), 
?line <<"BBmKOIEOebra">> = iolist_to_binary(re:replace("Zebra","^[W-\\]46]","BBmKOI\\1E\\1O",[global])), 
?line <<"fsXBGOoQmDJroEwPIXEylophone">> = iolist_to_binary(re:replace("Xylophone","^[W-\\]46]","f\\1s&BGOoQmDJroEwPI&E",[])), 
?line <<"fsXBGOoQmDJroEwPIXEylophone">> = iolist_to_binary(re:replace("Xylophone","^[W-\\]46]","f\\1s&BGOoQmDJroEwPI&E",[global])), 
?line <<"rtkSPUv4c2">> = iolist_to_binary(re:replace("42","^[W-\\]46]","rtkSPUv&c",[])), 
?line <<"rtkSPUv4c2">> = iolist_to_binary(re:replace("42","^[W-\\]46]","rtkSPUv&c",[global])), 
?line <<"AqCR[dTqabcd]">> = iolist_to_binary(re:replace("[abcd]","^[W-\\]46]","AqCR\\1&dTq",[])), 
?line <<"AqCR[dTqabcd]">> = iolist_to_binary(re:replace("[abcd]","^[W-\\]46]","AqCR\\1&dTq",[global])), 
?line <<"XG]JRsPEtL]eoabcd[">> = iolist_to_binary(re:replace("]abcd[","^[W-\\]46]","XG&JRsPEtL&e\\1o",[])), 
?line <<"XG]JRsPEtL]eoabcd[">> = iolist_to_binary(re:replace("]abcd[","^[W-\\]46]","XG&JRsPEtL&e\\1o",[global])), 
?line <<"YrokgJhnnbackslash">> = iolist_to_binary(re:replace("\\backslash","^[W-\\]46]","YrokgJhnn\\1",[])), 
?line <<"YrokgJhnnbackslash">> = iolist_to_binary(re:replace("\\backslash","^[W-\\]46]","YrokgJhnn\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-\\]46]","\\1l",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[W-\\]46]","\\1l",[global])), 
?line <<"-46]789">> = iolist_to_binary(re:replace("-46]789","^[W-\\]46]","lUctT",[])), 
?line <<"-46]789">> = iolist_to_binary(re:replace("-46]789","^[W-\\]46]","lUctT",[global])), 
?line <<"well">> = iolist_to_binary(re:replace("well","^[W-\\]46]","xELX&QH\\1AsnFr&SH",[])), 
?line <<"well">> = iolist_to_binary(re:replace("well","^[W-\\]46]","xELX&QH\\1AsnFr&SH",[global])), 
?line <<"vword cat dog elephant mussel cow horse canary baboon snake shark otherwordword cat dog elephant mussel cow horse canary baboon snake shark otherwordKteyKVE">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark otherword","word (?:[a-zA-Z0-9]+ ){0,10}otherword","v&&KteyKVE\\1",[])), 
?line <<"vword cat dog elephant mussel cow horse canary baboon snake shark otherwordword cat dog elephant mussel cow horse canary baboon snake shark otherwordKteyKVE">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark otherword","word (?:[a-zA-Z0-9]+ ){0,10}otherword","v&&KteyKVE\\1",[global])), 
?line <<"word cat dog elephant mussel cow horse canary baboon snake shark">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark","word (?:[a-zA-Z0-9]+ ){0,10}otherword","wUEYJgw",[])), 
?line <<"word cat dog elephant mussel cow horse canary baboon snake shark">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark","word (?:[a-zA-Z0-9]+ ){0,10}otherword","wUEYJgw",[global])), 
?line <<"word cat dog elephant mussel cow horse canary baboon snake shark the quick brown fox and the lazy dog and several other words getting close to thirty by now I hope">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark the quick brown fox and the lazy dog and several other words getting close to thirty by now I hope","word (?:[a-zA-Z0-9]+ ){0,300}otherword","ABdTK\\1Y\\1",[])), 
?line <<"word cat dog elephant mussel cow horse canary baboon snake shark the quick brown fox and the lazy dog and several other words getting close to thirty by now I hope">> = iolist_to_binary(re:replace("word cat dog elephant mussel cow horse canary baboon snake shark the quick brown fox and the lazy dog and several other words getting close to thirty by now I hope","word (?:[a-zA-Z0-9]+ ){0,300}otherword","ABdTK\\1Y\\1",[global])), 
?line <<"CahYoKbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,0}","\\1CahYoK",[])), 
?line <<"CahYoKbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,0}","\\1CahYoK",[global])), 
?line <<"QcFabc">> = iolist_to_binary(re:replace("abc","^(a){0,0}","&QcF",[])), 
?line <<"QcFabc">> = iolist_to_binary(re:replace("abc","^(a){0,0}","&QcF",[global])), 
?line <<"BvdvcHaab">> = iolist_to_binary(re:replace("aab","^(a){0,0}","BvdvcH",[])), 
?line <<"BvdvcHaab">> = iolist_to_binary(re:replace("aab","^(a){0,0}","BvdvcH",[global])), 
?line <<"mtLIyIhdbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,1}","mtL\\1IyIhd",[])), 
?line <<"mtLIyIhdbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,1}","mtL\\1IyIhd",[global])), 
?line <<"oaDoeSPhHaNhncDqkiabc">> = iolist_to_binary(re:replace("abc","^(a){0,1}","o\\1DoeSPhH&NhncDqki\\1",[])), 
?line <<"oaDoeSPhHaNhncDqkiabc">> = iolist_to_binary(re:replace("abc","^(a){0,1}","o\\1DoeSPhH&NhncDqki\\1",[global])), 
?line <<"ahaXsxVhaFHSKPhapJQab">> = iolist_to_binary(re:replace("aab","^(a){0,1}","\\1h\\1XsxVh\\1FHSKPhapJQ",[])), 
?line <<"ahaXsxVhaFHSKPhapJQab">> = iolist_to_binary(re:replace("aab","^(a){0,1}","\\1h\\1XsxVh\\1FHSKPhapJQ",[global])), 
?line <<"iMdtvIhKruTIdObcd">> = iolist_to_binary(re:replace("bcd","^(a){0,2}","iMd\\1\\1\\1tvIhK&r\\1uTIdO",[])), 
?line <<"iMdtvIhKruTIdObcd">> = iolist_to_binary(re:replace("bcd","^(a){0,2}","iMd\\1\\1\\1tvIhK&r\\1uTIdO",[global])), 
?line <<"WYRQMjbc">> = iolist_to_binary(re:replace("abc","^(a){0,2}","WYRQMj",[])), 
?line <<"WYRQMjbc">> = iolist_to_binary(re:replace("abc","^(a){0,2}","WYRQMj",[global])), 
?line <<"XaKbiaaaEub">> = iolist_to_binary(re:replace("aab","^(a){0,2}","XaKbi\\1&Eu",[])), 
?line <<"XaKbiaaaEub">> = iolist_to_binary(re:replace("aab","^(a){0,2}","XaKbi\\1&Eu",[global])), 
?line <<"cFVbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,3}","&c&&FV&",[])), 
?line <<"cFVbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,3}","&c&&FV&",[global])), 
?line <<"gEwbc">> = iolist_to_binary(re:replace("abc","^(a){0,3}","gEw",[])), 
?line <<"gEwbc">> = iolist_to_binary(re:replace("abc","^(a){0,3}","gEw",[global])), 
?line <<"aaSuagMaaaaIaaKb">> = iolist_to_binary(re:replace("aab","^(a){0,3}","&Su\\1gM&&I&K",[])), 
?line <<"aaSuagMaaaaIaaKb">> = iolist_to_binary(re:replace("aab","^(a){0,3}","&Su\\1gM&&I&K",[global])), 
?line <<"GaaahIAJLaMaaaaaSBlaaaTU">> = iolist_to_binary(re:replace("aaa","^(a){0,3}","G&hIAJL\\1M\\1&aSBl&TU",[])), 
?line <<"GaaahIAJLaMaaaaaSBlaaaTU">> = iolist_to_binary(re:replace("aaa","^(a){0,3}","G&hIAJL\\1M\\1&aSBl&TU",[global])), 
?line <<"gcHyvqMebtbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,}","g&cHyvqMebt",[])), 
?line <<"gcHyvqMebtbcd">> = iolist_to_binary(re:replace("bcd","^(a){0,}","g&cHyvqMebt",[global])), 
?line <<"atJaOxHRjOnDbc">> = iolist_to_binary(re:replace("abc","^(a){0,}","\\1tJaOxHRjOnD",[])), 
?line <<"atJaOxHRjOnDbc">> = iolist_to_binary(re:replace("abc","^(a){0,}","\\1tJaOxHRjOnD",[global])), 
?line <<"RlAewSMFrb">> = iolist_to_binary(re:replace("aab","^(a){0,}","RlAewSMFr",[])), 
?line <<"RlAewSMFrb">> = iolist_to_binary(re:replace("aab","^(a){0,}","RlAewSMFr",[global])), 
?line <<"FaaaBoIPaaaLaaaYfapavgA">> = iolist_to_binary(re:replace("aaa","^(a){0,}","F&BoIP&L&Yf\\1p\\1vgA",[])), 
?line <<"FaaaBoIPaaaLaaaYfapavgA">> = iolist_to_binary(re:replace("aaa","^(a){0,}","F&BoIP&L&Yf\\1p\\1vgA",[global])), 
?line <<"baaaaaaaacUvaaaaaaaaCgeDoaRaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a){0,}","b&cUv&CgeDo\\1R&",[])), 
?line <<"baaaaaaaacUvaaaaaaaaCgeDoaRaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a){0,}","b&cUv&CgeDo\\1R&",[global])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,1}","F&vqwCbrndilc&Wb\\1LRH",[])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,1}","F&vqwCbrndilc&Wb\\1LRH",[global])), 
?line <<"BaaYanfjPxbaabc">> = iolist_to_binary(re:replace("abc","^(a){1,1}","B\\1\\1Y\\1nfjPxb\\1&",[])), 
?line <<"BaaYanfjPxbaabc">> = iolist_to_binary(re:replace("abc","^(a){1,1}","B\\1\\1Y\\1nfjPxb\\1&",[global])), 
?line <<"Pab">> = iolist_to_binary(re:replace("aab","^(a){1,1}","P",[])), 
?line <<"Pab">> = iolist_to_binary(re:replace("aab","^(a){1,1}","P",[global])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,2}","eK\\1B&ypECvCJqtlr&",[])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,2}","eK\\1B&ypECvCJqtlr&",[global])), 
?line <<"QYbc">> = iolist_to_binary(re:replace("abc","^(a){1,2}","QY",[])), 
?line <<"QYbc">> = iolist_to_binary(re:replace("abc","^(a){1,2}","QY",[global])), 
?line <<"MbnVXaaaXhaab">> = iolist_to_binary(re:replace("aab","^(a){1,2}","MbnVX&\\1Xh&",[])), 
?line <<"MbnVXaaaXhaab">> = iolist_to_binary(re:replace("aab","^(a){1,2}","MbnVX&\\1Xh&",[global])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,3}","UKOH",[])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,3}","UKOH",[global])), 
?line <<"TJxKYHFmaaadWlbc">> = iolist_to_binary(re:replace("abc","^(a){1,3}","TJxKYHFm&&\\1dWl",[])), 
?line <<"TJxKYHFmaaadWlbc">> = iolist_to_binary(re:replace("abc","^(a){1,3}","TJxKYHFm&&\\1dWl",[global])), 
?line <<"ub">> = iolist_to_binary(re:replace("aab","^(a){1,3}","u",[])), 
?line <<"ub">> = iolist_to_binary(re:replace("aab","^(a){1,3}","u",[global])), 
?line <<"FOX">> = iolist_to_binary(re:replace("aaa","^(a){1,3}","FOX",[])), 
?line <<"FOX">> = iolist_to_binary(re:replace("aaa","^(a){1,3}","FOX",[global])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,}","W\\1Urn\\1O",[])), 
?line <<"bcd">> = iolist_to_binary(re:replace("bcd","^(a){1,}","W\\1Urn\\1O",[global])), 
?line <<"awalKDgaLeMbc">> = iolist_to_binary(re:replace("abc","^(a){1,}","\\1w\\1lKDg&LeM",[])), 
?line <<"awalKDgaLeMbc">> = iolist_to_binary(re:replace("abc","^(a){1,}","\\1w\\1lKDg&LeM",[global])), 
?line <<"qHVYNjismoeaasSpb">> = iolist_to_binary(re:replace("aab","^(a){1,}","qHVYNjismoe&sSp",[])), 
?line <<"qHVYNjismoeaasSpb">> = iolist_to_binary(re:replace("aab","^(a){1,}","qHVYNjismoe&sSp",[global])), 
?line <<"laa">> = iolist_to_binary(re:replace("aaa","^(a){1,}","la\\1",[])), 
?line <<"laa">> = iolist_to_binary(re:replace("aaa","^(a){1,}","la\\1",[global])), 
?line <<"UJqaaaaaaaarcaaaaaaaaQHavwaGaaaaaaaaoX">> = iolist_to_binary(re:replace("aaaaaaaa","^(a){1,}","UJq&rc&QH\\1vw\\1G&oX",[])), 
?line <<"UJqaaaaaaaarcaaaaaaaaQHavwaGaaaaaaaaoX">> = iolist_to_binary(re:replace("aaaaaaaa","^(a){1,}","UJq&rc&QH\\1vw\\1G&oX",[global])), 
?line <<"borfle
bib.gifs
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","&s",[])), 
?line <<"borfle
bib.gifs
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","&s",[global])), 
?line <<"borfle
BD
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".{0,}\\.gif","BD",[])), 
?line <<"borfle
BD
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".{0,}\\.gif","BD",[global])), 
?line <<"borfle
vDNsbib.gif
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","vDNs&",[multiline])), 
?line <<"borfle
vDNsbib.gif
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","vDNs&",[multiline,global])), 
?line <<"dPgeQVbGVD
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","dPge\\1QVbGVD",[dotall])), 
?line <<"dPgeQVbGVD
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","dPge\\1QVbGVD",[dotall,global])), 
?line <<"SGyevborfle
bib.gifCborfle
bib.gifWUWborfle
bib.gifHd
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","SGyev&C\\1&\\1\\1WUW&Hd\\1",[multiline,dotall])), 
?line <<"SGyevborfle
bib.gifCborfle
bib.gifWUWborfle
bib.gifHd
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*\\.gif","SGyev&C\\1&\\1\\1WUW&Hd\\1",[multiline,dotall,
                                                            global])), 
?line <<"borfle
bib.gif
BKNYIMcbaV">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","BKNYIMcbaV",[])), 
?line <<"borfle
bib.gif
BKNYIMcbaVBKNYIMcbaV">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","BKNYIMcbaV",[global])), 
?line <<"borflevLMilNh
bib.gif
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","&vLM\\1ilNh\\1",[multiline])), 
?line <<"borflevLMilNhvLMilNh
bib.gifvLMilNhvLMilNh
novLMilNhvLMilNh">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","&vLM\\1ilNh\\1",[multiline,global])), 
?line <<"borfle
bib.gif
noMtTxgborfle
bib.gif
noXborfle
bib.gif
noqKCRborfle
bib.gif
noRFb">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","&MtTxg&X&qKCR&RFb",[dotall])), 
?line <<"borfle
bib.gif
noMtTxgborfle
bib.gif
noXborfle
bib.gif
noqKCRborfle
bib.gif
noRFbMtTxgXqKCRRFb">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","&MtTxg&X&qKCR&RFb",[dotall,global])), 
?line <<"rb">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","rb",[multiline,dotall])), 
?line <<"rbrb">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","rb",[multiline,dotall,global])), 
?line <<"borfle
bib.gif
dTAVnoxiWSnoiuGHA">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","dTAV&xiWS&iuGH\\1A\\1",[])), 
?line <<"borfle
bib.gif
dTAVnoxiWSnoiuGHAdTAVxiWSiuGHA">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","dTAV&xiWS&iuGH\\1A\\1",[global])), 
?line <<"bcnFLv
bib.gif
no">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","bc\\1nFLv",[multiline])), 
?line <<"bcnFLvbcnFLv
bcnFLvbcnFLv
bcnFLvbcnFLv">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","bc\\1nFLv",[multiline,global])), 
?line <<"LIQosdWborfle
bib.gif
nogcg">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","L\\1IQosd\\1W&gcg",[dotall])), 
?line <<"LIQosdWborfle
bib.gif
nogcgLIQosdWgcg">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","L\\1IQosd\\1W&gcg",[dotall,global])), 
?line <<"EcPBKTVborfle
bib.gif
noPrborfle
bib.gif
noXxQSc">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","EcPBKTV&Pr&XxQSc",[multiline,dotall])), 
?line <<"EcPBKTVborfle
bib.gif
noPrborfle
bib.gif
noXxQScEcPBKTVPrXxQSc">> = iolist_to_binary(re:replace("borfle
bib.gif
no",".*$","EcPBKTV&Pr&XxQSc",[multiline,dotall,global])), 
?line <<"abcde
uhjjD1234XGTHcATIgH1234X1234XfbByz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","uhjjD&GTHcATIgH\\1\\1fbB",[])), 
?line <<"abcde
uhjjD1234XGTHcATIgH1234X1234XfbByz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","uhjjD&GTHcATIgH\\1\\1fbB",[global])), 
?line <<"dbqarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","dbq",[])), 
?line <<"dbqarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","dbq",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(.*X|^B)","tdwOa\\1DQul",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(.*X|^B)","tdwOa\\1DQul",[global])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","j\\1&fFKu\\1tLJjDOmjkU",[])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","j\\1&fFKu\\1tLJjDOmjkU",[global])), 
?line <<"abcde
cKv1234XFUwb1234XTPoWrycn1234XO1234Xyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","cKv&FUwb&TPoWrycn&O&",[multiline])), 
?line <<"abcde
cKv1234XFUwb1234XTPoWrycn1234XO1234Xyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","cKv&FUwb&TPoWrycn&O&",[multiline,global])), 
?line <<"FBHWgBBNiGBkIarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","F&HWgB\\1NiG\\1kI",[multiline])), 
?line <<"FBHWgBBNiGBkIarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","F&HWgB\\1NiG\\1kI",[multiline,
                                                                                                                                                                                                            global])), 
?line <<"abcde
oArar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","oAr",[multiline])), 
?line <<"abcde
oArar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","oAr",[multiline,global])), 
?line <<"abcde
1234XpqJuWOcKJabcde
1234XyXyvjQwPyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","\\1pqJuWOcKJ&yXyvjQwP",[dotall])), 
?line <<"abcde
1234XpqJuWOcKJabcde
1234XyXyvjQwPyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","\\1pqJuWOcKJ&yXyvjQwP",[dotall,global])), 
?line <<"BHBBBLbBBgBBoarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","BH\\1&&Lb&&g\\1&o",[dotall])), 
?line <<"BHBBBLbBBgBBoarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","BH\\1&&Lb&&g\\1&o",[dotall,
                                                                                                                                                                                                                global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(.*X|^B)","&LH",[dotall])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(.*X|^B)","&LH",[dotall,
                                                                                                                                                                                        global])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","HvNOg&qrhICiO",[dotall])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","HvNOg&qrhICiO",[dotall,global])), 
?line <<"eabcde
1234Xabcde
1234XIRtabcde
1234Xabcde
1234XCMGsyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","e\\1&IRt\\1\\1CMGs",[multiline,dotall])), 
?line <<"eabcde
1234Xabcde
1234XIRtabcde
1234Xabcde
1234XCMGsyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(.*X|^B)","e\\1&IRt\\1\\1CMGs",[multiline,dotall,global])), 
?line <<"MBMpwYiMLarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","M\\1MpwYiML",[multiline,
                                                                                                                                                                                              dotall])), 
?line <<"MBMpwYiMLarFoo">> = iolist_to_binary(re:replace("BarFoo","(.*X|^B)","M\\1MpwYiML",[multiline,
                                                                                                                                                                                               dotall,
                                                                                                                                                                                               global])), 
?line <<"abcde
SOfar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","SOf",[multiline,dotall])), 
?line <<"abcde
SOfar">> = iolist_to_binary(re:replace("abcde
Bar","(.*X|^B)","SOf",[multiline,dotall,global])), 
?line <<"Xabcde
1234XIabcde
1234XJyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(?s)(.*X|^B)","X\\1I\\1J",[])), 
?line <<"Xabcde
1234XIabcde
1234XJyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(?s)(.*X|^B)","X\\1I\\1J",[global])), 
?line <<"ckBBgDwBNcECcmswBGrarFoo">> = iolist_to_binary(re:replace("BarFoo","(?s)(.*X|^B)","ck\\1&gDw\\1NcECcmsw\\1Gr",[])), 
?line <<"ckBBgDwBNcECcmswBGrarFoo">> = iolist_to_binary(re:replace("BarFoo","(?s)(.*X|^B)","ck\\1&gDw\\1NcECcmsw\\1Gr",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s)(.*X|^B)","dC\\1SBGDJPgKye\\1iTO",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s)(.*X|^B)","dC\\1SBGDJPgKye\\1iTO",[global])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(?s)(.*X|^B)","hL&HrGi&",[])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(?s)(.*X|^B)","hL&HrGi&",[global])), 
?line <<"abcde
1234Xabcde
1234XBpOYYilckyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(?s:.*X|^B)","&&\\1BpOYYilck",[])), 
?line <<"abcde
1234Xabcde
1234XBpOYYilckyz">> = iolist_to_binary(re:replace("abcde
1234Xyz","(?s:.*X|^B)","&&\\1BpOYYilck",[global])), 
?line <<"ThDpSQKkSSwHarFoo">> = iolist_to_binary(re:replace("BarFoo","(?s:.*X|^B)","ThDpSQ\\1KkSSwH",[])), 
?line <<"ThDpSQKkSSwHarFoo">> = iolist_to_binary(re:replace("BarFoo","(?s:.*X|^B)","ThDpSQ\\1KkSSwH",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s:.*X|^B)","H&KaW\\1iKok\\1x&gEh&",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s:.*X|^B)","H&KaW\\1iKok\\1x&gEh&",[global])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(?s:.*X|^B)","DFJoEUQUCdLTM\\1ETp",[])), 
?line <<"abcde
Bar">> = iolist_to_binary(re:replace("abcde
Bar","(?s:.*X|^B)","DFJoEUQUCdLTM\\1ETp",[global])), 
?line <<"**** Failers">> = iolist_to_binary(re:replace("**** Failers","^.*B","N&QUc\\1IX&",[])), 
?line <<"**** Failers">> = iolist_to_binary(re:replace("**** Failers","^.*B","N&QUc\\1IX&",[global])), 
?line <<"abc
B">> = iolist_to_binary(re:replace("abc
B","^.*B","XtHO\\1dFCGIat\\1\\1A\\1yj\\1",[])), 
?line <<"abc
B">> = iolist_to_binary(re:replace("abc
B","^.*B","XtHO\\1dFCGIat\\1\\1A\\1yj\\1",[global])), 
?line <<"yKkFabc
B">> = iolist_to_binary(re:replace("abc
B","(?s)^.*B","yKkF&",[])), 
?line <<"yKkFabc
B">> = iolist_to_binary(re:replace("abc
B","(?s)^.*B","yKkF&",[global])), 
?line <<"abc
AQ">> = iolist_to_binary(re:replace("abc
B","(?m)^.*B","AQ",[])), 
?line <<"abc
AQ">> = iolist_to_binary(re:replace("abc
B","(?m)^.*B","AQ",[global])), 
?line <<"abc
BDabc
BNabc
BxoUHHabc
Bo">> = iolist_to_binary(re:replace("abc
B","(?ms)^.*B","\\1&D&N&xoUHH&o",[])), 
?line <<"abc
BDabc
BNabc
BxoUHHabc
Bo">> = iolist_to_binary(re:replace("abc
B","(?ms)^.*B","\\1&D&N&xoUHH&o",[global])), 
?line <<"abc
GHgiVrjlVxqskBLR">> = iolist_to_binary(re:replace("abc
B","(?ms)^B","GHgiVrj\\1lVxqsk&LR",[])), 
?line <<"abc
GHgiVrjlVxqskBLR">> = iolist_to_binary(re:replace("abc
B","(?ms)^B","GHgiVrj\\1lVxqsk&LR",[global])), 
?line <<"RBtqaBce">> = iolist_to_binary(re:replace("B","(?s)B$","R&tqaBce",[])), 
?line <<"RBtqaBce">> = iolist_to_binary(re:replace("B","(?s)B$","R&tqaBce",[global])), 
?line <<"kG">> = iolist_to_binary(re:replace("123456654321","^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]","kG",[])), 
?line <<"kG">> = iolist_to_binary(re:replace("123456654321","^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]","kG",[global])), 
?line <<"Tx">> = iolist_to_binary(re:replace("123456654321","^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d","Tx",[])), 
?line <<"Tx">> = iolist_to_binary(re:replace("123456654321","^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d","Tx",[global])), 
?line <<"xB">> = iolist_to_binary(re:replace("123456654321","^[\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d]","xB",[])), 
?line <<"xB">> = iolist_to_binary(re:replace("123456654321","^[\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d][\\d]","xB",[global])), 
?line <<"OpPIBabcabcabcabcDcxDvlIdSoa">> = iolist_to_binary(re:replace("abcabcabcabc","^[abc]{12}","OpPIB&DcxDvlIdSoa",[])), 
?line <<"OpPIBabcabcabcabcDcxDvlIdSoa">> = iolist_to_binary(re:replace("abcabcabcabc","^[abc]{12}","OpPIB&DcxDvlIdSoa",[global])), 
?line <<"LGEMfnjAabcabcabcabcuAotOabcabcabcabcs">> = iolist_to_binary(re:replace("abcabcabcabc","^[a-c]{12}","LGEMfnj\\1A&uAotO&s",[])), 
?line <<"LGEMfnjAabcabcabcabcuAotOabcabcabcabcs">> = iolist_to_binary(re:replace("abcabcabcabc","^[a-c]{12}","LGEMfnj\\1A&uAotO&s",[global])), 
?line <<"PNcwcmOyx">> = iolist_to_binary(re:replace("abcabcabcabc","^(a|b|c){12}","PN\\1w\\1mOyx",[])), 
?line <<"PNcwcmOyx">> = iolist_to_binary(re:replace("abcabcabcabc","^(a|b|c){12}","PN\\1w\\1mOyx",[global])), 
?line <<"hVfRbFrAh">> = iolist_to_binary(re:replace("n","^[abcdefghijklmnopqrstuvwxy0123456789]","hVfRbFrAh",[])), 
?line <<"hVfRbFrAh">> = iolist_to_binary(re:replace("n","^[abcdefghijklmnopqrstuvwxy0123456789]","hVfRbFrAh",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[abcdefghijklmnopqrstuvwxy0123456789]","R\\1gE\\1TmOo&B&\\1EaaIWLL",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^[abcdefghijklmnopqrstuvwxy0123456789]","R\\1gE\\1TmOo&B&\\1EaaIWLL",[global])), 
?line <<"z">> = iolist_to_binary(re:replace("z","^[abcdefghijklmnopqrstuvwxy0123456789]","dPAGng",[])), 
?line <<"z">> = iolist_to_binary(re:replace("z","^[abcdefghijklmnopqrstuvwxy0123456789]","dPAGng",[global])), 
?line <<"GalPHuLJkabcdJ">> = iolist_to_binary(re:replace("abcd","abcde{0,0}","Gal\\1PHu\\1LJk&J",[])), 
?line <<"GalPHuLJkabcdJ">> = iolist_to_binary(re:replace("abcd","abcde{0,0}","Gal\\1PHu\\1LJk&J",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abcde{0,0}","nRSqklns\\1RNQ",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abcde{0,0}","nRSqklns\\1RNQ",[global])), 
?line <<"abce">> = iolist_to_binary(re:replace("abce","abcde{0,0}","aYgl\\1WJ",[])), 
?line <<"abce">> = iolist_to_binary(re:replace("abce","abcde{0,0}","aYgl\\1WJ",[global])), 
?line <<"JSDhTpxGUy">> = iolist_to_binary(re:replace("abe","ab[cd]{0,0}e","J\\1SDhT\\1pxGUy",[])), 
?line <<"JSDhTpxGUy">> = iolist_to_binary(re:replace("abe","ab[cd]{0,0}e","J\\1SDhT\\1pxGUy",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab[cd]{0,0}e","K\\1VVqQdlOY\\1IFC",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab[cd]{0,0}e","K\\1VVqQdlOY\\1IFC",[global])), 
?line <<"abcde">> = iolist_to_binary(re:replace("abcde","ab[cd]{0,0}e","CBmXc&",[])), 
?line <<"abcde">> = iolist_to_binary(re:replace("abcde","ab[cd]{0,0}e","CBmXc&",[global])), 
?line <<"YKTMKcsKabd">> = iolist_to_binary(re:replace("abd","ab(c){0,0}d","YKT\\1MKcsK&",[])), 
?line <<"YKTMKcsKabd">> = iolist_to_binary(re:replace("abd","ab(c){0,0}d","YKT\\1MKcsK&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab(c){0,0}d","&j&dtuA\\1A&vS",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab(c){0,0}d","&j&dtuA\\1A&vS",[global])), 
?line <<"abcd">> = iolist_to_binary(re:replace("abcd","ab(c){0,0}d","&ceeJC\\1HRtWmI",[])), 
?line <<"abcd">> = iolist_to_binary(re:replace("abcd","ab(c){0,0}d","&ceeJC\\1HRtWmI",[global])), 
?line <<"k">> = iolist_to_binary(re:replace("a","a(b*)","\\1k",[])), 
?line <<"k">> = iolist_to_binary(re:replace("a","a(b*)","\\1k",[global])), 
?line <<"abnwnAb">> = iolist_to_binary(re:replace("ab","a(b*)","&nwnA\\1",[])), 
?line <<"abnwnAb">> = iolist_to_binary(re:replace("ab","a(b*)","&nwnA\\1",[global])), 
?line <<"nLIbbbbd">> = iolist_to_binary(re:replace("abbbb","a(b*)","nLI\\1d",[])), 
?line <<"nLIbbbbd">> = iolist_to_binary(re:replace("abbbb","a(b*)","nLI\\1d",[global])), 
?line <<"*** FMxgxBanxQaNgAilers">> = iolist_to_binary(re:replace("*** Failers","a(b*)","Mxgx\\1\\1B&nxQ&NgA",[])), 
?line <<"*** FMxgxBanxQaNgAilers">> = iolist_to_binary(re:replace("*** Failers","a(b*)","Mxgx\\1\\1B&nxQ&NgA",[global])), 
?line <<"bbbbb">> = iolist_to_binary(re:replace("bbbbb","a(b*)","Yho\\1QKp",[])), 
?line <<"bbbbb">> = iolist_to_binary(re:replace("bbbbb","a(b*)","Yho\\1QKp",[global])), 
?line <<"c">> = iolist_to_binary(re:replace("abe","ab\\d{0}e","c",[])), 
?line <<"c">> = iolist_to_binary(re:replace("abe","ab\\d{0}e","c",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab\\d{0}e","e\\1Nu\\1BSg\\1Rxb",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab\\d{0}e","e\\1Nu\\1BSg\\1Rxb",[global])), 
?line <<"ab1e">> = iolist_to_binary(re:replace("ab1e","ab\\d{0}e","C\\1xDlVAxYcYUK\\1fMs",[])), 
?line <<"ab1e">> = iolist_to_binary(re:replace("ab1e","ab\\d{0}e","C\\1xDlVAxYcYUK\\1fMs",[global])), 
?line <<"the MipoEquickBcm brown fox">> = iolist_to_binary(re:replace("the \"quick\" brown fox","\"([^\\\\\"]+|\\\\.)*\"","MipoE\\1Bcm",[])), 
?line <<"the MipoEquickBcm brown fox">> = iolist_to_binary(re:replace("the \"quick\" brown fox","\"([^\\\\\"]+|\\\\.)*\"","MipoE\\1Bcm",[global])), 
?line <<"\"the \\\"quick\\\" brown fox\"\"the \\\"quick\\\" brown fox\"K brown fox\"the \\\"quick\\\" brown fox\"twdFEi\"the \\\"quick\\\" brown fox\"Tf">> = iolist_to_binary(re:replace("\"the \\\"quick\\\" brown fox\"","\"([^\\\\\"]+|\\\\.)*\"","&&K\\1&twdFEi&Tf",[])), 
?line <<"\"the \\\"quick\\\" brown fox\"\"the \\\"quick\\\" brown fox\"K brown fox\"the \\\"quick\\\" brown fox\"twdFEi\"the \\\"quick\\\" brown fox\"Tf">> = iolist_to_binary(re:replace("\"the \\\"quick\\\" brown fox\"","\"([^\\\\\"]+|\\\\.)*\"","&&K\\1&twdFEi&Tf",[global])), 
?line <<"uOiYpObvYvnabc">> = iolist_to_binary(re:replace("abc","","uOiYp&\\1Obv&Yvn",[])), 
?line <<"uOiYpObvYvnauOiYpObvYvnbuOiYpObvYvncuOiYpObvYvn">> = iolist_to_binary(re:replace("abc","","uOiYp&\\1Obv&Yvn",[global])), 
?line <<"cacbJUVL">> = iolist_to_binary(re:replace("acb","a[^a]b","c&JUVL",[])), 
?line <<"cacbJUVL">> = iolist_to_binary(re:replace("acb","a[^a]b","c&JUVL",[global])), 
?line <<"a
bnnciOUFa
bttqb">> = iolist_to_binary(re:replace("a
b","a[^a]b","&nnciOUF&ttq\\1b",[])), 
?line <<"a
bnnciOUFa
bttqb">> = iolist_to_binary(re:replace("a
b","a[^a]b","&nnciOUF&ttq\\1b",[global])), 
?line <<"acbrJrBLmacbnacb">> = iolist_to_binary(re:replace("acb","a.b","&rJrBLm&n&",[])), 
?line <<"acbrJrBLmacbnacb">> = iolist_to_binary(re:replace("acb","a.b","&rJrBLm&n&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a.b","lUyaU",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a.b","lUyaU",[global])), 
?line <<"a
b">> = iolist_to_binary(re:replace("a
b","a.b","&etys",[])), 
?line <<"a
b">> = iolist_to_binary(re:replace("a
b","a.b","&etys",[global])), 
?line <<"BRCBYDDacbacbacbLfVw">> = iolist_to_binary(re:replace("acb","a[^a]b","BRCBY\\1D\\1D&&\\1&LfVw",[dotall])), 
?line <<"BRCBYDDacbacbacbLfVw">> = iolist_to_binary(re:replace("acb","a[^a]b","BRCBY\\1D\\1D&&\\1&LfVw",[dotall,
                                                                                                                                                                                                                 global])), 
?line <<"a
bQkfhPqa
bka
byK">> = iolist_to_binary(re:replace("a
b","a[^a]b","&Qk\\1fhPq&k&yK",[dotall])), 
?line <<"a
bQkfhPqa
bka
byK">> = iolist_to_binary(re:replace("a
b","a[^a]b","&Qk\\1fhPq&k&yK",[dotall,global])), 
?line <<"nKFpFMMacbmxur">> = iolist_to_binary(re:replace("acb","a.b","\\1nKF\\1\\1pF\\1MM\\1&mxur",[dotall])), 
?line <<"nKFpFMMacbmxur">> = iolist_to_binary(re:replace("acb","a.b","\\1nKF\\1\\1pF\\1MM\\1&mxur",[dotall,
                                                                                                                                                                                                                   global])), 
?line <<"RESrDVpIxqsoAT">> = iolist_to_binary(re:replace("a
b","a.b","\\1RES\\1rDVpIxqso\\1AT",[dotall])), 
?line <<"RESrDVpIxqsoAT">> = iolist_to_binary(re:replace("a
b","a.b","\\1RES\\1rDVpIxqso\\1AT",[dotall,global])), 
?line <<"aNchRRBHywejNvbacE">> = iolist_to_binary(re:replace("bac","^(b+?|a){1,2}?c","\\1NchRRBHywejNv&E",[])), 
?line <<"aNchRRBHywejNvbacE">> = iolist_to_binary(re:replace("bac","^(b+?|a){1,2}?c","\\1NchRRBHywejNv&E",[global])), 
?line <<"tOamCbbacgsmxbbac">> = iolist_to_binary(re:replace("bbac","^(b+?|a){1,2}?c","tO\\1mC&gsmx&",[])), 
?line <<"tOamCbbacgsmxbbac">> = iolist_to_binary(re:replace("bbac","^(b+?|a){1,2}?c","tO\\1mC&gsmx&",[global])), 
?line <<"xHTFdauecabbbacGpaol">> = iolist_to_binary(re:replace("bbbac","^(b+?|a){1,2}?c","xHTFd\\1uec\\1&Gp\\1ol",[])), 
?line <<"xHTFdauecabbbacGpaol">> = iolist_to_binary(re:replace("bbbac","^(b+?|a){1,2}?c","xHTFd\\1uec\\1&Gp\\1ol",[global])), 
?line <<"baapjPEIagYbbbbacvbbbbacUPkPJ">> = iolist_to_binary(re:replace("bbbbac","^(b+?|a){1,2}?c","b\\1\\1pjPEI\\1gY&v&UPkPJ",[])), 
?line <<"baapjPEIagYbbbbacvbbbbacUPkPJ">> = iolist_to_binary(re:replace("bbbbac","^(b+?|a){1,2}?c","b\\1\\1pjPEI\\1gY&v&UPkPJ",[global])), 
?line <<"atqCLSTaKnviKn">> = iolist_to_binary(re:replace("bbbbbac","^(b+?|a){1,2}?c","\\1tqCLST\\1KnviKn",[])), 
?line <<"atqCLSTaKnviKn">> = iolist_to_binary(re:replace("bbbbbac","^(b+?|a){1,2}?c","\\1tqCLST\\1KnviKn",[global])), 
?line <<"x">> = iolist_to_binary(re:replace("bac","^(b+|a){1,2}?c","x",[])), 
?line <<"x">> = iolist_to_binary(re:replace("bac","^(b+|a){1,2}?c","x",[global])), 
?line <<"ysaxGbbachYTP">> = iolist_to_binary(re:replace("bbac","^(b+|a){1,2}?c","ysaxG&hYTP",[])), 
?line <<"ysaxGbbachYTP">> = iolist_to_binary(re:replace("bbac","^(b+|a){1,2}?c","ysaxG&hYTP",[global])), 
?line <<"IxpOsaoUxbbbacCEcBow">> = iolist_to_binary(re:replace("bbbac","^(b+|a){1,2}?c","IxpOs\\1oUx&CEcBow",[])), 
?line <<"IxpOsaoUxbbbacCEcBow">> = iolist_to_binary(re:replace("bbbac","^(b+|a){1,2}?c","IxpOs\\1oUx&CEcBow",[global])), 
?line <<"bbbbacDeITf">> = iolist_to_binary(re:replace("bbbbac","^(b+|a){1,2}?c","&DeITf",[])), 
?line <<"bbbbacDeITf">> = iolist_to_binary(re:replace("bbbbac","^(b+|a){1,2}?c","&DeITf",[global])), 
?line <<"XlWabAqKnj">> = iolist_to_binary(re:replace("bbbbbac","^(b+|a){1,2}?c","XlW\\1bAqKnj",[])), 
?line <<"XlWabAqKnj">> = iolist_to_binary(re:replace("bbbbbac","^(b+|a){1,2}?c","XlW\\1bAqKnj",[global])), 
?line <<"x
b">> = iolist_to_binary(re:replace("x
b","(?!\\A)x","DxdEs\\1&\\1LKts&",[multiline])), 
?line <<"x
b">> = iolist_to_binary(re:replace("x
b","(?!\\A)x","DxdEs\\1&\\1LKts&",[multiline,global])), 
?line <<"aAx">> = iolist_to_binary(re:replace("ax","(?!\\A)x","Ax",[multiline])), 
?line <<"aAx">> = iolist_to_binary(re:replace("ax","(?!\\A)x","Ax",[multiline,
                                                                                                                                                                      global])), 
?line <<"{ab}">> = iolist_to_binary(re:replace("{ab}","\\x0{ab}","aOVgpiCu\\1P\\1xjYe\\1",[])), 
?line <<"{ab}">> = iolist_to_binary(re:replace("{ab}","\\x0{ab}","aOVgpiCu\\1P\\1xjYe\\1",[global])), 
?line <<"PilCDnyDeI">> = iolist_to_binary(re:replace("CD","(A|B)*?CD","Pil&\\1nyDeI",[])), 
?line <<"PilCDnyDeI">> = iolist_to_binary(re:replace("CD","(A|B)*?CD","Pil&\\1nyDeI",[global])), 
?line <<"WrpDiffmnCDPINGCDSe">> = iolist_to_binary(re:replace("CD","(A|B)*CD","WrpDiffmn&PING&Se",[])), 
?line <<"WrpDiffmnCDPINGCDSe">> = iolist_to_binary(re:replace("CD","(A|B)*CD","WrpDiffmn&PING&Se",[global])), 
?line <<"mIeAB">> = iolist_to_binary(re:replace("ABABAB","(AB)*?\\1","mIe",[])), 
?line <<"mIeAB">> = iolist_to_binary(re:replace("ABABAB","(AB)*?\\1","mIe",[global])), 
?line <<"JThaowd">> = iolist_to_binary(re:replace("ABABAB","(AB)*\\1","JThaowd",[])), 
?line <<"JThaowd">> = iolist_to_binary(re:replace("ABABAB","(AB)*\\1","JThaowd",[global])), 
?line <<"mxivbdfooiW">> = iolist_to_binary(re:replace("foo","(?<!bar)foo","m\\1xi\\1\\1vbd&iW",[])), 
?line <<"mxivbdfooiW">> = iolist_to_binary(re:replace("foo","(?<!bar)foo","m\\1xi\\1\\1vbd&iW",[global])), 
?line <<"cathTPTYtGud">> = iolist_to_binary(re:replace("catfood","(?<!bar)foo","hTPTYtGu",[])), 
?line <<"cathTPTYtGud">> = iolist_to_binary(re:replace("catfood","(?<!bar)foo","hTPTYtGu",[global])), 
?line <<"arTMXuVvEElifooRfooXqctle">> = iolist_to_binary(re:replace("arfootle","(?<!bar)foo","TMXu\\1VvEEli&R&Xqc",[])), 
?line <<"arTMXuVvEElifooRfooXqctle">> = iolist_to_binary(re:replace("arfootle","(?<!bar)foo","TMXu\\1VvEEli&R&Xqc",[global])), 
?line <<"rCCfnfoopTfbpOVUOFBsh">> = iolist_to_binary(re:replace("rfoosh","(?<!bar)foo","CCfn&pT\\1fbpOVUOFB",[])), 
?line <<"rCCfnfoopTfbpOVUOFBsh">> = iolist_to_binary(re:replace("rfoosh","(?<!bar)foo","CCfn&pT\\1fbpOVUOFB",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<!bar)foo","bxdEUE&SEpWXK&",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<!bar)foo","bxdEUE&SEpWXK&",[global])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","(?<!bar)foo","ghAth&\\1XCvK&&",[])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","(?<!bar)foo","ghAth&\\1XCvK&&",[global])), 
?line <<"towbarfoo">> = iolist_to_binary(re:replace("towbarfoo","(?<!bar)foo","soY&O&QNmTi\\1xspnti&T",[])), 
?line <<"towbarfoo">> = iolist_to_binary(re:replace("towbarfoo","(?<!bar)foo","soY&O&QNmTi\\1xspnti&T",[global])), 
?line <<"JBHNVNd">> = iolist_to_binary(re:replace("catfood","\\w{3}(?<!bar)foo","J\\1BHN\\1VN\\1",[])), 
?line <<"JBHNVNd">> = iolist_to_binary(re:replace("catfood","\\w{3}(?<!bar)foo","J\\1BHN\\1VN\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\w{3}(?<!bar)foo","&ucJ",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\w{3}(?<!bar)foo","&ucJ",[global])), 
?line <<"foo">> = iolist_to_binary(re:replace("foo","\\w{3}(?<!bar)foo","uasVxSucjJKX",[])), 
?line <<"foo">> = iolist_to_binary(re:replace("foo","\\w{3}(?<!bar)foo","uasVxSucjJKX",[global])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","\\w{3}(?<!bar)foo","u&&Su\\1&YWVvwAftwcE&",[])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","\\w{3}(?<!bar)foo","u&&Su\\1&YWVvwAftwcE&",[global])), 
?line <<"towbarfoo">> = iolist_to_binary(re:replace("towbarfoo","\\w{3}(?<!bar)foo","IH",[])), 
?line <<"towbarfoo">> = iolist_to_binary(re:replace("towbarfoo","\\w{3}(?<!bar)foo","IH",[global])), 
?line <<"fooabarSWfoobar">> = iolist_to_binary(re:replace("fooabar","(?<=(foo)a)bar","&SW\\1&",[])), 
?line <<"fooabarSWfoobar">> = iolist_to_binary(re:replace("fooabar","(?<=(foo)a)bar","&SW\\1&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(foo)a)bar","&ShYlKf",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(foo)a)bar","&ShYlKf",[global])), 
?line <<"bar">> = iolist_to_binary(re:replace("bar","(?<=(foo)a)bar","Usk\\1PJ&",[])), 
?line <<"bar">> = iolist_to_binary(re:replace("bar","(?<=(foo)a)bar","Usk\\1PJ&",[global])), 
?line <<"foobbar">> = iolist_to_binary(re:replace("foobbar","(?<=(foo)a)bar","\\1pXSA",[])), 
?line <<"foobbar">> = iolist_to_binary(re:replace("foobbar","(?<=(foo)a)bar","\\1pXSA",[global])), 
?line <<"gWabcqJMuvLrGqnPLJK">> = iolist_to_binary(re:replace("abc","\\Aabc\\z","gW&qJ\\1MuvLrGqnPLJK",[multiline])), 
?line <<"gWabcqJMuvLrGqnPLJK">> = iolist_to_binary(re:replace("abc","\\Aabc\\z","gW&qJ\\1MuvLrGqnPLJK",[multiline,
                                                                                                                                                                                                               global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\Aabc\\z","tcIt&YpWtGEy\\1p",[multiline])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\Aabc\\z","tcIt&YpWtGEy\\1p",[multiline,
                                                                                                                                                                                                                       global])), 
?line <<"abcM">> = iolist_to_binary(re:replace("abc","\\Aabc\\z","&M",[multiline])), 
?line <<"abcM">> = iolist_to_binary(re:replace("abc","\\Aabc\\z","&M",[multiline,
                                                                                                                                                                          global])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","\\Aabc\\z","B\\1B\\1fqK\\1nocSHwGCCiM",[multiline])), 
?line <<"qqq
abc">> = iolist_to_binary(re:replace("qqq
abc","\\Aabc\\z","B\\1B\\1fqK\\1nocSHwGCCiM",[multiline,global])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","\\Aabc\\z","P",[multiline])), 
?line <<"abc
zzz">> = iolist_to_binary(re:replace("abc
zzz","\\Aabc\\z","P",[multiline,global])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","\\Aabc\\z","\\1adD\\1",[multiline])), 
?line <<"qqq
abc
zzz">> = iolist_to_binary(re:replace("qqq
abc
zzz","\\Aabc\\z","\\1adD\\1",[multiline,global])), 
?line <<"1U">> = iolist_to_binary(re:replace("1.230003938","(?>(\\.\\d\\d[1-9]?))\\d+","U",[])), 
?line <<"1U">> = iolist_to_binary(re:replace("1.230003938","(?>(\\.\\d\\d[1-9]?))\\d+","U",[global])), 
?line <<"1bJ.875fwFYOodDWXyr.875tm.875000282.875000282">> = iolist_to_binary(re:replace("1.875000282","(?>(\\.\\d\\d[1-9]?))\\d+","bJ\\1fwFYOodDWXyr\\1tm&&",[])), 
?line <<"1bJ.875fwFYOodDWXyr.875tm.875000282.875000282">> = iolist_to_binary(re:replace("1.875000282","(?>(\\.\\d\\d[1-9]?))\\d+","bJ\\1fwFYOodDWXyr\\1tm&&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?>(\\.\\d\\d[1-9]?))\\d+","e\\1JPFf&",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?>(\\.\\d\\d[1-9]?))\\d+","e\\1JPFf&",[global])), 
?line <<"1.235">> = iolist_to_binary(re:replace("1.235","(?>(\\.\\d\\d[1-9]?))\\d+","yOPhp&Vy&fKXLBmiJx\\1a",[])), 
?line <<"1.235">> = iolist_to_binary(re:replace("1.235","(?>(\\.\\d\\d[1-9]?))\\d+","yOPhp&Vy&fKXLBmiJx\\1a",[global])), 
?line <<"partynow is the time for all good men to come to the aid of the partycnow is the time for all good men to come to the aid of the partynow is the time for all good men to come to the aid of the partypartyyecj">> = iolist_to_binary(re:replace("now is the time for all good men to come to the aid of the party","^((?>\\w+)|(?>\\s+))*$","\\1&c&&\\1yecj",[])), 
?line <<"partynow is the time for all good men to come to the aid of the partycnow is the time for all good men to come to the aid of the partynow is the time for all good men to come to the aid of the partypartyyecj">> = iolist_to_binary(re:replace("now is the time for all good men to come to the aid of the party","^((?>\\w+)|(?>\\s+))*$","\\1&c&&\\1yecj",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^((?>\\w+)|(?>\\s+))*$","\\1u",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^((?>\\w+)|(?>\\s+))*$","\\1u",[global])), 
?line <<"this is not a line with only words and spaces!">> = iolist_to_binary(re:replace("this is not a line with only words and spaces!","^((?>\\w+)|(?>\\s+))*$","gH&CX\\1&vnufnGXYAun",[])), 
?line <<"this is not a line with only words and spaces!">> = iolist_to_binary(re:replace("this is not a line with only words and spaces!","^((?>\\w+)|(?>\\s+))*$","gH&CX\\1&vnufnGXYAun",[global])), 
?line <<"K1234512345aH12345a">> = iolist_to_binary(re:replace("12345a","(\\d+)(\\w)","K\\1&H&",[])), 
?line <<"K1234512345aH12345a">> = iolist_to_binary(re:replace("12345a","(\\d+)(\\w)","K\\1&H&",[global])), 
?line <<"IdNK+">> = iolist_to_binary(re:replace("12345+","(\\d+)(\\w)","IdNK",[])), 
?line <<"IdNK+">> = iolist_to_binary(re:replace("12345+","(\\d+)(\\w)","IdNK",[global])), 
?line <<"jvjjhmthsl">> = iolist_to_binary(re:replace("12345a","((?>\\d+))(\\w)","jvjjhmthsl",[])), 
?line <<"jvjjhmthsl">> = iolist_to_binary(re:replace("12345a","((?>\\d+))(\\w)","jvjjhmthsl",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","((?>\\d+))(\\w)","eK&NTn&\\1T",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","((?>\\d+))(\\w)","eK&NTn&\\1T",[global])), 
?line <<"12345+">> = iolist_to_binary(re:replace("12345+","((?>\\d+))(\\w)","&&TXSquRgMqkDs&K&",[])), 
?line <<"12345+">> = iolist_to_binary(re:replace("12345+","((?>\\d+))(\\w)","&&TXSquRgMqkDs&K&",[global])), 
?line <<"NeYcvQCaaabtbOkx">> = iolist_to_binary(re:replace("aaab","(?>a+)b","NeYcvQC&tbOkx\\1",[])), 
?line <<"NeYcvQCaaabtbOkx">> = iolist_to_binary(re:replace("aaab","(?>a+)b","NeYcvQC&tbOkx\\1",[global])), 
?line <<"aaabbaaabFOSaaabKKtRUNaaabLDTCH">> = iolist_to_binary(re:replace("aaab","((?>a+)b)","&b&FOS&KKtRUN\\1LDTCH",[])), 
?line <<"aaabbaaabFOSaaabKKtRUNaaabLDTCH">> = iolist_to_binary(re:replace("aaab","((?>a+)b)","&b&FOS&KKtRUN\\1LDTCH",[global])), 
?line <<"xaaabaaabaaaiaaabCaGaaaaaabaaaaaaaaabaaabaaaF">> = iolist_to_binary(re:replace("aaab","(?>(a+))b","x\\1b&\\1i&CaG\\1&\\1\\1&&\\1F",[])), 
?line <<"xaaabaaabaaaiaaabCaGaaaaaabaaaaaaaaabaaabaaaF">> = iolist_to_binary(re:replace("aaab","(?>(a+))b","x\\1b&\\1i&CaG\\1&\\1\\1&&\\1F",[global])), 
?line <<"aaaLDSAYvgtbbbotccc">> = iolist_to_binary(re:replace("aaabbbccc","(?>b)+","LDSAYvgt&ot",[])), 
?line <<"aaaLDSAYvgtbbbotccc">> = iolist_to_binary(re:replace("aaabbbccc","(?>b)+","LDSAYvgt&ot",[global])), 
?line <<"ABQFhQjYaaabbbbcAcccd">> = iolist_to_binary(re:replace("aaabbbbccccd","(?>a+|b+|c+)*c","ABQ\\1Fh\\1QjY&A",[])), 
?line <<"ABQFhQjYaaabbbbcAABQFhQjYcAABQFhQjYcAABQFhQjYcAd">> = iolist_to_binary(re:replace("aaabbbbccccd","(?>a+|b+|c+)*c","ABQ\\1Fh\\1QjY&A",[global])), 
?line <<"((xiabc(ade)ufh()()xpJf">> = iolist_to_binary(re:replace("((abc(ade)ufh()()x","((?>[^()]+)|\\([^()]*\\))+","\\1i&pJf",[])), 
?line <<"((xiabc(ade)ufh()()xpJf">> = iolist_to_binary(re:replace("((abc(ade)ufh()()x","((?>[^()]+)|\\([^()]*\\))+","\\1i&pJf",[global])), 
?line <<"NBF">> = iolist_to_binary(re:replace("(abc)","\\(((?>[^()]+)|\\([^()]+\\))+\\)","NBF",[])), 
?line <<"NBF">> = iolist_to_binary(re:replace("(abc)","\\(((?>[^()]+)|\\([^()]+\\))+\\)","NBF",[global])), 
?line <<"(abc(def)xyz)AFLTv">> = iolist_to_binary(re:replace("(abc(def)xyz)","\\(((?>[^()]+)|\\([^()]+\\))+\\)","&AFLTv",[])), 
?line <<"(abc(def)xyz)AFLTv">> = iolist_to_binary(re:replace("(abc(def)xyz)","\\(((?>[^()]+)|\\([^()]+\\))+\\)","&AFLTv",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\(((?>[^()]+)|\\([^()]+\\))+\\)","P\\1OC",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\(((?>[^()]+)|\\([^()]+\\))+\\)","P\\1OC",[global])), 
?line <<"((()aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("((()aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa","\\(((?>[^()]+)|\\([^()]+\\))+\\)","u\\1\\1H\\1TOt\\1fVI&X",[])), 
?line <<"((()aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("((()aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa","\\(((?>[^()]+)|\\([^()]+\\))+\\)","u\\1\\1H\\1TOt\\1fVI&X",[global])), 
?line <<"E">> = iolist_to_binary(re:replace("ab","a(?-i)b","E",[caseless])), 
?line <<"E">> = iolist_to_binary(re:replace("ab","a(?-i)b","E",[caseless,
                                                                                                                                                               global])), 
?line <<"hAboOovpk">> = iolist_to_binary(re:replace("Ab","a(?-i)b","h&oOovpk",[caseless])), 
?line <<"hAboOovpk">> = iolist_to_binary(re:replace("Ab","a(?-i)b","h&oOovpk",[caseless,
                                                                                                                                                                              global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?-i)b","liOu",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?-i)b","liOu",[caseless,
                                                                                                                                                                                       global])), 
?line <<"aB">> = iolist_to_binary(re:replace("aB","a(?-i)b","P",[caseless])), 
?line <<"aB">> = iolist_to_binary(re:replace("aB","a(?-i)b","P",[caseless,
                                                                                                                                                               global])), 
?line <<"AB">> = iolist_to_binary(re:replace("AB","a(?-i)b","GdSF&e&",[caseless])), 
?line <<"AB">> = iolist_to_binary(re:replace("AB","a(?-i)b","GdSF&e&",[caseless,
                                                                                                                                                                             global])), 
?line <<"a bcd eSPWrUhOwa">> = iolist_to_binary(re:replace("a bcd e","(a (?x)b c)d e","&SPWrUhOwa",[])), 
?line <<"a bcd eSPWrUhOwa">> = iolist_to_binary(re:replace("a bcd e","(a (?x)b c)d e","&SPWrUhOwa",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a (?x)b c)d e","IgDGvOUoEIi",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a (?x)b c)d e","IgDGvOUoEIi",[global])), 
?line <<"a b cd e">> = iolist_to_binary(re:replace("a b cd e","(a (?x)b c)d e","C\\1Lora&uj\\1nePq",[])), 
?line <<"a b cd e">> = iolist_to_binary(re:replace("a b cd e","(a (?x)b c)d e","C\\1Lora&uj\\1nePq",[global])), 
?line <<"abcd e">> = iolist_to_binary(re:replace("abcd e","(a (?x)b c)d e","M",[])), 
?line <<"abcd e">> = iolist_to_binary(re:replace("abcd e","(a (?x)b c)d e","M",[global])), 
?line <<"a bcde">> = iolist_to_binary(re:replace("a bcde","(a (?x)b c)d e","mNwUc&",[])), 
?line <<"a bcde">> = iolist_to_binary(re:replace("a bcde","(a (?x)b c)d e","mNwUc&",[global])), 
?line <<"a bcde fTra bcde fnDatbuPn">> = iolist_to_binary(re:replace("a bcde f","(a b(?x)c d (?-x)e f)","&Tr\\1nDatbuPn",[])), 
?line <<"a bcde fTra bcde fnDatbuPn">> = iolist_to_binary(re:replace("a bcde f","(a b(?x)c d (?-x)e f)","&Tr\\1nDatbuPn",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a b(?x)c d (?-x)e f)","\\1AXE&qrGnJBeg",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a b(?x)c d (?-x)e f)","\\1AXE&qrGnJBeg",[global])), 
?line <<"abcdef">> = iolist_to_binary(re:replace("abcdef","(a b(?x)c d (?-x)e f)","YXaHuSXEMrxHLIUXuNu\\1",[])), 
?line <<"abcdef">> = iolist_to_binary(re:replace("abcdef","(a b(?x)c d (?-x)e f)","YXaHuSXEMrxHLIUXuNu\\1",[global])), 
?line <<"AmT">> = iolist_to_binary(re:replace("abc","(a(?i)b)c","AmT",[])), 
?line <<"AmT">> = iolist_to_binary(re:replace("abc","(a(?i)b)c","AmT",[global])), 
?line <<"CYjrwVi">> = iolist_to_binary(re:replace("aBc","(a(?i)b)c","CYjrwVi",[])), 
?line <<"CYjrwVi">> = iolist_to_binary(re:replace("aBc","(a(?i)b)c","CYjrwVi",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a(?i)b)c","STYFgfjhE&dcc",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a(?i)b)c","STYFgfjhE&dcc",[global])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","(a(?i)b)c","BAcmfc\\1fAfr&o",[])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","(a(?i)b)c","BAcmfc\\1fAfr&o",[global])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","(a(?i)b)c","NGkAgBCJxbCgR",[])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","(a(?i)b)c","NGkAgBCJxbCgR",[global])), 
?line <<"Abc">> = iolist_to_binary(re:replace("Abc","(a(?i)b)c","aS&kKYGwkOB&YhadhLX",[])), 
?line <<"Abc">> = iolist_to_binary(re:replace("Abc","(a(?i)b)c","aS&kKYGwkOB&YhadhLX",[global])), 
?line <<"ABc">> = iolist_to_binary(re:replace("ABc","(a(?i)b)c","hP\\1RiAIeDp",[])), 
?line <<"ABc">> = iolist_to_binary(re:replace("ABc","(a(?i)b)c","hP\\1RiAIeDp",[global])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","(a(?i)b)c","Jj&j\\1&I&\\1&CR\\1qDG",[])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","(a(?i)b)c","Jj&j\\1&I&\\1&CR\\1qDG",[global])), 
?line <<"AbC">> = iolist_to_binary(re:replace("AbC","(a(?i)b)c","\\1h\\1XCNuqcxa",[])), 
?line <<"AbC">> = iolist_to_binary(re:replace("AbC","(a(?i)b)c","\\1h\\1XCNuqcxa",[global])), 
?line <<"hsDxrqJjHQabc">> = iolist_to_binary(re:replace("abc","a(?i:b)c","hsDxrqJjHQ&",[])), 
?line <<"hsDxrqJjHQabc">> = iolist_to_binary(re:replace("abc","a(?i:b)c","hsDxrqJjHQ&",[global])), 
?line <<"QltXULOSWaBcFaBcS">> = iolist_to_binary(re:replace("aBc","a(?i:b)c","Qlt\\1XU\\1L\\1OSW&F&S",[])), 
?line <<"QltXULOSWaBcFaBcS">> = iolist_to_binary(re:replace("aBc","a(?i:b)c","Qlt\\1XU\\1L\\1OSW&F&S",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?i:b)c","owyoniUsut",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?i:b)c","owyoniUsut",[global])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","a(?i:b)c","unB&TlphDWAD",[])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","a(?i:b)c","unB&TlphDWAD",[global])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","a(?i:b)c","\\1XaX&kAbe&\\1V",[])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","a(?i:b)c","\\1XaX&kAbe&\\1V",[global])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","a(?i:b)c","IY\\1aQ&tM\\1",[])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","a(?i:b)c","IY\\1aQ&tM\\1",[global])), 
?line <<"aBcOHQouBOaBc">> = iolist_to_binary(re:replace("aBc","a(?i:b)*c","&O\\1HQo\\1uBO&",[])), 
?line <<"aBcOHQouBOaBc">> = iolist_to_binary(re:replace("aBc","a(?i:b)*c","&O\\1HQo\\1uBO&",[global])), 
?line <<"lvjhpFaBBceaBBciWQNaBBcr">> = iolist_to_binary(re:replace("aBBc","a(?i:b)*c","lvjhpF&e&i\\1WQN\\1&r",[])), 
?line <<"lvjhpFaBBceaBBciWQNaBBcr">> = iolist_to_binary(re:replace("aBBc","a(?i:b)*c","lvjhpF&e&i\\1WQN\\1&r",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?i:b)*c","\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?i:b)*c","\\1",[global])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","a(?i:b)*c","OaR&&ytX",[])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","a(?i:b)*c","OaR&&ytX",[global])), 
?line <<"aBBC">> = iolist_to_binary(re:replace("aBBC","a(?i:b)*c","Su",[])), 
?line <<"aBBC">> = iolist_to_binary(re:replace("aBBC","a(?i:b)*c","Su",[global])), 
?line <<"abcdabcdalFfabcdsPxC">> = iolist_to_binary(re:replace("abcd","a(?=b(?i)c)\\w\\wd","&&alFf&sPxC",[])), 
?line <<"abcdabcdalFfabcdsPxC">> = iolist_to_binary(re:replace("abcd","a(?=b(?i)c)\\w\\wd","&&alFf&sPxC",[global])), 
?line <<"hNuQEFvcSEabCdQTlwEabCd">> = iolist_to_binary(re:replace("abCd","a(?=b(?i)c)\\w\\wd","hNuQEFvcSE\\1&QTlwE&",[])), 
?line <<"hNuQEFvcSEabCdQTlwEabCd">> = iolist_to_binary(re:replace("abCd","a(?=b(?i)c)\\w\\wd","hNuQEFvcSE\\1&QTlwE&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?=b(?i)c)\\w\\wd","YLT",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a(?=b(?i)c)\\w\\wd","YLT",[global])), 
?line <<"aBCd">> = iolist_to_binary(re:replace("aBCd","a(?=b(?i)c)\\w\\wd","u",[])), 
?line <<"aBCd">> = iolist_to_binary(re:replace("aBCd","a(?=b(?i)c)\\w\\wd","u",[global])), 
?line <<"abcD">> = iolist_to_binary(re:replace("abcD","a(?=b(?i)c)\\w\\wd","PIaL\\1rCHujWQjtBluw",[])), 
?line <<"abcD">> = iolist_to_binary(re:replace("abcD","a(?=b(?i)c)\\w\\wd","PIaL\\1rCHujWQjtBluw",[global])), 
?line <<"JklClgvcUHdcbpmore than million">> = iolist_to_binary(re:replace("more than million","(?s-i:more.*than).*million","JklCl\\1gvc\\1UHdcbp&",[caseless])), 
?line <<"JklClgvcUHdcbpmore than million">> = iolist_to_binary(re:replace("more than million","(?s-i:more.*than).*million","JklCl\\1gvc\\1UHdcbp&",[caseless,
                                                                                                                                                                                                                                                                              global])), 
?line <<"RaiCEcYVVcTj">> = iolist_to_binary(re:replace("more than MILLION","(?s-i:more.*than).*million","R\\1\\1\\1aiCEcYVVcTj",[caseless])), 
?line <<"RaiCEcYVVcTj">> = iolist_to_binary(re:replace("more than MILLION","(?s-i:more.*than).*million","R\\1\\1\\1aiCEcYVVcTj",[caseless,
                                                                                                                                                                                                                                                                              global])), 
?line <<"AGtSe">> = iolist_to_binary(re:replace("more 
 than Million","(?s-i:more.*than).*million","AGtSe",[caseless])), 
?line <<"AGtSe">> = iolist_to_binary(re:replace("more 
 than Million","(?s-i:more.*than).*million","AGtSe",[caseless,global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s-i:more.*than).*million","vIAbYe&Vw\\1&VD",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?s-i:more.*than).*million","vIAbYe&Vw\\1&VD",[caseless,
                                                                                                                                                                                                                                                      global])), 
?line <<"MORE THAN MILLION">> = iolist_to_binary(re:replace("MORE THAN MILLION","(?s-i:more.*than).*million","LhBYPjwD\\1kJ\\1",[caseless])), 
?line <<"MORE THAN MILLION">> = iolist_to_binary(re:replace("MORE THAN MILLION","(?s-i:more.*than).*million","LhBYPjwD\\1kJ\\1",[caseless,
                                                                                                                                                                                                                                                                   global])), 
?line <<"more 
 than 
 million">> = iolist_to_binary(re:replace("more 
 than 
 million","(?s-i:more.*than).*million","SSp\\1ttOwEGO&H",[caseless])), 
?line <<"more 
 than 
 million">> = iolist_to_binary(re:replace("more 
 than 
 million","(?s-i:more.*than).*million","SSp\\1ttOwEGO&H",[caseless,
                                                                 global])), 
?line <<"dmore than millionhFexWTaTmclBHK">> = iolist_to_binary(re:replace("more than million","(?:(?s-i)more.*than).*million","d&hFexWTaT\\1\\1mc\\1\\1lBHK",[caseless])), 
?line <<"dmore than millionhFexWTaTmclBHK">> = iolist_to_binary(re:replace("more than million","(?:(?s-i)more.*than).*million","d&hFexWTaT\\1\\1mc\\1\\1lBHK",[caseless,
                                                                                                                                                                                                                                                                                                    global])), 
?line <<"wcVAikDmore than MILLIONFsmore than MILLIONIceKiuDm">> = iolist_to_binary(re:replace("more than MILLION","(?:(?s-i)more.*than).*million","wcVAikD&Fs&Ice\\1KiuDm",[caseless])), 
?line <<"wcVAikDmore than MILLIONFsmore than MILLIONIceKiuDm">> = iolist_to_binary(re:replace("more than MILLION","(?:(?s-i)more.*than).*million","wcVAikD&Fs&Ice\\1KiuDm",[caseless,
                                                                                                                                                                                                                                                                                      global])), 
?line <<"BMxnsX">> = iolist_to_binary(re:replace("more 
 than Million","(?:(?s-i)more.*than).*million","BMx\\1nsX",[caseless])), 
?line <<"BMxnsX">> = iolist_to_binary(re:replace("more 
 than Million","(?:(?s-i)more.*than).*million","BMx\\1nsX",[caseless,
                                                                   global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?:(?s-i)more.*than).*million","e\\1KeC\\1LrMA",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?:(?s-i)more.*than).*million","e\\1KeC\\1LrMA",[caseless,
                                                                                                                                                                                                                                                         global])), 
?line <<"MORE THAN MILLION">> = iolist_to_binary(re:replace("MORE THAN MILLION","(?:(?s-i)more.*than).*million","Oo&U&\\1O\\1royLyh\\1Uj\\1&e",[caseless])), 
?line <<"MORE THAN MILLION">> = iolist_to_binary(re:replace("MORE THAN MILLION","(?:(?s-i)more.*than).*million","Oo&U&\\1O\\1royLyh\\1Uj\\1&e",[caseless,
                                                                                                                                                                                                                                                                                                      global])), 
?line <<"more 
 than 
 million">> = iolist_to_binary(re:replace("more 
 than 
 million","(?:(?s-i)more.*than).*million","rsd\\1UhwpU\\1&S",[caseless])), 
?line <<"more 
 than 
 million">> = iolist_to_binary(re:replace("more 
 than 
 million","(?:(?s-i)more.*than).*million","rsd\\1UhwpU\\1&S",[caseless,
                                                                       global])), 
?line <<"rTdtycUabcoabcVaVEt">> = iolist_to_binary(re:replace("abc","(?>a(?i)b+)+c","r\\1\\1T\\1dtycU&o&V\\1aV\\1Et",[])), 
?line <<"rTdtycUabcoabcVaVEt">> = iolist_to_binary(re:replace("abc","(?>a(?i)b+)+c","r\\1\\1T\\1dtycU&o&V\\1aV\\1Et",[global])), 
?line <<"geFTAcqhWJc">> = iolist_to_binary(re:replace("aBbc","(?>a(?i)b+)+c","geFTAc\\1qhWJ\\1c",[])), 
?line <<"geFTAcqhWJc">> = iolist_to_binary(re:replace("aBbc","(?>a(?i)b+)+c","geFTAc\\1qhWJ\\1c",[global])), 
?line <<"lHStMaBBcnaBBcjCaBBcgdfm">> = iolist_to_binary(re:replace("aBBc","(?>a(?i)b+)+c","lHStM&n&jC&g\\1df\\1m",[])), 
?line <<"lHStMaBBcnaBBcjCaBBcgdfm">> = iolist_to_binary(re:replace("aBBc","(?>a(?i)b+)+c","lHStM&n&jC&g\\1df\\1m",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?>a(?i)b+)+c","U\\1pOiN&FCXl",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?>a(?i)b+)+c","U\\1pOiN&FCXl",[global])), 
?line <<"Abc">> = iolist_to_binary(re:replace("Abc","(?>a(?i)b+)+c","h",[])), 
?line <<"Abc">> = iolist_to_binary(re:replace("Abc","(?>a(?i)b+)+c","h",[global])), 
?line <<"abAb">> = iolist_to_binary(re:replace("abAb","(?>a(?i)b+)+c","f\\1\\1DwX\\1Y&y\\1dgv&A\\1",[])), 
?line <<"abAb">> = iolist_to_binary(re:replace("abAb","(?>a(?i)b+)+c","f\\1\\1DwX\\1Y&y\\1dgv&A\\1",[global])), 
?line <<"abbC">> = iolist_to_binary(re:replace("abbC","(?>a(?i)b+)+c","&\\1Gd&r\\1shP",[])), 
?line <<"abbC">> = iolist_to_binary(re:replace("abbC","(?>a(?i)b+)+c","&\\1Gd&r\\1shP",[global])), 
?line <<"VIaLabcabcCabcyvwsI">> = iolist_to_binary(re:replace("abc","(?=a(?i)b)\\w\\wc","VIaL&&C&yvwsI",[])), 
?line <<"VIaLabcabcCabcyvwsI">> = iolist_to_binary(re:replace("abc","(?=a(?i)b)\\w\\wc","VIaL&&C&yvwsI",[global])), 
?line <<"gaBcaBc">> = iolist_to_binary(re:replace("aBc","(?=a(?i)b)\\w\\wc","g&&",[])), 
?line <<"gaBcaBc">> = iolist_to_binary(re:replace("aBc","(?=a(?i)b)\\w\\wc","g&&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?=a(?i)b)\\w\\wc","RMcFr&",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?=a(?i)b)\\w\\wc","RMcFr&",[global])), 
?line <<"Ab">> = iolist_to_binary(re:replace("Ab","(?=a(?i)b)\\w\\wc","y\\1&kD&os\\1E",[])), 
?line <<"Ab">> = iolist_to_binary(re:replace("Ab","(?=a(?i)b)\\w\\wc","y\\1&kD&os\\1E",[global])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","(?=a(?i)b)\\w\\wc","ms\\1m",[])), 
?line <<"abC">> = iolist_to_binary(re:replace("abC","(?=a(?i)b)\\w\\wc","ms\\1m",[global])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","(?=a(?i)b)\\w\\wc","lD&&vcs",[])), 
?line <<"aBC">> = iolist_to_binary(re:replace("aBC","(?=a(?i)b)\\w\\wc","lD&&vcs",[global])), 
?line <<"abxqXfVViuPuvfMxxcvcj">> = iolist_to_binary(re:replace("abxxc","(?<=a(?i)b)(\\w\\w)c","xqXfVViuPuvfM&vcj",[])), 
?line <<"abxqXfVViuPuvfMxxcvcj">> = iolist_to_binary(re:replace("abxxc","(?<=a(?i)b)(\\w\\w)c","xqXfVViuPuvfM&vcj",[global])), 
?line <<"aBXoxxcXtiuxxXqWYfixxKxxcxxUs">> = iolist_to_binary(re:replace("aBxxc","(?<=a(?i)b)(\\w\\w)c","Xo&Xtiu\\1XqWYfi\\1K&\\1Us",[])), 
?line <<"aBXoxxcXtiuxxXqWYfixxKxxcxxUs">> = iolist_to_binary(re:replace("aBxxc","(?<=a(?i)b)(\\w\\w)c","Xo&Xtiu\\1XqWYfi\\1K&\\1Us",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=a(?i)b)(\\w\\w)c","cGWOK&O&A\\1Xq&&aF\\1G",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=a(?i)b)(\\w\\w)c","cGWOK&O&A\\1Xq&&aF\\1G",[global])), 
?line <<"Abxxc">> = iolist_to_binary(re:replace("Abxxc","(?<=a(?i)b)(\\w\\w)c","uosfXS&Drr&Nsg",[])), 
?line <<"Abxxc">> = iolist_to_binary(re:replace("Abxxc","(?<=a(?i)b)(\\w\\w)c","uosfXS&Drr&Nsg",[global])), 
?line <<"ABxxc">> = iolist_to_binary(re:replace("ABxxc","(?<=a(?i)b)(\\w\\w)c","mKjv&im",[])), 
?line <<"ABxxc">> = iolist_to_binary(re:replace("ABxxc","(?<=a(?i)b)(\\w\\w)c","mKjv&im",[global])), 
?line <<"abxxC">> = iolist_to_binary(re:replace("abxxC","(?<=a(?i)b)(\\w\\w)c","ferUg\\1J\\1T\\1kWcDAY\\1jM",[])), 
?line <<"abxxC">> = iolist_to_binary(re:replace("abxxC","(?<=a(?i)b)(\\w\\w)c","ferUg\\1J\\1T\\1kWcDAY\\1jM",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("aA","(?:(a)|b)(?(1)A|B)","\\1",[])), 
?line <<"a">> = iolist_to_binary(re:replace("aA","(?:(a)|b)(?(1)A|B)","\\1",[global])), 
?line <<"YdvbBbBsFnnbBKbB">> = iolist_to_binary(re:replace("bB","(?:(a)|b)(?(1)A|B)","Y\\1\\1dv&&\\1sFnn&K&",[])), 
?line <<"YdvbBbBsFnnbBKbB">> = iolist_to_binary(re:replace("bB","(?:(a)|b)(?(1)A|B)","Y\\1\\1dv&&\\1sFnn&K&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?:(a)|b)(?(1)A|B)","\\1\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?:(a)|b)(?(1)A|B)","\\1\\1",[global])), 
?line <<"aB">> = iolist_to_binary(re:replace("aB","(?:(a)|b)(?(1)A|B)","\\1To",[])), 
?line <<"aB">> = iolist_to_binary(re:replace("aB","(?:(a)|b)(?(1)A|B)","\\1To",[global])), 
?line <<"bA">> = iolist_to_binary(re:replace("bA","(?:(a)|b)(?(1)A|B)","K\\1UMD",[])), 
?line <<"bA">> = iolist_to_binary(re:replace("bA","(?:(a)|b)(?(1)A|B)","K\\1UMD",[global])), 
?line <<"mLbykSwT">> = iolist_to_binary(re:replace("aa","^(a)?(?(1)a|b)+$","mLbykSwT",[])), 
?line <<"mLbykSwT">> = iolist_to_binary(re:replace("aa","^(a)?(?(1)a|b)+$","mLbykSwT",[global])), 
?line <<"br">> = iolist_to_binary(re:replace("b","^(a)?(?(1)a|b)+$","&r",[])), 
?line <<"br">> = iolist_to_binary(re:replace("b","^(a)?(?(1)a|b)+$","&r",[global])), 
?line <<"yaAboE">> = iolist_to_binary(re:replace("bb","^(a)?(?(1)a|b)+$","yaAb\\1o\\1E",[])), 
?line <<"yaAboE">> = iolist_to_binary(re:replace("bb","^(a)?(?(1)a|b)+$","yaAb\\1o\\1E",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a)?(?(1)a|b)+$","QkLpQarHEu\\1Fi",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(a)?(?(1)a|b)+$","QkLpQarHEu\\1Fi",[global])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a)?(?(1)a|b)+$","U",[])), 
?line <<"ab">> = iolist_to_binary(re:replace("ab","^(a)?(?(1)a|b)+$","U",[global])), 
?line <<"MoTyD">> = iolist_to_binary(re:replace("abc:","^(?(?=abc)\\w{3}:|\\d\\d)$","M\\1oTyD",[])), 
?line <<"MoTyD">> = iolist_to_binary(re:replace("abc:","^(?(?=abc)\\w{3}:|\\d\\d)$","M\\1oTyD",[global])), 
?line <<"kawc12B">> = iolist_to_binary(re:replace("12","^(?(?=abc)\\w{3}:|\\d\\d)$","k\\1awc&B\\1",[])), 
?line <<"kawc12B">> = iolist_to_binary(re:replace("12","^(?(?=abc)\\w{3}:|\\d\\d)$","k\\1awc&B\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(?=abc)\\w{3}:|\\d\\d)$","TAqA",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(?=abc)\\w{3}:|\\d\\d)$","TAqA",[global])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^(?(?=abc)\\w{3}:|\\d\\d)$","WlKxg",[])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^(?(?=abc)\\w{3}:|\\d\\d)$","WlKxg",[global])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","^(?(?=abc)\\w{3}:|\\d\\d)$","O",[])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","^(?(?=abc)\\w{3}:|\\d\\d)$","O",[global])), 
?line <<"kNqQd">> = iolist_to_binary(re:replace("abc:","^(?(?!abc)\\d\\d|\\w{3}:)$","kNq\\1Q\\1d",[])), 
?line <<"kNqQd">> = iolist_to_binary(re:replace("abc:","^(?(?!abc)\\d\\d|\\w{3}:)$","kNq\\1Q\\1d",[global])), 
?line <<"Cr">> = iolist_to_binary(re:replace("12","^(?(?!abc)\\d\\d|\\w{3}:)$","\\1C\\1r",[])), 
?line <<"Cr">> = iolist_to_binary(re:replace("12","^(?(?!abc)\\d\\d|\\w{3}:)$","\\1C\\1r",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(?!abc)\\d\\d|\\w{3}:)$","&\\1\\1RHBBR",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(?!abc)\\d\\d|\\w{3}:)$","&\\1\\1RHBBR",[global])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^(?(?!abc)\\d\\d|\\w{3}:)$","P",[])), 
?line <<"123">> = iolist_to_binary(re:replace("123","^(?(?!abc)\\d\\d|\\w{3}:)$","P",[global])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","^(?(?!abc)\\d\\d|\\w{3}:)$","&awfl",[])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","^(?(?!abc)\\d\\d|\\w{3}:)$","&awfl",[global])), 
?line <<"fooHSXSjJapIqY">> = iolist_to_binary(re:replace("foobar","(?(?<=foo)bar|cat)","HSXSjJ\\1apIqY",[])), 
?line <<"fooHSXSjJapIqY">> = iolist_to_binary(re:replace("foobar","(?(?<=foo)bar|cat)","HSXSjJ\\1apIqY",[global])), 
?line <<"IouuQfOcatNN">> = iolist_to_binary(re:replace("cat","(?(?<=foo)bar|cat)","Iouu\\1QfO&NN\\1",[])), 
?line <<"IouuQfOcatNN">> = iolist_to_binary(re:replace("cat","(?(?<=foo)bar|cat)","Iouu\\1QfO&NN\\1",[global])), 
?line <<"fcatxAWTu">> = iolist_to_binary(re:replace("fcat","(?(?<=foo)bar|cat)","&\\1xAWTu",[])), 
?line <<"fcatxAWTu">> = iolist_to_binary(re:replace("fcat","(?(?<=foo)bar|cat)","&\\1xAWTu",[global])), 
?line <<"fodYcNREMccatAcatyvscatidk">> = iolist_to_binary(re:replace("focat","(?(?<=foo)bar|cat)","dYc\\1N\\1REMc&A&yvs&idk",[])), 
?line <<"fodYcNREMccatAcatyvscatidk">> = iolist_to_binary(re:replace("focat","(?(?<=foo)bar|cat)","dYc\\1N\\1REMc&A&yvs&idk",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?<=foo)bar|cat)","FmDOEt&",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?<=foo)bar|cat)","FmDOEt&",[global])), 
?line <<"foocat">> = iolist_to_binary(re:replace("foocat","(?(?<=foo)bar|cat)","Jj&OFdGEDut\\1HjNDH",[])), 
?line <<"foocat">> = iolist_to_binary(re:replace("foocat","(?(?<=foo)bar|cat)","Jj&OFdGEDut\\1HjNDH",[global])), 
?line <<"fooEGbarEwDYbarCNxYJbarbD">> = iolist_to_binary(re:replace("foobar","(?(?<!foo)cat|bar)","EG&Ew\\1DY&CN\\1xYJ&bD",[])), 
?line <<"fooEGbarEwDYbarCNxYJbarbD">> = iolist_to_binary(re:replace("foobar","(?(?<!foo)cat|bar)","EG&Ew\\1DY&CN\\1xYJ&bD",[global])), 
?line <<"jHKKpLcatBtkhMt">> = iolist_to_binary(re:replace("cat","(?(?<!foo)cat|bar)","jHKKpL&BtkhMt",[])), 
?line <<"jHKKpLcatBtkhMt">> = iolist_to_binary(re:replace("cat","(?(?<!foo)cat|bar)","jHKKpL&BtkhMt",[global])), 
?line <<"fiJOnynFk">> = iolist_to_binary(re:replace("fcat","(?(?<!foo)cat|bar)","iJ\\1O\\1ny\\1nFk",[])), 
?line <<"fiJOnynFk">> = iolist_to_binary(re:replace("fcat","(?(?<!foo)cat|bar)","iJ\\1O\\1ny\\1nFk",[global])), 
?line <<"foWCSvhChIBqicatcatLjMieK">> = iolist_to_binary(re:replace("focat","(?(?<!foo)cat|bar)","WCSvh\\1ChIBqi&&LjMieK",[])), 
?line <<"foWCSvhChIBqicatcatLjMieK">> = iolist_to_binary(re:replace("focat","(?(?<!foo)cat|bar)","WCSvh\\1ChIBqi&&LjMieK",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?<!foo)cat|bar)","v&yn",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?<!foo)cat|bar)","v&yn",[global])), 
?line <<"foocat">> = iolist_to_binary(re:replace("foocat","(?(?<!foo)cat|bar)","\\1&\\1\\1&dvNYDwrfFA\\1&d",[])), 
?line <<"foocat">> = iolist_to_binary(re:replace("foocat","(?(?<!foo)cat|bar)","\\1&\\1\\1&dvNYDwrfFA\\1&d",[global])), 
?line <<"TQKeRLoqn">> = iolist_to_binary(re:replace("abcd","( \\( )? [^()]+ (?(1) \\) |) ","T\\1\\1QK\\1e\\1RLoqn",[extended])), 
?line <<"TQKeRLoqn">> = iolist_to_binary(re:replace("abcd","( \\( )? [^()]+ (?(1) \\) |) ","T\\1\\1QK\\1e\\1RLoqn",[extended,
                                                                                                                                                                                                                                                             global])), 
?line <<"Qd(ovEgf(pkOYCuPDq(R">> = iolist_to_binary(re:replace("(abcd)","( \\( )? [^()]+ (?(1) \\) |) ","Qd\\1ovEgf\\1pkOYCuPDq\\1R",[extended])), 
?line <<"Qd(ovEgf(pkOYCuPDq(R">> = iolist_to_binary(re:replace("(abcd)","( \\( )? [^()]+ (?(1) \\) |) ","Qd\\1ovEgf\\1pkOYCuPDq\\1R",[extended,
                                                                                                                                                                                                                                                                          global])), 
?line <<"Dmthe quick QWSbgBeLthe quick E(abcd) fox">> = iolist_to_binary(re:replace("the quick (abcd) fox","( \\( )? [^()]+ (?(1) \\) |) ","Dm\\1&QWSbgBeL&E",[extended])), 
?line <<"Dmthe quick QWSbgBeLthe quick EDm((abcd)QWSbgBeL(abcd)EDm foxQWSbgBeL foxE">> = iolist_to_binary(re:replace("the quick (abcd) fox","( \\( )? [^()]+ (?(1) \\) |) ","Dm\\1&QWSbgBeL&E",[extended,
                                                                                                                                                                                                                                                                                  global])), 
?line <<"(Ld">> = iolist_to_binary(re:replace("(abcd","( \\( )? [^()]+ (?(1) \\) |) ","Ld",[extended])), 
?line <<"(Ld">> = iolist_to_binary(re:replace("(abcd","( \\( )? [^()]+ (?(1) \\) |) ","Ld",[extended,
                                                                                                                                                                                                                     global])), 
?line <<"abcdiCLfuabcdkd">> = iolist_to_binary(re:replace("abcd","( \\( )? [^()]+ (?(1) \\) ) ","&iCLfu&kd",[extended])), 
?line <<"abcdiCLfuabcdkd">> = iolist_to_binary(re:replace("abcd","( \\( )? [^()]+ (?(1) \\) ) ","&iCLfu&kd",[extended,
                                                                                                                                                                                                                                 global])), 
?line <<"uXgnII((abcd)SMj">> = iolist_to_binary(re:replace("(abcd)","( \\( )? [^()]+ (?(1) \\) ) ","uXgnII\\1&SMj",[extended])), 
?line <<"uXgnII((abcd)SMj">> = iolist_to_binary(re:replace("(abcd)","( \\( )? [^()]+ (?(1) \\) ) ","uXgnII\\1&SMj",[extended,
                                                                                                                                                                                                                                             global])), 
?line <<"the quick the quick the quick xjaBhsFamkEL(abcd) fox">> = iolist_to_binary(re:replace("the quick (abcd) fox","( \\( )? [^()]+ (?(1) \\) ) ","&&&xjaBhsFa\\1mkEL\\1",[extended])), 
?line <<"the quick the quick the quick xjaBhsFamkEL(abcd)(abcd)(abcd)xjaBhsFa(mkEL( fox fox foxxjaBhsFamkEL">> = iolist_to_binary(re:replace("the quick (abcd) fox","( \\( )? [^()]+ (?(1) \\) ) ","&&&xjaBhsFa\\1mkEL\\1",[extended,
                                                                                                                                                                                                                                                                                            global])), 
?line <<"(KuH">> = iolist_to_binary(re:replace("(abcd","( \\( )? [^()]+ (?(1) \\) ) ","K\\1uH",[extended])), 
?line <<"(KuH">> = iolist_to_binary(re:replace("(abcd","( \\( )? [^()]+ (?(1) \\) ) ","K\\1uH",[extended,
                                                                                                                                                                                                                            global])), 
?line <<"IMNCUvkRpMGDtA">> = iolist_to_binary(re:replace("12","^(?(2)a|(1)(2))+$","IMNCUvkRpMGDtA",[])), 
?line <<"IMNCUvkRpMGDtA">> = iolist_to_binary(re:replace("12","^(?(2)a|(1)(2))+$","IMNCUvkRpMGDtA",[global])), 
?line <<"YQQcCpqUaDwGin12a1he">> = iolist_to_binary(re:replace("12a","^(?(2)a|(1)(2))+$","YQQcCpqUaDwGin&\\1he",[])), 
?line <<"YQQcCpqUaDwGin12a1he">> = iolist_to_binary(re:replace("12a","^(?(2)a|(1)(2))+$","YQQcCpqUaDwGin&\\1he",[global])), 
?line <<"LiJWEQyka">> = iolist_to_binary(re:replace("12aa","^(?(2)a|(1)(2))+$","LiJWEQyka",[])), 
?line <<"LiJWEQyka">> = iolist_to_binary(re:replace("12aa","^(?(2)a|(1)(2))+$","LiJWEQyka",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(2)a|(1)(2))+$","jNpGudmNvPautj\\1\\1rc",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(?(2)a|(1)(2))+$","jNpGudmNvPautj\\1\\1rc",[global])), 
?line <<"1234">> = iolist_to_binary(re:replace("1234","^(?(2)a|(1)(2))+$","TKb&DSqQCtNBSjto\\1",[])), 
?line <<"1234">> = iolist_to_binary(re:replace("1234","^(?(2)a|(1)(2))+$","TKb&DSqQCtNBSjto\\1",[global])), 
?line <<"OKbblah blahmEblah blahcAEblah">> = iolist_to_binary(re:replace("blah blah","((?i)blah)\\s+\\1","OKb&mE&cAE\\1",[])), 
?line <<"OKbblah blahmEblah blahcAEblah">> = iolist_to_binary(re:replace("blah blah","((?i)blah)\\s+\\1","OKb&mE&cAE\\1",[global])), 
?line <<"sHRABLAH BLAHDBLAH BLAHofBLAHMonBF">> = iolist_to_binary(re:replace("BLAH BLAH","((?i)blah)\\s+\\1","sHRA&D&of\\1MonBF",[])), 
?line <<"sHRABLAH BLAHDBLAH BLAHofBLAHMonBF">> = iolist_to_binary(re:replace("BLAH BLAH","((?i)blah)\\s+\\1","sHRA&D&of\\1MonBF",[global])), 
?line <<"rBlah BlahowtRMgXJKNBlah Blah">> = iolist_to_binary(re:replace("Blah Blah","((?i)blah)\\s+\\1","r&owtRMgXJKN&",[])), 
?line <<"rBlah BlahowtRMgXJKNBlah Blah">> = iolist_to_binary(re:replace("Blah Blah","((?i)blah)\\s+\\1","r&owtRMgXJKN&",[global])), 
?line <<"JblaHeNvblaHaSeblaHblaH blaHg">> = iolist_to_binary(re:replace("blaH blaH","((?i)blah)\\s+\\1","J\\1eNv\\1aSe\\1&g",[])), 
?line <<"JblaHeNvblaHaSeblaHblaH blaHg">> = iolist_to_binary(re:replace("blaH blaH","((?i)blah)\\s+\\1","J\\1eNv\\1aSe\\1&g",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","((?i)blah)\\s+\\1","\\1LVUknDVfgj\\1ij\\1eDhAE",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","((?i)blah)\\s+\\1","\\1LVUknDVfgj\\1ij\\1eDhAE",[global])), 
?line <<"blah BLAH">> = iolist_to_binary(re:replace("blah BLAH","((?i)blah)\\s+\\1","auAYHQ\\1S&PKut",[])), 
?line <<"blah BLAH">> = iolist_to_binary(re:replace("blah BLAH","((?i)blah)\\s+\\1","auAYHQ\\1S&PKut",[global])), 
?line <<"Blah blah">> = iolist_to_binary(re:replace("Blah blah","((?i)blah)\\s+\\1","\\1&N\\1tNui&w&CgfgFCbPk",[])), 
?line <<"Blah blah">> = iolist_to_binary(re:replace("Blah blah","((?i)blah)\\s+\\1","\\1&N\\1tNui&w&CgfgFCbPk",[global])), 
?line <<"blaH blah">> = iolist_to_binary(re:replace("blaH blah","((?i)blah)\\s+\\1","rLouaVXAOeWe",[])), 
?line <<"blaH blah">> = iolist_to_binary(re:replace("blaH blah","((?i)blah)\\s+\\1","rLouaVXAOeWe",[global])), 
?line <<"CXblahSqUjfblah blahblah blahblah">> = iolist_to_binary(re:replace("blah blah","((?i)blah)\\s+(?i:\\1)","CX\\1SqUjf&&\\1",[])), 
?line <<"CXblahSqUjfblah blahblah blahblah">> = iolist_to_binary(re:replace("blah blah","((?i)blah)\\s+(?i:\\1)","CX\\1SqUjf&&\\1",[global])), 
?line <<"XBLAHTkBLAHXUjMhbiRBLAH BLAHgXxxti">> = iolist_to_binary(re:replace("BLAH BLAH","((?i)blah)\\s+(?i:\\1)","X\\1Tk\\1XUjMhbiR&gXxxti",[])), 
?line <<"XBLAHTkBLAHXUjMhbiRBLAH BLAHgXxxti">> = iolist_to_binary(re:replace("BLAH BLAH","((?i)blah)\\s+(?i:\\1)","X\\1Tk\\1XUjMhbiR&gXxxti",[global])), 
?line <<"SBlahlpSqiBlah BlahLvYBlahJBlahxSbx">> = iolist_to_binary(re:replace("Blah Blah","((?i)blah)\\s+(?i:\\1)","S\\1lpSqi&LvY\\1J\\1xSbx",[])), 
?line <<"SBlahlpSqiBlah BlahLvYBlahJBlahxSbx">> = iolist_to_binary(re:replace("Blah Blah","((?i)blah)\\s+(?i:\\1)","S\\1lpSqi&LvY\\1J\\1xSbx",[global])), 
?line <<"oIFblaHCV">> = iolist_to_binary(re:replace("blaH blaH","((?i)blah)\\s+(?i:\\1)","oIF\\1CV",[])), 
?line <<"oIFblaHCV">> = iolist_to_binary(re:replace("blaH blaH","((?i)blah)\\s+(?i:\\1)","oIF\\1CV",[global])), 
?line <<"blahblah BLAHnOGRLblahgvVwkgjq">> = iolist_to_binary(re:replace("blah BLAH","((?i)blah)\\s+(?i:\\1)","\\1&nOGRL\\1gvVwkgjq",[])), 
?line <<"blahblah BLAHnOGRLblahgvVwkgjq">> = iolist_to_binary(re:replace("blah BLAH","((?i)blah)\\s+(?i:\\1)","\\1&nOGRL\\1gvVwkgjq",[global])), 
?line <<"PrLBlahTtgBlah blahpNNDBlah blahBlah blahBlah blah">> = iolist_to_binary(re:replace("Blah blah","((?i)blah)\\s+(?i:\\1)","PrL\\1Ttg&pNND&&&",[])), 
?line <<"PrLBlahTtgBlah blahpNNDBlah blahBlah blahBlah blah">> = iolist_to_binary(re:replace("Blah blah","((?i)blah)\\s+(?i:\\1)","PrL\\1Ttg&pNND&&&",[global])), 
?line <<"blaH blahGnDblaHFhNOIOmBhblaH blahfblaH blahKt">> = iolist_to_binary(re:replace("blaH blah","((?i)blah)\\s+(?i:\\1)","&GnD\\1FhNOIOmBh&f&Kt",[])), 
?line <<"blaH blahGnDblaHFhNOIOmBhblaH blahfblaH blahKt">> = iolist_to_binary(re:replace("blaH blah","((?i)blah)\\s+(?i:\\1)","&GnD\\1FhNOIOmBh&f&Kt",[global])), 
?line <<"aW">> = iolist_to_binary(re:replace("a","(?>a*)*","&W",[])), 
?line <<"aWW">> = iolist_to_binary(re:replace("a","(?>a*)*","&W",[global])), 
?line <<"Seaa">> = iolist_to_binary(re:replace("aa","(?>a*)*","Se&",[])), 
?line <<"SeaaSe">> = iolist_to_binary(re:replace("aa","(?>a*)*","Se&",[global])), 
?line <<"itILgCmaaaaioxBkDkO">> = iolist_to_binary(re:replace("aaaa","(?>a*)*","itIL\\1gCm&ioxBkDkO",[])), 
?line <<"itILgCmaaaaioxBkDkOitILgCmioxBkDkO">> = iolist_to_binary(re:replace("aaaa","(?>a*)*","itIL\\1gCm&ioxBkDkO",[global])), 
?line <<"aqm">> = iolist_to_binary(re:replace("abc","(abc|)+","\\1aqm",[])), 
?line <<"aqmaqm">> = iolist_to_binary(re:replace("abc","(abc|)+","\\1aqm",[global])), 
?line <<"tSWTMOLPTnvvJTwabcabcJwE">> = iolist_to_binary(re:replace("abcabc","(abc|)+","tSWTMOLPTnvvJTw\\1&JwE",[])), 
?line <<"tSWTMOLPTnvvJTwabcabcJwEtSWTMOLPTnvvJTwJwE">> = iolist_to_binary(re:replace("abcabc","(abc|)+","tSWTMOLPTnvvJTw\\1&JwE",[global])), 
?line <<"eMhIJbMyp">> = iolist_to_binary(re:replace("abcabcabc","(abc|)+","\\1eMh\\1\\1IJb\\1Myp",[])), 
?line <<"eMhIJbMypeMhIJbMyp">> = iolist_to_binary(re:replace("abcabcabc","(abc|)+","\\1eMh\\1\\1IJb\\1Myp",[global])), 
?line <<"dBxyz">> = iolist_to_binary(re:replace("xyz","(abc|)+","dB",[])), 
?line <<"dBxdBydBzdB">> = iolist_to_binary(re:replace("xyz","(abc|)+","dB",[global])), 
?line <<"wCrHnihkSygW">> = iolist_to_binary(re:replace("a","([a]*)*","wCrHnihkSygW",[])), 
?line <<"wCrHnihkSygWwCrHnihkSygW">> = iolist_to_binary(re:replace("a","([a]*)*","wCrHnihkSygW",[global])), 
?line <<"GjjjYNVefTgBaaaaafMw">> = iolist_to_binary(re:replace("aaaaa","([a]*)*","\\1Gjj\\1jYNVefTgB&fMw",[])), 
?line <<"GjjjYNVefTgBaaaaafMwGjjjYNVefTgBfMw">> = iolist_to_binary(re:replace("aaaaa","([a]*)*","\\1Gjj\\1jYNVefTgB&fMw",[global])), 
?line <<"pXFqCJUNaNU">> = iolist_to_binary(re:replace("a","([ab]*)*","pXFqCJUN&NU",[])), 
?line <<"pXFqCJUNaNUpXFqCJUNNU">> = iolist_to_binary(re:replace("a","([ab]*)*","pXFqCJUN&NU",[global])), 
?line <<"qbGbaTAUHHibHnl">> = iolist_to_binary(re:replace("b","([ab]*)*","q&\\1GbaTAUHHi&Hn\\1l",[])), 
?line <<"qbGbaTAUHHibHnlqGbaTAUHHiHnl">> = iolist_to_binary(re:replace("b","([ab]*)*","q&\\1GbaTAUHHi&Hn\\1l",[global])), 
?line <<"l">> = iolist_to_binary(re:replace("ababab","([ab]*)*","\\1l",[])), 
?line <<"ll">> = iolist_to_binary(re:replace("ababab","([ab]*)*","\\1l",[global])), 
?line <<"scde">> = iolist_to_binary(re:replace("aaaabcde","([ab]*)*","s\\1\\1",[])), 
?line <<"sscsdses">> = iolist_to_binary(re:replace("aaaabcde","([ab]*)*","s\\1\\1",[global])), 
?line <<"cLbwWRDkdHt">> = iolist_to_binary(re:replace("bbbb","([ab]*)*","cL\\1bwWRDkdHt",[])), 
?line <<"cLbwWRDkdHtcLbwWRDkdHt">> = iolist_to_binary(re:replace("bbbb","([ab]*)*","cL\\1bwWRDkdHt",[global])), 
?line <<"nmytevammko">> = iolist_to_binary(re:replace("b","([^a]*)*","nmytevammk\\1o",[])), 
?line <<"nmytevammkonmytevammko">> = iolist_to_binary(re:replace("b","([^a]*)*","nmytevammk\\1o",[global])), 
?line <<"bbbbqIbAMyI">> = iolist_to_binary(re:replace("bbbb","([^a]*)*","&qIbAMyI",[])), 
?line <<"bbbbqIbAMyIqIbAMyI">> = iolist_to_binary(re:replace("bbbb","([^a]*)*","&qIbAMyI",[global])), 
?line <<"ItRSFsauaaa">> = iolist_to_binary(re:replace("aaa","([^a]*)*","ItRS\\1Fs&a&&u",[])), 
?line <<"ItRSFsauaItRSFsauaItRSFsauaItRSFsau">> = iolist_to_binary(re:replace("aaa","([^a]*)*","ItRS\\1Fs&a&&u",[global])), 
?line <<"PKlYUFjsxy">> = iolist_to_binary(re:replace("cccc","([^ab]*)*","PKlYUFjsxy",[])), 
?line <<"PKlYUFjsxyPKlYUFjsxy">> = iolist_to_binary(re:replace("cccc","([^ab]*)*","PKlYUFjsxy",[global])), 
?line <<"eBumQabab">> = iolist_to_binary(re:replace("abab","([^ab]*)*","e\\1BumQ",[])), 
?line <<"eBumQaeBumQbeBumQaeBumQbeBumQ">> = iolist_to_binary(re:replace("abab","([^ab]*)*","e\\1BumQ",[global])), 
?line <<"VsNPa">> = iolist_to_binary(re:replace("a","([a]*?)*","&Vs\\1N&P",[])), 
?line <<"VsNPaVsNaPVsNP">> = iolist_to_binary(re:replace("a","([a]*?)*","&Vs\\1N&P",[global])), 
?line <<"oJTmjRIMESSEdaaaa">> = iolist_to_binary(re:replace("aaaa","([a]*?)*","o&JT\\1\\1\\1&m&jR&IMESSEd",[])), 
?line <<"oJTmjRIMESSEdoaJTamajRaIMESSEdoJTmjRIMESSEdoaJTamajRaIMESSEdoJTmjRIMESSEdoaJTamajRaIMESSEdoJTmjRIMESSEdoaJTamajRaIMESSEdoJTmjRIMESSEd">> = iolist_to_binary(re:replace("aaaa","([a]*?)*","o&JT\\1\\1\\1&m&jR&IMESSEd",[global])), 
?line <<"uSOa">> = iolist_to_binary(re:replace("a","([ab]*?)*","&\\1&u&SO",[])), 
?line <<"uSOaauaSOuSO">> = iolist_to_binary(re:replace("a","([ab]*?)*","&\\1&u&SO",[global])), 
?line <<"BfDNwUAfjUb">> = iolist_to_binary(re:replace("b","([ab]*?)*","B&fDNwU\\1Af&j\\1U\\1",[])), 
?line <<"BfDNwUAfjUBbfDNwUAfbjUBfDNwUAfjU">> = iolist_to_binary(re:replace("b","([ab]*?)*","B&fDNwU\\1Af&j\\1U\\1",[global])), 
?line <<"kTOkbSeRnabab">> = iolist_to_binary(re:replace("abab","([ab]*?)*","k&TOkb\\1\\1S&eR&n&",[])), 
?line <<"kTOkbSeRnkaTOkbSaeRanakTOkbSeRnkbTOkbSbeRbnbkTOkbSeRnkaTOkbSaeRanakTOkbSeRnkbTOkbSbeRbnbkTOkbSeRn">> = iolist_to_binary(re:replace("abab","([ab]*?)*","k&TOkb\\1\\1S&eR&n&",[global])), 
?line <<"Sbaba">> = iolist_to_binary(re:replace("baba","([ab]*?)*","S",[])), 
?line <<"SSSSSSSSS">> = iolist_to_binary(re:replace("baba","([ab]*?)*","S",[global])), 
?line <<"Aotb">> = iolist_to_binary(re:replace("b","([^a]*?)*","A\\1ot",[])), 
?line <<"AotAotAot">> = iolist_to_binary(re:replace("b","([^a]*?)*","A\\1ot",[global])), 
?line <<"CbPnbbbb">> = iolist_to_binary(re:replace("bbbb","([^a]*?)*","CbPn&&",[])), 
?line <<"CbPnCbPnbbCbPnCbPnbbCbPnCbPnbbCbPnCbPnbbCbPn">> = iolist_to_binary(re:replace("bbbb","([^a]*?)*","CbPn&&",[global])), 
?line <<"DUteaaa">> = iolist_to_binary(re:replace("aaa","([^a]*?)*","D\\1\\1Ute",[])), 
?line <<"DUteaDUteaDUteaDUte">> = iolist_to_binary(re:replace("aaa","([^a]*?)*","D\\1\\1Ute",[global])), 
?line <<"ATgsBhAkPic">> = iolist_to_binary(re:replace("c","([^ab]*?)*","ATg\\1sB\\1hAkP&i",[])), 
?line <<"ATgsBhAkPiATgsBhAkPciATgsBhAkPi">> = iolist_to_binary(re:replace("c","([^ab]*?)*","ATg\\1sB\\1hAkP&i",[global])), 
?line <<"lwFoWkRIxUcccc">> = iolist_to_binary(re:replace("cccc","([^ab]*?)*","l&wFoWk\\1RIxU",[])), 
?line <<"lwFoWkRIxUlcwFoWkRIxUlwFoWkRIxUlcwFoWkRIxUlwFoWkRIxUlcwFoWkRIxUlwFoWkRIxUlcwFoWkRIxUlwFoWkRIxU">> = iolist_to_binary(re:replace("cccc","([^ab]*?)*","l&wFoWk\\1RIxU",[global])), 
?line <<"QXSXCbaba">> = iolist_to_binary(re:replace("baba","([^ab]*?)*","&QXSXC",[])), 
?line <<"QXSXCbQXSXCaQXSXCbQXSXCaQXSXC">> = iolist_to_binary(re:replace("baba","([^ab]*?)*","&QXSXC",[global])), 
?line <<"epgEBpyDja">> = iolist_to_binary(re:replace("a","(?>a*)*","e\\1\\1pgEB\\1\\1pyD\\1j&",[])), 
?line <<"epgEBpyDjaepgEBpyDj">> = iolist_to_binary(re:replace("a","(?>a*)*","e\\1\\1pgEB\\1\\1pyD\\1j&",[global])), 
?line <<"SekThCelBbcde">> = iolist_to_binary(re:replace("aaabcde","(?>a*)*","SekT\\1hC\\1\\1elB",[])), 
?line <<"SekThCelBSekThCelBbSekThCelBcSekThCelBdSekThCelBeSekThCelB">> = iolist_to_binary(re:replace("aaabcde","(?>a*)*","SekT\\1hC\\1\\1elB",[global])), 
?line <<"goPCaaaaawO">> = iolist_to_binary(re:replace("aaaaa","((?>a*))*","go\\1PC\\1&\\1wO",[])), 
?line <<"goPCaaaaawOgoPCwO">> = iolist_to_binary(re:replace("aaaaa","((?>a*))*","go\\1PC\\1&\\1wO",[global])), 
?line <<"SCaadJliaaKfxRbbbaa">> = iolist_to_binary(re:replace("aabbaa","((?>a*))*","\\1S\\1C&\\1dJ\\1\\1li&KfxR\\1b",[])), 
?line <<"SCaadJliaaKfxRbSCdJliKfxRbbSCdJliKfxRbbSCaadJliaaKfxRbSCdJliKfxRb">> = iolist_to_binary(re:replace("aabbaa","((?>a*))*","\\1S\\1C&\\1dJ\\1\\1li&KfxR\\1b",[global])), 
?line <<"ssMfBjQEIebjdsmPRaaaaa">> = iolist_to_binary(re:replace("aaaaa","((?>a*?))*","s&s&MfBjQEIebjdsmPR",[])), 
?line <<"ssMfBjQEIebjdsmPRassMfBjQEIebjdsmPRassMfBjQEIebjdsmPRassMfBjQEIebjdsmPRassMfBjQEIebjdsmPRassMfBjQEIebjdsmPR">> = iolist_to_binary(re:replace("aaaaa","((?>a*?))*","s&s&MfBjQEIebjdsmPR",[global])), 
?line <<"VQJGaabbaa">> = iolist_to_binary(re:replace("aabbaa","((?>a*?))*","VQ\\1&J\\1G",[])), 
?line <<"VQJGaVQJGaVQJGbVQJGbVQJGaVQJGaVQJG">> = iolist_to_binary(re:replace("aabbaa","((?>a*?))*","VQ\\1&J\\1G",[global])), 
?line <<"t">> = iolist_to_binary(re:replace("12-sep-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","t",[extended])), 
?line <<"t">> = iolist_to_binary(re:replace("12-sep-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","t",[extended,
                                                                                                                                                                                                                                                                                                                global])), 
?line <<"EIgEQmDKuIoMFts">> = iolist_to_binary(re:replace("12-09-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","EIgEQmDKuIoMFts",[extended])), 
?line <<"EIgEQmDKuIoMFts">> = iolist_to_binary(re:replace("12-09-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","EIgEQmDKuIoMFts",[extended,
                                                                                                                                                                                                                                                                                                                                          global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","M\\1K\\1N",[extended])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","M\\1K\\1N",[extended,
                                                                                                                                                                                                                                                                                                                                      global])), 
?line <<"sep-12-98">> = iolist_to_binary(re:replace("sep-12-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","Xby\\1g&vVVPgw\\1",[extended])), 
?line <<"sep-12-98">> = iolist_to_binary(re:replace("sep-12-98","(?(?=[^a-z]+[a-z])  \\d{2}-[a-z]{3}-\\d{2}  |  \\d{2}-\\d{2}-\\d{2} ) ","Xby\\1g&vVVPgw\\1",[extended,
                                                                                                                                                                                                                                                                                                                                                   global])), 
?line <<"foonfoobJpbIfooAbKhpTIXfoofooEN">> = iolist_to_binary(re:replace("foobarfoo","(?<=(foo))bar\\1","n\\1bJpbI\\1AbKhpTIX\\1\\1EN",[])), 
?line <<"foonfoobJpbIfooAbKhpTIXfoofooEN">> = iolist_to_binary(re:replace("foobarfoo","(?<=(foo))bar\\1","n\\1bJpbI\\1AbKhpTIX\\1\\1EN",[global])), 
?line <<"foobarfoofooUWdHfoofoocfifXWQdmKgtling">> = iolist_to_binary(re:replace("foobarfootling","(?<=(foo))bar\\1","&\\1UWdH\\1\\1cfifXWQdmKg",[])), 
?line <<"foobarfoofooUWdHfoofoocfifXWQdmKgtling">> = iolist_to_binary(re:replace("foobarfootling","(?<=(foo))bar\\1","&\\1UWdH\\1\\1cfifXWQdmKg",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(foo))bar\\1","\\1A\\1Do\\1roQX",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(foo))bar\\1","\\1A\\1Do\\1roQX",[global])), 
?line <<"foobar">> = iolist_to_binary(re:replace("foobar","(?<=(foo))bar\\1","WqywQ",[])), 
?line <<"foobar">> = iolist_to_binary(re:replace("foobar","(?<=(foo))bar\\1","WqywQ",[global])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","(?<=(foo))bar\\1","g&dx",[])), 
?line <<"barfoo">> = iolist_to_binary(re:replace("barfoo","(?<=(foo))bar\\1","g&dx",[global])), 
?line <<"EqLnXCi">> = iolist_to_binary(re:replace("saturday","(?i:saturday|sunday)","EqLnX\\1Ci\\1",[])), 
?line <<"EqLnXCi">> = iolist_to_binary(re:replace("saturday","(?i:saturday|sunday)","EqLnX\\1Ci\\1",[global])), 
?line <<"rXiCVoMssundayWVsundayg">> = iolist_to_binary(re:replace("sunday","(?i:saturday|sunday)","rXiCVoMs&WV&\\1g",[])), 
?line <<"rXiCVoMssundayWVsundayg">> = iolist_to_binary(re:replace("sunday","(?i:saturday|sunday)","rXiCVoMs&WV&\\1g",[global])), 
?line <<"DCML">> = iolist_to_binary(re:replace("Saturday","(?i:saturday|sunday)","D\\1CML",[])), 
?line <<"DCML">> = iolist_to_binary(re:replace("Saturday","(?i:saturday|sunday)","D\\1CML",[global])), 
?line <<"caYSundaylQsqBJmDFf">> = iolist_to_binary(re:replace("Sunday","(?i:saturday|sunday)","caY&l\\1Q\\1\\1sq\\1BJmD\\1Ff",[])), 
?line <<"caYSundaylQsqBJmDFf">> = iolist_to_binary(re:replace("Sunday","(?i:saturday|sunday)","caY&l\\1Q\\1\\1sq\\1BJmD\\1Ff",[global])), 
?line <<"LSATURDAYSATURDAYb">> = iolist_to_binary(re:replace("SATURDAY","(?i:saturday|sunday)","L&&b",[])), 
?line <<"LSATURDAYSATURDAYb">> = iolist_to_binary(re:replace("SATURDAY","(?i:saturday|sunday)","L&&b",[global])), 
?line <<"J">> = iolist_to_binary(re:replace("SUNDAY","(?i:saturday|sunday)","J",[])), 
?line <<"J">> = iolist_to_binary(re:replace("SUNDAY","(?i:saturday|sunday)","J",[global])), 
?line <<"cCHUgeqmaSunDaySunDayQSunDayHUJ">> = iolist_to_binary(re:replace("SunDay","(?i:saturday|sunday)","c\\1CHUgeqma&&Q&HUJ",[])), 
?line <<"cCHUgeqmaSunDaySunDayQSunDayHUJ">> = iolist_to_binary(re:replace("SunDay","(?i:saturday|sunday)","c\\1CHUgeqma&&Q&HUJ",[global])), 
?line <<"abcEbXpYQWabcxNabcxabcxVrPLd">> = iolist_to_binary(re:replace("abcx","(a(?i)bc|BB)x","\\1EbXpYQW&N&&VrPLd",[])), 
?line <<"abcEbXpYQWabcxNabcxabcxVrPLd">> = iolist_to_binary(re:replace("abcx","(a(?i)bc|BB)x","\\1EbXpYQW&N&&VrPLd",[global])), 
?line <<"jBMIviaBCvaBCxTRLe">> = iolist_to_binary(re:replace("aBCx","(a(?i)bc|BB)x","jBMIvi\\1v&TRLe",[])), 
?line <<"jBMIviaBCvaBCxTRLe">> = iolist_to_binary(re:replace("aBCx","(a(?i)bc|BB)x","jBMIvi\\1v&TRLe",[global])), 
?line <<"wDnyUbbxDgOUSgpsDtqV">> = iolist_to_binary(re:replace("bbx","(a(?i)bc|BB)x","wDnyU&DgOUSgpsDtqV",[])), 
?line <<"wDnyUbbxDgOUSgpsDtqV">> = iolist_to_binary(re:replace("bbx","(a(?i)bc|BB)x","wDnyU&DgOUSgpsDtqV",[global])), 
?line <<"Vx">> = iolist_to_binary(re:replace("BBx","(a(?i)bc|BB)x","Vx",[])), 
?line <<"Vx">> = iolist_to_binary(re:replace("BBx","(a(?i)bc|BB)x","Vx",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a(?i)bc|BB)x","vuaWcgIs\\1SRUcqMEb",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(a(?i)bc|BB)x","vuaWcgIs\\1SRUcqMEb",[global])), 
?line <<"abcX">> = iolist_to_binary(re:replace("abcX","(a(?i)bc|BB)x","V\\1",[])), 
?line <<"abcX">> = iolist_to_binary(re:replace("abcX","(a(?i)bc|BB)x","V\\1",[global])), 
?line <<"aBCX">> = iolist_to_binary(re:replace("aBCX","(a(?i)bc|BB)x","kcaH&mISces&gy\\1Mv",[])), 
?line <<"aBCX">> = iolist_to_binary(re:replace("aBCX","(a(?i)bc|BB)x","kcaH&mISces&gy\\1Mv",[global])), 
?line <<"bbX">> = iolist_to_binary(re:replace("bbX","(a(?i)bc|BB)x","hfQHW",[])), 
?line <<"bbX">> = iolist_to_binary(re:replace("bbX","(a(?i)bc|BB)x","hfQHW",[global])), 
?line <<"BBX">> = iolist_to_binary(re:replace("BBX","(a(?i)bc|BB)x","QWSdgANNG&a&hUuhv&T",[])), 
?line <<"BBX">> = iolist_to_binary(re:replace("BBX","(a(?i)bc|BB)x","QWSdgANNG&a&hUuhv&T",[global])), 
?line <<"tEacrW">> = iolist_to_binary(re:replace("ac","^([ab](?i)[cd]|[ef])","tE\\1rW",[])), 
?line <<"tEacrW">> = iolist_to_binary(re:replace("ac","^([ab](?i)[cd]|[ef])","tE\\1rW",[global])), 
?line <<"jjqwaCaCyaCpaCPWnSv">> = iolist_to_binary(re:replace("aC","^([ab](?i)[cd]|[ef])","jjqw\\1\\1y\\1p&PWnSv",[])), 
?line <<"jjqwaCaCyaCpaCPWnSv">> = iolist_to_binary(re:replace("aC","^([ab](?i)[cd]|[ef])","jjqw\\1\\1y\\1p&PWnSv",[global])), 
?line <<"pbDoK">> = iolist_to_binary(re:replace("bD","^([ab](?i)[cd]|[ef])","p&oK",[])), 
?line <<"pbDoK">> = iolist_to_binary(re:replace("bD","^([ab](?i)[cd]|[ef])","p&oK",[global])), 
?line <<"hOUSaMTfcPejGlephant">> = iolist_to_binary(re:replace("elephant","^([ab](?i)[cd]|[ef])","hOUSaMTfcP&jG",[])), 
?line <<"hOUSaMTfcPejGlephant">> = iolist_to_binary(re:replace("elephant","^([ab](?i)[cd]|[ef])","hOUSaMTfcP&jG",[global])), 
?line <<"EOnTdEESsrQXxRPurope">> = iolist_to_binary(re:replace("Europe","^([ab](?i)[cd]|[ef])","\\1OnTd&&SsrQXxRP",[])), 
?line <<"EOnTdEESsrQXxRPurope">> = iolist_to_binary(re:replace("Europe","^([ab](?i)[cd]|[ef])","\\1OnTd&&SsrQXxRP",[global])), 
?line <<"fhfBHfIDHldAwNfEfqrog">> = iolist_to_binary(re:replace("frog","^([ab](?i)[cd]|[ef])","\\1h&BH\\1IDHldAwN&E\\1q",[])), 
?line <<"fhfBHfIDHldAwNfEfqrog">> = iolist_to_binary(re:replace("frog","^([ab](?i)[cd]|[ef])","\\1h&BH\\1IDHldAwN&E\\1q",[global])), 
?line <<"FFFxSuhnFwrance">> = iolist_to_binary(re:replace("France","^([ab](?i)[cd]|[ef])","\\1&FxSuhn&w",[])), 
?line <<"FFFxSuhnFwrance">> = iolist_to_binary(re:replace("France","^([ab](?i)[cd]|[ef])","\\1&FxSuhn&w",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^([ab](?i)[cd]|[ef])","&ff\\1J\\1I",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^([ab](?i)[cd]|[ef])","&ff\\1J\\1I",[global])), 
?line <<"Africa">> = iolist_to_binary(re:replace("Africa","^([ab](?i)[cd]|[ef])","nEbgaPXOn\\1",[])), 
?line <<"Africa">> = iolist_to_binary(re:replace("Africa","^([ab](?i)[cd]|[ef])","nEbgaPXOn\\1",[global])), 
?line <<"abcabDXAiaSg">> = iolist_to_binary(re:replace("ab","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&c&DXAiaSg",[])), 
?line <<"abcabDXAiaSg">> = iolist_to_binary(re:replace("ab","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&c&DXAiaSg",[global])), 
?line <<"aBdqaBdmLoaaBdEb">> = iolist_to_binary(re:replace("aBd","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&q&mLoa&Eb",[])), 
?line <<"aBdqaBdmLoaaBdEb">> = iolist_to_binary(re:replace("aBd","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&q&mLoa&Eb",[global])), 
?line <<"xxyvFo">> = iolist_to_binary(re:replace("xy","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","x&vFo",[])), 
?line <<"xxyvFo">> = iolist_to_binary(re:replace("xy","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","x&vFo",[global])), 
?line <<"eWy">> = iolist_to_binary(re:replace("xY","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","eWy",[])), 
?line <<"eWy">> = iolist_to_binary(re:replace("xY","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","eWy",[global])), 
?line <<"bzVONndeqzaVKebra">> = iolist_to_binary(re:replace("zebra","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","b&VONndeq\\1aVK",[])), 
?line <<"bzVONndeqzaVKebra">> = iolist_to_binary(re:replace("zebra","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","b&VONndeq\\1aVK",[global])), 
?line <<"ZNZZjZVZJeZnZZCXZambesi">> = iolist_to_binary(re:replace("Zambesi","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&N&&j&V&Je\\1n&\\1CX&",[])), 
?line <<"ZNZZjZVZJeZnZZCXZambesi">> = iolist_to_binary(re:replace("Zambesi","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","&N&&j&V&Je\\1n&\\1CX&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","vJ\\1\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","vJ\\1\\1",[global])), 
?line <<"aCD">> = iolist_to_binary(re:replace("aCD","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","\\1FKPhO&",[])), 
?line <<"aCD">> = iolist_to_binary(re:replace("aCD","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","\\1FKPhO&",[global])), 
?line <<"XY">> = iolist_to_binary(re:replace("XY","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","SEE",[])), 
?line <<"XY">> = iolist_to_binary(re:replace("XY","^(ab|a(?i)[b-c](?m-i)d|x(?i)y|z)","SEE",[global])), 
?line <<"foo
rwHxBqDqeLQ">> = iolist_to_binary(re:replace("foo
bar","(?<=foo\\n)^bar","rwHxBqDq\\1eLQ",[multiline])), 
?line <<"foo
rwHxBqDqeLQ">> = iolist_to_binary(re:replace("foo
bar","(?<=foo\\n)^bar","rwHxBqDq\\1eLQ",[multiline,global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=foo\\n)^bar","\\1P&&W&\\1oN",[multiline])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=foo\\n)^bar","\\1P&&W&\\1oN",[multiline,
                                                                                                                                                                                                                               global])), 
?line <<"bar">> = iolist_to_binary(re:replace("bar","(?<=foo\\n)^bar","rk\\1SSPj&JPOE",[multiline])), 
?line <<"bar">> = iolist_to_binary(re:replace("bar","(?<=foo\\n)^bar","rk\\1SSPj&JPOE",[multiline,
                                                                                                                                                                                                              global])), 
?line <<"baz
bar">> = iolist_to_binary(re:replace("baz
bar","(?<=foo\\n)^bar","&JIhqO&Da",[multiline])), 
?line <<"baz
bar">> = iolist_to_binary(re:replace("baz
bar","(?<=foo\\n)^bar","&JIhqO&Da",[multiline,global])), 
?line <<"baruQUCmWhYKFBWj">> = iolist_to_binary(re:replace("barbaz","(?<=(?<!foo)bar)baz","uQUCmWhYKF\\1BWj\\1",[])), 
?line <<"baruQUCmWhYKFBWj">> = iolist_to_binary(re:replace("barbaz","(?<=(?<!foo)bar)baz","uQUCmWhYKF\\1BWj\\1",[global])), 
?line <<"barbarTNMlbazRYUbazYJyQER">> = iolist_to_binary(re:replace("barbarbaz","(?<=(?<!foo)bar)baz","TNMl\\1&RYU&YJyQER",[])), 
?line <<"barbarTNMlbazRYUbazYJyQER">> = iolist_to_binary(re:replace("barbarbaz","(?<=(?<!foo)bar)baz","TNMl\\1&RYU&YJyQER",[global])), 
?line <<"koobarxhTvv">> = iolist_to_binary(re:replace("koobarbaz","(?<=(?<!foo)bar)baz","xhTvv\\1",[])), 
?line <<"koobarxhTvv">> = iolist_to_binary(re:replace("koobarbaz","(?<=(?<!foo)bar)baz","xhTvv\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(?<!foo)bar)baz","uHmyIQ&yV&hQ&Di&\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(?<=(?<!foo)bar)baz","uHmyIQ&yV&hQ&Di&\\1",[global])), 
?line <<"baz">> = iolist_to_binary(re:replace("baz","(?<=(?<!foo)bar)baz","B",[])), 
?line <<"baz">> = iolist_to_binary(re:replace("baz","(?<=(?<!foo)bar)baz","B",[global])), 
?line <<"foobarbaz">> = iolist_to_binary(re:replace("foobarbaz","(?<=(?<!foo)bar)baz","BuNXYgf",[])), 
?line <<"foobarbaz">> = iolist_to_binary(re:replace("foobarbaz","(?<=(?<!foo)bar)baz","BuNXYgf",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a","^(a\\1?){4}$","N\\1&Psi",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a","^(a\\1?){4}$","N\\1&Psi",[global])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","^(a\\1?){4}$","&",[])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","^(a\\1?){4}$","&",[global])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","^(a\\1?){4}$","\\1OPhpdjl&J&F&j",[])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","^(a\\1?){4}$","\\1OPhpdjl&J&F&j",[global])), 
?line <<"oEaaPaaaaFyHMpKbNxCqlyG">> = iolist_to_binary(re:replace("aaaa","^(a\\1?){4}$","oE\\1\\1P&FyHMpKbNxCqlyG",[])), 
?line <<"oEaaPaaaaFyHMpKbNxCqlyG">> = iolist_to_binary(re:replace("aaaa","^(a\\1?){4}$","oE\\1\\1P&FyHMpKbNxCqlyG",[global])), 
?line <<"aaaaaawR">> = iolist_to_binary(re:replace("aaaaa","^(a\\1?){4}$","\\1&wR",[])), 
?line <<"aaaaaawR">> = iolist_to_binary(re:replace("aaaaa","^(a\\1?){4}$","\\1&wR",[global])), 
?line <<"SaWUrMlNUaaaaaaaaaaaaaan">> = iolist_to_binary(re:replace("aaaaaaa","^(a\\1?){4}$","S\\1WUrMlNU&&n",[])), 
?line <<"SaWUrMlNUaaaaaaaaaaaaaan">> = iolist_to_binary(re:replace("aaaaaaa","^(a\\1?){4}$","S\\1WUrMlNU&&n",[global])), 
?line <<"aaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a\\1?){4}$","Vk&&RgxI\\1\\1pJ&&",[])), 
?line <<"aaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a\\1?){4}$","Vk&&RgxI\\1\\1pJ&&",[global])), 
?line <<"aaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaa","^(a\\1?){4}$","x",[])), 
?line <<"aaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaa","^(a\\1?){4}$","x",[global])), 
?line <<"FEkJCFraaaaaaaaaaaaaaaaaaaaMlwosy">> = iolist_to_binary(re:replace("aaaaaaaaaa","^(a\\1?){4}$","FEkJCFr&&Mlwosy",[])), 
?line <<"FEkJCFraaaaaaaaaaaaaaaaaaaaMlwosy">> = iolist_to_binary(re:replace("aaaaaaaaaa","^(a\\1?){4}$","FEkJCFr&&Mlwosy",[global])), 
?line <<"aaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaa","^(a\\1?){4}$","&IO",[])), 
?line <<"aaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaa","^(a\\1?){4}$","&IO",[global])), 
?line <<"aaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaa","^(a\\1?){4}$","lKw",[])), 
?line <<"aaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaa","^(a\\1?){4}$","lKw",[global])), 
?line <<"aaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaa","^(a\\1?){4}$","nN&bSVJh\\1J\\1d&Ko",[])), 
?line <<"aaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaa","^(a\\1?){4}$","nN&bSVJh\\1J\\1d&Ko",[global])), 
?line <<"aaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaa","^(a\\1?){4}$","Fut\\1X\\1",[])), 
?line <<"aaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaa","^(a\\1?){4}$","Fut\\1X\\1",[global])), 
?line <<"aaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaa","^(a\\1?){4}$","v",[])), 
?line <<"aaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaa","^(a\\1?){4}$","v",[global])), 
?line <<"aaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaaa","^(a\\1?){4}$","b",[])), 
?line <<"aaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaaa","^(a\\1?){4}$","b",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","VC",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","VC",[global])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","&&mKsMkXfPP",[])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","&&mKsMkXfPP",[global])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","c\\1HhkFrF&vy&\\1bmNHPw",[])), 
?line <<"aaa">> = iolist_to_binary(re:replace("aaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","c\\1HhkFrF&vy&\\1bmNHPw",[global])), 
?line <<"SnJcTQRFQiat">> = iolist_to_binary(re:replace("aaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","SnJcTQRFQi\\1t",[])), 
?line <<"SnJcTQRFQiat">> = iolist_to_binary(re:replace("aaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","SnJcTQRFQi\\1t",[global])), 
?line <<"MaaaaakiYfFeaaaaaetD">> = iolist_to_binary(re:replace("aaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","M&kiYfFe&etD",[])), 
?line <<"MaaaaakiYfFeaaaaaetD">> = iolist_to_binary(re:replace("aaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","M&kiYfFe&etD",[global])), 
?line <<"WDaaaaaasEn">> = iolist_to_binary(re:replace("aaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","WD&sEn",[])), 
?line <<"WDaaaaaasEn">> = iolist_to_binary(re:replace("aaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","WD&sEn",[global])), 
?line <<"sauvrqyMaaaaaaaEvrD">> = iolist_to_binary(re:replace("aaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","s\\1uvrqyM&EvrD",[])), 
?line <<"sauvrqyMaaaaaaaEvrD">> = iolist_to_binary(re:replace("aaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","s\\1uvrqyM&EvrD",[global])), 
?line <<"aaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","WyhxEMLFTAGuL&Hymc",[])), 
?line <<"aaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","WyhxEMLFTAGuL&Hymc",[global])), 
?line <<"aaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","\\1WXGI&T&rPigX\\1IAQu",[])), 
?line <<"aaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","\\1WXGI&T&rPigX\\1IAQu",[global])), 
?line <<"HaaaaaaaaaajHUn">> = iolist_to_binary(re:replace("aaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","H&jHUn",[])), 
?line <<"HaaaaaaaaaajHUn">> = iolist_to_binary(re:replace("aaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","H&jHUn",[global])), 
?line <<"aaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","e",[])), 
?line <<"aaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","e",[global])), 
?line <<"aaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","dSM\\1GGkyX&xNUIVG&",[])), 
?line <<"aaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","dSM\\1GGkyX&xNUIVG&",[global])), 
?line <<"aaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","p\\1T",[])), 
?line <<"aaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","p\\1T",[global])), 
?line <<"aaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","wOWcxD\\1e&",[])), 
?line <<"aaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","wOWcxD\\1e&",[global])), 
?line <<"aaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","C&CWw&kAen&",[])), 
?line <<"aaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","C&CWw&kAen&",[global])), 
?line <<"aaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","rkiiFEQ&WDahG&lSqR",[])), 
?line <<"aaaaaaaaaaaaaaaa">> = iolist_to_binary(re:replace("aaaaaaaaaaaaaaaa","^(a\\1?)(a\\1?)(a\\2?)(a\\3?)$","rkiiFEQ&WDahG&lSqR",[global])), 
?line <<"babcoabcabcESPlWKsDDog">> = iolist_to_binary(re:replace("abc","abc","b&o&&\\1ES\\1\\1PlWKsD\\1Dog",[])), 
?line <<"babcoabcabcESPlWKsDDog">> = iolist_to_binary(re:replace("abc","abc","b&o&&\\1ES\\1\\1PlWKsD\\1Dog",[global])), 
?line <<"xFfvcJy">> = iolist_to_binary(re:replace("xabcy","abc","FfvcJ",[])), 
?line <<"xFfvcJy">> = iolist_to_binary(re:replace("xabcy","abc","FfvcJ",[global])), 
?line <<"abaGvHrWEIIXoI">> = iolist_to_binary(re:replace("ababc","abc","a\\1\\1G\\1v\\1HrWEIIXoI\\1",[])), 
?line <<"abaGvHrWEIIXoI">> = iolist_to_binary(re:replace("ababc","abc","a\\1\\1G\\1v\\1HrWEIIXoI\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","DOtxCgk&UIBKmk\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","DOtxCgk&UIBKmk\\1",[global])), 
?line <<"xbc">> = iolist_to_binary(re:replace("xbc","abc","qmfvVTE\\1aHl\\1BT&U",[])), 
?line <<"xbc">> = iolist_to_binary(re:replace("xbc","abc","qmfvVTE\\1aHl\\1BT&U",[global])), 
?line <<"axc">> = iolist_to_binary(re:replace("axc","abc","uN&yFKoX\\1pBswe\\1HLf",[])), 
?line <<"axc">> = iolist_to_binary(re:replace("axc","abc","uN&yFKoX\\1pBswe\\1HLf",[global])), 
?line <<"abx">> = iolist_to_binary(re:replace("abx","abc","&v\\1\\1QwMhqY",[])), 
?line <<"abx">> = iolist_to_binary(re:replace("abx","abc","&v\\1\\1QwMhqY",[global])), 
?line <<"FIOGpcHeabcNHJ">> = iolist_to_binary(re:replace("abc","ab*c","FIOGpcHe&NHJ",[])), 
?line <<"FIOGpcHeabcNHJ">> = iolist_to_binary(re:replace("abc","ab*c","FIOGpcHe&NHJ",[global])), 
?line <<"abcbnCUabcnxKKHabcXVaO">> = iolist_to_binary(re:replace("abc","ab*bc","&bnCU&n\\1xKKH&\\1XVaO",[])), 
?line <<"abcbnCUabcnxKKHabcXVaO">> = iolist_to_binary(re:replace("abc","ab*bc","&bnCU&n\\1xKKH&\\1XVaO",[global])), 
?line <<"bFtejUbnDA">> = iolist_to_binary(re:replace("abbc","ab*bc","bFtejUbn\\1DA",[])), 
?line <<"bFtejUbnDA">> = iolist_to_binary(re:replace("abbc","ab*bc","bFtejUbn\\1DA",[global])), 
?line <<"W">> = iolist_to_binary(re:replace("abbbbc","ab*bc","W",[])), 
?line <<"W">> = iolist_to_binary(re:replace("abbbbc","ab*bc","W",[global])), 
?line <<"BlaEararHKSGaabbbbc">> = iolist_to_binary(re:replace("abbbbc",".{1}","Bl&E&r&r\\1HKSG&&\\1",[])), 
?line <<"BlaEararHKSGaaBlbEbrbrHKSGbbBlbEbrbrHKSGbbBlbEbrbrHKSGbbBlbEbrbrHKSGbbBlcEcrcrHKSGcc">> = iolist_to_binary(re:replace("abbbbc",".{1}","Bl&E&r&r\\1HKSG&&\\1",[global])), 
?line <<"pabbbcRXxcEabbbIabbbXTbc">> = iolist_to_binary(re:replace("abbbbc",".{3,4}","p&cRXxcE&I&XT",[])), 
?line <<"pabbbcRXxcEabbbIabbbXTbc">> = iolist_to_binary(re:replace("abbbbc",".{3,4}","p&cRXxcE&I&XT",[global])), 
?line <<"HkIFCqCBaabbbbcyHm">> = iolist_to_binary(re:replace("abbbbc","ab{0,}bc","Hk\\1IFCq\\1CBa&yHm",[])), 
?line <<"HkIFCqCBaabbbbcyHm">> = iolist_to_binary(re:replace("abbbbc","ab{0,}bc","Hk\\1IFCq\\1CBa&yHm",[global])), 
?line <<"HBKHabbcHxdabbciuxleGabbc">> = iolist_to_binary(re:replace("abbc","ab+bc","HBKH&\\1Hx\\1d&iuxleG&",[])), 
?line <<"HBKHabbcHxdabbciuxleGabbc">> = iolist_to_binary(re:replace("abbc","ab+bc","HBKH&\\1Hx\\1d&iuxleG&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab+bc","&Pm&sRjS",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab+bc","&Pm&sRjS",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","ab+bc","IiWLkYFrIIhMk\\1D\\1vagP",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","ab+bc","IiWLkYFrIIhMk\\1D\\1vagP",[global])), 
?line <<"abq">> = iolist_to_binary(re:replace("abq","ab+bc","&\\1\\1UiX\\1&MgPB",[])), 
?line <<"abq">> = iolist_to_binary(re:replace("abq","ab+bc","&\\1\\1UiX\\1&MgPB",[global])), 
?line <<"WLvlqVMuiA">> = iolist_to_binary(re:replace("abbbbc","ab+bc","WLvlqVMuiA",[])), 
?line <<"WLvlqVMuiA">> = iolist_to_binary(re:replace("abbbbc","ab+bc","WLvlqVMuiA",[global])), 
?line <<"qQ">> = iolist_to_binary(re:replace("abbbbc","ab{1,}bc","qQ",[])), 
?line <<"qQ">> = iolist_to_binary(re:replace("abbbbc","ab{1,}bc","qQ",[global])), 
?line <<"ALwvHVhFGH">> = iolist_to_binary(re:replace("abbbbc","ab{1,3}bc","A\\1LwvHVhFGH",[])), 
?line <<"ALwvHVhFGH">> = iolist_to_binary(re:replace("abbbbc","ab{1,3}bc","A\\1LwvHVhFGH",[global])), 
?line <<"ORLsuabbbbc">> = iolist_to_binary(re:replace("abbbbc","ab{3,4}bc","ORL\\1su&",[])), 
?line <<"ORLsuabbbbc">> = iolist_to_binary(re:replace("abbbbc","ab{3,4}bc","ORL\\1su&",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{4,5}bc","APwPKjxS\\1Di&\\1",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{4,5}bc","APwPKjxS\\1Di&\\1",[global])), 
?line <<"abq">> = iolist_to_binary(re:replace("abq","ab{4,5}bc","FVk",[])), 
?line <<"abq">> = iolist_to_binary(re:replace("abq","ab{4,5}bc","FVk",[global])), 
?line <<"abbbbc">> = iolist_to_binary(re:replace("abbbbc","ab{4,5}bc","PO&t",[])), 
?line <<"abbbbc">> = iolist_to_binary(re:replace("abbbbc","ab{4,5}bc","PO&t",[global])), 
?line <<"EHtIXyQbabbclaCBg">> = iolist_to_binary(re:replace("abbc","ab?bc","EHtIXyQb&laCBg",[])), 
?line <<"EHtIXyQbabbclaCBg">> = iolist_to_binary(re:replace("abbc","ab?bc","EHtIXyQb&laCBg",[global])), 
?line <<"SVx">> = iolist_to_binary(re:replace("abc","ab?bc","SVx",[])), 
?line <<"SVx">> = iolist_to_binary(re:replace("abc","ab?bc","SVx",[global])), 
?line <<"KJabcWtBNRX">> = iolist_to_binary(re:replace("abc","ab{0,1}bc","KJ&WtBNRX",[])), 
?line <<"KJabcWtBNRX">> = iolist_to_binary(re:replace("abc","ab{0,1}bc","KJ&WtBNRX",[global])), 
?line <<"oabcQlOwmmeXxTySSV">> = iolist_to_binary(re:replace("abc","ab?c","o&Q\\1lOwmmeXx\\1TySSV",[])), 
?line <<"oabcQlOwmmeXxTySSV">> = iolist_to_binary(re:replace("abc","ab?c","o&Q\\1lOwmmeXx\\1TySSV",[global])), 
?line <<"abcQpPYPtQcFabcCDEcWOl">> = iolist_to_binary(re:replace("abc","ab{0,1}c","&QpPY\\1PtQcF&CDEcWOl",[])), 
?line <<"abcQpPYPtQcFabcCDEcWOl">> = iolist_to_binary(re:replace("abc","ab{0,1}c","&QpPY\\1PtQcF&CDEcWOl",[global])), 
?line <<"YbB">> = iolist_to_binary(re:replace("abc","^abc$","YbB",[])), 
?line <<"YbB">> = iolist_to_binary(re:replace("abc","^abc$","YbB",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","r&t\\1OLYfC",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","r&t\\1OLYfC",[global])), 
?line <<"abbbbc">> = iolist_to_binary(re:replace("abbbbc","^abc$","P&QwAxc\\1vYfQF",[])), 
?line <<"abbbbc">> = iolist_to_binary(re:replace("abbbbc","^abc$","P&QwAxc\\1vYfQF",[global])), 
?line <<"abcc">> = iolist_to_binary(re:replace("abcc","^abc$","d\\1j&LhAN\\1JvojhyCmSwU",[])), 
?line <<"abcc">> = iolist_to_binary(re:replace("abcc","^abc$","d\\1j&LhAN\\1JvojhyCmSwU",[global])), 
?line <<"yabcxAc">> = iolist_to_binary(re:replace("abcc","^abc","y\\1&xA",[])), 
?line <<"yabcxAc">> = iolist_to_binary(re:replace("abcc","^abc","y\\1&xA",[global])), 
?line <<"awrOx">> = iolist_to_binary(re:replace("aabc","abc$","wrOx",[])), 
?line <<"awrOx">> = iolist_to_binary(re:replace("aabc","abc$","wrOx",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc$","XLe",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc$","XLe",[global])), 
?line <<"aRthCinfyGSJTg">> = iolist_to_binary(re:replace("aabc","abc$","\\1RthCi\\1nfyGSJTg",[])), 
?line <<"aRthCinfyGSJTg">> = iolist_to_binary(re:replace("aabc","abc$","\\1RthCi\\1nfyGSJTg",[global])), 
?line <<"aabcd">> = iolist_to_binary(re:replace("aabcd","abc$","UT&CPLaUA\\1nluQPA",[])), 
?line <<"aabcd">> = iolist_to_binary(re:replace("aabcd","abc$","UT&CPLaUA\\1nluQPA",[global])), 
?line <<"hYaxcodDoHwNTLtDQoabc">> = iolist_to_binary(re:replace("abc","^","hYaxc&o&dDoHwNTLtDQo",[])), 
?line <<"hYaxcodDoHwNTLtDQoabc">> = iolist_to_binary(re:replace("abc","^","hYaxc&o&dDoHwNTLtDQo",[global])), 
?line <<"abcepxRqYNdJMdQeRKr">> = iolist_to_binary(re:replace("abc","$","epxRqYNdJ&MdQeR&Kr",[])), 
?line <<"abcepxRqYNdJMdQeRKr">> = iolist_to_binary(re:replace("abc","$","epxRqYNdJ&MdQeR&Kr",[global])), 
?line <<"vnabcXvSRrFjWv">> = iolist_to_binary(re:replace("abc","a.c","\\1vn&X\\1vSRrFj\\1Wv",[])), 
?line <<"vnabcXvSRrFjWv">> = iolist_to_binary(re:replace("abc","a.c","\\1vn&X\\1vSRrFj\\1Wv",[global])), 
?line <<"YSYAvHCLl">> = iolist_to_binary(re:replace("axc","a.c","Y\\1\\1SYAvHCLl",[])), 
?line <<"YSYAvHCLl">> = iolist_to_binary(re:replace("axc","a.c","Y\\1\\1SYAvHCLl",[global])), 
?line <<"oTi">> = iolist_to_binary(re:replace("axyzc","a.*c","oTi",[])), 
?line <<"oTi">> = iolist_to_binary(re:replace("axyzc","a.*c","oTi",[global])), 
?line <<"abdd">> = iolist_to_binary(re:replace("abd","a[bc]d","&d",[])), 
?line <<"abdd">> = iolist_to_binary(re:replace("abd","a[bc]d","&d",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[bc]d","m",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[bc]d","m",[global])), 
?line <<"axyzd">> = iolist_to_binary(re:replace("axyzd","a[bc]d","xw\\1kClblo&A&pX",[])), 
?line <<"axyzd">> = iolist_to_binary(re:replace("axyzd","a[bc]d","xw\\1kClblo&A&pX",[global])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","a[bc]d","DXVJBfd&&nWiQKDXx&p",[])), 
?line <<"abc">> = iolist_to_binary(re:replace("abc","a[bc]d","DXVJBfd&&nWiQKDXx&p",[global])), 
?line <<"qgcyq">> = iolist_to_binary(re:replace("ace","a[b-d]e","qgcyq\\1",[])), 
?line <<"qgcyq">> = iolist_to_binary(re:replace("ace","a[b-d]e","qgcyq\\1",[global])), 
?line <<"aSo">> = iolist_to_binary(re:replace("aac","a[b-d]","S\\1o",[])), 
?line <<"aSo">> = iolist_to_binary(re:replace("aac","a[b-d]","S\\1o",[global])), 
?line <<"FalJiLh">> = iolist_to_binary(re:replace("a-","a[-b]","FalJ\\1iL\\1h",[])), 
?line <<"FalJiLh">> = iolist_to_binary(re:replace("a-","a[-b]","FalJ\\1iL\\1h",[global])), 
?line <<"aea-">> = iolist_to_binary(re:replace("a-","a[b-]","ae&",[])), 
?line <<"aea-">> = iolist_to_binary(re:replace("a-","a[b-]","ae&",[global])), 
?line <<"Uxci">> = iolist_to_binary(re:replace("a]","a]","Uxci",[])), 
?line <<"Uxci">> = iolist_to_binary(re:replace("a]","a]","Uxci",[global])), 
?line <<"fuDs">> = iolist_to_binary(re:replace("a]b","a[]]b","fu\\1Ds",[])), 
?line <<"fuDs">> = iolist_to_binary(re:replace("a]b","a[]]b","fu\\1Ds",[global])), 
?line <<"S">> = iolist_to_binary(re:replace("aed","a[^bc]d","\\1S",[])), 
?line <<"S">> = iolist_to_binary(re:replace("aed","a[^bc]d","\\1S",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[^bc]d","q\\1c",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[^bc]d","q\\1c",[global])), 
?line <<"abd">> = iolist_to_binary(re:replace("abd","a[^bc]d","CwigRG\\1",[])), 
?line <<"abd">> = iolist_to_binary(re:replace("abd","a[^bc]d","CwigRG\\1",[global])), 
?line <<"abd">> = iolist_to_binary(re:replace("abd","a[^bc]d","G&sOiYoXxtvjC\\1C",[])), 
?line <<"abd">> = iolist_to_binary(re:replace("abd","a[^bc]d","G&sOiYoXxtvjC\\1C",[global])), 
?line <<"WjwradcGadcGdiadcJadcadc">> = iolist_to_binary(re:replace("adc","a[^-b]c","Wjwr&G&Gdi&J&&",[])), 
?line <<"WjwradcGadcGdiadcJadcadc">> = iolist_to_binary(re:replace("adc","a[^-b]c","Wjwr&G&Gdi&J&&",[global])), 
?line <<"sXuNQuSoADXQHaadcc">> = iolist_to_binary(re:replace("adc","a[^]b]c","sXuNQuS\\1oAD\\1XQH\\1a&c",[])), 
?line <<"sXuNQuSoADXQHaadcc">> = iolist_to_binary(re:replace("adc","a[^]b]c","sXuNQuS\\1oAD\\1XQH\\1a&c",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[^]b]c","\\1WTVFfqlY\\1I",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[^]b]c","\\1WTVFfqlY\\1I",[global])), 
?line <<"a-c">> = iolist_to_binary(re:replace("a-c","a[^]b]c","&",[])), 
?line <<"a-c">> = iolist_to_binary(re:replace("a-c","a[^]b]c","&",[global])), 
?line <<"a]c">> = iolist_to_binary(re:replace("a]c","a[^]b]c","U\\1ASb",[])), 
?line <<"a]c">> = iolist_to_binary(re:replace("a]c","a[^]b]c","U\\1ASb",[global])), 
?line <<"FhmTxP-">> = iolist_to_binary(re:replace("a-","\\ba\\b","FhmTxP",[])), 
?line <<"FhmTxP-">> = iolist_to_binary(re:replace("a-","\\ba\\b","FhmTxP",[global])), 
?line <<"-sIgAwOVeaIs">> = iolist_to_binary(re:replace("-a","\\ba\\b","sIgAwOVe&Is",[])), 
?line <<"-sIgAwOVeaIs">> = iolist_to_binary(re:replace("-a","\\ba\\b","sIgAwOVe&Is",[global])), 
?line <<"-K-">> = iolist_to_binary(re:replace("-a-","\\ba\\b","K",[])), 
?line <<"-K-">> = iolist_to_binary(re:replace("-a-","\\ba\\b","K",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\by\\b","NFs\\1N&no&v&LBhrfD",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","\\by\\b","NFs\\1N&no&v&LBhrfD",[global])), 
?line <<"xy">> = iolist_to_binary(re:replace("xy","\\by\\b","\\1&WFL&q",[])), 
?line <<"xy">> = iolist_to_binary(re:replace("xy","\\by\\b","\\1&WFL&q",[global])), 
?line <<"yz">> = iolist_to_binary(re:replace("yz","\\by\\b","pjeKdgSu&&",[])), 
?line <<"yz">> = iolist_to_binary(re:replace("yz","\\by\\b","pjeKdgSu&&",[global])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","\\by\\b","hyG",[])), 
?line <<"xyz">> = iolist_to_binary(re:replace("xyz","\\by\\b","hyG",[global])), 
?line <<"*** FCasopdebailers">> = iolist_to_binary(re:replace("*** Failers","\\Ba\\B","C\\1&sopdeb&",[])), 
?line <<"*** FCasopdebailers">> = iolist_to_binary(re:replace("*** Failers","\\Ba\\B","C\\1&sopdeb&",[global])), 
?line <<"a-">> = iolist_to_binary(re:replace("a-","\\Ba\\B","mnLWav",[])), 
?line <<"a-">> = iolist_to_binary(re:replace("a-","\\Ba\\B","mnLWav",[global])), 
?line <<"-a">> = iolist_to_binary(re:replace("-a","\\Ba\\B","X&NpSD\\1If",[])), 
?line <<"-a">> = iolist_to_binary(re:replace("-a","\\Ba\\B","X&NpSD\\1If",[global])), 
?line <<"-a-">> = iolist_to_binary(re:replace("-a-","\\Ba\\B","loFA&cpicKF&FLSfj&",[])), 
?line <<"-a-">> = iolist_to_binary(re:replace("-a-","\\Ba\\B","loFA&cpicKF&FLSfj&",[global])), 
?line <<"xyTAT">> = iolist_to_binary(re:replace("xy","\\By\\b","&TAT",[])), 
?line <<"xyTAT">> = iolist_to_binary(re:replace("xy","\\By\\b","&TAT",[global])), 
?line <<"fxz">> = iolist_to_binary(re:replace("yz","\\by\\B","fx\\1\\1",[])), 
?line <<"fxz">> = iolist_to_binary(re:replace("yz","\\by\\B","fx\\1\\1",[global])), 
?line <<"xKryOdAEz">> = iolist_to_binary(re:replace("xyz","\\By\\B","Kr&OdAE",[])), 
?line <<"xKryOdAEz">> = iolist_to_binary(re:replace("xyz","\\By\\B","Kr&OdAE",[global])), 
?line <<"IRVtaAqLDh">> = iolist_to_binary(re:replace("a","\\w","IRVt&AqLDh\\1",[])), 
?line <<"IRVtaAqLDh">> = iolist_to_binary(re:replace("a","\\w","IRVt&AqLDh\\1",[global])), 
?line <<"EckncnNqwHO">> = iolist_to_binary(re:replace("-","\\W","EckncnNq\\1wHO\\1",[])), 
?line <<"EckncnNqwHO">> = iolist_to_binary(re:replace("-","\\W","EckncnNq\\1wHO\\1",[global])), 
?line <<"Yf*VvjLGbD*h** Failers">> = iolist_to_binary(re:replace("*** Failers","\\W","Yf&VvjLGbD&h",[])), 
?line <<"Yf*VvjLGbD*hYf*VvjLGbD*hYf*VvjLGbD*hYf VvjLGbD hFailers">> = iolist_to_binary(re:replace("*** Failers","\\W","Yf&VvjLGbD&h",[global])), 
?line <<"GBjpbjk">> = iolist_to_binary(re:replace("-","\\W","GBjpbjk",[])), 
?line <<"GBjpbjk">> = iolist_to_binary(re:replace("-","\\W","GBjpbjk",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a","\\W","j",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a","\\W","j",[global])), 
?line <<"VAiCYGiBXpa bumnbi">> = iolist_to_binary(re:replace("a b","a\\sb","VAiCYGiBX\\1p&umn\\1bi",[])), 
?line <<"VAiCYGiBXpa bumnbi">> = iolist_to_binary(re:replace("a b","a\\sb","VAiCYGiBX\\1p&umn\\1bi",[global])), 
?line <<"Etv">> = iolist_to_binary(re:replace("a-b","a\\Sb","Etv",[])), 
?line <<"Etv">> = iolist_to_binary(re:replace("a-b","a\\Sb","Etv",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a\\Sb","EbhHjGSDvEtLT\\1cSURa",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a\\Sb","EbhHjGSDvEtLT\\1cSURa",[global])), 
?line <<"uD">> = iolist_to_binary(re:replace("a-b","a\\Sb","uD",[])), 
?line <<"uD">> = iolist_to_binary(re:replace("a-b","a\\Sb","uD",[global])), 
?line <<"a b">> = iolist_to_binary(re:replace("a b","a\\Sb","fQm&D&nJmqrWl",[])), 
?line <<"a b">> = iolist_to_binary(re:replace("a b","a\\Sb","fQm&D&nJmqrWl",[global])), 
?line <<"jti">> = iolist_to_binary(re:replace("1","\\d","jti",[])), 
?line <<"jti">> = iolist_to_binary(re:replace("1","\\d","jti",[global])), 
?line <<"-m">> = iolist_to_binary(re:replace("-","\\D","&m",[])), 
?line <<"-m">> = iolist_to_binary(re:replace("-","\\D","&m",[global])), 
?line <<"Tw** Failers">> = iolist_to_binary(re:replace("*** Failers","\\D","\\1Tw",[])), 
?line <<"TwTwTwTwTwTwTwTwTwTwTw">> = iolist_to_binary(re:replace("*** Failers","\\D","\\1Tw",[global])), 
?line <<"T">> = iolist_to_binary(re:replace("-","\\D","T",[])), 
?line <<"T">> = iolist_to_binary(re:replace("-","\\D","T",[global])), 
?line <<"1">> = iolist_to_binary(re:replace("1","\\D","QkyGdjVcibs",[])), 
?line <<"1">> = iolist_to_binary(re:replace("1","\\D","QkyGdjVcibs",[global])), 
?line <<"Vsg">> = iolist_to_binary(re:replace("a","[\\w]","Vsg",[])), 
?line <<"Vsg">> = iolist_to_binary(re:replace("a","[\\w]","Vsg",[global])), 
?line <<"AeUjdVITmvExYR">> = iolist_to_binary(re:replace("-","[\\W]","AeU\\1jdVITmvExYR\\1",[])), 
?line <<"AeUjdVITmvExYR">> = iolist_to_binary(re:replace("-","[\\W]","AeU\\1jdVITmvExYR\\1",[global])), 
?line <<"WhGTRj*eDnCm** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\W]","WhGTRj&eDnCm",[])), 
?line <<"WhGTRj*eDnCmWhGTRj*eDnCmWhGTRj*eDnCmWhGTRj eDnCmFailers">> = iolist_to_binary(re:replace("*** Failers","[\\W]","WhGTRj&eDnCm",[global])), 
?line <<"c-aqg-Be">> = iolist_to_binary(re:replace("-","[\\W]","c&aqg&Be",[])), 
?line <<"c-aqg-Be">> = iolist_to_binary(re:replace("-","[\\W]","c&aqg&Be",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a","[\\W]","lS",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a","[\\W]","lS",[global])), 
?line <<"aTa bLH">> = iolist_to_binary(re:replace("a b","a[\\s]b","aT&LH\\1",[])), 
?line <<"aTa bLH">> = iolist_to_binary(re:replace("a b","a[\\s]b","aT&LH\\1",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a-b","a[\\S]b","a",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a-b","a[\\S]b","a",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[\\S]b","b\\1E&yC\\1kT&CwD",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[\\S]b","b\\1E&yC\\1kT&CwD",[global])), 
?line <<"a-bfLEHcwVqa-bwEar">> = iolist_to_binary(re:replace("a-b","a[\\S]b","&fLE\\1\\1Hcw\\1V\\1q&wEar",[])), 
?line <<"a-bfLEHcwVqa-bwEar">> = iolist_to_binary(re:replace("a-b","a[\\S]b","&fLE\\1\\1Hcw\\1V\\1q&wEar",[global])), 
?line <<"a b">> = iolist_to_binary(re:replace("a b","a[\\S]b","E\\1NcSC&l",[])), 
?line <<"a b">> = iolist_to_binary(re:replace("a b","a[\\S]b","E\\1NcSC&l",[global])), 
?line <<"U1LgIwNodaqkLmOQ">> = iolist_to_binary(re:replace("1","[\\d]","U\\1&LgIwNo\\1daqkL\\1mOQ",[])), 
?line <<"U1LgIwNodaqkLmOQ">> = iolist_to_binary(re:replace("1","[\\d]","U\\1&LgIwNo\\1daqkL\\1mOQ",[global])), 
?line <<"XTGOaAL-XOENvmW">> = iolist_to_binary(re:replace("-","[\\D]","XTGOa\\1AL&XOE\\1NvmW",[])), 
?line <<"XTGOaAL-XOENvmW">> = iolist_to_binary(re:replace("-","[\\D]","XTGOa\\1AL&XOE\\1NvmW",[global])), 
?line <<"*rIhW*QnqjR*** Failers">> = iolist_to_binary(re:replace("*** Failers","[\\D]","&\\1r\\1I\\1h\\1W&Q\\1n\\1qjR&",[])), 
?line <<"*rIhW*QnqjR**rIhW*QnqjR**rIhW*QnqjR* rIhW QnqjR FrIhWFQnqjRFarIhWaQnqjRairIhWiQnqjRilrIhWlQnqjRlerIhWeQnqjRerrIhWrQnqjRrsrIhWsQnqjRs">> = iolist_to_binary(re:replace("*** Failers","[\\D]","&\\1r\\1I\\1h\\1W&Q\\1n\\1qjR&",[global])), 
?line <<"TEOmg-mrq">> = iolist_to_binary(re:replace("-","[\\D]","TE\\1Omg&\\1mrq",[])), 
?line <<"TEOmg-mrq">> = iolist_to_binary(re:replace("-","[\\D]","TE\\1Omg&\\1mrq",[global])), 
?line <<"1">> = iolist_to_binary(re:replace("1","[\\D]","YI\\1o&\\1IwvchJgD&&",[])), 
?line <<"1">> = iolist_to_binary(re:replace("1","[\\D]","YI\\1o&\\1IwvchJgD&&",[global])), 
?line <<"DKXoAolSGIabc">> = iolist_to_binary(re:replace("abc","ab|cd","DKXoAolSGI&",[])), 
?line <<"DKXoAolSGIabc">> = iolist_to_binary(re:replace("abc","ab|cd","DKXoAolSGI&",[global])), 
?line <<"tFHUIrVcd">> = iolist_to_binary(re:replace("abcd","ab|cd","tFHUIrV\\1",[])), 
?line <<"tFHUIrVtFHUIrV">> = iolist_to_binary(re:replace("abcd","ab|cd","tFHUIrV\\1",[global])), 
?line <<"doeAAefCeUJ">> = iolist_to_binary(re:replace("def","()ef","oeAA&CeUJ",[])), 
?line <<"doeAAefCeUJ">> = iolist_to_binary(re:replace("def","()ef","oeAA&CeUJ",[global])), 
?line <<"B">> = iolist_to_binary(re:replace("a(b","a\\(b","B",[])), 
?line <<"B">> = iolist_to_binary(re:replace("a(b","a\\(b","B",[global])), 
?line <<"sFcBhj">> = iolist_to_binary(re:replace("ab","a\\(*b","sFcBhj",[])), 
?line <<"sFcBhj">> = iolist_to_binary(re:replace("ab","a\\(*b","sFcBhj",[global])), 
?line <<"iTla((bUcHSjwja((ba((b">> = iolist_to_binary(re:replace("a((b","a\\(*b","iTl&UcHSjwj\\1&&",[])), 
?line <<"iTla((bUcHSjwja((ba((b">> = iolist_to_binary(re:replace("a((b","a\\(*b","iTl&UcHSjwj\\1&&",[global])), 
?line <<"a">> = iolist_to_binary(re:replace("a","a\\\\b","AkoMVU&",[])), 
?line <<"a">> = iolist_to_binary(re:replace("a","a\\\\b","AkoMVU&",[global])), 
?line <<"Gbc">> = iolist_to_binary(re:replace("abc","((a))","G",[])), 
?line <<"Gbc">> = iolist_to_binary(re:replace("abc","((a))","G",[global])), 
?line <<"aaabcTualQ">> = iolist_to_binary(re:replace("abc","(a)b(c)","\\1\\1&Tu\\1lQ",[])), 
?line <<"aaabcTualQ">> = iolist_to_binary(re:replace("abc","(a)b(c)","\\1\\1&Tu\\1lQ",[global])), 
?line <<"aabbCivt">> = iolist_to_binary(re:replace("aabbabc","a+b+c","\\1Civt",[])), 
?line <<"aabbCivt">> = iolist_to_binary(re:replace("aabbabc","a+b+c","\\1Civt",[global])), 
?line <<"aabbT">> = iolist_to_binary(re:replace("aabbabc","a{1,}b{1,}c","T",[])), 
?line <<"aabbT">> = iolist_to_binary(re:replace("aabbabc","a{1,}b{1,}c","T",[global])), 
?line <<"VxJHThVabcketabcebWabc">> = iolist_to_binary(re:replace("abcabc","a.+?c","VxJHThV&ket&ebW",[])), 
?line <<"VxJHThVabcketabcebWVxJHThVabcketabcebW">> = iolist_to_binary(re:replace("abcabc","a.+?c","VxJHThV&ket&ebW",[global])), 
?line <<"LXfabNabCqMabHb">> = iolist_to_binary(re:replace("ab","(a+|b)*","LXf&N&CqM&H\\1",[])), 
?line <<"LXfabNabCqMabHbLXfNCqMH">> = iolist_to_binary(re:replace("ab","(a+|b)*","LXf&N&CqM&H\\1",[global])), 
?line <<"NNopapyUJpabVxnQ">> = iolist_to_binary(re:replace("ab","(a+|b){0,}","NNopapyUJpa\\1VxnQ",[])), 
?line <<"NNopapyUJpabVxnQNNopapyUJpaVxnQ">> = iolist_to_binary(re:replace("ab","(a+|b){0,}","NNopapyUJpa\\1VxnQ",[global])), 
?line <<"cejhccpabbAd">> = iolist_to_binary(re:replace("ab","(a+|b)+","cejhccp&\\1Ad",[])), 
?line <<"cejhccpabbAd">> = iolist_to_binary(re:replace("ab","(a+|b)+","cejhccp&\\1Ad",[global])), 
?line <<"uMqbbBaYPvPbkabNdlb">> = iolist_to_binary(re:replace("ab","(a+|b){1,}","uMqb\\1BaYPvP\\1k&Ndl\\1",[])), 
?line <<"uMqbbBaYPvPbkabNdlb">> = iolist_to_binary(re:replace("ab","(a+|b){1,}","uMqb\\1BaYPvP\\1k&Ndl\\1",[global])), 
?line <<"cyKMb">> = iolist_to_binary(re:replace("ab","(a+|b)?","cyKM",[])), 
?line <<"cyKMcyKMcyKM">> = iolist_to_binary(re:replace("ab","(a+|b)?","cyKM",[global])), 
?line <<"uaaPjgxb">> = iolist_to_binary(re:replace("ab","(a+|b){0,1}","u\\1\\1Pjgx",[])), 
?line <<"uaaPjgxubbPjgxuPjgx">> = iolist_to_binary(re:replace("ab","(a+|b){0,1}","u\\1\\1Pjgx",[global])), 
?line <<"JsG">> = iolist_to_binary(re:replace("cde","[^ab]*","\\1J\\1sG",[])), 
?line <<"JsGJsG">> = iolist_to_binary(re:replace("cde","[^ab]*","\\1J\\1sG",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","NyHCvfJjxj\\1SrM&BdF",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","NyHCvfJjxj\\1SrM&BdF",[global])), 
?line <<"b">> = iolist_to_binary(re:replace("b","abc","T&\\1Jd\\1tQxU\\1&\\1\\1bp",[])), 
?line <<"b">> = iolist_to_binary(re:replace("b","abc","T&\\1Jd\\1tQxU\\1&\\1\\1bp",[global])), 
?line <<"AHcabbbcdabbbcdabbbcdSCcNR">> = iolist_to_binary(re:replace("abbbcd","([abc])*d","AH\\1&&&SC\\1NR",[])), 
?line <<"AHcabbbcdabbbcdabbbcdSCcNR">> = iolist_to_binary(re:replace("abbbcd","([abc])*d","AH\\1&&&SC\\1NR",[global])), 
?line <<"jDJabcdqabcdgNaaNoyaGm">> = iolist_to_binary(re:replace("abcd","([abc])*bcd","jDJ&q&gN\\1\\1Noy\\1Gm",[])), 
?line <<"jDJabcdqabcdgNaaNoyaGm">> = iolist_to_binary(re:replace("abcd","([abc])*bcd","jDJ&q&gN\\1\\1Noy\\1Gm",[global])), 
?line <<"IHdxtFuTeF">> = iolist_to_binary(re:replace("e","a|b|c|d|e","IHdxtFuT&F",[])), 
?line <<"IHdxtFuTeF">> = iolist_to_binary(re:replace("e","a|b|c|d|e","IHdxtFuT&F",[global])), 
?line <<"RjceNtss">> = iolist_to_binary(re:replace("ef","(a|b|c|d|e)f","Rjc\\1Ntss",[])), 
?line <<"RjceNtss">> = iolist_to_binary(re:replace("ef","(a|b|c|d|e)f","Rjc\\1Ntss",[global])), 
?line <<"nViLDabcdefg">> = iolist_to_binary(re:replace("abcdefg","abcd*efg","nViL\\1D&\\1",[])), 
?line <<"nViLDabcdefg">> = iolist_to_binary(re:replace("abcdefg","abcd*efg","nViL\\1D&\\1",[global])), 
?line <<"xoJUabyHFyabbbz">> = iolist_to_binary(re:replace("xabyabbbz","ab*","oJ\\1U&yHF",[])), 
?line <<"xoJUabyHFyoJUabbbyHFz">> = iolist_to_binary(re:replace("xabyabbbz","ab*","oJ\\1U&yHF",[global])), 
?line <<"xbaEdBayabbbz">> = iolist_to_binary(re:replace("xayabbbz","ab*","b&EdBa",[])), 
?line <<"xbaEdBaybabbbEdBaz">> = iolist_to_binary(re:replace("xayabbbz","ab*","b&EdBa",[global])), 
?line <<"abHqcde">> = iolist_to_binary(re:replace("abcde","(ab|cd)e","Hq&",[])), 
?line <<"abHqcde">> = iolist_to_binary(re:replace("abcde","(ab|cd)e","Hq&",[global])), 
?line <<"lrrKIUARhij">> = iolist_to_binary(re:replace("hij","[abhgefdc]ij","l\\1\\1r\\1rKIUAR&",[])), 
?line <<"lrrKIUARhij">> = iolist_to_binary(re:replace("hij","[abhgefdc]ij","l\\1\\1r\\1rKIUAR&",[global])), 
?line <<"abcdWfgkefnnefNPAQ">> = iolist_to_binary(re:replace("abcdef","(abc|)ef","\\1Wfgk&nn&\\1NPAQ\\1",[])), 
?line <<"abcdWfgkefnnefNPAQ">> = iolist_to_binary(re:replace("abcdef","(abc|)ef","\\1Wfgk&nn&\\1NPAQ\\1",[global])), 
?line <<"aUbGqmbcdWXLMCpYbbcd">> = iolist_to_binary(re:replace("abcd","(a|b)c*d","U\\1Gqm&WXLMCpY\\1&",[])), 
?line <<"aUbGqmbcdWXLMCpYbbcd">> = iolist_to_binary(re:replace("abcd","(a|b)c*d","U\\1Gqm&WXLMCpY\\1&",[global])), 
?line <<"vYALaabcfgsaUfyDabcjOtcQ">> = iolist_to_binary(re:replace("abc","(ab|ab*)bc","vYAL\\1&fgs\\1UfyD&jOtcQ",[])), 
?line <<"vYALaabcfgsaUfyDabcjOtcQ">> = iolist_to_binary(re:replace("abc","(ab|ab*)bc","vYAL\\1&fgs\\1UfyD&jOtcQ",[global])), 
?line <<"uyabcabcp">> = iolist_to_binary(re:replace("abc","a([bc]*)c*","uy&&p",[])), 
?line <<"uyabcabcp">> = iolist_to_binary(re:replace("abc","a([bc]*)c*","uy&&p",[global])), 
?line <<"iAyJUbcM">> = iolist_to_binary(re:replace("abcd","a([bc]*)(c*d)","iAyJU\\1M",[])), 
?line <<"iAyJUbcM">> = iolist_to_binary(re:replace("abcd","a([bc]*)(c*d)","iAyJU\\1M",[global])), 
?line <<"abcdabcdabcd">> = iolist_to_binary(re:replace("abcd","a([bc]+)(c*d)","&&&",[])), 
?line <<"abcdabcdabcd">> = iolist_to_binary(re:replace("abcd","a([bc]+)(c*d)","&&&",[global])), 
?line <<"UgwJmKabcddNBBm">> = iolist_to_binary(re:replace("abcd","a([bc]*)(c+d)","UgwJmK&dNBBm",[])), 
?line <<"UgwJmKabcddNBBm">> = iolist_to_binary(re:replace("abcd","a([bc]*)(c+d)","UgwJmK&dNBBm",[global])), 
?line <<"glXDRFe">> = iolist_to_binary(re:replace("adcdcde","a[bcd]*dcdcde","glXDRFe\\1",[])), 
?line <<"glXDRFe">> = iolist_to_binary(re:replace("adcdcde","a[bcd]*dcdcde","glXDRFe\\1",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[bcd]+dcdcde","&\\1Tw",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a[bcd]+dcdcde","&\\1Tw",[global])), 
?line <<"abcde">> = iolist_to_binary(re:replace("abcde","a[bcd]+dcdcde","OaFcNB\\1AbGk\\1RcX&\\1hU",[])), 
?line <<"abcde">> = iolist_to_binary(re:replace("abcde","a[bcd]+dcdcde","OaFcNB\\1AbGk\\1RcX&\\1hU",[global])), 
?line <<"adcdcde">> = iolist_to_binary(re:replace("adcdcde","a[bcd]+dcdcde","LRCnDGeISr",[])), 
?line <<"adcdcde">> = iolist_to_binary(re:replace("adcdcde","a[bcd]+dcdcde","LRCnDGeISr",[global])), 
?line <<"ab">> = iolist_to_binary(re:replace("abc","(ab|a)b*c","\\1",[])), 
?line <<"ab">> = iolist_to_binary(re:replace("abc","(ab|a)b*c","\\1",[global])), 
?line <<"abcdYujfprabcdqmHBi">> = iolist_to_binary(re:replace("abcd","((a)(b)c)(d)","&Yujfpr&qmHBi",[])), 
?line <<"abcdYujfprabcdqmHBi">> = iolist_to_binary(re:replace("abcd","((a)(b)c)(d)","&Yujfpr&qmHBi",[global])), 
?line <<"HSalphaw">> = iolist_to_binary(re:replace("alpha","[a-zA-Z_][a-zA-Z0-9_]*","HS&w",[])), 
?line <<"HSalphaw">> = iolist_to_binary(re:replace("alpha","[a-zA-Z_][a-zA-Z0-9_]*","HS&w",[global])), 
?line <<"amKrkJTTmWxwbhbhVXebhD">> = iolist_to_binary(re:replace("abh","^a(bc+|b[eh])g|.h$","mKrkJTT\\1mWxw&&VXe&D",[])), 
?line <<"amKrkJTTmWxwbhbhVXebhD">> = iolist_to_binary(re:replace("abh","^a(bc+|b[eh])g|.h$","mKrkJTT\\1mWxw&&VXe&D",[global])), 
?line <<"gkglaeffgzeffgzwvwD">> = iolist_to_binary(re:replace("effgz","(bc+d$|ef*g.|h?i(j|k))","gkgla\\1&wvwD",[])), 
?line <<"gkglaeffgzeffgzwvwD">> = iolist_to_binary(re:replace("effgz","(bc+d$|ef*g.|h?i(j|k))","gkgla\\1&wvwD",[global])), 
?line <<"ivMGijUoGoijri">> = iolist_to_binary(re:replace("ij","(bc+d$|ef*g.|h?i(j|k))","ivMG\\1UoGo\\1ri",[])), 
?line <<"ivMGijUoGoijri">> = iolist_to_binary(re:replace("ij","(bc+d$|ef*g.|h?i(j|k))","ivMG\\1UoGo\\1ri",[global])), 
?line <<"reffgzWeffgzJeffgzeffgzFUK">> = iolist_to_binary(re:replace("reffgz","(bc+d$|ef*g.|h?i(j|k))","&W\\1J\\1&FUK",[])), 
?line <<"reffgzWeffgzJeffgzeffgzFUK">> = iolist_to_binary(re:replace("reffgz","(bc+d$|ef*g.|h?i(j|k))","&W\\1J\\1&FUK",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(bc+d$|ef*g.|h?i(j|k))","qoREgh&sKvuYfqcVSQ",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","(bc+d$|ef*g.|h?i(j|k))","qoREgh&sKvuYfqcVSQ",[global])), 
?line <<"effg">> = iolist_to_binary(re:replace("effg","(bc+d$|ef*g.|h?i(j|k))","OSMK&kVLNnI",[])), 
?line <<"effg">> = iolist_to_binary(re:replace("effg","(bc+d$|ef*g.|h?i(j|k))","OSMK&kVLNnI",[global])), 
?line <<"bcdd">> = iolist_to_binary(re:replace("bcdd","(bc+d$|ef*g.|h?i(j|k))","l\\1SFH&\\1WG\\1N&\\1WpNv",[])), 
?line <<"bcdd">> = iolist_to_binary(re:replace("bcdd","(bc+d$|ef*g.|h?i(j|k))","l\\1SFH&\\1WG\\1N&\\1WpNv",[global])), 
?line <<"uCcLk">> = iolist_to_binary(re:replace("a","((((((((((a))))))))))","uCcLk",[])), 
?line <<"uCcLk">> = iolist_to_binary(re:replace("a","((((((((((a))))))))))","uCcLk",[global])), 
?line <<"VCUvbvxORiulavLRaFa">> = iolist_to_binary(re:replace("aa","((((((((((a))))))))))\\10","VCUvbvxORiul\\1vLR\\1F\\1",[])), 
?line <<"VCUvbvxORiulavLRaFa">> = iolist_to_binary(re:replace("aa","((((((((((a))))))))))\\10","VCUvbvxORiul\\1vLR\\1F\\1",[global])), 
?line <<"vFhEaarfaQfeLfaFGiV">> = iolist_to_binary(re:replace("a","(((((((((a)))))))))","vFhE\\1&rf&QfeLf\\1FGiV",[])), 
?line <<"vFhEaarfaQfeLfaFGiV">> = iolist_to_binary(re:replace("a","(((((((((a)))))))))","vFhE\\1&rf&QfeLf\\1FGiV",[global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","multiple words of text","jlWax\\1&H",[])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","multiple words of text","jlWax\\1&H",[global])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","multiple words of text","hsUw",[])), 
?line <<"aa">> = iolist_to_binary(re:replace("aa","multiple words of text","hsUw",[global])), 
?line <<"uh-uh">> = iolist_to_binary(re:replace("uh-uh","multiple words of text","ASEw\\1gOsB",[])), 
?line <<"uh-uh">> = iolist_to_binary(re:replace("uh-uh","multiple words of text","ASEw\\1gOsB",[global])), 
?line <<"dmultiple wordsxkMtmultiple words, yeah">> = iolist_to_binary(re:replace("multiple words, yeah","multiple words","d&x\\1\\1kMt&",[])), 
?line <<"dmultiple wordsxkMtmultiple words, yeah">> = iolist_to_binary(re:replace("multiple words, yeah","multiple words","d&x\\1\\1kMt&",[global])), 
?line <<"ykkVabcdefmldQabUjIJjw">> = iolist_to_binary(re:replace("abcde","(.*)c(.*)","ykkV&fmldQ\\1UjIJjw",[])), 
?line <<"ykkVabcdefmldQabUjIJjw">> = iolist_to_binary(re:replace("abcde","(.*)c(.*)","ykkV&fmldQ\\1UjIJjw",[global])), 
?line <<"efWBSCaa(a, b)Q">> = iolist_to_binary(re:replace("(a, b)","\\((.*), (.*)\\)","efWBSC\\1\\1&Q",[])), 
?line <<"efWBSCaa(a, b)Q">> = iolist_to_binary(re:replace("(a, b)","\\((.*), (.*)\\)","efWBSC\\1\\1&Q",[global])), 
?line <<"abcdBdXhwHpBabcdPC">> = iolist_to_binary(re:replace("abcd","abcd","&Bd\\1XhwHp\\1B&PC",[])), 
?line <<"abcdBdXhwHpBabcdPC">> = iolist_to_binary(re:replace("abcd","abcd","&Bd\\1XhwHp\\1B&PC",[global])), 
?line <<"SbsAruCoIPbckBgbcSyqva">> = iolist_to_binary(re:replace("abcd","a(bc)d","SbsAruCoIP\\1kBg\\1Syqva",[])), 
?line <<"SbsAruCoIPbckBgbcSyqva">> = iolist_to_binary(re:replace("abcd","a(bc)d","SbsAruCoIP\\1kBg\\1Syqva",[global])), 
?line <<"XiUVfmkDnpfY">> = iolist_to_binary(re:replace("ac","a[-]?c","XiUVfmkDnpfY",[])), 
?line <<"XiUVfmkDnpfY">> = iolist_to_binary(re:replace("ac","a[-]?c","XiUVfmkDnpfY",[global])), 
?line <<"GYmabcndabcabcabcabcCjabcabcabcabctjmn">> = iolist_to_binary(re:replace("abcabc","(abc)\\1","GYm\\1nd&&Cj&\\1\\1tjmn",[])), 
?line <<"GYmabcndabcabcabcabcCjabcabcabcabctjmn">> = iolist_to_binary(re:replace("abcabc","(abc)\\1","GYm\\1nd&&Cj&\\1\\1tjmn",[global])), 
?line <<"AabcFabcabcOw">> = iolist_to_binary(re:replace("abcabc","([a-c]*)\\1","A\\1F&Ow",[])), 
?line <<"AabcFabcabcOwAFOw">> = iolist_to_binary(re:replace("abcabc","([a-c]*)\\1","A\\1F&Ow",[global])), 
?line <<"savneuiFiA">> = iolist_to_binary(re:replace("a","(a)|\\1","s&vneuiFiA",[])), 
?line <<"savneuiFiA">> = iolist_to_binary(re:replace("a","(a)|\\1","s&vneuiFiA",[global])), 
?line <<"*** FatXvbwaxGeTrgahaailers">> = iolist_to_binary(re:replace("*** Failers","(a)|\\1","\\1tXvbw&xGeTrg\\1h&\\1",[])), 
?line <<"*** FatXvbwaxGeTrgahaailers">> = iolist_to_binary(re:replace("*** Failers","(a)|\\1","\\1tXvbw&xGeTrg\\1h&\\1",[global])), 
?line <<"ShaaIOaiKrRarjaTFxavb">> = iolist_to_binary(re:replace("ab","(a)|\\1","Sh\\1\\1IO&iKrR\\1rj\\1TFx&v",[])), 
?line <<"ShaaIOaiKrRarjaTFxavb">> = iolist_to_binary(re:replace("ab","(a)|\\1","Sh\\1\\1IO&iKrR\\1rj\\1TFx&v",[global])), 
?line <<"x">> = iolist_to_binary(re:replace("x","(a)|\\1","wG&OmupsBaCA&ULU&br",[])), 
?line <<"x">> = iolist_to_binary(re:replace("x","(a)|\\1","wG&OmupsBaCA&ULU&br",[global])), 
?line <<"ababbsaHOnababbDlUpRwMMqlababbCbbbcbc">> = iolist_to_binary(re:replace("ababbbcbc","(([a-c])b*?\\2)*","&saHOn&DlUpRwMMql&C\\1",[])), 
?line <<"ababbsaHOnababbDlUpRwMMqlababbCbbsaHOnDlUpRwMMqlCbcbcsaHOncbcDlUpRwMMqlcbcCcbcsaHOnDlUpRwMMqlC">> = iolist_to_binary(re:replace("ababbbcbc","(([a-c])b*?\\2)*","&saHOn&DlUpRwMMql&C\\1",[global])), 
?line <<"YdAFYmyyababbbcbcHpJCababbbcbcQa">> = iolist_to_binary(re:replace("ababbbcbc","(([a-c])b*?\\2){3}","YdAFYmyy&HpJC&Qa",[])), 
?line <<"YdAFYmyyababbbcbcHpJCababbbcbcQa">> = iolist_to_binary(re:replace("ababbbcbc","(([a-c])b*?\\2){3}","YdAFYmyy&HpJC&Qa",[global])), 
?line <<"aaaxabaxbaaxabbax">> = iolist_to_binary(re:replace("aaaxabaxbaaxbbax","((\\3|b)\\2(a)x)+","a\\1",[])), 
?line <<"aaaxabaxbaaxabbax">> = iolist_to_binary(re:replace("aaaxabaxbaaxbbax","((\\3|b)\\2(a)x)+","a\\1",[global])), 
?line <<"bbaababbabaaaaaoh">> = iolist_to_binary(re:replace("bbaababbabaaaaabbaaaabba","((\\3|b)\\2(a)){2,}","oh",[])), 
?line <<"bbaababbabaaaaaoh">> = iolist_to_binary(re:replace("bbaababbabaaaaabbaaaabba","((\\3|b)\\2(a)){2,}","oh",[global])), 
?line <<"fABCaeUgIABCDABCNFvst">> = iolist_to_binary(re:replace("ABC","abc","f&aeUgI&D&\\1NFvst",[caseless])), 
?line <<"fABCaeUgIABCDABCNFvst">> = iolist_to_binary(re:replace("ABC","abc","f&aeUgI&D&\\1NFvst",[caseless,
                                                                                                                                                                                               global])), 
?line <<"XgOY">> = iolist_to_binary(re:replace("XABCY","abc","gO",[caseless])), 
?line <<"XgOY">> = iolist_to_binary(re:replace("XABCY","abc","gO",[caseless,
                                                                                                                                                               global])), 
?line <<"ABnpaQvR">> = iolist_to_binary(re:replace("ABABC","abc","npaQvR",[caseless])), 
?line <<"ABnpaQvR">> = iolist_to_binary(re:replace("ABABC","abc","npaQvR",[caseless,
                                                                                                                                                                       global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","E&beuUX&&",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","abc","E&beuUX&&",[caseless,
                                                                                                                                                                                            global])), 
?line <<"aaxabxbaxbbx">> = iolist_to_binary(re:replace("aaxabxbaxbbx","abc","\\1hAU\\1hg&Pk",[caseless])), 
?line <<"aaxabxbaxbbx">> = iolist_to_binary(re:replace("aaxabxbaxbbx","abc","\\1hAU\\1hg&Pk",[caseless,
                                                                                                                                                                                                        global])), 
?line <<"XBC">> = iolist_to_binary(re:replace("XBC","abc","yqsG",[caseless])), 
?line <<"XBC">> = iolist_to_binary(re:replace("XBC","abc","yqsG",[caseless,
                                                                                                                                                               global])), 
?line <<"AXC">> = iolist_to_binary(re:replace("AXC","abc","\\1bi&Ff\\1kGVy&V",[caseless])), 
?line <<"AXC">> = iolist_to_binary(re:replace("AXC","abc","\\1bi&Ff\\1kGVy&V",[caseless,
                                                                                                                                                                                             global])), 
?line <<"ABX">> = iolist_to_binary(re:replace("ABX","abc","x&m\\1jtf&ptFxBd",[caseless])), 
?line <<"ABX">> = iolist_to_binary(re:replace("ABX","abc","x&m\\1jtf&ptFxBd",[caseless,
                                                                                                                                                                                          global])), 
?line <<"VOTkukABC">> = iolist_to_binary(re:replace("ABC","ab*c","V\\1OTkuk&\\1",[caseless])), 
?line <<"VOTkukABC">> = iolist_to_binary(re:replace("ABC","ab*c","V\\1OTkuk&\\1",[caseless,
                                                                                                                                                                                      global])), 
?line <<"gkYiABCuYNOFDNc">> = iolist_to_binary(re:replace("ABC","ab*bc","g\\1kYi&uYNOFDNc",[caseless])), 
?line <<"gkYiABCuYNOFDNc">> = iolist_to_binary(re:replace("ABC","ab*bc","g\\1kYi&uYNOFDNc",[caseless,
                                                                                                                                                                                             global])), 
?line <<"GHfaNWh">> = iolist_to_binary(re:replace("ABBC","ab*bc","G\\1HfaNWh",[caseless])), 
?line <<"GHfaNWh">> = iolist_to_binary(re:replace("ABBC","ab*bc","G\\1HfaNWh",[caseless,
                                                                                                                                                                                  global])), 
?line <<"IJJBqWcABBBBCmU">> = iolist_to_binary(re:replace("ABBBBC","ab*?bc","I\\1JJB\\1\\1qWc&mU",[caseless])), 
?line <<"IJJBqWcABBBBCmU">> = iolist_to_binary(re:replace("ABBBBC","ab*?bc","I\\1JJB\\1\\1qWc&mU",[caseless,
                                                                                                                                                                                                             global])), 
?line <<"YOCTcABBBBCABBBBCbVDCpABBBBChP">> = iolist_to_binary(re:replace("ABBBBC","ab{0,}?bc","YOCTc&&bVDCp&hP",[caseless])), 
?line <<"YOCTcABBBBCABBBBCbVDCpABBBBChP">> = iolist_to_binary(re:replace("ABBBBC","ab{0,}?bc","YOCTc&&bVDCp&hP",[caseless,
                                                                                                                                                                                                          global])), 
?line <<"j">> = iolist_to_binary(re:replace("ABBC","ab+?bc","j",[caseless])), 
?line <<"j">> = iolist_to_binary(re:replace("ABBC","ab+?bc","j",[caseless,
                                                                                                                                                                 global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab+bc","vLfo&Q\\1&uXHE",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab+bc","vLfo&Q\\1&uXHE",[caseless,
                                                                                                                                                                                                          global])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","ab+bc","hPVKmARvLrX&l",[caseless])), 
?line <<"ABC">> = iolist_to_binary(re:replace("ABC","ab+bc","hPVKmARvLrX&l",[caseless,
                                                                                                                                                                                      global])), 
?line <<"ABQ">> = iolist_to_binary(re:replace("ABQ","ab+bc","&\\1OP&EAg",[caseless])), 
?line <<"ABQ">> = iolist_to_binary(re:replace("ABQ","ab+bc","&\\1OP&EAg",[caseless,
                                                                                                                                                                                  global])), 
?line <<"PElq">> = iolist_to_binary(re:replace("ABBBBC","ab+bc","PElq",[caseless])), 
?line <<"PElq">> = iolist_to_binary(re:replace("ABBBBC","ab+bc","PElq",[caseless,
                                                                                                                                                                         global])), 
?line <<"aqDjyRpvS">> = iolist_to_binary(re:replace("ABBBBC","ab{1,}?bc","\\1a\\1\\1q\\1DjyRpvS\\1",[caseless])), 
?line <<"aqDjyRpvS">> = iolist_to_binary(re:replace("ABBBBC","ab{1,}?bc","\\1a\\1\\1q\\1DjyRpvS\\1",[caseless,
                                                                                                                                                                                                                              global])), 
?line <<"aTWqxABBBBCInABBBBCpRFpO">> = iolist_to_binary(re:replace("ABBBBC","ab{1,3}?bc","aTW\\1qx&In&\\1pRFpO",[caseless])), 
?line <<"aTWqxABBBBCInABBBBCpRFpO">> = iolist_to_binary(re:replace("ABBBBC","ab{1,3}?bc","aTW\\1qx&In&\\1pRFpO",[caseless,
                                                                                                                                                                                                                       global])), 
?line <<"ABBBBCTlrABBBBCJOlJvqwgABBBBCh">> = iolist_to_binary(re:replace("ABBBBC","ab{3,4}?bc","&T\\1lr&JOl\\1Jvqwg&h",[caseless])), 
?line <<"ABBBBCTlrABBBBCJOlJvqwgABBBBCh">> = iolist_to_binary(re:replace("ABBBBC","ab{3,4}?bc","&T\\1lr&JOl\\1Jvqwg&h",[caseless,
                                                                                                                                                                                                                          global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{4,5}?bc","QBVMd\\1eBP&j\\1Y\\1\\1",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","ab{4,5}?bc","QBVMd\\1eBP&j\\1Y\\1\\1",[caseless,
                                                                                                                                                                                                                                        global])), 
?line <<"ABQ">> = iolist_to_binary(re:replace("ABQ","ab{4,5}?bc","pvlNJ\\1o\\1yAcNJhSec\\1",[caseless])), 
?line <<"ABQ">> = iolist_to_binary(re:replace("ABQ","ab{4,5}?bc","pvlNJ\\1o\\1yAcNJhSec\\1",[caseless,
                                                                                                                                                                                                                        global])), 
?line <<"ABBBBC">> = iolist_to_binary(re:replace("ABBBBC","ab{4,5}?bc","dGdgiMqW\\1X",[caseless])), 
?line <<"ABBBBC">> = iolist_to_binary(re:replace("ABBBBC","ab{4,5}?bc","dGdgiMqW\\1X",[caseless,
                                                                                                                                                                                                    global])), 
?line <<"eqlxxIffIhfLhL">> = iolist_to_binary(re:replace("ABBC","ab??bc","eqlxxIffIhfLhL",[caseless])), 
?line <<"eqlxxIffIhfLhL">> = iolist_to_binary(re:replace("ABBC","ab??bc","eqlxxIffIhfLhL",[caseless,
                                                                                                                                                                                           global])), 
?line <<"bQqNAjyKOqhMXyoABC">> = iolist_to_binary(re:replace("ABC","ab??bc","b\\1QqNAjyKOqhMXyo&",[caseless])), 
?line <<"bQqNAjyKOqhMXyoABC">> = iolist_to_binary(re:replace("ABC","ab??bc","b\\1QqNAjyKOqhMXyo&",[caseless,
                                                                                                                                                                                                     global])), 
?line <<"jJQGABCIRM">> = iolist_to_binary(re:replace("ABC","ab{0,1}?bc","jJQG&IR\\1M",[caseless])), 
?line <<"jJQGABCIRM">> = iolist_to_binary(re:replace("ABC","ab{0,1}?bc","jJQG&IR\\1M",[caseless,
                                                                                                                                                                                             global])), 
?line <<"gPABCCho">> = iolist_to_binary(re:replace("ABC","ab??c","gP&Cho",[caseless])), 
?line <<"gPABCCho">> = iolist_to_binary(re:replace("ABC","ab??c","gP&Cho",[caseless,
                                                                                                                                                                        global])), 
?line <<"iNBxUabjwtTABCLABCvXhABC">> = iolist_to_binary(re:replace("ABC","ab{0,1}?c","iNBxUabjw\\1tT&L&vXh&",[caseless])), 
?line <<"iNBxUabjwtTABCLABCvXhABC">> = iolist_to_binary(re:replace("ABC","ab{0,1}?c","iNBxUabjw\\1tT&L&vXh&",[caseless,
                                                                                                                                                                                                                 global])), 
?line <<"iBkpxqXNa">> = iolist_to_binary(re:replace("ABC","^abc$","iBkpxqXNa",[caseless])), 
?line <<"iBkpxqXNa">> = iolist_to_binary(re:replace("ABC","^abc$","iBkpxqXNa",[caseless,
                                                                                                                                                                              global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","OhTwUeW&yJtn",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","^abc$","OhTwUeW&yJtn",[caseless,
                                                                                                                                                                                                     global])), 
?line <<"ABBBBC">> = iolist_to_binary(re:replace("ABBBBC","^abc$","LoawT&xKl\\1&",[caseless])), 
?line <<"ABBBBC">> = iolist_to_binary(re:replace("ABBBBC","^abc$","LoawT&xKl\\1&",[caseless,
                                                                                                                                                                                               global])), 
?line <<"ABCC">> = iolist_to_binary(re:replace("ABCC","^abc$","iVcopu",[caseless])), 
?line <<"ABCC">> = iolist_to_binary(re:replace("ABCC","^abc$","iVcopu",[caseless,
                                                                                                                                                                          global])), 
?line <<"ABCtC">> = iolist_to_binary(re:replace("ABCC","^abc","&t",[caseless])), 
?line <<"ABCtC">> = iolist_to_binary(re:replace("ABCC","^abc","&t",[caseless,
                                                                                                                                                                global])), 
?line <<"AABCWBABCtLipJGm">> = iolist_to_binary(re:replace("AABC","abc$","&W\\1B&tLipJGm",[caseless])), 
?line <<"AABCWBABCtLipJGm">> = iolist_to_binary(re:replace("AABC","abc$","&W\\1B&tLipJGm",[caseless,
                                                                                                                                                                                           global])), 
?line <<"wDvJtREmkCGdgtGtgABC">> = iolist_to_binary(re:replace("ABC","^","wDvJt\\1REmk\\1CGdgtGtg",[caseless])), 
?line <<"wDvJtREmkCGdgtGtgABC">> = iolist_to_binary(re:replace("ABC","^","wDvJt\\1REmk\\1CGdgtGtg",[caseless,
                                                                                                                                                                                                   global])), 
?line <<"ABCWiqpRnpqRRBAD">> = iolist_to_binary(re:replace("ABC","$","W\\1iqpRnpq\\1RRB&\\1AD",[caseless])), 
?line <<"ABCWiqpRnpqRRBAD">> = iolist_to_binary(re:replace("ABC","$","W\\1iqpRnpq\\1RRB&\\1AD",[caseless,
                                                                                                                                                                                                      global])), 
?line <<"FOABCHABCuJ">> = iolist_to_binary(re:replace("ABC","a.c","FO&H&uJ",[caseless])), 
?line <<"FOABCHABCuJ">> = iolist_to_binary(re:replace("ABC","a.c","FO&H&uJ",[caseless,
                                                                                                                                                                       global])), 
?line <<"mmAXCwHQUmyij">> = iolist_to_binary(re:replace("AXC","a.c","m\\1m&\\1wHQUmyi\\1j",[caseless])), 
?line <<"mmAXCwHQUmyij">> = iolist_to_binary(re:replace("AXC","a.c","m\\1m&\\1wHQUmyi\\1j",[caseless,
                                                                                                                                                                                                   global])), 
?line <<"vKLhT">> = iolist_to_binary(re:replace("AXYZC","a.*?c","vKLhT",[caseless])), 
?line <<"vKLhT">> = iolist_to_binary(re:replace("AXYZC","a.*?c","vKLhT",[caseless,
                                                                                                                                                                         global])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a.*c","TrBPBlhlCyS&oLwXCYxT",[caseless])), 
?line <<"*** Failers">> = iolist_to_binary(re:replace("*** Failers","a.*c","TrBPBlhlCyS&oLwXCYxT",[caseless,
                                                                                                                                                                                                                  global])), 
?line <<"oNBAABC">> = iolist_to_binary(re:replace("AABC","a.*c","oNB&",[caseless])), 
?line <<"oNBAABC">> = iolist_to_binary(re:replace("AABC","a.*c","oNB&",[caseless,
                                                                                                                                                                    global])), 
?line <<"AXYZD">> = iolist_to_binary(re:replace("AXYZD","a.*c","v\\1byeTHd&vaDRL\\1",[caseless])), 
?line <<"AXYZD">> = iolist_to_binary(re:replace("AXYZD","a.*c","v\\1byeTHd&vaDRL\\1",[caseless,
                                                                                       