/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;

public class EmbossCirdnaReader {
    private File cirdnaFile;
    private boolean reading = false;
    private Vector restrictionEnzyme = new Vector();
    private Vector block = new Vector();
    private Color[] embossColor = new Color[]{Color.black, Color.red, Color.yellow, Color.green, Color.decode("#99CCFF"), Color.decode("#FFCCCC"), Color.decode("#FFFFCC"), Color.gray, Color.decode("#993300"), Color.blue, Color.decode("#9933FF"), Color.cyan, Color.decode("#33FFCC"), Color.decode("#FF00FF"), Color.decode("#FF9966"), Color.white};
    int start = 0;
    int end = 0;

    public EmbossCirdnaReader() {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        System.setSecurityManager(sm);
        int returnVal = fc.showOpenDialog(fc);
        if (returnVal == 0) {
            this.cirdnaFile = fc.getSelectedFile();
            this.readFile();
            this.reading = true;
        }
    }

    public EmbossCirdnaReader(File cirdnaFile) {
        this.cirdnaFile = cirdnaFile;
        this.readFile();
        this.reading = true;
    }

    public boolean isReading() {
        return this.reading;
    }

    public Vector readFile() {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(this.cirdnaFile));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim().toLowerCase()).equals("")) continue;
                StringTokenizer stok = new StringTokenizer(line, " ");
                if (line.startsWith("start ")) {
                    stok.nextElement();
                    this.start = Integer.parseInt((String)stok.nextElement());
                    continue;
                }
                if (line.startsWith("end ")) {
                    stok.nextElement();
                    this.end = Integer.parseInt((String)stok.nextElement());
                    continue;
                }
                if (!line.startsWith("group")) continue;
                while ((line = in.readLine()) != null && !(line = line.trim().toLowerCase()).startsWith("endgroup")) {
                    if (line.startsWith("block ")) {
                        String name;
                        stok = new StringTokenizer(line, " ");
                        Vector<Object> marker = new Vector<Object>();
                        stok.nextElement();
                        Integer bstart = new Integer((String)stok.nextElement());
                        Integer bend = new Integer((String)stok.nextElement());
                        Color col = Color.red;
                        if (stok.hasMoreTokens()) {
                            col = this.embossColor[Integer.parseInt((String)stok.nextElement())];
                        }
                        if ((name = in.readLine().trim()).equals("endlabel")) {
                            name = "";
                        }
                        marker.add(name);
                        marker.add(bstart);
                        marker.add(bend);
                        marker.add(col);
                        marker.add(new Float(10.0f));
                        marker.add(new Boolean(false));
                        marker.add(new Boolean(false));
                        this.block.add(marker);
                        continue;
                    }
                    if (!line.startsWith("tick")) continue;
                    stok = new StringTokenizer(line, " ");
                    stok.nextElement();
                    Integer pos = new Integer((String)stok.nextElement());
                    Color col = Color.red;
                    if (stok.hasMoreTokens()) {
                        col = this.embossColor[Integer.parseInt((String)stok.nextElement())];
                    }
                    String name = in.readLine();
                    if (line.equals("endlabel")) {
                        name = "";
                    }
                    Vector<Object> re = new Vector<Object>();
                    re.add(name);
                    re.add(pos);
                    re.add(col);
                    this.restrictionEnzyme.add(re);
                }
            }
        }
        catch (IOException e) {
            System.out.println("SequenceReader Error");
        }
        System.out.println("Start : " + this.start);
        System.out.println("End   : " + this.end);
        return null;
    }

    protected Vector getRestrictionEnzyme() {
        return this.restrictionEnzyme;
    }

    protected Vector getBlock() {
        return this.block;
    }

    protected int getStart() {
        return this.start;
    }

    protected int getEnd() {
        return this.end;
    }
}

