#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf temp1 temp2
mkdir temp1
cd temp1
$DARCS initialize
echo ALL ignore-times >> _darcs/prefs/defaults
echo A > foo
$DARCS add foo
$DARCS record -a -m A -A x
echo B > foo
$DARCS record -a -m B -A x
echo C > foo
$DARCS record -a -m C -A x
$DARCS tag -m 1.0 -A x
cp foo foo_version_1.0
echo D > foo
$DARCS record -a -m D -A x
echo E > foo
$DARCS record -a -m E -A x
echo F > foo
$DARCS record -a -m F -A x


# Check that get store commuted patches
cd ..
$DARCS get --tag 1.0 --repo-name temp2 temp1
cmp temp2/foo temp1/foo_version_1.0
rm -rf temp1 temp2 temp3

mkdir temp1
cd temp1
$DARCS init
cat > file <<EOF
1
2
3
4
EOF
$DARCS rec -Ax -alm 'Add file'
cat > file <<EOF
2
3
4
EOF
$DARCS rec -Ax -alm 'Remove line 1'
cat > file <<EOF
2
4
EOF
$DARCS rec -Ax -alm 'Remove line 3'
cd ..
mkdir temp2
cd temp2
$DARCS init
echo y/n/y | tr / \\012 | $DARCS pull ../temp1
$DARCS tag -Ax -m Tag
$DARCS push -a ../temp1
cd ..
$DARCS get --tag=Tag temp1 temp3
cd temp3
$DARCS check
cd ..
rm -rf temp1 temp2 temp3
