/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class BasicEventList
extends AbstractEventList
implements Serializable {
    private static final long serialVersionUID = 4883958173323072345L;
    private List data;

    public BasicEventList() {
        this(LockFactory.DEFAULT.createReadWriteLock());
    }

    public BasicEventList(ReadWriteLock readWriteLock) {
        super(null);
        this.data = new ArrayList();
        this.readWriteLock = readWriteLock;
    }

    public BasicEventList(List list) {
        super(null);
        this.data = list;
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
    }

    public void add(int index, Object element) {
        this.updates.beginEvent();
        this.updates.addInsert(index);
        this.data.add(index, element);
        this.updates.commitEvent();
    }

    public boolean add(Object element) {
        this.updates.beginEvent();
        this.updates.addInsert(this.size());
        boolean result = this.data.add(element);
        this.updates.commitEvent();
        return result;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int index, Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        this.updates.beginEvent();
        this.updates.addInsert(index, index + collection.size() - 1);
        boolean result = this.data.addAll(index, collection);
        this.updates.commitEvent();
        return result;
    }

    public Object remove(int index) {
        this.updates.beginEvent();
        this.updates.addDelete(index);
        Object removed = this.data.remove(index);
        this.updates.commitEvent();
        return removed;
    }

    public boolean remove(Object element) {
        int index = this.data.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.updates.beginEvent();
        this.updates.addDelete(0, this.size() - 1);
        this.data.clear();
        this.updates.commitEvent();
    }

    public Object set(int index, Object element) {
        this.updates.beginEvent();
        this.updates.addUpdate(index);
        Object previous = this.data.set(index, element);
        this.updates.commitEvent();
        return previous;
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    public int size() {
        return this.data.size();
    }

    public boolean removeAll(Collection collection) {
        boolean changed = false;
        this.updates.beginEvent();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            int index = -1;
            while ((index = this.indexOf(value)) != -1) {
                this.updates.addDelete(index);
                this.data.remove(index);
                changed = true;
            }
        }
        this.updates.commitEvent();
        return changed;
    }

    public boolean retainAll(Collection collection) {
        boolean changed = false;
        this.updates.beginEvent();
        int index = 0;
        while (index < this.data.size()) {
            if (collection.contains(this.data.get(index))) {
                ++index;
                continue;
            }
            this.updates.addDelete(index);
            this.data.remove(index);
            changed = true;
        }
        this.updates.commitEvent();
        return changed;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object[] elements = this.data.toArray(new Object[this.size()]);
        ArrayList<ListEventListener> serializableListeners = new ArrayList<ListEventListener>(1);
        Iterator i = this.updates.getListEventListeners().iterator();
        while (i.hasNext()) {
            ListEventListener listener = (ListEventListener)i.next();
            if (!(listener instanceof Serializable)) continue;
            serializableListeners.add(listener);
        }
        ListEventListener[] listeners = serializableListeners.toArray(new ListEventListener[serializableListeners.size()]);
        out.writeObject(elements);
        out.writeObject(listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
        Object[] elements = (Object[])in.readObject();
        ListEventListener[] listeners = (ListEventListener[])in.readObject();
        this.data = new ArrayList();
        this.data.addAll(Arrays.asList(elements));
        for (int i = 0; i < listeners.length; ++i) {
            this.updates.addListEventListener(listeners[i]);
        }
    }
}

