##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class MSProjectAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    MS Project file abstraction
    """
    
    icon_file = "msproject.gif"
    small_icon_file = "msproject_small.gif"
    content_types = ('application/vnd.ms-project', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => nothing
        No indexing is done on images
        """
        raise RuntimeError, "Unable to index this"


    def isPreviewAvailable(self,):
        return 0


    def convertPreview(self,):
        return None


ZAttachmentRegistry.AttachmentRegistry.registerClass(MSProjectAttachment, globals())

