##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class ImageAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    Image file abstraction
    """
    
    icon_file = "image.gif"
    small_icon_file = "image_small.gif"
    content_types = (
                     'image/gif', 
                     'image/jpeg', 
                     'image/jpg', 
                     'image/pjpeg',
                     'image/png', 
                     'image/x-png', 
                     'image/xpm', 
                     'image/bmp', 
                     'image/x-windows-bmp',
                     'image/x-MS-bmp',
                     'image/tiff',
                     'image/x-icon',
                     'image/x-photoshop',
                     'image/x-targa',
                     'image/xbm',
                    )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => nothing
        No indexing is done on images
        """
        raise RuntimeError, "Unable to index this"


    def isPreviewAvailable(self,):
        return 1


    def convertPreview(self,):
        """
        Let's convert things into pretty HTML !
        """
        return ""


    def getSmallPreview(self,):
        """
        getSmallPreview(self,) => None

        No small preview for images
        """
        return None


    def getPreview(self,):
        """
        XXX may have to restrict width ?
        """
        return '''
        <img src="%s/%s" alt="%s"
        ''' % (self.absolute_url(), self.attachment_id, self.getFilename(), )



ZAttachmentRegistry.AttachmentRegistry.registerClass(ImageAttachment, globals())

