
# Perform some additional security checks (base_edit, pcng_base_edit
# pcng_content_edit) 

from AccessControl import Unauthorized, getSecurityManager

user = getSecurityManager().getUser()
roles = user.getRoles()
context_roles = user.getRolesInContext(context)

if context.isPCNGContext():
    # Collector context

    for role in ('Manager', 'TrackerAdmin'):
        if role in context_roles:
            return True
    raise Unauthorized, context

else:
    # Issue context

    if not context.isPersistent():
        return True

    for role in ('Manager', 'TrackerAdmin', 'Supporter'):
        if role in context_roles:
            return True
    raise Unauthorized, context

raise Unauthorized, context

