
from UserDict import UserDict

class Session(UserDict):
    def set(self, key, value):
        self.__setitem__(key, value)

def setupDummySession(request):
    request['SESSION'] = Session()

def setupGlobalRequest(request):
    from ZPublisher import Publish
    from thread import get_ident
    Publish._requests[get_ident()] = request

def addLanguage(portal, language):
    portal.portal_languages.addSupportedLanguage(language)

def setLanguage(language):
    from Globals import get_request
    request = get_request()
    if request:
        request.cookies['I18N_CONTENT_LANGUAGE'] = language
        request.cookies['I18N_LANGUAGE'] = language
        request['set_language'] = language
        session = request.get('SESSION')
        session['pts_language'] = 'language'
        request.SESSION = session

def makeContent(context, portal_type, id='doc', **kw):
    context.invokeFactory(portal_type, id, **kw)
    return getattr(context, id)

def makeTranslation(content, language='en'):
    content.addTranslation(language)
    return content.getTranslation(language)

def sortTuple(t):
    l = list(t)
    l.sort()
    return tuple(l)

