__doc__='''Shopper product implementation'''

__version__='$Revision: 1.9 $'[11:-2]

ShopperError = "Shopper Error."

from Globals import HTMLFile, MessageDialog, Persistent
import OFS.SimpleItem, Acquisition, AccessControl.Role
from Products import ZPatterns
import string
import time
from Products import ZPatterns

class ShopperManager( ZPatterns.Specialists.Specialist ):

    """ A Shopper Manager """

    # Specify a name for the item type:
    meta_type='ShopperManager'

    # Specify how individual operations add up to "permissions":

    def newShopper(self, shopperID, passwd, email  ):
        """ Create a new Shopper... """

        shopper = self.newItem( shopperID )
        shopper.passwd = passwd
        shopper.email = email
        shopper.transCount = 1

        # this shopper needs a new basket...
        
        newBasket = self.basketManager.newShoppingBasket( shopperID )

        return shopper

    def getTransCount(self, shopper):
        """
        get the shopper's current transCount.. if none is set.. return 1.
        """
        return getattr(shopper, 'transCount', 1)

    def incrTransCount(self, shopper):
        """
        increment the shopper's transCount...
        """
        shopper.transCount = self.getTransCount( shopper ) + 1
        
    def currentBasketId( self, shopperId):
        """ get the current basket id.. """
        shopper = self.getItem(shopperId)
        return shopperId + '_' + `self.getTransCount(shopper)`

    def shopperIDForBasket(self, basketId):
        """ get the shopper id for a particular basketId """
        return string.split(basketId, '_')[0]
    
    def setProcessed(self, theShopper):
        """ finalize a transaction... put the current basket id into the list of
            'checked out' baskets.
        """
        
        theTransactionCollection = self.transactions.getItem( theShopper.id )

        if theTransactionCollection is None:
            theTransactionCollection = self.transactions.newItem( theShopper.id )
            theTransactionCollection.transactionIds = []

        tids = theTransactionCollection.transactionIds   # update transactionIds as an immutable.. 
        tids.append(self.currentBasketId( theShopper.id ))
        theTransactionCollection.transactionIds = tids

        self.incrTransCount(theShopper)
        
        newBasket = self.basketManager.newShoppingBasket( theShopper.id )
        
        return 1
    
    def addToBasket(self, REQUEST=None, RESPONSE=None):

        """ Add and item to the basket... get everything from the 'REQUEST'

        returns  statusMsg, statusCode

        where

            statusMsg = "OK" if all is well and offer is high enough
                        "Failed" if there is some unrecoverable problem

            statusCode =
                       -1 cannot find any MarketItem to match request
                       1  attempt to drop quantity
                       2  not enough product remaining
                       3  attempt to drop offer
                       4  offer is below minPrice, or it's an auction
        """
        # py-mode can be wierd sometimes...
        #
    
        itemID = REQUEST.get('itemID',None)
        quantity = REQUEST.get('quantity',0)
        updateBasket = REQUEST.get('updateBasket',0)
        shopperId = REQUEST.get('clientCookie')
        basketId = self.currentBasketId( shopperId )

        if type(quantity) == type(''):
            quantity = string.strip(quantity)
            quantity = string.replace(quantity,',','')
            quantity = int(string.atoi(quantity))

        optionDict={}

        if REQUEST.has_key('optionDict'):
            optionDict = REQUEST['optionDict']

        elif REQUEST.has_key('options'):
            options = string.split(string.strip(REQUEST['options'])[1:-1],',')
            for option in options:
                option = string.strip(option)[1:-1]  # get rid of quotes!
                optionDict[option] = REQUEST.get(option,'')
        
        item = self.marketFolder.getItem(itemID)

        if item is not None: # we found the item....
            if quantity > 0:
                self.basketManager.addItemToBasket( shopperId, item, quantity, updateBasket, REQUEST )
            else:
                self.basketManager.deleteItemFromBasket( theItem=item, basketId=basketId, REQUEST=REQUEST )

            returnVal = "OK",0
        else:
            returnVal="Failed",-1

        return returnVal

    def loginAsUser(self, shopperID, REQUEST=None, RESPONSE=None, PARENTS=None, PATH_INFO=None):
        """ set the browser cookie to user id for this user..."""

        result = self.set_cookie(RESPONSE = RESPONSE, REQUEST=REQUEST,
                                 path=PATH_INFO, parents=PARENTS, clientCookie=shopperID)

        if REQUEST is not None:
            result = MessageDialog(
                title='Logged In',
                message='You are logged in as <strong>%s</strong><br> %s.' % (self.id, result),
                action = "./manage_main")
        else:
            result = "OK"

        return result

