/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: ThemeZip.h,v 1.4 2003/09/16 17:35:32 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_THEMEZIP_H__
#define INCLUDED_THEMEZIP_H__

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#include "config.h"
#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include <string>
#include <vector>
#include "errors.h"


class ThemeZip
{
    public:

               ThemeZip(void);
      virtual ~ThemeZip(void);

      virtual  Error CompressThemeZip(const std::string &oDestFile, 
                                      std::vector<std::string *> &oFileList);
      virtual  Error DecompressTheme(const std::string &oSrcFile,
                                     const std::string &oDestPath);
      virtual  Error CleanupThemeZip(void);    
      virtual  Error CleanupThemeZip(std::string &oDir); 
      virtual  Error GetDescriptiveName(const std::string &oSrcFile, 
                                        std::string &oDescriptiveName);

    protected:
     
    private:
          Error DecompressZip(const std::string &oSrcFile, 
			      const std::string &oDestFile);
          Error DecompressGZ(const std::string &oSrcFile, 
			     const std::string &oDestFile);

	  std::vector<std::string> m_oCreatedFiles;
};

#endif

/* arch-tag: cc8f2510-6b97-45d2-b43f-4b187ccc0010
   (do not change this comment) */
