/* zbconfig.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qfile.h>
#include <qdom.h>
#include <qdatetime.h>
#include "zbconfig.hh"

#ifndef ZEIBERBUDE_RC
#define ZEIBERBUDE_RC "/etc/zeiberbude.conf"
#endif

zbconfig::zbconfig (QString location)
{
  file = location;
}

zbconfig::~zbconfig ()
{

}

int
zbconfig::readConfig (tarifList * tarife, productList * products,
		      groupList * groups, companyInfo * company,
		      QString * cur, int *park, printInfo * pInfo)
{
  QDomDocument doc ("config");
  if (file.isNull ())
    file = ZEIBERBUDE_RC;
  QFile f (file);
  if (!f.open (IO_ReadOnly))
    return (-1);
  if (!doc.setContent (&f))
    {
      f.close ();
      return (-1);
    }
  QDomElement docElem = doc.documentElement ();
  QDomNode n = docElem.firstChild ();
  while (!n.isNull ())
    {
      QDomElement e = n.toElement ();
      if (!e.isNull ())
	{
	  if (e.tagName () == "TARIF")
	    {
	      tarifInfo t;
	      t.name = e.attribute ("NAME");
	      t.fullHour = e.attribute ("FULL_HOUR", "0").toFloat ();
	      t.halfHour = e.attribute ("HALF_HOUR", "0").toFloat ();
	      t.quartHour = e.attribute ("QUART_HOUR", "0").toFloat ();
	      t.fullDay = e.attribute ("FULL_DAY", "0").toFloat ();
	      t.halfDay = e.attribute ("HALF_DAY", "0").toFloat ();
	      t.fullDayHours = e.attribute ("FULL_DAY_HOURS", "0").toInt ();
	      t.halfDayHours = e.attribute ("HALF_DAY_HOURS", "0").toInt ();
	      t.happyEnabled = e.attribute ("HAPPY_ENABLED", "0").toInt ();
	      t.happyFullHour =
		e.attribute ("HAPPY_FULL_HOUR", "0").toFloat ();
	      t.happyHalfHour =
		e.attribute ("HAPPY_HALF_HOUR", "0").toFloat ();
	      t.happyQuartHour =
		e.attribute ("HAPPY_QUART_HOUR", "0").toFloat ();
	      t.happyStart =
		QTime::fromString (e.attribute ("HAPPY_START", "00:00"));
	      t.happyStop =
		QTime::fromString (e.attribute ("HAPPY_STOP", "00:00"));
	      t.day[0] = e.attribute ("DAY_MO", "0").toInt ();
	      t.day[1] = e.attribute ("DAY_DI", "0").toInt ();
	      t.day[2] = e.attribute ("DAY_MI", "0").toInt ();
	      t.day[3] = e.attribute ("DAY_DO", "0").toInt ();
	      t.day[4] = e.attribute ("DAY_FR", "0").toInt ();
	      t.day[5] = e.attribute ("DAY_SA", "0").toInt ();
	      t.day[6] = e.attribute ("DAY_SO", "0").toInt ();
	      t.tax = e.attribute ("TAX", "0").toFloat ();
	      t.vorlauf = e.attribute ("VORLAUF", "0").toInt ();
	      (*tarife).append (t);
	    }
	  else if (e.tagName () == "PRODUCT")
	    {
	      productInfo p;
	      p.name = e.attribute ("NAME");
	      p.price = e.attribute ("PRICE", "0").toFloat ();
	      p.tax = e.attribute ("TAX", "0").toFloat ();
	      (*products).append (p);
	    }
	  else if (e.tagName () == "GROUP")
	    {
	      groupInfo g;
	      g.name = e.attribute ("NAME");
	      QDomNode cmp = e.firstChild ();
	      while (!cmp.isNull ())
		{
		  QDomElement cm = cmp.toElement ();
		  if (!cm.isNull ())
		    {
		      //if(cm.tagName() == "CLIENT"){
		      compInfo c;
		      c.name = cm.attribute ("NAME");
		      c.address = cm.attribute ("IP");
		      c.number = cm.attribute ("NR").toInt ();
		      g.comp.append (c);
		      //}
		    }
		  cmp = cmp.nextSibling ();
		}
	      (*groups).append (g);
	    }
	  else if (e.tagName () == "COMPANY")
	    {
	      company->name = e.attribute ("NAME");
	      company->owner = e.attribute ("OWNER");
	      company->street = e.attribute ("STREET");
	      company->zip = e.attribute ("ZIP");
	      company->city = e.attribute ("CITY");
	      company->tel = e.attribute ("TEL");
	      company->fax = e.attribute ("FAX");
	      company->mail = e.attribute ("MAIL");
	      company->web = e.attribute ("WEB");
	    }
	  else if (e.tagName () == "CURENCY")
	    {
	      *cur = e.attribute ("NAME");
	    }
	  else if (e.tagName () == "PARKING")
	    {
	      *park = e.attribute ("COUNT").toInt ();
	    }
	  else if (e.tagName () == "PRINT")
	    {
	      pInfo->tax = e.attribute ("TAX", "0").toFloat ();
	      pInfo->color = e.attribute ("COLOR", "0").toFloat ();
	      pInfo->gray = e.attribute ("GRAY", "0").toFloat ();
	    }
	}
      n = n.nextSibling ();
    }
  return (0);
}

int
zbconfig::writeConfig (tarifList * tarife, productList * products,
		       groupList * groups, companyInfo * company,
		       QString * cur, int *park, printInfo * pInfo)
{
  QDomDocument doc ("config");
  QString start = "<ZEIBERBUDE />";
  doc.setContent (start);
  QDomElement docElem = doc.documentElement ();
  // company
  QDomElement e = doc.createElement ("COMPANY");
  e.setAttribute ("NAME", company->name);
  e.setAttribute ("OWNER", company->owner);
  e.setAttribute ("STREET", company->street);
  e.setAttribute ("ZIP", company->zip);
  e.setAttribute ("CITY", company->city);
  e.setAttribute ("TEL", company->tel);
  e.setAttribute ("FAX", company->fax);
  e.setAttribute ("MAIL", company->mail);
  e.setAttribute ("WEB", company->web);
  docElem.appendChild (e);
  // tarife
  for (tarifList::iterator ti = tarife->begin (); ti != tarife->end (); ++ti)
    {
      e = doc.createElement ("TARIF");
      e.setAttribute ("NAME", (*ti).name);
      e.setAttribute ("FULL_HOUR", (*ti).fullHour);
      e.setAttribute ("HALF_HOUR", (*ti).halfHour);
      e.setAttribute ("QUART_HOUR", (*ti).quartHour);
      e.setAttribute ("FULL_DAY", (*ti).fullDay);
      e.setAttribute ("HALF_DAY", (*ti).halfDay);
      e.setAttribute ("FULL_DAY_HOURS", (*ti).fullDayHours);
      e.setAttribute ("HALF_DAY_HOURS", (*ti).halfDayHours);
      e.setAttribute ("HAPPY_ENABLED", (*ti).happyEnabled);
      e.setAttribute ("HAPPY_FULL_HOUR", (*ti).happyFullHour);
      e.setAttribute ("HAPPY_HALF_HOUR", (*ti).happyHalfHour);
      e.setAttribute ("HAPPY_QUART_HOUR", (*ti).happyQuartHour);
      e.setAttribute ("HAPPY_START", (*ti).happyStart.toString ("hh:mm"));
      e.setAttribute ("HAPPY_STOP", (*ti).happyStop.toString ("hh:mm"));
      e.setAttribute ("DAY_MO", (*ti).day[0]);
      e.setAttribute ("DAY_DI", (*ti).day[1]);
      e.setAttribute ("DAY_MI", (*ti).day[2]);
      e.setAttribute ("DAY_DO", (*ti).day[3]);
      e.setAttribute ("DAY_FR", (*ti).day[4]);
      e.setAttribute ("DAY_SA", (*ti).day[5]);
      e.setAttribute ("DAY_SO", (*ti).day[6]);
      e.setAttribute ("TAX", (*ti).tax);
      e.setAttribute ("VORLAUF", (*ti).vorlauf);
      docElem.appendChild (e);
    }
  // groups
  compList::iterator ci;
  QDomElement g;
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    {
      g = doc.createElement ("GROUP");
      g.setAttribute ("NAME", (*gi).name);
      // clients
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	{
	  e = doc.createElement ("CLIENT");
	  e.setAttribute ("NAME", (*ci).name);
	  e.setAttribute ("IP", (*ci).address);
	  e.setAttribute ("NR", (*ci).number);
	  g.appendChild (e);
	}
      docElem.appendChild (g);
    }
  // products
  for (productList::iterator pi = products->begin (); pi != products->end ();
       ++pi)
    {
      e = doc.createElement ("PRODUCT");
      e.setAttribute ("NAME", (*pi).name);
      e.setAttribute ("PRICE", (*pi).price);
      e.setAttribute ("TAX", (*pi).tax);
      docElem.appendChild (e);
    }
  // printss
  e = doc.createElement ("PRINT");
  e.setAttribute ("TAX", pInfo->tax);
  e.setAttribute ("COLOR", pInfo->color);
  e.setAttribute ("GRAY", pInfo->gray);
  docElem.appendChild (e);
  // curency
  e = doc.createElement ("CURENCY");
  e.setAttribute ("NAME", *cur);
  docElem.appendChild (e);
  // parking
  e = doc.createElement ("PARKING");
  e.setAttribute ("COUNT", *park);
  docElem.appendChild (e);
  // write the config
  if (file.isNull ())
    file = ZEIBERBUDE_RC;
  QFile f (file);
  if (!f.open (IO_WriteOnly))
    return (-1);
  QTextStream t (&f);
  t << doc.toString ().latin1 ();
  f.close ();
  return (0);
}

int zbconfig::readDb(tarifList *tarife, productList *products, printInfo *pInfo)
{
  zbuser *usr;
  QDomDocument doc("db");
  QFile f(ZEIBERBUDE_DB);
  if(!f.open(IO_ReadOnly))
    return -1;
  if(!doc.setContent(&f))
    {
      f.close();
      return -1;
    }
  QDomElement docElem = doc.documentElement();
  QDomNode n = docElem.firstChild();
  QString name;
  bool isCount;
  QString tarif;
  QDomNode n2;
  QDomElement e2;
  QTime tme;
  while(!n.isNull())
    {
      QDomElement e = n.toElement();
      if(e.tagName() == "PARK")
	{
	  name = e.attribute("NAME");
	  isCount = false;
	  if(e.attribute("COUNTDOWN") == "1")
	    isCount = true;
	  tme = QTime::fromString(e.attribute("TIME"));
	  usr = new zbuser(name, products,pInfo,isCount,tme);
	  n2 = e.firstChild();
	  while(!n2.isNull())
	    {
	      e2 = n2.toElement();
	      if(e2.tagName() == "TARIF")
		{
		  tarif = e2.attribute("NAME");
		  for(tarifList::iterator ti = tarife->begin(); ti != tarife->end(); ++ti)
		    if((*ti).name == tarif)
		      usr->setTarif(&(*ti));
		}
	      else if(e2.tagName() == "PRODUCT")
		usr->addItem(e2.attribute("INDEX").toInt(),e2.attribute("COUNT").toInt());
	      n2 = n2.nextSibling();
	    }
	  emit parkUser(usr);
	}
      else if(e.tagName() == "GROUP")
	{
	  QString gName = e.attribute("NAME");
	  n2 = e.firstChild();
	  while(!n2.isNull())
	    {
	      e2 = n2.toElement();
	      QString cName = e2.attribute("COMP");
	      name = e2.attribute("NAME");
	      isCount = false;
	      if(e.attribute("COUNTDOWN") == "1")
		isCount = true;
	      tme = QTime::fromString(e2.attribute("TIME"));
	      usr = new zbuser(name,products,pInfo,isCount,tme);
	      QDomNode n3 = e2.firstChild();
	      while(!n3.isNull())
		{
		  QDomElement e3 = n3.toElement();
		  if(e3.tagName() == "TARIF")
		    {
		      tarif = e3.attribute("NAME");
		      for(tarifList::iterator ti = tarife->begin(); ti != tarife->end(); ++ti)
			if((*ti).name == tarif)
			  usr->setTarif(&(*ti));
		    }
		  else if(e3.tagName() == "PRODUCT")
		    {
		      usr->addItem(e3.attribute("INDEX").toInt(),e3.attribute("COUNT").toInt());
		    }
		  n3 = n3.nextSibling();
		}
	      emit compUser(usr,gName,cName);
	      n2 = n2.nextSibling();
	    }
	}
      n = n.nextSibling();
    }
  return 0;
}

int zbconfig::writeDb(QValueList<userparkview*> *park, groupList *groups)
{
  QDomDocument doc("db");
  doc.setContent(QString("<ZEIBERBUDEDB />"));
  QDomElement docElem = doc.documentElement();
  QDomElement e,e2,e3;
  // park view
  userProdList::iterator pi;
  QValueList<userparkview*>::iterator ui;
  for(ui = park->begin(); ui != park->end(); ++ui)
    {
      if((*ui)->isOn())
	{
	  e = doc.createElement("PARK");
	  e.setAttribute("NAME",(*ui)->zbUser->name());
	  if((*ui)->zbUser->countdown)
	    e.setAttribute("COUNTDOWN","1");
	  e.setAttribute("TIME",(*ui)->zbUser->getTime());
	  // tarif
	  e2 = doc.createElement("TARIF");
	  e2.setAttribute("NAME",(*ui)->zbUser->tarif());
	  e.appendChild(e2);
	  // products
	  for(pi = (*ui)->zbUser->usProdList.begin();pi != (*ui)->zbUser->usProdList.end(); ++pi)
	    {
	      e2 = doc.createElement("PRODUCT");
	      e2.setAttribute("INDEX",(*pi).index);
	      e2.setAttribute("COUNT",(*pi).count);
	      e.appendChild(e2);
	    }
	  docElem.appendChild(e);
	}
    }
  //groups
  groupList::iterator gi;
  compList::iterator ci;
  for(gi = groups->begin(); gi != groups->end(); ++gi)
    {
      e = doc.createElement("GROUP");
      e.setAttribute("NAME",(*gi).name);
      for(ci = (*gi).comp.begin(); ci != (*gi).comp.end(); ++ci)
	{
	  if((*ci).view->isActive())
	    {
	      e2 =doc.createElement("CLIENT");
	      e2.setAttribute("COMP",(*ci).view->title());
	      e2.setAttribute("NAME",(*ci).view->zbUser->name());
	      if((*ci).view->zbUser->countdown)
		e2.setAttribute("COUNTDOWN","1");
	      e2.setAttribute("TIME",(*ci).view->zbUser->getTime());
	      e3 = doc.createElement("TARIF");
	      e3.setAttribute("NAME",(*ci).view->zbUser->tarif());
	      e2.appendChild(e3);
	      for(pi = (*ci).view->zbUser->usProdList.begin();pi != (*ci).view->zbUser->usProdList.end(); ++pi)
		{
		  e3 = doc.createElement("PRODUCT");
		  e3.setAttribute("INDEX",(*pi).index);
		  e3.setAttribute("COUNT",(*pi).count);
		  e2.appendChild(e3);
		}
	      e.appendChild(e2);
	    }
	}
      docElem.appendChild(e);
    }
  QFile f(ZEIBERBUDE_DB);
  if(!f.open(IO_WriteOnly))
    return -1;
  QTextStream t(&f);
  t<<doc.toString().latin1();
  f.close();
  return 0;
}
