/* userparkview.cc 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "userparkview.hh"
#include "printout.hh"
#include "icons/ok.xpm"
#include "icons/griff.xpm"
#include "icons/led_gelb.xpm"
#include "icons/led_rot.xpm"

userparkview::userparkview (QWidget * parent, QString title,
			    tarifList * tfList, groupList * gList,
			    productList * pList, printInfo * prints,
			    const char *name):
QGroupBox (title, parent, name)
{
  pInfo = prints;
  setTitle (title);
  initView ();
  setFixedSize (150, 90);
  tarife = tfList;
  groups = gList;
  prods = pList;
  setAcceptDrops (true);
  initData();
}

userparkview::~userparkview ()
{

}

void
userparkview::initView ()
{
  icoLedYellow = QPixmap(led_gelb_xpm);
  icoLedRed = QPixmap(led_red_xpm);
  // frei
  icoOk = QPixmap (ok_xpm);
  freeWidget = new QWidget (this);
  freeWidget->setGeometry (5, 15, 140, 70);
  freeWidget->setFixedSize (140, 70);
  freeLabel = new QLabel (freeWidget);
  freeLabel->setText (tr ("Drop users here"));
  freeLabel->setAlignment (AlignHCenter);
  newUser = new zbbutton (freeWidget);
  newUser->setText (tr ("New User"));
  freeGrid = new QGridLayout (freeWidget, 2, 1);
  freeGrid->addWidget (freeLabel, 0, 0);
  freeGrid->addWidget (newUser, 1, 0);
  // belegt
  belWidget = new QWidget (this);
  belWidget->setGeometry (5, 15, 140, 70);
  belWidget->setFixedSize (140, 70);
  griff = QPixmap (griff_xpm);
  lbGriff = new ZLabel (belWidget);
  lbGriff->setPixmap (griff);
  lbGriff->setAlignment (AlignTop);
  connect (lbGriff, SIGNAL (pressed ()), this, SLOT (startDrag ()));
  hbox = new QHBoxLayout(0);
  timeView = new QLabel (belWidget);
  timeView->setText("00:00");
  timeView->setFixedHeight(20);
  timeView->setAlignment(AlignBottom|AlignLeft);
  hbox->addWidget(timeView);
  priceView = new QLabel (belWidget);
  priceView->setText ("0.00");
  priceView->setFixedHeight (20);
  priceView->setAlignment (AlignBottom|AlignRight);
  hbox->addWidget(priceView);
  curency = new QLabel (belWidget);
  curency->setText ("EUR");
  curency->setFixedHeight (20);
  curency->setAlignment (AlignBottom|AlignHCenter);
  hbox->addWidget(curency);
  menuBox = new QComboBox (belWidget);
  menuBox->setFixedSize (140, 20);
  connect (menuBox, SIGNAL (activated (int)), this, SLOT (slotMenu (int)));
  grid = new QGridLayout (belWidget, 3, 2);
  grid->addMultiCellWidget (lbGriff, 0, 0, 0, 1);
  grid->addMultiCellLayout(hbox,1,1,0,1);
  grid->addMultiCellWidget (menuBox, 2, 2, 0, 1);
  //      grid->addWidget(btnOk,1,1);
  belWidget->hide ();
  connect (newUser, SIGNAL (clicked ()), this, SLOT (slotNewUser ()));

}
void
userparkview::initData()
{
  menuBox->clear();
  menuBox->insertItem(tr("Select Action"));
  menuBox->insertItem(icoLedRed, tr("Delete user"));
  menuBox->insertItem(icoLedYellow, tr("Rate"));
  for(tarifList::iterator ti = tarife->begin(); ti != tarife->end(); ++ti)
    menuBox->insertItem((*ti).name);
  menuBox->insertItem(icoLedYellow, tr("Items"));
  menuBox->insertItem(tr("Printout"));
  for(productList::iterator pi = prods->begin(); pi != prods->end(); ++pi)
    menuBox->insertItem((*pi).name);
}
void
userparkview::slotNewUser ()
{
  newuser *dlg = new newuser (this, "newuser", true);
  if (dlg->exec () == QDialog::Accepted)
    {
      zbUser =
	new zbuser (dlg->edName->text (), prods, pInfo,
		    dlg->edCountdown->isChecked (), dlg->edTime->time ());
      connect (zbUser, SIGNAL (nameChanged (QString)), this,
	       SLOT (slotNameChanged (QString)));
      connect (zbUser, SIGNAL (timeChanged (QTime)), this,
	       SLOT (slotTimeChanged (QTime)));
      connect (zbUser, SIGNAL (priceChanged (float)), this,
	       SLOT (slotPriceChanged (float)));
      connect(zbUser,SIGNAL(updateUser()),SLOT(slotUpdateUser()));
      slotNameChanged (dlg->edName->text ());
      zbUser->updateTarif (&(*tarife)[0]);
      timeView->setText(dlg->edTime->time().toString("hh:mm"));
      updateMenu();
    }
  dlg->~newuser ();
  freeWidget->hide ();
  belWidget->show ();
  setAcceptDrops(false);
  emit updateUser();
}

void
userparkview::slotMenu (int i)
{
  if (i > 0)
    {
      if(i == 1)
	delUser();
      else if(i == menuPrintId)
	addPrint();
      else if(i > menuProdId)
	{
	  addProd(i - menuProdId - 2);
	}
      else if(i > menuTarifId)
	{
	  setTarif(i - menuTarifId - 1);
	}
    }
  menuBox->setCurrentItem(0);
}

void
userparkview::slotNameChanged (QString s)
{
  setTitle (s);
}

void
userparkview::slotTimeChanged (QTime t)
{
  //TODO
  if (t.isValid ())
    {
      timeView->setText(t.toString("hh:mm"));
    }
}

void
userparkview::slotPriceChanged (float p)
{
  QString s;
  s.setNum (p,'f',2);
  priceView->setText (s);
}

void
userparkview::dragEnterEvent (QDragEnterEvent * event)
{
  if (!event->spontaneous ())
    {
      event->accept (event->source ()->className () != className ()
		     && QTextDrag::canDecode (event));
      setFrameShadow (QFrame::Raised);
      setMidLineWidth (2);
    }
}

void
userparkview::dropEvent (QDropEvent * event)
{
  setFrameShadow (QFrame::Sunken);
  setMidLineWidth (0);
  QString s;
  if (QTextDrag::decode (event, s))
    {
      compList::iterator ci;
      for (groupList::iterator gi = groups->begin (); gi != groups->end ();
	   ++gi)
	{
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      if ((*ci).name == s)
		{
		  zbUser = (*ci).view->zbUser;
		  zbUser->timeStop ();
		  setTitle (zbUser->name ());
		  connect (zbUser, SIGNAL (nameChanged (QString)), this,
			   SLOT (slotNameChanged (QString)));
		  connect (zbUser, SIGNAL (timeChanged (QTime)), this,
			   SLOT (slotTimeChanged (QTime)));
		  connect (zbUser, SIGNAL (priceChanged (float)), this,
			   SLOT (slotPriceChanged (float)));
		  connect(zbUser,SIGNAL(updateUser()),SLOT(slotUpdateUser()));
		  for (tarifList::iterator ti = tarife->begin ();
		       ti != tarife->end (); ++ti)
		    {
		      if ((*ti).name == (*ci).view->tarif ())
			{
			  zbUser->updateTarif (&(*ti));
			}
		    }
		  (*ci).view->setOff ();
		  freeWidget->hide ();
		  belWidget->show ();
		  updateMenu();
		  setAcceptDrops(false);
		  emit updateUser();
		  return;
		}
	    }
	}
    }
}

void
userparkview::dragLeaveEvent (QDragLeaveEvent * event)
{
  if (!event->spontaneous ())
    {
      setFrameShadow (QFrame::Sunken);
      setMidLineWidth (0);
    }
}

void
userparkview::startDrag ()
{
  QPixmap p;
  p = QPixmap::grabWidget (belWidget);
  QDragObject *d = new QTextDrag (zbUser->name (), this);
  d->setPixmap (p, QPoint (70, 0));
  d->dragCopy ();
}

void
userparkview::setOff ()
{
  belWidget->hide ();
  freeWidget->show ();
  setTitle (tr ("Free"));
  setAcceptDrops(true);
  emit updateUser();
}

bool
userparkview::isOn()
{
  return belWidget->isVisible();
}

void
userparkview::setOn()
{
  setTitle (zbUser->name ());
  connect (zbUser, SIGNAL (nameChanged (QString)), this,
	   SLOT (slotNameChanged (QString)));
  connect (zbUser, SIGNAL (timeChanged (QTime)), this,
	   SLOT (slotTimeChanged (QTime)));
  connect (zbUser, SIGNAL (priceChanged (float)), this,
	   SLOT (slotPriceChanged (float)));
  for (tarifList::iterator ti = tarife->begin ();ti != tarife->end (); ++ti)
    if((*ti).name == zbUser->tarif())
      zbUser->updateTarif(&(*ti));
  freeWidget->hide();
  belWidget->show();
  setTitle(zbUser->name());
  setAcceptDrops(false);
}

void
userparkview::updateMenu()
{
  for(int i = 0; i < menuBox->count(); i++)
    {
      menuBox->listBox()->item(i)->setSelectable(true);
      if(menuBox->text(i) == tr("Rate"))
	{
	  menuBox->listBox()->item(i)->setSelectable(false);
	  menuTarifId = i;
	}
      if(menuBox->text(i) == tr("Items"))
	{
	  menuBox->listBox()->item(i)->setSelectable(false);
	  menuProdId = i;
	}
      if(menuBox->text(i) == tr("Printout"))
	{
	  menuPrintId = i;
	}
      if(menuBox->text(i) == zbUser->tarif())
	menuBox->listBox()->item(i)->setSelectable(false);
    }
}

void
userparkview::setTarif(int i)
{
  zbUser->updateTarif(&(*tarife)[i]);
  updateMenu();
}

void
userparkview::addProd(int i)
{
  zbUser->addItem(i,1);
}

void
userparkview::addPrint()
{
  printout *prn = new printout(this,"printout",true);
  if(prn->exec() == QDialog::Accepted)
    {
      zbUser->addPrint(prn->rdColor->isChecked(), prn->count->value());
    }
  prn->~printout();
}

void
userparkview::delUser()
{
  if(QMessageBox::query(tr("Delete user"),tr("do they want to really delete this user?"),tr("Yes"),tr("No"),this))
    {
      belWidget->hide();
      freeWidget->show();
      zbUser->~zbuser();
      setAcceptDrops(true);
      setTitle(tr("Free"));
    }
}
