/* printout.cc 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qmessagebox.h>
#include "icons/ok.xpm"
#include "icons/reject.xpm"
#include "printout.hh"

printout::printout (QWidget * parent, const char *name, bool modal, WFlags f):
QDialog (parent, name, modal, f)
{
  setCaption (tr ("Printout"));
  icoOk = QPixmap (ok_xpm);
  icoReject = QPixmap (reject_xpm);
  lbCount = new QLabel (this);
  lbCount->setText (tr ("Count"));
  count = new QSpinBox (this);
  rdColor = new QRadioButton (this);
  rdColor->setChecked (true);
  rdColor->setText (tr ("Color"));
  connect (rdColor, SIGNAL (toggled (bool)), this, SLOT (slotColor (bool)));
  rdGray = new QRadioButton (this);
  rdGray->setChecked (false);
  rdGray->setText (tr ("Grayscale"));
  connect (rdGray, SIGNAL (toggled (bool)), this, SLOT (slotGray (bool)));
  btnAccept = new QPushButton (this);
  btnAccept->setPixmap (icoOk);
  btnAccept->setDefault (true);
  connect (btnAccept, SIGNAL (clicked ()), this, SLOT (slotBtnAccept ()));
  btnReject = new QPushButton (this);
  btnReject->setPixmap (icoReject);
  connect (btnReject, SIGNAL (clicked ()), this, SLOT (slotBtnReject ()));
  grid = new QGridLayout (this, 3, 2, 0, 3);
  grid->addWidget (lbCount, 0, 0);
  grid->addWidget (count, 0, 1);
  grid->addWidget (rdColor, 1, 0);
  grid->addWidget (rdGray, 1, 1);
  grid->addWidget (btnAccept, 2, 0);
  grid->addWidget (btnReject, 2, 1);
}

printout::~printout ()
{
}

void
printout::slotBtnAccept ()
{
  if (count->value () == 0)
    QMessageBox::information (this, tr ("Printout"),
			      tr ("The Count for printouts can not be null"));
  else
    QDialog::accept ();
}

void
printout::slotBtnReject ()
{
  QDialog::reject ();
}

void
printout::slotColor (bool on)
{
  if (on)
    rdGray->setChecked (false);
  else
    rdGray->setChecked (true);
}

void
printout::slotGray (bool on)
{
  if (on)
    rdColor->setChecked (false);
  else
    rdColor->setChecked (true);
}
