/* cfg_prod.hh
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFG_PROD_H
#define CFG_PROD_H

#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlistbox.h>

#include "zbuser.hh"
#include "zbconfig.hh"

class cfg_prod:public QWidget
{
Q_OBJECT public:
    cfg_prod (QWidget * parent, productList * pList, printInfo * prints,
	      bool write, QString * cur);
   ~cfg_prod ();
  void setEnabled (bool write);
private:			// private functions
  void initView ();
  void initData ();
  void clear ();
private:			// private variables
    bool CfgWrite;
  productList *prods;
  printInfo *pInfo;
  int currentItem;
  QString *curency;
  QGridLayout *prodGrid;
  QGroupBox *adiGroup;
  QWidget *adiWidget;
  QGridLayout *adiGrid;
  // list
  QListBox *prodList;
  // name
  QLabel *lbName;
  QLineEdit *edName;
  // price
  QLabel *lbPrice;
  QLineEdit *edPrice;
  QLabel *lbCur1;
  // tax
  QLabel *lbTax;
  QLineEdit *edTax;
  QLabel *lbCur2;
  // description
  QLabel *lbDesc;
  QSpacerItem *spDesc;
  QMultiLineEdit *edDesc;
  // buttons
  QWidget *btnWidget;
  QHBoxLayout *btnBox;
  QPushButton *btnNew;
  QPushButton *btnSave;
  QSpacerItem *btnSpace;
  QPushButton *btnDel;
  // spacer
  QSpacerItem *sp1;
  QSpacerItem *sp2;
  private slots:void slotListSelected (int i);
  void slotBtnNew ();
  void slotBtnSave ();
  void slotBtnDel ();
  void slotName (const QString & s);
  void slotPrice (const QString & s);
  void slotTax (const QString & s);
  public slots:void setCurency (QString s);
    signals:void configChanged ();
};

#endif
