/* --------------------------------------------------------------------------
 * ``SPARCstation'' specific audio driver interface. (very poor)
 * (SunOS and Solaris)
 * --------------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <unistd.h>
// for streamio ioctl commands and args
#include <sys/types.h>
#include <stropts.h>
#include <sys/conf.h>

#if defined(HAVE_SOLARIS) && defined(HAVE_SUN_AUDIOIO_H)
  #include <sun/audioio.h>
//  #include <sun/dbriio.h>
#elif defined(HAVE_SOLARIS) && defined(HAVE_SYS_AUDIOIO_H)
  #include <sys/audioio.h>
#elif defined(HAVE_SUNOS) && defined(HAVE_SUN_AUDIOIO_H)
  #include <sun/audioio.h>
//  #include <sun/dbriio.h>
#elif defined(HAVE_SUNOS) && defined(HAVE_SYS_AUDIOIO_H)
  #include <sys/audioio.h>
#else
  #error Audio driver not supported.
#endif

#include "AudioDriver.h"

const char AudioDriver::AUDIODEVICE[] = "/dev/audio";

AudioDriver::AudioDriver()
{
	outOfOrder();
}

AudioDriver::~AudioDriver()
{
	reset();
	close();
}

void AudioDriver::outOfOrder()
{
	// Reset everything.
	errorString = "None";
	audioHd = (-1);
}

bool AudioDriver::isThere()
{
	return (access(AUDIODEVICE,W_OK)==0);
}

bool AudioDriver::reset()
{
	// Flush output stream.
	if (audioHd != (-1))
		return (ioctl (audioHd, I_FLUSH, FLUSHW) != (-1));
	else
		return false;
}

bool AudioDriver::open(const AudioConfig& inConfig)
{
	// Copy input parameters. May later be replaced with driver defaults.
	config = inConfig;

	if ((audioHd=::open(AUDIODEVICE,O_WRONLY,0)) == (-1))
	{
		perror(AUDIODEVICE);
		errorString = "ERROR: Could not open audio device.\n	   See standard error output.";
		return false;
	}

#ifdef CHECKFORSPEAKERBOX  
	int hwdevice;
	if ( ioctl(audioHd,AUDIO_GETDEV,&hwdevice) == (-1))
	{
		perror(AUDIODEVICE);
		errorString = "AUDIO: No audio hardware device installed.";
		return false;
	}
	if ( hwdevice != AUDIO_DEV_SPEAKERBOX )
	{
		audioHd = -1;
		perror(AUDIODEVICE);
		errorString = "AUDIO: Speakerbox not installed/enabled.";
		return false;
	}
#endif
	
	// Choose the nearest possible frequency.
	int dbrifreqs[] = 
	{
		8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000, 0
	};
	int dbrifsel = 0;
	int dbrifreqdiff = 100000;
	int dbrifrequency = config.frequency;
	do
	{  
		int dbrifreqdiff2 = config.frequency - dbrifreqs[dbrifsel];
		dbrifreqdiff2 < 0 ? dbrifreqdiff2 = 0 - dbrifreqdiff2 : dbrifreqdiff2 += 0;
		if ( dbrifreqdiff2 < dbrifreqdiff )  
		{
			dbrifreqdiff = dbrifreqdiff2;
			dbrifrequency = dbrifreqs[dbrifsel];
		}
		dbrifsel++;
	}  while ( dbrifreqs[dbrifsel] != 0 );
	config.frequency = dbrifrequency;
	
	// Only poor audio capabilities at 8-bit.
	// Sparcstations 5 and 10 tend to be 16-bit only at rates above 8000 Hz.
	// CS4231 at 8-bit supports only /u-law or A-law.
	config.precision = AudioConfig::BITS_16;
	config.encoding = AudioConfig::SIGNED_PCM;
	// Dumb mode. Dumb default. See below.
	config.blockSize = (config.frequency>>2);
	
	audio_info myaudio_info;
	if ( ioctl(audioHd,AUDIO_GETINFO,&myaudio_info) == (-1))
	{
		perror(AUDIODEVICE);
		errorString = "AUDIO: Could not get audio info.\n	   See standard error output.";
		return false;
	}
	AUDIO_INITINFO( &myaudio_info );
	
	//myaudio_info.play.buffer_size = config.blockSize;  // does not work (?)
	myaudio_info.play.sample_rate = config.frequency;
	if (config.channels == AudioConfig::STEREO)
		myaudio_info.play.channels = 2;
	else  // if (config.channels == AudioConfig::MONO)
		myaudio_info.play.channels = 1;
	myaudio_info.play.precision = config.precision;
	myaudio_info.play.encoding = AUDIO_ENCODING_LINEAR;
	myaudio_info.output_muted = 0;
	if ( ioctl(audioHd,AUDIO_SETINFO,&myaudio_info) == (-1))
	{
		perror(AUDIODEVICE);
		errorString = "AUDIO: Could not set audio info.\n	   See standard error output.";
		return false;
	}

	// Unsupported.
	config.maxFrags = 1;
	config.fragSize = 0;

	errorString = "OK";
	return true;
}

void AudioDriver::close()
{
	if (audioHd != (-1))
	{
		::close(audioHd);
		outOfOrder();
	}
}

void AudioDriver::unload()
{
    close();
}

void AudioDriver::play(void* buffer, unsigned long int bufferSize)
{
	if (audioHd != (-1))
	{
		write(audioHd,(char*)buffer,bufferSize);
	}
}
