/*-
# X-BASED TRIANGLES
#
#  TrianglesP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Triangles */

#ifndef _TrianglesP_h
#define _TrianglesP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Triangles.h"

#ifndef BUMPSOUND
#define BUMPSOUND "c:/windows/bump.wav"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->triangles.memDC)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w,x1,y1,NULL); \
  (void)LineTo(w,x2,y2)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) \
  if (dr) w->triangles.hOldBitmap = \
  (HBITMAP) SelectObject(w->triangles.memDC,dr); \
  w->triangles.hPen = CreatePen(PS_SOLID, 1, c); \
  w->triangles.hOldPen = (HPEN) SelectObject(DC(w,dr), w->triangles.hPen); \
  LINE(DC(w,dr),x1,y1,x2,y2); \
  (void) SelectObject(DC(w,dr), w->triangles.hOldPen); \
  (void) DeleteObject(w->triangles.hPen); \
  if (dr) (void) SelectObject(w->triangles.memDC,w->triangles.hOldBitmap)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->triangles.hOldBitmap = \
  (HBITMAP) SelectObject(w->triangles.memDC,dr); \
  w->triangles.hPen = CreatePen(PS_SOLID, 1, c); \
  w->triangles.hOldPen = (HPEN) SelectObject(DC(w,dr), w->triangles.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr), w->triangles.hOldPen); \
  (void) DeleteObject(w->triangles.hPen) \
  if (dr) (void) SelectObject(w->triangles.memDC,w->triangles.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->triangles.hOldBitmap = \
  (HBITMAP) SelectObject(w->triangles.memDC, dr); \
  w->triangles.hPen = CreatePen(PS_SOLID, 1, c); \
  w->triangles.hOldPen = (HPEN) SelectObject(DC(w,dr), w->triangles.hPen); \
  w->triangles.hBrush = CreateSolidBrush(c); \
  w->triangles.hOldBrush = (HBRUSH) SelectObject(DC(w,dr), \
  w->triangles.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr), w->triangles.hOldBrush); \
  (void) DeleteObject(w->triangles.hBrush); \
  (void) SelectObject(DC(w,dr), w->triangles.hOldPen); \
  (void) DeleteObject(w->triangles.hPen); \
  if (dr) (void) SelectObject(w->triangles.memDC,w->triangles.hOldBitmap)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->triangles.hOldBitmap = \
  (HBITMAP) SelectObject(w->triangles.memDC,dr); \
  (void) SetTextColor(DC(w,dr), c); \
  (void) SetBkMode(DC(w,dr), TRANSPARENT); \
  (void) TextOut(DC(w,dr), (x)-3, (y)-11, (LPCSTR) s, l); \
  if (dr) (void) SelectObject(w->triangles.memDC,w->triangles.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND hWnd;
	HDC hDC;
	HINSTANCE hInstance;
	POS width, height;
} CorePart;

extern void DestroyTriangles(HBRUSH brush);
extern void ResizeTriangles(TrianglesWidget w);
extern void SizeTriangles(TrianglesWidget w);
extern void InitializeTriangles(TrianglesWidget w, HBRUSH brush);
extern void ExposeTriangles(const TrianglesWidget w);
extern void HideTriangles(const TrianglesWidget w);
extern void SelectTriangles(TrianglesWidget w, const int x, const int y);
extern void ReleaseTriangles(TrianglesWidget w);
extern void RandomizeTriangles(TrianglesWidget w);
extern void RandomizeTrianglesMaybe(TrianglesWidget w);
extern void RandomizeTriangles2(TrianglesWidget w);
extern void ClearTriangles(TrianglesWidget w);
extern void GetTriangles(TrianglesWidget w);
extern void WriteTriangles(TrianglesWidget w);
extern void UndoTriangles(TrianglesWidget w);
extern void SolveTriangles(TrianglesWidget w);
extern void IncrementTriangles(TrianglesWidget w);
extern void DecrementTriangles(TrianglesWidget w);
extern void SpeedTriangles(TrianglesWidget w);
extern void SlowTriangles(TrianglesWidget w);
extern void SoundTriangles(TrianglesWidget w);
extern void EnterTriangles(TrianglesWidget w);
extern void LeaveTriangles(TrianglesWidget w);
extern int MoveTriangles(TrianglesWidget w, const int direction);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Triangles.h"

#ifdef VMS
#ifndef BUMPSOUND
#define BUMPSOUND "[.]bump.wav"
#endif
#else
#ifndef BUMPSOUND
#if 0
#define BUMPSOUND "/usr/share/games/xpuzzles/bump.au"
#endif
#define BUMPSOUND "/usr/local/share/games/xpuzzles/bump.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) XDrawLine(XtDisplay(w),DR(w,dr),\
  c,x1,y1,x2,y2)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)
#define POLYGON(w,dr,c,lc,l,n,o) XFillPolygon(XtDisplay(w), DR(w,dr), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), DR(w,dr), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,dr,c,l,n,o) XDrawLines(XtDisplay(w), DR(w,dr), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _TrianglesClassPart {
	int ignore;
} TrianglesClassPart;

typedef struct _TrianglesClassRec {
	CoreClassPart core_class;
	TrianglesClassPart triangles_class;
} TrianglesClassRec;

extern TrianglesClassRec trianglesClassRec;
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROWTYPES 3
#define DOWN 0
#define UP 1
#define MAXORIENT 2

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND random
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND rand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _TrianglesPart {
	int        *tileOfPosition, spacePosition[MAXORIENT];
	int         spaceRow[MAXORIENT][ROWTYPES];
	int         currentPosition, currentRow[ROWTYPES];
	int         currentPositionOrient;
	Boolean     started, cheat, sound;
	Boolean     mono, reverse, focus;
	int         delay, numSlices;
	int         base;
	int         size, sizeSize;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
#ifdef WINVER
	long        oldTime;
	char        username[81], bumpSound[81], picture[81];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	int         menu, graphicsFormat;
	char       *username, *bumpSound, *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	XtCallbackList select;
#endif
} TrianglesPart;

typedef struct _TrianglesRec {
	CorePart core;
	TrianglesPart triangles;
} TrianglesRec;

extern int *startPosition;
extern void SetTriangles(TrianglesWidget w, int reason);
extern int MoveTrianglesDir(TrianglesWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void SolveSomeTiles(TrianglesWidget w);
#endif
extern void DrawAllTiles(const TrianglesWidget w);
extern Boolean CheckSolved(const TrianglesWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int MadeMoves(void);
extern void FlushMoves(TrianglesWidget w);
extern int NumMoves(void);
extern void ScanMoves(FILE * fp, TrianglesWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, TrianglesWidget w);
extern void PrintStartPosition(FILE * fp, TrianglesWidget w);
extern void SetStartPosition(TrianglesWidget w);
extern int Row(const int pos);
extern int TrBl(const int pos, const int posRow);
extern int TlBr(const int pos, const int posRow);

#endif /* _TrianglesP_h */
