/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sqlite.h>

#include "includes.h"
#include "sqlite_functions.h"

extern int fd;
extern char *zErrMsg;

void create_xml_file(char *path)
{
	printf("Creating XML file in %s\n",path);
	if(!(fd = open(path, O_WRONLY|O_TRUNC|O_CREAT,0644)))
	{
	 	perror("Open() error");
	 	return;
	}
 	write(fd,"<?xml version=\"1.0\"?>\n<xmmsstats>\n",34); 
 	rc = sqlite_exec(db, "select name,length,hits, listen_time, last_listen from stats order by 3 desc", callback_write_all, 0, &zErrMsg);
 	if( rc!=SQLITE_OK ){
	 	printf("SQL error_select: %s\n", zErrMsg);
	}
	write(fd,"</xmmsstats>",12);
	close(fd);
}

void write_xml(int fd1, char *text, int length)
{
	if(fd1)
		write(fd1,text,length);
}


void replace_char_xml(char ** string)
{
#define NB_RAW 1
	char raw[NB_RAW] = { '&'};
	char *xmlstr[NB_RAW] = { "&amp;" };
	
	char *a, *tmp, *buf;
	int i, j;

	for(j = 0; j < NB_RAW; j++)
	{
		if((a = strchr(string[0], raw[j])))
		{
			buf = strdup(string[0]);
			tmp = string[0];

			/* Grow old string */
			string[0] = (char *) malloc(sizeof(char) * (strlen(string[0]) + strlen(xmlstr[j])));
			strcpy(string[0], buf);
			
			/* Move of 4 chars right old chain after '&'*/
			for(i = (strlen(buf) + (strlen(xmlstr[j]) - 1)); i >= ((tmp + strlen(buf) - a) - 1); i--)
				string[0][i] = buf[i - (strlen(xmlstr[j]) - 1)];
			
			for(i = 0; i < strlen(xmlstr[j]); i++)
				string[0][(a - tmp + i)] = xmlstr[j][i];
			
			/* Final space */
			string[0][(a - tmp) + i] = ' ';
		}
	}
}
